/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.encryption.AESPasswordEncrypter;
import com.xebialabs.deployit.encryption.IPasswordEncrypter;
import com.xebialabs.deployit.encryption.LegacyPasswordEncrypter;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.overthere.util.OverthereUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;

public class PasswordEncrypter
implements IPasswordEncrypter {
    private LegacyPasswordEncrypter legacyEncrypter;
    private AESPasswordEncrypter aesEncrypter;
    private static final AtomicReference<PasswordEncrypter> instance = new AtomicReference();

    public static void init(SecretKey secretKey) {
        SecretKeyHolder.init(secretKey);
        instance.set(new PasswordEncrypter(secretKey));
    }

    public static void init(SecretKey secretKey, PasswordEncrypter passwordEncrypter) {
        SecretKeyHolder.init(secretKey);
        instance.set(passwordEncrypter);
    }

    public static PasswordEncrypter getInstance() {
        OverthereUtils.checkState((instance.get() != null ? 1 : 0) != 0, (String)"PasswordEncrypter not yet set, please construct one.", (Object[])new Object[0]);
        return instance.get();
    }

    public PasswordEncrypter(SecretKeyHolder encryptionKeyHolder) {
        this.legacyEncrypter = new LegacyPasswordEncrypter(encryptionKeyHolder);
        this.aesEncrypter = new AESPasswordEncrypter(encryptionKeyHolder);
    }

    public PasswordEncrypter(SecretKey passwordEncryptionKey) {
        this.legacyEncrypter = new LegacyPasswordEncrypter(passwordEncryptionKey);
        this.aesEncrypter = new AESPasswordEncrypter(passwordEncryptionKey);
    }

    protected PasswordEncrypter() {
    }

    @Override
    public boolean isEncoded(String text) {
        return this.aesEncrypter.isEncoded(text) || this.legacyEncrypter.isEncoded(text);
    }

    @Override
    public boolean isEncrypted(String text) {
        return this.aesEncrypter.isEncrypted(text) || this.legacyEncrypter.isEncrypted(text);
    }

    @Override
    public boolean isEncodedAndDecryptable(String text) {
        return this.aesEncrypter.isEncodedAndDecryptable(text) || this.legacyEncrypter.isEncodedAndDecryptable(text);
    }

    @Override
    public String encrypt(String plaintext) {
        return this.aesEncrypter.encrypt(plaintext);
    }

    @Override
    public String ensureEncrypted(String text) {
        if (this.isEncrypted(text)) {
            return text;
        }
        return this.encrypt(text);
    }

    @Override
    public String decrypt(String encryptedText) {
        Checks.checkArgument((encryptedText != null ? 1 : 0) != 0, (String)"The password is null", (Object[])new Object[0]);
        Checks.checkArgument((encryptedText.startsWith("{b64}") || encryptedText.startsWith("{aes:%s}".substring(0, 4)) ? 1 : 0) != 0, (String)"The password should be Base64 encoded", (Object[])new Object[0]);
        try {
            if (this.aesEncrypter.isEncoded(encryptedText)) {
                return this.aesEncrypter.doDecodeAndDecrypt(encryptedText);
            }
            return this.legacyEncrypter.doDecodeAndDecrypt(encryptedText);
        }
        catch (IllegalStateException e) {
            throw new DeployitException("Could not decrypt the password.");
        }
    }

    @Override
    public String ensureDecrypted(String text) {
        if (this.isEncrypted(text)) {
            return this.decrypt(text);
        }
        return text;
    }

    @Override
    public String getKeyFingerprint() {
        return this.aesEncrypter.getKeyFingerprint();
    }

    @Override
    public String prefix() {
        return this.aesEncrypter.prefix();
    }
}

