/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BasePythonScript;
import com.xebialabs.xlrelease.domain.PollType;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned=false)
public class ReleaseTrigger
extends BasePythonScript {
    public static final String SCRIPT_VARS = "variables";
    @PublicApiMember
    @Property(required=false, category="hidden")
    private String triggerState = "";
    @PublicApiMember
    @Property(required=false, category="hidden", defaultValue="false", description="Set this property to true to trigger a new release on the initial trigger fire. Otherwise, the first release will be triggered on the next state change")
    private boolean initialFire = false;
    @PublicApiMember
    @Property(category="Common", description="Symbolic name for the trigger")
    private String title;
    @Property(required=false, description="The description of the trigger.", size=Property.Size.LARGE)
    private String description;
    @PublicApiMember
    @Property(category="Common", description="Name given to releases created by this trigger. This field can contain variables")
    private String releaseTitle;
    @PublicApiMember
    @Property(category="Common", defaultValue="REPEAT", required=true, label="Poll Type", description="Type of polling to use; this is a repeatable period in seconds (for example, every 10 seconds) or a cron expression")
    private PollType pollType = PollType.REPEAT;
    @PublicApiMember
    @Property(category="Common", defaultValue="10", required=true, label="Poll Interval", description="Interval in seconds (REPEAT) or as a cron expression (CRON). The cron pattern is a list of six fields separated by a single space; these fields represent second, minute, hour, day, month, weekday. Month and weekday names can be given as the first three letters of their English names. For example: 0 0 * * * * = the top of every hour of every day; */10 * * * * * = every ten seconds; 0 0 9-17 * * MON-FRI = on the hour nine-to-five weekdays")
    private String periodicity = "10";
    @PublicApiMember
    @Property(category="Common", defaultValue="true", required=false)
    private boolean enabled = true;
    @Property(required=false, category="hidden")
    private String executionId;
    @PublicApiMember
    @Property(asContainment=true, required=false, category="hidden")
    protected List<Variable> variables = Lists.newArrayList();
    @Property(required=false, category="hidden", asContainment=true)
    private Release template;
    @PublicApiMember
    @Property(required=false, category="hidden")
    protected List<String> tags;

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getDescription() {
        return this.description;
    }

    @PublicApiMember
    public void setDescription(String description) {
        this.description = description;
    }

    @PublicApiMember
    public String getReleaseTitle() {
        return this.releaseTitle;
    }

    @PublicApiMember
    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    @PublicApiMember
    public PollType getPollType() {
        return this.pollType;
    }

    @PublicApiMember
    public void setPollType(PollType pollType) {
        this.pollType = pollType;
    }

    @PublicApiMember
    public Map<String, String> getTemplateVariables() {
        return VariableHelper.getStringVariableValues(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getTemplatePasswordVariables() {
        return VariableHelper.getPasswordStringVariableValues(this.variables);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return Lists.newArrayList(this.variables);
    }

    public void setVariables(List<Variable> variables) {
        VariableHelper.checkVariables(variables);
        this.variables = variables;
    }

    @PublicApiMember
    public String getPeriodicity() {
        return this.periodicity;
    }

    @PublicApiMember
    public void setPeriodicity(String periodicity) {
        this.periodicity = periodicity;
    }

    @PublicApiMember
    public String getTriggerState() {
        return this.triggerState;
    }

    @PublicApiMember
    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    public boolean isInitialFire() {
        return this.initialFire;
    }

    public void setInitialFire(boolean initialFire) {
        this.initialFire = initialFire;
    }

    @PublicApiMember
    public boolean isEnabled() {
        return this.enabled;
    }

    @PublicApiMember
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Release getTemplate() {
        return this.template;
    }

    public void setTemplate(Release template) {
        this.template = template;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean hasExecutionId() {
        return this.executionId != null;
    }

    @VisibleForTesting
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void resetExecutionId() {
        this.executionId = null;
    }

    public void setTriggerStateFromResults(String state) {
        if (state != null && !state.trim().isEmpty()) {
            this.setTriggerState(state);
        }
    }

    public void setScriptVariablesFromResults(Map<String, Object> variableValues) {
        Collection propertyDescriptors = this.getType().getDescriptor().getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!Objects.equal((Object)propertyDescriptor.getCategory(), (Object)SCRIPT_VARS)) continue;
            String propertyName = propertyDescriptor.getName();
            this.setProperty(propertyName, variableValues.get(propertyName));
        }
    }

    public Map<String, String> getStringScriptVariableValues() {
        return this.getScriptVariableValues().entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> VariableHelper.withVariableSyntax((String)e.getKey()), e -> e.getValue().toString()));
    }

    public Map<String, Object> getScriptVariableValues() {
        return this.getType().getDescriptor().getPropertyDescriptors().stream().filter(pd -> Objects.equal((Object)pd.getCategory(), (Object)SCRIPT_VARS)).collect(Collectors.toMap(PropertyDescriptor::getName, pd -> this.getProperty(pd.getName())));
    }

    public Map<String, Object> getTemplateVariableValues(Predicate<Variable> variablePredicate) {
        return this.getVariables().stream().filter(variablePredicate).collect(Collectors.toMap(Variable::getKey, Variable::getValue));
    }
}

