/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RetryTitleGenerator {
    private static final Pattern CAPTURE_RETRY_COUNT_PATTERN = Pattern.compile("\\(([0-9]+)\\)$");

    public static String getNextTitle(String originalTitle) {
        Matcher matcher = CAPTURE_RETRY_COUNT_PATTERN.matcher(originalTitle);
        if (matcher.find()) {
            int retryCount = Integer.parseInt(matcher.group(1));
            return matcher.replaceAll("(" + Integer.toString(retryCount + 1) + ")");
        }
        return originalTitle + " (2)";
    }
}

