/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.serialization;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.persistence.serialization.Snapshot;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.Serialization$;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.ByteString$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001\u0002\t\u0012\u0001aA\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!\n\u0005\tY\u0001\u0011\t\u0011)A\u0005M!)Q\u0006\u0001C\u0001]!9!\u0007\u0001b\u0001\n\u0003\u001a\u0004BB\u001c\u0001A\u0003%A\u0007\u0003\u0005\u0013\u0001!\u0015\r\u0011\"\u00039\u0011!a\u0004\u0001#b\u0001\n\u0013i\u0004\"\u0002%\u0001\t\u0003I\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u00029\u0001\t\u0013\t\b\"B=\u0001\t\u0013Q\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003#\u0001A\u0011BA\n\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\u000f\u0001\t\u0013\tYD\u0001\nT]\u0006\u00048\u000f[8u'\u0016\u0014\u0018.\u00197ju\u0016\u0014(B\u0001\n\u0014\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011A#F\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001\u0017\u0003\u0011\t7n[1\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001#%D\u0001\"\u0015\t\u0011R#\u0003\u0002$C\tq!)Y:f'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AB:zgR,W.F\u0001'!\t9#&D\u0001)\u0015\tIS#A\u0003bGR|'/\u0003\u0002,Q\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\u000691/_:uK6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00020cA\u0011\u0001\u0007A\u0007\u0002#!)Ae\u0001a\u0001M\u0005y\u0011N\\2mk\u0012,W*\u00198jM\u0016\u001cH/F\u00015!\tQR'\u0003\u000277\t9!i\\8mK\u0006t\u0017\u0001E5oG2,H-Z'b]&4Wm\u001d;!+\u0005I\u0004C\u0001\u0011;\u0013\tY\u0014EA\u0007TKJL\u0017\r\\5{CRLwN\\\u0001\u0015iJ\fgn\u001d9peRLeNZ8s[\u0006$\u0018n\u001c8\u0016\u0003y\u00022AG B\u0013\t\u00015D\u0001\u0004PaRLwN\u001c\t\u0003\u0005\u0016s!\u0001I\"\n\u0005\u0011\u000b\u0013!D*fe&\fG.\u001b>bi&|g.\u0003\u0002G\u000f\nY\u0011J\u001c4pe6\fG/[8o\u0015\t!\u0015%\u0001\u0005u_\nKg.\u0019:z)\tQ\u0005\u000bE\u0002\u001b\u00176K!\u0001T\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005iq\u0015BA(\u001c\u0005\u0011\u0011\u0015\u0010^3\t\u000bEC\u0001\u0019A\r\u0002\u0003=\f!B\u001a:p[\nKg.\u0019:z)\rIBK\u0016\u0005\u0006+&\u0001\rAS\u0001\u0006Ef$Xm\u001d\u0005\u0006/&\u0001\r\u0001W\u0001\t[\u0006t\u0017NZ3tiB\u0019!dP-1\u0005i;\u0007cA.cK:\u0011A\f\u0019\t\u0003;ni\u0011A\u0018\u0006\u0003?^\ta\u0001\u0010:p_Rt\u0014BA1\u001c\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0006\u00072\f7o\u001d\u0006\u0003Cn\u0001\"AZ4\r\u0001\u0011I\u0001NVA\u0001\u0002\u0003\u0015\t!\u001b\u0002\u0004?\u0012\n\u0014C\u00016n!\tQ2.\u0003\u0002m7\t9aj\u001c;iS:<\u0007C\u0001\u000eo\u0013\ty7DA\u0002B]f\fa\u0002[3bI\u0016\u0014Hk\u001c\"j]\u0006\u0014\u0018\u0010F\u0002KeRDQa\u001d\u0006A\u0002e\t\u0001b\u001d8baNDw\u000e\u001e\u0005\u0006k*\u0001\rA^\u0001\u0013g:\f\u0007o\u001d5piN+'/[1mSj,'\u000f\u0005\u0002!o&\u0011\u00010\t\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001\u00055fC\u0012,'O\u0012:p[\nKg.\u0019:z)\rY\u0018\u0011\u0002\t\u00065qt\u00181A\u0005\u0003{n\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u000e\u0000\u0013\r\t\ta\u0007\u0002\u0004\u0013:$\bcA.\u0002\u0006%\u0019\u0011q\u00013\u0003\rM#(/\u001b8h\u0011\u0015)6\u00021\u0001K\u0003A\u0019h.\u00199tQ>$Hk\u001c\"j]\u0006\u0014\u0018\u0010F\u0002K\u0003\u001fAQa\u001d\u0007A\u0002e\t!c\u001d8baNDw\u000e\u001e$s_6\u0014\u0015N\\1ssR\u0019\u0011$!\u0006\t\u000bUk\u0001\u0019\u0001&\u0002\u0011]\u0014\u0018\u000e^3J]R$b!a\u0007\u0002\"\u0005U\u0002c\u0001\u000e\u0002\u001e%\u0019\u0011qD\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003\ryW\u000f\u001e\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\tIwN\u0003\u0002\u00020\u0005!!.\u0019<b\u0013\u0011\t\u0019$!\u000b\u0003\u0019=+H\u000f];u'R\u0014X-Y7\t\r\u0005]b\u00021\u0001\u007f\u0003\u0005I\u0017a\u0002:fC\u0012Le\u000e\u001e\u000b\u0004}\u0006u\u0002bBA \u001f\u0001\u0007\u0011\u0011I\u0001\u0003S:\u0004B!a\n\u0002D%!\u0011QIA\u0015\u0005-Ie\u000e];u'R\u0014X-Y7")
public class SnapshotSerializer
implements BaseSerializer {
    private Serialization serialization;
    private Option<Serialization.Information> transportInformation;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private final int identifier;
    private volatile byte bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private Option<Serialization.Information> transportInformation$lzycompute() {
        SnapshotSerializer snapshotSerializer = this;
        synchronized (snapshotSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Address address = this.system().provider().getDefaultAddress();
                this.transportInformation = address.hasLocalScope() ? None$.MODULE$ : new Some((Object)new Serialization.Information(address, (ActorSystem)this.system()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.transportInformation;
    }

    private Option<Serialization.Information> transportInformation() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.transportInformation$lzycompute() : this.transportInformation;
    }

    public byte[] toBinary(Object o) {
        Object object = o;
        if (!(object instanceof Snapshot)) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
        }
        Snapshot snapshot = (Snapshot)object;
        Object data = snapshot.data();
        byte[] byArray = this.snapshotToBinary(data);
        return byArray;
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out;
        block0: {
            out = new ByteArrayOutputStream();
            this.writeInt(out, snapshotSerializer.identifier());
            String ms = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshot);
            if (!new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty()) break block0;
            out.write(ms.getBytes(ByteString$.MODULE$.UTF_8()));
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException("Replaying snapshot from akka 2.3.x version is not supported any more");
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            byArray = this.serialize$1(snapshot);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return byArray;
    }

    private Object snapshotFromBinary(byte[] bytes) {
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).drop(headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int serializerId = tuple2._1$mcI$sp();
        String manifest = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
        Tuple2 tuple23 = tuple22;
        int serializerId2 = tuple23._1$mcI$sp();
        String manifest2 = (String)tuple23._2();
        return this.serialization().deserialize(snapshotBytes, serializerId2, manifest2).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
    }
}

