/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.service.ArchivingService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001-\u0011\u0001$\u0011:dQ&4\u0018N\\4TG\",G-\u001e7f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0004tKJ4\u0018nY3\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0012\u0001C4sSjTH.\u001a3\n\u0005e!\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005\u0001\u0012M]2iSZLgnZ*feZL7-Z\u000b\u0002;A\u0011adH\u0007\u0002\u0005%\u0011\u0001E\u0001\u0002\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016D\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0012CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\u0003\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\u001f\u0005\u00148\r[5wS:<7i\u001c8gS\u001e,\u0012A\n\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\u0011\taaY8oM&<\u0017BA\u0016)\u0005a\t%o\u00195jm&twmU3ui&twm]'b]\u0006<WM\u001d\u0005\t[\u0001\u0011\t\u0011)A\u0005M\u0005\u0001\u0012M]2iSZLgnZ\"p]\u001aLw\r\t\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00124\u0007\u0005\u0002\u001f\u0001!)1D\fa\u0001;!)AE\fa\u0001M!\u0012a&\u000e\t\u0003m\u0005k\u0011a\u000e\u0006\u0003qe\n!\"\u00198o_R\fG/[8o\u0015\tQ4(A\u0004gC\u000e$xN]=\u000b\u0005qj\u0014!\u00022fC:\u001c(B\u0001 @\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001!\u0002\u0007=\u0014x-\u0003\u0002Co\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0003EI7oQ1oG\u0016d'+Z9vKN$X\rZ\u000b\u0002\rB\u0011q\tU\u0007\u0002\u0011*\u0011\u0011JS\u0001\u0007CR|W.[2\u000b\u0005-c\u0015AC2p]\u000e,(O]3oi*\u0011QJT\u0001\u0005kRLGNC\u0001P\u0003\u0011Q\u0017M^1\n\u0005EC%!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004T\u0001\u0001\u0006IAR\u0001\u0013SN\u001c\u0015M\\2fYJ+\u0017/^3ti\u0016$\u0007\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u0002+\u0005\u00148\r[5wK&s\u0007K]8he\u0016\u001c8\u000fT8dWV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[\u001d\u0006!A.\u00198h\u0013\ta\u0016L\u0001\u0004PE*,7\r\u001e\u0005\u0007=\u0002\u0001\u000b\u0011B,\u0002-\u0005\u00148\r[5wK&s\u0007K]8he\u0016\u001c8\u000fT8dW\u0002BQ\u0001\u0019\u0001\u0005\u0002\u0005\f1dZ3u\u0003J\u001c\u0007.\u001b<j]\u001eTuNY\"s_:\u001c6\r[3ek2,W#\u00012\u0011\u0005\rTgB\u00013i!\t)g\"D\u0001g\u0015\t9'\"\u0001\u0004=e>|GOP\u0005\u0003S:\ta\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011N\u0004\u0005\u0006]\u0002!\ta\\\u0001\u0017CJ\u001c\u0007.\u001b<f\u000bb\u0004\u0018N]3e%\u0016dW-Y:fgR\u0011\u0001o\u001d\t\u0003\u001bEL!A\u001d\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006i6\u0004\r!^\u0001\u0014e\u0016dW-Y:f\u0003\u001e,Gk\\!sG\"Lg/\u001a\t\u00031ZL!a^-\u0003\u000f%sG/Z4fe\"\u0012Q.\u001f\t\u0004u\u0006\u0005Q\"A>\u000b\u0005ab(BA?\u007f\u0003\u001diW\r\u001e:jGNT!a \u0005\u0002\u0011\r|G-\u00195bY\u0016L1!a\u0001|\u0005\u0015!\u0016.\\3e\u0011\u0019q\u0007\u0001\"\u0001\u0002\bQ\t\u0001\u000fK\u0002\u0002\u0006eDq!!\u0004\u0001\t\u0013\ty!\u0001\u0011gS:$\u0017I\u001c3Qe>\u001cWm]:Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016\u001cH\u0003BA\t\u0003G!B!a\u0005\u0002\u001aA\u0019Q\"!\u0006\n\u0007\u0005]aBA\u0002J]RD\u0001\"a\u0007\u0002\f\u0001\u0007\u0011QD\u0001\u0007C\u000e$\u0018n\u001c8\u0011\u000b5\tyB\u00199\n\u0007\u0005\u0005bBA\u0005Gk:\u001cG/[8oc!A\u0011QEA\u0006\u0001\u0004\t9#\u0001\u0003eCR,\u0007\u0003BA\u0015\u0003Wi\u0011\u0001T\u0005\u0004\u0003[a%\u0001\u0002#bi\u0016Dq!!\r\u0001\t\u0013\t\u0019$A\bqe>\u001cWm]:SK2,\u0017m]3t)!\t)$a\u0010\u0002V\u0005}C\u0003BA\u001c\u0003{\u00012!DA\u001d\u0013\r\tYD\u0004\u0002\b\u0005>|G.Z1o\u0011!\tY\"a\fA\u0002\u0005u\u0001\u0002CA!\u0003_\u0001\r!a\u0011\u0002\u0015I,G.Z1tK&#7\u000fE\u0003\u0002F\u0005=#M\u0004\u0003\u0002H\u0005-cbA3\u0002J%\tq\"C\u0002\u0002N9\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002R\u0005M#\u0001C%uKJ\f'\r\\3\u000b\u0007\u00055c\u0002\u0003\u0005\u0002X\u0005=\u0002\u0019AA-\u0003\u0015\u0019w.\u001e8u!\r9\u00151L\u0005\u0004\u0003;B%!D!u_6L7-\u00138uK\u001e,'\u000f\u0003\u0005\u0002b\u0005=\u0002\u0019AA2\u0003I\u0011XO\\*uCJ$H+[7f\u001b&dG.[:\u0011\u00075\t)'C\u0002\u0002h9\u0011A\u0001T8oO\"9\u00111\u000e\u0001\u0005\n\u00055\u0014aF1sG\"Lg/Z\"p[BdW\r^3e%\u0016dW-Y:f)\u0011\ty'!\u001f\u0011\u000b\u0005E\u0014Q\u000f9\u000e\u0005\u0005M$BA'\u000f\u0013\u0011\t9(a\u001d\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0002|\u0005%\u0004\u0019\u00012\u0002\u0013I,G.Z1tK&#\u0007bBA@\u0001\u0011%\u0011\u0011Q\u0001\u0012O\u0016$8+Z1sG\"\u0004\u0016mZ3TSj,WCAA\n\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\tQb\u001d7fKBLeMT3fI\u0016$\u0007bBAE\u0001\u0011%\u00111R\u0001\u000be\u0006tGk\\8M_:<G\u0003BA\u001c\u0003\u001bC\u0001\"!\u0019\u0002\b\u0002\u0007\u00111\r\u0005\b\u0003#\u0003A\u0011BA\u0004\u0003\rygM\u001a\u0005\b\u0003+\u0003A\u0011BA\u0004\u0003)\u0001(/\u001a#fgR\u0014x.\u001f\u0015\u0005\u0003'\u000bI\n\u0005\u0003\u0002\u001c\u0006\rVBAAO\u0015\rA\u0014q\u0014\u0006\u0003\u0003C\u000bQA[1wCbLA!!*\u0002\u001e\nQ\u0001K]3EKN$(o\\=)\u0007\u0001\tI\u000b\u0005\u0003\u0002,\u0006EVBAAW\u0015\r\ty+P\u0001\u000bgR,'/Z8usB,\u0017\u0002BAZ\u0003[\u0013qaU3sm&\u001cW\r")
public class ArchivingScheduleService
implements Logging {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final AtomicBoolean isCancelRequested;
    private final Object archiveInProgressLock;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingScheduleService archivingScheduleService = this;
        synchronized (archivingScheduleService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ArchivingSettingsManager archivingConfig() {
        return this.archivingConfig;
    }

    private AtomicBoolean isCancelRequested() {
        return this.isCancelRequested;
    }

    private Object archiveInProgressLock() {
        return this.archiveInProgressLock;
    }

    public String getArchivingJobCronSchedule() {
        return this.archivingConfig().getArchivingJobCronSchedule();
    }

    @Timed
    public void archiveExpiredReleases(Integer releaseAgeToArchive) {
        if (this.archivingConfig().getEnabled()) {
            long startArchiving = System.currentTimeMillis();
            Date expirationDate = LocalDateTime.now().minusHours(Predef$.MODULE$.Integer2int(releaseAgeToArchive)).toDate();
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving completed releases older than ", " hours (completed before ", ")..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseAgeToArchive, expirationDate})));
            Object object = this.archiveInProgressLock();
            synchronized (object) {
                int archivedReleasesCount = this.findAndProcessArchivableReleases(expirationDate, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
                    this.archiveCompletedRelease(s);
                    return BoxedUnit.UNIT;
                });
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivedReleasesCount), BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startArchiving))})));
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Archiving is not enabled.");
        }
    }

    @Timed
    public void archiveExpiredReleases() {
        this.archiveExpiredReleases(this.archivingConfig().getReleaseAgeToDeleteFromJcr());
    }

    private int findAndProcessArchivableReleases(Date date, Function1<String, BoxedUnit> action) {
        AtomicInteger count;
        block3: {
            long runStartTimeMillis = System.currentTimeMillis();
            count = new AtomicInteger(0);
            boolean done = false;
            while (!done && !this.isCancelRequested().get()) {
                int archivingPageSize = this.getSearchPageSize();
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fetching ", " completed or aborted releases from repository"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivingPageSize)})));
                Seq<String> releaseIds = this.archivingService().findArchivableReleaseIds(date, Predef$.MODULE$.int2Integer(archivingPageSize));
                if (releaseIds.nonEmpty() && count.get() == 0) {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{date})));
                }
                if (done = this.processReleases((Iterable<String>)releaseIds, count, runStartTimeMillis, action)) continue;
                if (releaseIds.isEmpty() || releaseIds.size() < archivingPageSize) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processed only ", " finished releases on this page: we're done."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)releaseIds.size())})));
                    done = true;
                    continue;
                }
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ", fetching the next ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date, BoxesRunTime.boxToInteger((int)archivingPageSize)})));
            }
            if (count.get() <= 0) break block3;
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived ", " releases that completed before ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count.get()), date})));
        }
        return count.get();
    }

    private boolean processReleases(Iterable<String> releaseIds, AtomicInteger count, long runStartTimeMillis, Function1<String, BoxedUnit> action) {
        boolean bl;
        Object object = new Object();
        try {
            releaseIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
                ArchivingScheduleService.$anonfun$processReleases$1(this, count, runStartTimeMillis, action, object, releaseId);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private Try<BoxedUnit> archiveCompletedRelease(String releaseId) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving release [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})));
            long s = System.currentTimeMillis();
            this.archivingService().archiveRelease(releaseId);
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archived release [", "] in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId, BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - s))})));
        }).recoverWith((PartialFunction)new scala.Serializable(this, releaseId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArchivingScheduleService $outer;
            private final String releaseId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not archive release [", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.releaseId$1, exception.getMessage()})), (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.releaseId$1 = releaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.ArchivingScheduleService$$anonfun$archiveCompletedRelease$4 java.lang.Exception ), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private int getSearchPageSize() {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) > 0 ? Predef$.MODULE$.Integer2int(this.archivingConfig().getSearchPageSize()) : 20;
    }

    private void sleepIfNeeded() {
        block2: {
            if (Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) <= 0) break block2;
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds before archiving the next release"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            try {
                Thread.sleep(Predef$.MODULE$.Integer2int(this.archivingConfig().getSleepSecondsBetweenReleases()) * 1000);
            }
            catch (InterruptedException interruptedException) {
                this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sleeping for ", " seconds was interrupted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.archivingConfig().getSleepSecondsBetweenReleases()})));
            }
        }
    }

    private boolean ranTooLong(long runStartTimeMillis) {
        return Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) > 0 ? System.currentTimeMillis() - runStartTimeMillis > (long)(Predef$.MODULE$.Integer2int(this.archivingConfig().getMaxSecondsPerRun()) * 1000) : false;
    }

    private void off() {
        this.isCancelRequested().set(true);
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Waiting until no archiving is in progress");
        Object object = this.archiveInProgressLock();
        synchronized (object) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Archiving done, destroying ArchivingScheduleService");
        }
    }

    @PreDestroy
    private void preDestroy() {
        this.off();
    }

    public static final /* synthetic */ void $anonfun$processReleases$1(ArchivingScheduleService $this, AtomicInteger count$2, long runStartTimeMillis$1, Function1 action$1, Object nonLocalReturnKey1$1, String releaseId) {
        if ($this.isCancelRequested().get()) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
        if (count$2.get() > 0) {
            $this.sleepIfNeeded();
        }
        action$1.apply((Object)releaseId);
        count$2.incrementAndGet();
        if ($this.ranTooLong(runStartTimeMillis$1)) {
            $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving paused because it ran for more than ", " seconds. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.archivingConfig().getMaxSecondsPerRun()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Archiving will continue in the next run"})).s((Seq)Nil$.MODULE$));
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    @Autowired
    public ArchivingScheduleService(ArchivingService archivingService, ArchivingSettingsManager archivingConfig) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        Logging.$init$((Logging)this);
        this.isCancelRequested = new AtomicBoolean(false);
        this.archiveInProgressLock = new Object();
    }
}

