/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001-\u00111\u0005\u00177QKJ\u001c\u0018n\u001d;f]R$vn[3o%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7O\u0003\u0002\u0004\t\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\u0003\u0007\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\b\u0011\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bei\u0011A\u0004\u0006\u0003\u001fA\t!B]3nK6\u0014WM]7f\u0015\t\u0019\u0011C\u0003\u0002\u0013'\u0005\u0019q/\u001a2\u000b\u0005Q)\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Y9\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\t1a\u001c:h\u0013\tQbB\u0001\u000eBEN$(/Y2u%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\rYW-\u001f\t\u0003=\u001dr!aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011A\u0002\u001fs_>$hHC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014$\u0011!Y\u0003A!A!\u0002\u0013a\u0013AE;tKJ$U\r^1jYN\u001cVM\u001d<jG\u0016\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0017U\u001cXM\u001d3fi\u0006LGn\u001d\u0006\u0003cM\tAaY8sK&\u00111G\f\u0002\u0013+N,'\u000fR3uC&d7oU3sm&\u001cW\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003=!xn[3o%\u0016\u0004xn]5u_JL\bCA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003wa\u0012qdQ;ti>l\u0007+\u001a:tSN$XM\u001c;U_.,gNU3q_NLGo\u001c:z\u0011!i\u0004A!A!\u0002\u0013q\u0014aE:feZ,'oQ8oM&<WO]1uS>t\u0007CA C\u001b\u0005\u0001%BA!\u0007\u0003!!W\r\u001d7ps&$\u0018BA\"A\u0005M\u0019VM\u001d<fe\u000e{gNZ5hkJ\fG/[8o\u0011\u0015)\u0005\u0001\"\u0001G\u0003\u0019a\u0014N\\5u}Q)q)\u0013&L\u0019B\u0011\u0001\nA\u0007\u0002\u0005!)A\u0004\u0012a\u0001;!)1\u0006\u0012a\u0001Y!)Q\u0007\u0012a\u0001m!)Q\b\u0012a\u0001}!9a\n\u0001b\u0001\n\u0013y\u0015!\u0006#F\r\u0006+F\nV0T\u000bJKUiU0M\u000b:;E\u000bS\u000b\u0002!B\u0011\u0011KU\u0007\u0002G%\u00111k\t\u0002\u0004\u0013:$\bBB+\u0001A\u0003%\u0001+\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`'\u0016\u0013\u0016*R*`\u0019\u0016su\t\u0016%!\u0011\u001d9\u0006A1A\u0005\n=\u000bA\u0003R#G\u0003VcEk\u0018+P\u0017\u0016su\fT#O\u000fRC\u0005BB-\u0001A\u0003%\u0001+A\u000bE\u000b\u001a\u000bU\u000b\u0014+`)>[UIT0M\u000b:;E\u000b\u0013\u0011\t\u000fm\u0003\u0001\u0019!C\u0005\u001f\u0006a1/\u001a:jKNdUM\\4uQ\"9Q\f\u0001a\u0001\n\u0013q\u0016\u0001E:fe&,7\u000fT3oORDw\fJ3r)\ty&\r\u0005\u0002RA&\u0011\u0011m\t\u0002\u0005+:LG\u000fC\u0004d9\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0013\u0007\u0003\u0004f\u0001\u0001\u0006K\u0001U\u0001\u000eg\u0016\u0014\u0018.Z:MK:<G\u000f\u001b\u0011\t\u000f\u001d\u0004\u0001\u0019!C\u0005\u001f\u0006YAo\\6f]2+gn\u001a;i\u0011\u001dI\u0007\u00011A\u0005\n)\fq\u0002^8lK:dUM\\4uQ~#S-\u001d\u000b\u0003?.Dqa\u00195\u0002\u0002\u0003\u0007\u0001\u000b\u0003\u0004n\u0001\u0001\u0006K\u0001U\u0001\ri>\\WM\u001c'f]\u001e$\b\u000e\t\u0005\u0006_\u0002!I\u0001]\u0001\u0007O>\u0004\u0016m\u001d;\u0015\u0007EL8\u0010\u0005\u0002so6\t1O\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003\t\u0011\u000bG/\u001a\u0005\u0006u:\u0004\r!]\u0001\nO&4XM\u001c#bi\u0016DQ\u0001 8A\u0002u\f\u0001\u0002^5nK&sWj\u001d\t\u0003#zL!a`\u0012\u0003\t1{gn\u001a\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0003!9wNR;ukJ,G#B9\u0002\b\u0005%\u0001B\u0002>\u0002\u0002\u0001\u0007\u0011\u000f\u0003\u0004}\u0003\u0003\u0001\r! \u0005\b\u0003\u001b\u0001A\u0011IA\b\u00039yg\u000eT8hS:\u001cVoY2fgN$raXA\t\u0003S\t\u0019\u0004\u0003\u0005\u0002\u0014\u0005-\u0001\u0019AA\u000b\u0003\u001d\u0011X-];fgR\u0004B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003iiR\u0004(\u0002BA\u0010\u0003C\tqa]3sm2,GO\u0003\u0002\u0002$\u0005)!.\u0019<bq&!\u0011qEA\r\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\t\u0011\u0005-\u00121\u0002a\u0001\u0003[\t\u0001B]3ta>t7/\u001a\t\u0005\u0003/\ty#\u0003\u0003\u00022\u0005e!a\u0005%uiB\u001cVM\u001d<mKR\u0014Vm\u001d9p]N,\u0007\u0002CA\u001b\u0003\u0017\u0001\r!a\u000e\u00021M,8mY3tg\u001a,H.Q;uQ\u0016tG/[2bi&|g\u000e\u0005\u0003\u0002:\u0005mR\"\u0001\u0019\n\u0007\u0005u\u0002G\u0001\bBkRDWM\u001c;jG\u0006$\u0018n\u001c8\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u00051\u0002O]8dKN\u001c\u0018)\u001e;p\u0019><\u0017N\\\"p_.LW\r\u0006\u0005\u0002F\u0005-\u0013QKA,!\ri\u0013qI\u0005\u0004\u0003\u0013r#aC+tKJ$U\r^1jYND\u0001\"!\u0014\u0002@\u0001\u0007\u0011qJ\u0001\rG>|7.[3U_.,gn\u001d\t\u0005#\u0006ES$C\u0002\u0002T\r\u0012Q!\u0011:sCfD\u0001\"a\u0005\u0002@\u0001\u0007\u0011Q\u0003\u0005\t\u0003W\ty\u00041\u0001\u0002.!9\u00111\f\u0001\u0005B\u0005u\u0013A\u00027pO>,H\u000fF\u0004`\u0003?\n\t'a\u0019\t\u0011\u0005M\u0011\u0011\fa\u0001\u0003+A\u0001\"a\u000b\u0002Z\u0001\u0007\u0011Q\u0006\u0005\b\u0007\u0005e\u0003\u0019AA\u001c\u0011\u001d\t9\u0007\u0001C\t\u0003S\n!cZ3oKJ\fG/Z*fe&,7\u000fR1uCV\tQ\u0004C\u0004\u0002n\u0001!\t\"!\u001b\u0002#\u001d,g.\u001a:bi\u0016$vn[3o\t\u0006$\u0018\rC\u0004\u0002r\u0001!I!a\u001d\u0002\u0013\u0005$GmQ8pW&,GcB0\u0002v\u0005}\u0014\u0011\u0011\u0005\t\u0003o\ny\u00071\u0001\u0002z\u0005)Ao\\6f]B\u0019Q\"a\u001f\n\u0007\u0005udBA\rQKJ\u001c\u0018n\u001d;f]R\u0014V-\\3nE\u0016\u0014X*\u001a+pW\u0016t\u0007\u0002CA\n\u0003_\u0002\r!!\u0006\t\u0011\u0005-\u0012q\u000ea\u0001\u0003[Aq!!\"\u0001\t\u0003\t9)A\btKR\u001cVM]5fg2+gn\u001a;i)\ry\u0016\u0011\u0012\u0005\u00077\u0006\r\u0005\u0019\u0001)\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\u0006q1/\u001a;U_.,g\u000eT3oORDGcA0\u0002\u0012\"1q-a#A\u0002ACq!!&\u0001\t\u0003\n9*A\ftKR$vn[3o-\u0006d\u0017\u000eZ5usN+7m\u001c8egR\u0019q,!'\t\u000f\u0005m\u00151\u0013a\u0001!\u0006!Bo\\6f]Z\u000bG.\u001b3jif\u001cVmY8oINDA\"a(\u0001!\u0003\u0005\t\u0011!C\u0001\u0003C\u000bq\u0003\u001d:pi\u0016\u001cG/\u001a3%O\u0016$8i\\8lS\u0016t\u0015-\\3\u0015\t\u0005\r\u0016q\u0016\u000b\u0003\u0003K\u0003B!a*\u0002.6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W+\u0018\u0001\u00027b]\u001eL1\u0001KAU\u0011!\u0019\u0017QTA\u0001\u0002\u00049\u0005\u0002DAZ\u0001A\u0005\t\u0011!A\u0005\u0002\u0005U\u0016A\u00069s_R,7\r^3eI\u0011,7m\u001c3f\u0007>|7.[3\u0015\t\u0005]\u0016Q\u0018\u000b\u0005\u0003s\u000bY\fE\u0003R\u0003#\n)\u000bC\u0005d\u0003c\u000b\t\u00111\u0001\u0002&\"A1-!-\u0002\u0002\u0003\u0007q\t")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final ServerConfiguration serverConfiguration;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String x$12) {
        return x$1.decodeCookie(x$12);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        block2: {
            if (!this.serverConfiguration.isClientSessionRememberEnabled()) break block2;
            String username = successfulAuthentication.getName();
            this.logger.debug((Object)("Creating new persistent login for user " + username));
            PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
            try {
                this.tokenRepository.createNewToken(persistentToken);
                this.addCookie(persistentToken, request, response);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
            }
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain " + 2 + " tokens, but contained '" + Arrays.asList((Object[])new String[][]{cookieTokens}) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing persistent login token for user '" + token.getUsername() + "', series '" + token.getSeries() + "'"));
        }
        if (!this.serverConfiguration.isClientSessionRememberEnabled()) {
            throw new RememberMeAuthenticationException("Remember-me login is disabled");
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])request.getCookies())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$2(this, c);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.seriesLength())));
    }

    public String generateTokenData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.tokenLength())));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}), this.getTokenValiditySeconds(), request, response);
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).headOption().foreach((Function1 & Serializable & scala.Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository, ServerConfiguration serverConfiguration) {
        this.tokenRepository = tokenRepository;
        this.serverConfiguration = serverConfiguration;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
    }
}

