/*
 * Decompiled with CFR 0.152.
 */
package org.lmdbjava;

import java.util.Objects;
import jnr.ffi.Pointer;
import jnr.ffi.byref.NativeLongByReference;
import org.lmdbjava.Env;
import org.lmdbjava.GetOp;
import org.lmdbjava.KeyVal;
import org.lmdbjava.Library;
import org.lmdbjava.LmdbException;
import org.lmdbjava.LmdbNativeException;
import org.lmdbjava.MaskedFlag;
import org.lmdbjava.PutFlags;
import org.lmdbjava.ResultCodeMapper;
import org.lmdbjava.SeekOp;
import org.lmdbjava.Txn;

public final class Cursor<T>
implements AutoCloseable {
    private boolean closed;
    private final KeyVal<T> kv;
    private final Pointer ptrCursor;
    private Txn<T> txn;

    Cursor(Pointer ptr, Txn<T> txn) {
        Objects.requireNonNull(ptr);
        Objects.requireNonNull(txn);
        this.ptrCursor = ptr;
        this.txn = txn;
        this.kv = txn.newKeyVal();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (Env.SHOULD_CHECK && !this.txn.isReadOnly()) {
            this.txn.checkReady();
        }
        Library.LIB.mdb_cursor_close(this.ptrCursor);
        this.kv.close();
        this.closed = true;
    }

    public long count() {
        if (Env.SHOULD_CHECK) {
            this.checkNotClosed();
            this.txn.checkReady();
        }
        NativeLongByReference longByReference = new NativeLongByReference();
        ResultCodeMapper.checkRc(Library.LIB.mdb_cursor_count(this.ptrCursor, longByReference));
        return longByReference.longValue();
    }

    public void delete(PutFlags ... f) {
        if (Env.SHOULD_CHECK) {
            this.checkNotClosed();
            this.txn.checkReady();
            this.txn.checkWritesAllowed();
        }
        int flags = MaskedFlag.mask(f);
        ResultCodeMapper.checkRc(Library.LIB.mdb_cursor_del(this.ptrCursor, flags));
    }

    public boolean first() {
        return this.seek(SeekOp.MDB_FIRST);
    }

    public boolean get(T key, GetOp op) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(op);
            this.checkNotClosed();
            this.txn.checkReady();
        }
        this.kv.keyIn(key);
        int rc = Library.LIB.mdb_cursor_get(this.ptrCursor, this.kv.pointerKey(), this.kv.pointerVal(), op.getCode());
        if (rc == -30798) {
            return false;
        }
        ResultCodeMapper.checkRc(rc);
        this.kv.keyOut();
        this.kv.valOut();
        return true;
    }

    public T key() {
        return this.kv.key();
    }

    public boolean last() {
        return this.seek(SeekOp.MDB_LAST);
    }

    public boolean next() {
        return this.seek(SeekOp.MDB_NEXT);
    }

    public boolean prev() {
        return this.seek(SeekOp.MDB_PREV);
    }

    public boolean put(T key, T val, PutFlags ... op) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(val);
            this.checkNotClosed();
            this.txn.checkReady();
            this.txn.checkWritesAllowed();
        }
        this.kv.keyIn(key);
        this.kv.valIn(val);
        int mask = MaskedFlag.mask(op);
        int rc = Library.LIB.mdb_cursor_put(this.ptrCursor, this.kv.pointerKey(), this.kv.pointerVal(), mask);
        if (rc == -30799) {
            if (MaskedFlag.isSet(mask, PutFlags.MDB_NOOVERWRITE)) {
                this.kv.valOut();
            } else if (!MaskedFlag.isSet(mask, PutFlags.MDB_NODUPDATA)) {
                ResultCodeMapper.checkRc(rc);
            }
            return false;
        }
        ResultCodeMapper.checkRc(rc);
        return true;
    }

    public void putMultiple(T key, T val, int elements, PutFlags ... op) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(this.txn);
            Objects.requireNonNull(key);
            Objects.requireNonNull(val);
            this.txn.checkReady();
            this.txn.checkWritesAllowed();
        }
        int mask = MaskedFlag.mask(op);
        if (Env.SHOULD_CHECK && !MaskedFlag.isSet(mask, PutFlags.MDB_MULTIPLE)) {
            throw new IllegalArgumentException("Must set " + PutFlags.MDB_MULTIPLE + " flag");
        }
        this.txn.kv().keyIn(key);
        Pointer dataPtr = this.txn.kv().valInMulti(val, elements);
        int rc = Library.LIB.mdb_cursor_put(this.ptrCursor, this.txn.kv().pointerKey(), dataPtr, mask);
        ResultCodeMapper.checkRc(rc);
    }

    public void renew(Txn<T> newTxn) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(newTxn);
            this.checkNotClosed();
            this.txn.checkReadOnly();
            newTxn.checkReadOnly();
            newTxn.checkReady();
        }
        ResultCodeMapper.checkRc(Library.LIB.mdb_cursor_renew(newTxn.pointer(), this.ptrCursor));
        this.txn = newTxn;
    }

    public T reserve(T key, int size, PutFlags ... op) {
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(key);
            this.checkNotClosed();
            this.txn.checkReady();
            this.txn.checkWritesAllowed();
        }
        this.kv.keyIn(key);
        this.kv.valIn(size);
        int flags = MaskedFlag.mask(op) | PutFlags.MDB_RESERVE.getMask();
        ResultCodeMapper.checkRc(Library.LIB.mdb_cursor_put(this.ptrCursor, this.kv.pointerKey(), this.kv.pointerVal(), flags));
        this.kv.valOut();
        return this.val();
    }

    public boolean seek(SeekOp op) {
        int rc;
        if (Env.SHOULD_CHECK) {
            Objects.requireNonNull(op);
            this.checkNotClosed();
            this.txn.checkReady();
        }
        if ((rc = Library.LIB.mdb_cursor_get(this.ptrCursor, this.kv.pointerKey(), this.kv.pointerVal(), op.getCode())) == -30798) {
            return false;
        }
        ResultCodeMapper.checkRc(rc);
        this.kv.keyOut();
        this.kv.valOut();
        return true;
    }

    public T val() {
        return this.kv.val();
    }

    private void checkNotClosed() throws ClosedException {
        if (this.closed) {
            throw new ClosedException();
        }
    }

    public static final class FullException
    extends LmdbNativeException {
        static final int MDB_CURSOR_FULL = -30787;
        private static final long serialVersionUID = 1L;

        FullException() {
            super(-30787, "Cursor stack too deep - internal error");
        }
    }

    public static final class ClosedException
    extends LmdbException {
        private static final long serialVersionUID = 1L;

        public ClosedException() {
            super("Cursor has already been closed");
        }
    }
}

