/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm.connector.github;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException$;
import com.xebialabs.xlrelease.versioning.scm.connector.Attachments;
import com.xebialabs.xlrelease.versioning.scm.connector.BasicScmConnector;
import com.xebialabs.xlrelease.versioning.scm.connector.BinaryFile;
import com.xebialabs.xlrelease.versioning.scm.connector.Blobs;
import com.xebialabs.xlrelease.versioning.scm.connector.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubOAuth2Token;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubScmCredential;
import com.xebialabs.xlrelease.versioning.scm.connector.github.GitHubUsernamePasswordCredential;
import java.io.Serializable;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.RateLimitHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001B\u0001\u0003\u0001E\u0011!cR5u\u0011V\u00147kY7D_:tWm\u0019;pe*\u00111\u0001B\u0001\u0007O&$\b.\u001e2\u000b\u0005\u00151\u0011!C2p]:,7\r^8s\u0015\t9\u0001\"A\u0002tG6T!!\u0003\u0006\u0002\u0015Y,'o]5p]&twM\u0003\u0002\f\u0019\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u001b9\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003=\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0003\n\u0005U!!!\u0005\"bg&\u001c7kY7D_:tWm\u0019;pe\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004d_:4\u0017n\u001a\t\u00033ii\u0011AA\u0005\u00037\t\u0011\u0001dR5u\u0011V\u00147kY7D_:tWm\u0019;pe\u000e{gNZ5h\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u00033\u0001AQa\u0006\u000fA\u0002aA\u0001B\t\u0001\t\u0006\u0004%IaI\u0001\u0006?J,\u0007o\\\u000b\u0002IA\u0019QE\u000b\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002S\u0005)1oY1mC&\u00111F\n\u0002\u0004)JL\bCA\u00174\u001b\u0005q#BA\u00020\u0015\t\u0001\u0014'A\u0004l_\"\u001cXo[3\u000b\u0003I\n1a\u001c:h\u0013\t!dF\u0001\u0007H\u0011J+\u0007o\\:ji>\u0014\u0018\u0010C\u00037\u0001\u0011Es'\u0001\buKN$(+\u001a9pg&$xN]=\u0016\u0003a\u00022!\n\u0016:!\tQ4(D\u0001)\u0013\ta\u0004F\u0001\u0003V]&$\b\"\u0002 \u0001\t#z\u0014\u0001D2p[6LG/\u00118e)\u0006<G\u0003\u0002!M#Z\u00032!\n\u0016B!\t\u0011\u0015J\u0004\u0002D\u000fB\u0011A\tK\u0007\u0002\u000b*\u0011a\tE\u0001\u0007yI|w\u000e\u001e \n\u0005!C\u0013A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n11\u000b\u001e:j]\u001eT!\u0001\u0013\u0015\t\u000b5k\u0004\u0019\u0001(\u0002\u000b\tdwNY:\u0011\u0005My\u0015B\u0001)\u0005\u0005\u0015\u0011En\u001c2t\u0011\u0015\u0011V\b1\u0001T\u0003)\u0019w.\\7ji&sgm\u001c\t\u0003'QK!!\u0016\u0003\u0003'Y\u000bG.\u001b3bi\u0016$7i\\7nSRLeNZ8\t\u000b]k\u0004\u0019A!\u0002\tU\u001cXM\u001d\u0005\u00063\u0002!\tFW\u0001\u000ei\u0006<gj\u001c;Qe\u0016\u001cXM\u001c;\u0015\u0005m{\u0006cA\u0013+9B\u0011!(X\u0005\u0003=\"\u0012qAQ8pY\u0016\fg\u000eC\u0003a1\u0002\u0007\u0011)A\u0002uC\u001eDQA\u0019\u0001\u0005\n\r\f1EZ5mi\u0016\u0014x*\u001e;BYJ,\u0017\rZ=Va2|\u0017\rZ3e\u0003R$\u0018m\u00195nK:$8\u000f\u0006\u0003eO&t\u0007CA\nf\u0013\t1GAA\u0006BiR\f7\r[7f]R\u001c\b\"\u00025b\u0001\u0004a\u0013\u0001\u0002:fa>DQA[1A\u0002-\f\u0001BY1tKR\u0013X-\u001a\t\u0003[1L!!\u001c\u0018\u0003\r\u001dCEK]3f\u0011\u0015y\u0017\r1\u0001e\u0003-\tG\u000f^1dQ6,g\u000e^:\t\u000bE\u0004A\u0011\u0002:\u0002\u0015Q\u0014\u0018pQ8o]\u0016\u001cG\u000fF\u0001t!\r)#\u0006\u001e\t\u0003[UL!A\u001e\u0018\u0003\r\u001dKG\u000fS;c\u000b\u0011A\b\u0001A=\u0003\u00179\u000bW.\u001a3H\u0011\ncwN\u0019\t\u0005ui\fE0\u0003\u0002|Q\t1A+\u001e9mKJ\u0002\"!L?\n\u0005yt#AB$I\u00052|'\rC\u0004\u0002\u0002\u0001!I!a\u0001\u0002\u0017U\u0004Hn\\1e\u00052|'m\u001d\u000b\t\u0003\u000b\ti\"!\t\u0002$A!QEKA\u0004!\u0019\tI!a\u0005\u0002\u001a9!\u00111BA\b\u001d\r!\u0015QB\u0005\u0002S%\u0019\u0011\u0011\u0003\u0015\u0002\u000fA\f7m[1hK&!\u0011QCA\f\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005E\u0001\u0006E\u0002\u0002\u001c]l\u0011\u0001\u0001\u0005\u0007\u0003?y\b\u0019A!\u0002\u0011\u0019LG.\u001a9bi\"DQ!T@A\u00029CQ\u0001[@A\u00021Bq!a\n\u0001\t\u0013\tI#\u0001\u0006de\u0016\fG/\u001a+sK\u0016$\u0002\"a\u000b\u0002.\u0005=\u00121\u0007\t\u0004K)Z\u0007B\u00025\u0002&\u0001\u0007A\u0006C\u0004\u00022\u0005\u0015\u0002\u0019A!\u0002\u0017\t\f7/\u001a+sK\u0016\u001c\u0006.\u0019\u0005\b\u001b\u0006\u0015\u0002\u0019AA\u001b!\u0019\tI!a\u000e\u0002\u001a%!\u0011\u0011HA\f\u0005!IE/\u001a:bE2,\u0007")
public class GitHubScmConnector
extends BasicScmConnector {
    private Try<GHRepository> _repo;
    private final GitHubScmConnectorConfig config;
    private volatile boolean bitmap$0;

    private Try<GHRepository> _repo$lzycompute() {
        GitHubScmConnector gitHubScmConnector = this;
        synchronized (gitHubScmConnector) {
            if (!this.bitmap$0) {
                Try repo = this.tryConnect().map((Function1 & Serializable & scala.Serializable)gh -> gh.getRepository($this.config.repository()));
                this._repo = repo.recoverWith((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        HttpException httpException;
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof GHFileNotFoundException) {
                            GHFileNotFoundException gHFileNotFoundException = (GHFileNotFoundException)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Repository not found", (Throwable)gHFileNotFoundException, 404)));
                        } else if (A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 401) {
                            object = new Failure((Throwable)((Object)new TemplateVersioningException("Invalid credentials", (Throwable)httpException, 401)));
                        } else if (A1 instanceof Exception) {
                            Exception exception = (Exception)A1;
                            object = new Failure((Throwable)((Object)new TemplateVersioningException(exception.getMessage(), TemplateVersioningException$.MODULE$.apply$default$2(), TemplateVersioningException$.MODULE$.apply$default$3())));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        HttpException httpException;
                        Throwable throwable = x1;
                        boolean bl = throwable instanceof GHFileNotFoundException ? true : (throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 401 ? true : throwable instanceof Exception);
                        return bl;
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this._repo;
    }

    private Try<GHRepository> _repo() {
        return !this.bitmap$0 ? this._repo$lzycompute() : this._repo;
    }

    @Override
    public Try<BoxedUnit> testRepository() {
        return this._repo().map((Function1 & Serializable & scala.Serializable)x$1 -> {
            GitHubScmConnector.$anonfun$testRepository$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Try<String> commitAndTag(Blobs blobs, ValidatedCommitInfo commitInfo, String user) {
        return this._repo().flatMap((Function1 & Serializable & scala.Serializable)repo -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getRef(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heads/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.config.branch()})))).recoverWith((PartialFunction)new scala.Serializable(this, (GHRepository)repo){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GitHubScmConnector $outer;
            private final GHRepository repo$5;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                HttpException httpException;
                A1 A1 = x2;
                Object object = A1 instanceof HttpException && (httpException = (HttpException)A1).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$5) : (A1 instanceof GHFileNotFoundException ? this.$outer.com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(this.repo$5) : function1.apply(x2));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x2) {
                HttpException httpException;
                Throwable throwable = x2;
                boolean bl = throwable instanceof HttpException && (httpException = (HttpException)throwable).getResponseCode() == 200 && httpException.getCause().getCause() instanceof MismatchedInputException ? true : throwable instanceof GHFileNotFoundException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.repo$5 = repo$5;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)headRef -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getTree($this.config.branch())).map((Function1 & Serializable & scala.Serializable)baseTree -> {
            Blobs newBlobs = new Blobs(blobs.templateId(), blobs.dsl(), this.filterOutAlreadyUploadedAttachments((GHRepository)repo, (GHTree)baseTree, blobs.attachments()));
            return new Tuple2(baseTree, (Object)newBlobs);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GHTree baseTree = (GHTree)tuple2._1();
            Blobs newBlobs = (Blobs)tuple2._2();
            Try try_ = this.uploadBlobs(blobs.filePath(), newBlobs, (GHRepository)repo).flatMap((Function1 & Serializable & scala.Serializable)ghNamedBlobs -> this.createTree((GHRepository)repo, baseTree.getSha(), (Iterable<Tuple2<String, GHBlob>>)ghNamedBlobs).flatMap((Function1 & Serializable & scala.Serializable)newTree -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.createCommit().message(commitInfo.message()).tree(newTree.getSha()).parent(headRef.getObject().getSha()).create()).flatMap((Function1 & Serializable & scala.Serializable)commit -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.createRef(commitInfo.tag().toString(), commit.getSHA1())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> headRef.updateTo(commit.getSHA1())).map((Function1 & Serializable & scala.Serializable)_ -> commit.getSHA1())))));
            return try_;
        })));
    }

    @Override
    public Try<Object> tagNotPresent(String tag) {
        return this._repo().map((Function1 & Serializable & scala.Serializable)repo -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$tagNotPresent$1(tag, repo)));
    }

    private Attachments filterOutAlreadyUploadedAttachments(GHRepository repo, GHTree baseTree, Attachments attachments) {
        Seq toUpload = attachments.files().isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)Option$.MODULE$.apply((Object)baseTree.getEntry("XLRelease")).flatMap((Function1 & Serializable & scala.Serializable)rootTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> rootTreeEntry.asTree()).toOption().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$3(x$3))).flatMap((Function1 & Serializable & scala.Serializable)rootTree -> Option$.MODULE$.apply((Object)rootTree.getEntry(".attachments")).flatMap((Function1 & Serializable & scala.Serializable)attachmentTreeEntry -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachmentTreeEntry.asTree()).toOption().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)GitHubScmConnector.$anonfun$filterOutAlreadyUploadedAttachments$7(x$4))).map((Function1 & Serializable & scala.Serializable)attachmentTree -> {
            BoxedUnit boxedUnit;
            Map filesMap = (Map)Map$.MODULE$.apply((Seq)attachments.files().map((Function1 & Serializable & scala.Serializable)file -> new Tuple2((Object)file.fileName(), file), Seq$.MODULE$.canBuildFrom()));
            ((IterableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(attachmentTree.getTree()).asScala()).view().takeWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)filesMap.nonEmpty()))).foreach((Function1 & Serializable & scala.Serializable)entry -> (Map)filesMap.$minus$eq((Object)entry.getPath()));
            if (filesMap.nonEmpty() && attachmentTree.isTruncated()) {
                scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)filesMap.flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getFileContent(attachments.folderName() + "/" + filename, $this.config.branch())).toOption().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName())), Iterable$.MODULE$.canBuildFrom());
                boxedUnit = filesMap.$minus$minus$eq((TraversableOnce)toRemove);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return filesMap.values().toSeq();
        })))).getOrElse((Function0 & Serializable & scala.Serializable)() -> attachments.files());
        return new Attachments(attachments.folderName(), (Seq<BinaryFile>)toUpload);
    }

    private Try<GitHub> tryConnect() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GitHubBuilder gitHubBuilder;
            GitHubBuilder builder = new GitHubBuilder().withRateLimitHandler(RateLimitHandler.FAIL).withAbuseLimitHandler(AbuseLimitHandler.FAIL).withEndpoint($this.config.restApiUrl());
            GitHubScmCredential gitHubScmCredential = $this.config.credential();
            if (gitHubScmCredential instanceof GitHubUsernamePasswordCredential) {
                GitHubUsernamePasswordCredential gitHubUsernamePasswordCredential = (GitHubUsernamePasswordCredential)gitHubScmCredential;
                gitHubBuilder = builder.withPassword(gitHubUsernamePasswordCredential.username(), PasswordEncrypter.getInstance().ensureDecrypted(gitHubUsernamePasswordCredential.password()));
            } else if (gitHubScmCredential instanceof GitHubOAuth2Token) {
                GitHubOAuth2Token gitHubOAuth2Token = (GitHubOAuth2Token)gitHubScmCredential;
                gitHubBuilder = builder.withOAuthToken(PasswordEncrypter.getInstance().ensureDecrypted(gitHubOAuth2Token.token()));
            } else {
                if (gitHubScmCredential == null) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No credential provided for GitHub SCM config '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.config.getTitle()})));
                }
                throw new MatchError((Object)gitHubScmCredential);
            }
            return builder.build();
        });
    }

    private Try<List<Tuple2<String, GHBlob>>> uploadBlobs(String filepath, Blobs blobs, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ListBuffer ghBlobs = (ListBuffer)ListBuffer$.MODULE$.empty();
            ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filepath), (Object)repo.createBlob().binaryContent((byte[])blobs.dsl().getContent().apply()).create()));
            blobs.attachments().files().foreach((Function1 & Serializable & scala.Serializable)attachment -> ghBlobs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(blobs.attachments().folderName() + "/" + attachment.fileName())), (Object)repo.createBlob().binaryContent((byte[])attachment.getContent().apply()).create())));
            return ghBlobs.toList();
        });
    }

    private Try<GHTree> createTree(GHRepository repo, String baseTreeSha, Iterable<Tuple2<String, GHBlob>> blobs) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GHTreeBuilder builder = repo.createTree().baseTree(baseTreeSha);
            blobs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String filename = (String)tuple2._1();
                GHBlob ghBlob = (GHBlob)tuple2._2();
                GHTreeBuilder gHTreeBuilder = builder.shaEntry(filename, ghBlob.getSha(), false);
                return gHTreeBuilder;
            });
            return builder.create();
        });
    }

    public static final /* synthetic */ void $anonfun$testRepository$1(GHRepository x$1) {
    }

    public final Try com$xebialabs$xlrelease$versioning$scm$connector$github$GitHubScmConnector$$createBranch$1(GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            GHRef defaultBranch = repo.getRef(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heads/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repo.getDefaultBranch()})));
            return repo.createRef(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"refs/heads/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.config.branch()})), defaultBranch.getObject().getSha());
        });
    }

    public static final /* synthetic */ boolean $anonfun$tagNotPresent$1(String tag$1, GHRepository repo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> repo.getRef("tags/" + tag$1)).failed().isSuccess();
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$3(GHTree x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutAlreadyUploadedAttachments$7(GHTree x$4) {
        return x$4 != null;
    }

    public GitHubScmConnector(GitHubScmConnectorConfig config) {
        this.config = config;
        super(config);
    }
}

