/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.api;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.DateParam;
import com.xebialabs.xlrelease.api.utils.ResponseHelper;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile;
import com.xebialabs.xlrelease.plugins.dashboard.service.TileService;
import com.xebialabs.xlrelease.reports.api.ReportResource;
import com.xebialabs.xlrelease.reports.excel.ReportExcel;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.filters.impl.DateFilter;
import com.xebialabs.xlrelease.reports.service.ReportParams;
import com.xebialabs.xlrelease.reports.utils.ReportUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/export")
@Controller
public class ExportResourceReports {
    private static final String EXCEL_CONTENT_TYPE = "application/vnd.ms-excel";
    private static final String EXCEL_EXTENSION = ".xlsx";
    private ReportExcel reportExcel;
    private TileService tileService;

    @Autowired
    public ExportResourceReports(ReportExcel reportExcel, TileService tileService) {
        this.reportExcel = reportExcel;
        this.tileService = tileService;
    }

    @GET
    @Path(value="report")
    @Produces(value={"application/octet-stream"})
    public Response exportReportToExcel(@DefaultValue(value="LAST_SIX_MONTHS") @QueryParam(value="since") TimeFrame timeFrame, @QueryParam(value="report") ReportResource.ReportType report, @QueryParam(value="tags") String tags, @QueryParam(value="from") @DateParam Date from, @QueryParam(value="to") @DateParam Date to) {
        ReportParams reportParams = ReportParams.apply(timeFrame, from, to, ReportUtils.splitTags(tags), new ArrayList<ReportFilter>(), true, null, true);
        Workbook workbook = this.reportExcel.getWorkBook(report, reportParams);
        StreamingOutput output = arg_0 -> ((Workbook)workbook).write(arg_0);
        return ResponseHelper.streamFile((String)(report.name().toLowerCase() + EXCEL_EXTENSION), (StreamingOutput)output, (String)EXCEL_CONTENT_TYPE);
    }

    @GET
    @Path(value="tile-report")
    @Produces(value={"application/octet-stream"})
    public Response exportTileReportToExcel(@QueryParam(value="report") ReportResource.ReportType report, @QueryParam(value="tileId") String tileId) {
        Tile tile = this.tileService.findTileById(tileId);
        List filters = (List)tile.getProperty("filters");
        if (filters != null) {
            DateFilter dateFilter = (DateFilter)filters.stream().filter(filter -> filter.getType().instanceOf(Type.valueOf(DateFilter.class))).findFirst().orElse(new DateFilter(TimeFrame.LAST_SIX_MONTHS));
            ReportParams reportParams = ReportParams.apply(dateFilter.getTimeFrame(), dateFilter.getFrom(), dateFilter.getTo(), null, filters, false, null, true);
            Workbook workbook = this.reportExcel.getWorkBook(report, reportParams);
            StreamingOutput output = arg_0 -> ((Workbook)workbook).write(arg_0);
            return ResponseHelper.streamFile((String)(report.name().toLowerCase() + EXCEL_EXTENSION), (StreamingOutput)output, (String)EXCEL_CONTENT_TYPE);
        }
        return Response.noContent().build();
    }
}

