/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.FacetRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.CloseableUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u0001-\u0011ac\u00115b]\u001e,W\t_3dkRLwN\\*feZL7-\u001a\u0006\u0003\u0007\u0011\tqa]3sm&\u001cWM\u0003\u0002\u0006\r\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u000f!\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0006g24GG\u001b\u0006\u0002/\u0005AqM]5{u2,G-\u0003\u0002\u001a)\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u001d\r|W.\\3oiN+'O^5dKV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\tq1i\\7nK:$8+\u001a:wS\u000e,\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u001f\r|W.\\3oiN+'O^5dK\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\u0012CR$\u0018m\u00195nK:$8+\u001a:wS\u000e,W#\u0001\u0014\u0011\u0005y9\u0013B\u0001\u0015\u0003\u0005E\tE\u000f^1dQ6,g\u000e^*feZL7-\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005M\u0005\u0011\u0012\r\u001e;bG\"lWM\u001c;TKJ4\u0018nY3!\u0011!a\u0003A!b\u0001\n\u0003i\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u001a1\u00059!\u0016m]6SKB|7/\u001b;pefD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0010i\u0006\u001c8NU3q_NLGo\u001c:zA!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001(\u0001\u000bbiR\f7\r[7f]R\u0014V\r]8tSR|'/_\u000b\u0002sA\u0011qFO\u0005\u0003wA\u0012A#\u0011;uC\u000eDW.\u001a8u%\u0016\u0004xn]5u_JL\b\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002+\u0005$H/Y2i[\u0016tGOU3q_NLGo\u001c:zA!Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012!\u0011\t\u0003_\tK!a\u0011\u0019\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003B\u0003I\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0011\t\u0011\u001d\u0003!Q1A\u0005\u0002!\u000bqBZ1dKR\u0014V\r]8tSR|'/_\u000b\u0002\u0013B\u0011qFS\u0005\u0003\u0017B\u0012qBR1dKR\u0014V\r]8tSR|'/\u001f\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0013\u0006\u0001b-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010\t\u0005\t\u001f\u0002\u0011)\u0019!C\u0001!\u0006AQM^3oi\n+8/F\u0001R!\t\u0011V+D\u0001T\u0015\t!F!\u0001\u0004fm\u0016tGo]\u0005\u0003-N\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0011!A\u0006A!A!\u0002\u0013\t\u0016!C3wK:$()^:!\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0019a\u0014N\\5u}QAA,\u00180`A\u0006\u00147\r\u0005\u0002\u001f\u0001!)1$\u0017a\u0001;!)A%\u0017a\u0001M!)A&\u0017a\u0001]!)q'\u0017a\u0001s!)q(\u0017a\u0001\u0003\")q)\u0017a\u0001\u0013\")q*\u0017a\u0001#\"\u0012\u0011,\u001a\t\u0003MFl\u0011a\u001a\u0006\u0003Q&\f!\"\u00198o_R\fG/[8o\u0015\tQ7.A\u0004gC\u000e$xN]=\u000b\u00051l\u0017!\u00022fC:\u001c(B\u00018p\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sO\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006i\u0002!\t!^\u0001\bKb,7-\u001e;f)\u00111\u00180a\u0001\u0011\u000559\u0018B\u0001=\u000f\u0005\u0011)f.\u001b;\t\u000bi\u001c\b\u0019A>\u0002\u000f\rD\u0017M\\4fgB\u0011Ap`\u0007\u0002{*\u0011a\u0010B\u0001\u0007I>l\u0017-\u001b8\n\u0007\u0005\u0005QPA\u0004DQ\u0006tw-Z:\t\u000f\u0005\u00151\u000f1\u0001\u0002\b\u0005!Qo]3s!\u0011\tI!!\u0004\u000e\u0005\u0005-!bAA\u0003\t%!\u0011qBA\u0006\u0005\u0011)6/\u001a:)\u0007M\f\u0019\u0002\u0005\u0003\u0002\u0016\u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0005\u0003;\ty\"A\u0002tc2T1!!\t\u0005\u0003\t!'-\u0003\u0003\u0002&\u0005]!aD%t)J\fgn]1di&|g.\u00197\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,\u0005y1m\u001c7mK\u000e$8i\\7nK:$8\u000f\u0006\u0004\u0002.\u0005\u0005\u00141\r\t\t\u0003_\ti$a\u0011\u0002J9!\u0011\u0011GA\u001d!\r\t\u0019DD\u0007\u0003\u0003kQ1!a\u000e\u000b\u0003\u0019a$o\\8u}%\u0019\u00111\b\b\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\u00075\u000b\u0007OC\u0002\u0002<9\u00012\u0001`A#\u0013\r\t9% \u0002\u0005)\u0006\u001c8\u000e\u0005\u0004\u0002L\u0005U\u00131\f\b\u0005\u0003\u001b\n\tF\u0004\u0003\u00024\u0005=\u0013\"A\b\n\u0007\u0005Mc\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\u0004'\u0016\f(bAA*\u001dA\u0019A0!\u0018\n\u0007\u0005}SPA\u0004D_6lWM\u001c;\t\ri\f9\u00031\u0001|\u0011!\t)!a\nA\u0002\u0005\u001d\u0001bBA4\u0001\u0011%\u0011\u0011N\u0001\u0013G>dG.Z2u\u0003R$\u0018m\u00195nK:$8\u000f\u0006\u0003\u0002l\u0005U\u0004\u0003CA\u0018\u0003{\t\u0019%!\u001c\u0011\r\u0005-\u0013QKA8!\ra\u0018\u0011O\u0005\u0004\u0003gj(AC!ui\u0006\u001c\u0007.\\3oi\"1!0!\u001aA\u0002mDq!!\u001f\u0001\t#\tY(\u0001\nqe>\u001cWm]:BiR\f7\r[7f]R\u001cH#\u0002<\u0002~\u00055\u0005\u0002CA@\u0003o\u0002\r!!!\u0002\u0011I,G.Z1tKN\u0004b!a\f\u0002\u0004\u0006\u001d\u0015\u0002BAC\u0003\u0003\u00121aU3u!\ra\u0018\u0011R\u0005\u0004\u0003\u0017k(a\u0002*fY\u0016\f7/\u001a\u0005\t\u0003\u001f\u000b9\b1\u0001\u0002l\u0005\t\u0012\r\u001e;bG\"lWM\u001c;t\u0005f$\u0016m]6\t\u000f\u0005M\u0005\u0001\"\u0005\u0002\u0016\u0006y\u0001O]8dKN\u001c8i\\7nK:$8\u000fF\u0003w\u0003/\u000bY\n\u0003\u0005\u0002\u001a\u0006E\u0005\u0019AA\u0017\u00039\u0019w.\\7f]R\u001c()\u001f+bg.D\u0001\"!\u0002\u0002\u0012\u0002\u0007\u0011q\u0001\u0015\u0004\u0001\u0005}\u0005\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015V.\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!+\u0002$\n91+\u001a:wS\u000e,\u0007")
public class ChangeExecutionService
implements Logging {
    private final CommentService commentService;
    private final AttachmentService attachmentService;
    private final TaskRepository taskRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseRepository releaseRepository;
    private final FacetRepository facetRepository;
    private final XLReleaseEventBus eventBus;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ChangeExecutionService changeExecutionService = this;
        synchronized (changeExecutionService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public CommentService commentService() {
        return this.commentService;
    }

    public AttachmentService attachmentService() {
        return this.attachmentService;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public AttachmentRepository attachmentRepository() {
        return this.attachmentRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public FacetRepository facetRepository() {
        return this.facetRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    @IsTransactional
    public void execute(Changes changes, User user) {
        Set releases = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> ((PlanItem)x$2).getRelease(), Set$.MODULE$.canBuildFrom())).toSet();
        Set tasks = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$3(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> (Task)x$4, Set$.MODULE$.canBuildFrom())).toSet();
        Set facets = ((TraversableOnce)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(changes.getUpdatedItems()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ChangeExecutionService.$anonfun$execute$5(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> (Facet)x$6, Set$.MODULE$.canBuildFrom())).toSet();
        facets.foreach((Function1 & Serializable & scala.Serializable)facet -> this.facetRepository().update((Facet)facet));
        this.processAttachments((Set<Release>)releases, this.collectAttachments(changes));
        tasks.foreach((Function1 & Serializable & scala.Serializable)task -> {
            ChangeExecutionService.$anonfun$execute$8(this, task);
            return BoxedUnit.UNIT;
        });
        this.processComments(this.collectComments(changes, user), user);
    }

    private Map<Task, Seq<Comment>> collectComments(Changes changes, User user) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getCommentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection commentTexts = (Collection)tuple2._2();
            Seq userComments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(commentTexts).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                User u = (User)tuple3._1();
                String text = (String)tuple3._2();
                DateTime date = (DateTime)tuple3._3();
                User actualUser = (User)Option$.MODULE$.apply((Object)u).getOrElse((Function0 & Serializable & scala.Serializable)() -> user);
                Comment comment = this.commentService().buildComment(task, text, actualUser, date.toDate(), CommentService.COMMENT_PREFIX_MANUAL, CommentService.COMMENT_SUFFIX);
                return comment;
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getComments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(userComments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)userComments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<Task, Seq<Attachment>> collectAttachments(Changes changes) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(changes.getAttachmentsByTask().asMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task task = (Task)tuple2._1();
            Collection attachments = (Collection)tuple2._2();
            Seq updatedAttachments = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(attachments).asScala()).map((Function1 & Serializable & scala.Serializable)attachment -> (Attachment)CloseableUtils$.MODULE$.using(attachment.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)is -> this.attachmentService().attachToRelease(task.getRelease(), attachment.getFile().getName(), attachment.getContentType(), (InputStream)is)), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq();
            task.getAttachments().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(updatedAttachments).asJava());
            Tuple2 tuple22 = new Tuple2((Object)task, (Object)updatedAttachments);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void processAttachments(Set<Release> releases, Map<Task, Seq<Attachment>> attachmentsByTask) {
        attachmentsByTask.groupBy((Function1 & Serializable & scala.Serializable)x$7 -> ((Task)x$7._1()).getRelease()).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)x$8.flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Seq)x$9._2(), Iterable$.MODULE$.canBuildFrom())).toSeq()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            ChangeExecutionService.$anonfun$processAttachments$4(this, x0$4);
            return BoxedUnit.UNIT;
        });
        releases.$plus$plus((GenTraversableOnce)attachmentsByTask.map((Function1 & Serializable & scala.Serializable)x$10 -> ((Task)x$10._1()).getRelease(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)release -> this.releaseRepository().update((Release)release));
        attachmentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            ChangeExecutionService.$anonfun$processAttachments$7(this, x0$5);
            return BoxedUnit.UNIT;
        });
    }

    public void processComments(Map<Task, Seq<Comment>> commentsByTask, User user) {
        commentsByTask.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            ChangeExecutionService.$anonfun$processComments$1(this, user, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(ConfigurationItem x$1) {
        return x$1 instanceof PlanItem;
    }

    public static final /* synthetic */ boolean $anonfun$execute$3(ConfigurationItem x$3) {
        return x$3 instanceof Task;
    }

    public static final /* synthetic */ boolean $anonfun$execute$5(ConfigurationItem x$5) {
        return x$5 instanceof Facet;
    }

    public static final /* synthetic */ void $anonfun$execute$8(ChangeExecutionService $this, Task task) {
        $this.taskRepository().updateTaskProperties(task);
    }

    public static final /* synthetic */ void $anonfun$processAttachments$4(ChangeExecutionService $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        $this.attachmentRepository().batchInsert(release, (Seq<Attachment>)attachments);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processAttachments$8(ChangeExecutionService $this, Task task$3, Attachment attachment) {
        $this.eventBus().publish((XLReleaseEvent)new AttachmentCreatedEvent(task$3.getId(), attachment));
    }

    public static final /* synthetic */ void $anonfun$processAttachments$7(ChangeExecutionService $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq attachments = (Seq)tuple2._2();
        attachments.foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ChangeExecutionService.$anonfun$processAttachments$8($this, task, attachment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processComments$2(ChangeExecutionService $this, User user$1, Task task$4, Comment comment) {
        $this.commentService().create(task$4, comment);
        $this.eventBus().publish((XLReleaseEvent)new CommentCreatedEvent(task$4, comment, user$1.getName(), false));
    }

    public static final /* synthetic */ void $anonfun$processComments$1(ChangeExecutionService $this, User user$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Task task = (Task)tuple2._1();
        Seq comments = (Seq)tuple2._2();
        comments.foreach((Function1 & Serializable & scala.Serializable)comment -> {
            ChangeExecutionService.$anonfun$processComments$2($this, user$1, task, comment);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Autowired
    public ChangeExecutionService(CommentService commentService, AttachmentService attachmentService, TaskRepository taskRepository, AttachmentRepository attachmentRepository, ReleaseRepository releaseRepository, FacetRepository facetRepository, XLReleaseEventBus eventBus) {
        this.commentService = commentService;
        this.attachmentService = attachmentService;
        this.taskRepository = taskRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseRepository = releaseRepository;
        this.facetRepository = facetRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

