/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.service;

import com.codahale.metrics.annotation.Timed;
import com.github.benmanes.caffeine.cache.Cache;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.ScriptHelper;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardCreatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardDeletedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.events.DashboardUpdatedEvent;
import com.xebialabs.xlrelease.plugins.dashboard.repository.DelegatingDashboardRepository;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurityDecorator;
import com.xebialabs.xlrelease.script.XlrScriptContext;
import com.xebialabs.xlrelease.script.jython.JythonScriptService;
import com.xebialabs.xlrelease.service.CiIdService;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003R1tQ\n|\u0017M\u001d3TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002Z1tQ\n|\u0017M\u001d3\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$A\neCND'm\\1sIJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\t\u0005Q!/\u001a9pg&$xN]=\n\u0005uQ\"!\b#fY\u0016<\u0017\r^5oO\u0012\u000b7\u000f\u001b2pCJ$'+\u001a9pg&$xN]=\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n\u0011\u0003Z1tQ\n|\u0017M\u001d3TK\u000e,(/\u001b;z!\t\t#%D\u0001\u0003\u0013\t\u0019#AA\tECND'm\\1sIN+7-\u001e:jifD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u001bI\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLH)Z2pe\u0006$xN\u001d\t\u0003C\u001dJ!\u0001\u000b\u0002\u00035\u0011\u000b7\u000f\u001b2pCJ$7+Z2ve&$\u0018\u0010R3d_J\fGo\u001c:\t\u0011)\u0002!\u0011!Q\u0001\n-\nAbY1dQ\u0016l\u0015M\\1hKJ\u0004\"\u0001L\u001a\u000e\u00035R!AL\u0018\u0002\u000b\r\f7\r[3\u000b\u0005A\n\u0014aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003I\n1a\u001c:h\u0013\t!TF\u0001\u0007DC\u000eDW-T1oC\u001e,'\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0003-\u0011x\u000e\\3TKJ4\u0018nY3\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005qR\u0011\u0001\u00033fa2|\u00170\u001b;\n\u0005yJ$a\u0003*pY\u0016\u001cVM\u001d<jG\u0016D\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000eg\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015A\u00026zi\"|gN\u0003\u0002G\u0011\u000511o\u0019:jaRL!\u0001S\"\u0003')KH\u000f[8o'\u000e\u0014\u0018\u000e\u001d;TKJ4\u0018nY3\t\u0011)\u0003!Q1A\u0005\u0002-\u000b\u0001\"\u001a<f]R\u0014Uo]\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nC\u0001\u0007KZ,g\u000e^:\n\u0005Es%!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\"A1\u000b\u0001B\u0001B\u0003%A*A\u0005fm\u0016tGOQ;tA!AQ\u000b\u0001BC\u0002\u0013\ra+A\u0006dS&#7+\u001a:wS\u000e,W#A,\u0011\u0005aSV\"A-\u000b\u0005\rA\u0011BA.Z\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011u\u0003!\u0011!Q\u0001\n]\u000bAbY5JIN+'O^5dK\u0002BQa\u0018\u0001\u0005\u0002\u0001\fa\u0001P5oSRtD#C1cG\u0012,gm\u001a5j!\t\t\u0003\u0001C\u0003\u0018=\u0002\u0007\u0001\u0004C\u0003 =\u0002\u0007\u0001\u0005C\u0003&=\u0002\u0007a\u0005C\u0003+=\u0002\u00071\u0006C\u00037=\u0002\u0007q\u0007C\u0003A=\u0002\u0007\u0011\tC\u0003K=\u0002\u0007A\nC\u0003V=\u0002\u000fq\u000b\u000b\u0002_WB\u0011An]\u0007\u0002[*\u0011an\\\u0001\u000bC:tw\u000e^1uS>t'B\u00019r\u0003\u001d1\u0017m\u0019;pefT!A]\u0018\u0002\u000b\t,\u0017M\\:\n\u0005Ql'!C!vi><\u0018N]3e\u0011\u00151\b\u0001\"\u0001x\u0003\u0019)\u00070[:ugR\u0011\u0001p\u001f\t\u0003#eL!A\u001f\n\u0003\u000f\t{w\u000e\\3b]\")A0\u001ea\u0001{\u0006YA-Y:iE>\f'\u000fZ%e!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001%5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0011A\u0002\u001fs_>$h(C\u0002\u0002\nI\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005%!\u001aQ/a\u0005\u0011\t\u0005U\u0011\u0011E\u0007\u0003\u0003/Q1A\\A\r\u0015\u0011\tY\"!\b\u0002\u000f5,GO]5dg*\u0019\u0011q\u0004\u0007\u0002\u0011\r|G-\u00195bY\u0016LA!a\t\u0002\u0018\t)A+[7fI\"9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0012AB:fCJ\u001c\u0007\u000e\u0006\u0004\u0002,\u0005%\u0013Q\n\t\u0007\u0003[\t9$!\u0010\u000f\t\u0005=\u00121\u0007\b\u0005\u0003\u0003\t\t$C\u0001\u0014\u0013\r\t)DE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI$a\u000f\u0003\u0007M+\u0017OC\u0002\u00026I\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007\"\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002H\u0005\u0005#!\u0003#bg\"\u0014w.\u0019:e\u0011\u001d\tY%!\nA\u0002u\f\u0001\u0002]1sK:$\u0018\n\u001a\u0005\n\u0003\u001f\n)\u0003%AA\u0002u\fQ\u0001^5uY\u0016DC!!\n\u0002\u0014!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013!\u00054j]\u0012$\u0015m\u001d5c_\u0006\u0014HMQ=JIR!\u0011QHA-\u0011\u0019a\u00181\u000ba\u0001{\"\"\u00111KA\n\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\nqb\u0019:fCR,G)Y:iE>\f'\u000f\u001a\u000b\u0005\u0003{\t\u0019\u0007C\u0004\u0006\u0003;\u0002\r!!\u0010)\t\u0005u\u00131\u0003\u0005\b\u0003S\u0002A\u0011AA6\u0003=)\b\u000fZ1uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BA\u001f\u0003[Bq!BA4\u0001\u0004\ti\u0004\u000b\u0003\u0002h\u0005M\u0001bBA:\u0001\u0011\u0005\u0011QO\u0001\u0010I\u0016dW\r^3ECND'm\\1sIR!\u0011qOA?!\r\t\u0012\u0011P\u0005\u0004\u0003w\u0012\"\u0001B+oSRDa\u0001`A9\u0001\u0004i\b\u0006BA9\u0003'Aq!a!\u0001\t\u0003\t))A\u000bhKR$\u0015m\u001d5c_\u0006\u0014H\rV3na2\fG/Z:\u0015\t\u0005\u001d\u0015Q\u0014\t\u0007\u0003[\t9$!#\u0011\t\u0005-\u0015\u0011T\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u00069!/\u001a4mK\u000e$(\u0002BAJ\u0003+\u000b1!\u00199j\u0015\r\t9jO\u0001\u0007a2,x-\u001b8\n\t\u0005m\u0015Q\u0012\u0002\u000b\t\u0016\u001c8M]5qi>\u0014\b\u0002CAP\u0003\u0003\u0003\r!!)\u0002\u000bM\u001cw\u000e]3\u0011\t\u0005}\u00121U\u0005\u0005\u0003K\u000b\tEA\u0005US2,7kY8qK\"\"\u0011\u0011QA\n\u0011\u001d\tY\u000b\u0001C\u0001\u0003[\u000bq\"\u001a<jGR$\u0016\u000e\\3t\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003o\ny\u000bC\u0004\u0006\u0003S\u0003\r!!\u0010)\t\u0005%\u00161\u0003\u0005\b\u0003k\u0003A\u0011CA\\\u0003u!WmY8sCR,w+\u001b;i\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRLH\u0003BA\u0016\u0003sC\u0001\"a/\u00024\u0002\u0007\u00111F\u0001\u000bI\u0006\u001c\bNY8be\u0012\u001c\bbBA`\u0001\u0011%\u0011\u0011Y\u0001\tm\u0006d\u0017\u000eZ1uKR!\u0011qOAb\u0011\u001d)\u0011Q\u0018a\u0001\u0003{Aq!a2\u0001\t\u0013\tI-A\ttKR|uO\\3s\u0013\u001al\u0015n]:j]\u001e$B!a\u001e\u0002L\"9Q!!2A\u0002\u0005u\u0002bBAh\u0001\u0011%\u0011\u0011[\u0001\u0012GV\u0014(/\u001a8u!JLgnY5qC2\u001cXCAAj!\u0019\t).a7\u0002`6\u0011\u0011q\u001b\u0006\u0004\u00033\u0014\u0012AC2pY2,7\r^5p]&!\u0011Q\\Al\u0005!IE/\u001a:bE2,\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\u0005Y\u0006twM\u0003\u0002\u0002j\u0006!!.\u0019<b\u0013\u0011\ti!a9\t\u000f\u0005=\b\u0001\"\u0003\u0002r\u0006a1-\u001e:sK:$(k\u001c7fgV\u0011\u00111\u001f\t\u0007\u0003k\fY0a@\u000e\u0005\u0005](\u0002BA}\u0003/\fq!\\;uC\ndW-\u0003\u0003\u0002~\u0006](A\u0002\"vM\u001a,'\u000fE\u00029\u0005\u0003I1Aa\u0001:\u0005\u0011\u0011v\u000e\\3\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n\u0005\u0011\u0002O]8wSNLwN\u001c#bg\"\u0014w.\u0019:e)\u0011\u0011YA!\u0005\u0011\u0007E\u0011i!C\u0002\u0003\u0010I\u00111!\u00118z\u0011\u001d)!Q\u0001a\u0001\u0003{AqA!\u0006\u0001\t\u0013\u00119\"\u0001\ffq\u0016\u001cW\u000f^3Qe>4\u0018n]5p]N\u001b'/\u001b9u)\u0011\tiD!\u0007\t\u000f\u0015\u0011\u0019\u00021\u0001\u0002>!9!Q\u0004\u0001\u0005\n\t}\u0011aE2sK\u0006$XmU2sSB$8i\u001c8uKb$H\u0003\u0002B\u0011\u0005S\u0001BAa\t\u0003&5\tQ)C\u0002\u0003(\u0015\u0013\u0001\u0003\u00177s'\u000e\u0014\u0018\u000e\u001d;D_:$X\r\u001f;\t\u000f\u0015\u0011Y\u00021\u0001\u0002>!I!Q\u0006\u0001\u0012\u0002\u0013\u0005!qF\u0001\u0011g\u0016\f'o\u00195%I\u00164\u0017-\u001e7uII*\"A!\r+\u0007u\u0014\u0019d\u000b\u0002\u00036A!!q\u0007B \u001b\t\u0011ID\u0003\u0003\u0003<\tu\u0012!C;oG\",7m[3e\u0015\tq'#\u0003\u0003\u0003B\te\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a\u0001A!\u0012\u0011\t\t\u001d#QJ\u0007\u0003\u0005\u0013R1Aa\u00130\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u001f\u0012IEA\u0004TKJ4\u0018nY3")
public class DashboardService {
    private final DelegatingDashboardRepository dashboardRepository;
    private final DashboardSecurity dashboardSecurity;
    private final DashboardSecurityDecorator dashboardSecurityDecorator;
    private final CacheManager cacheManager;
    private final RoleService roleService;
    private final JythonScriptService scriptService;
    private final XLReleaseEventBus eventBus;
    private final CiIdService ciIdService;

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Timed
    public boolean exists(String dashboardId) {
        return this.dashboardRepository.exists(dashboardId);
    }

    @Timed
    public Seq<Dashboard> search(String parentId, String title) {
        return this.decorateWithEffectiveSecurity(this.dashboardRepository.search(parentId, title, this.currentPrincipals(), (Iterable<Role>)this.currentRoles()));
    }

    public String search$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard findDashboardById(String dashboardId) {
        void var2_2;
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.decorateWithEffectiveSecurity((Seq<Dashboard>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dashboard[]{dashboard}))));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard createDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        this.provisionDashboard(dashboard);
        Dashboard createdDashboard = this.dashboardRepository.createDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardCreatedEvent(createdDashboard));
        this.dashboardSecurity.savePermissions(createdDashboard);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dashboard updateDashboard(Dashboard dashboard) {
        void var2_2;
        this.validate(dashboard);
        this.setOwnerIfMissing(dashboard);
        Dashboard updatedDashboard = this.dashboardRepository.updateDashboard(dashboard);
        this.eventBus().publish((XLReleaseEvent)new DashboardUpdatedEvent(updatedDashboard));
        this.dashboardSecurity.savePermissions(updatedDashboard);
        return var2_2;
    }

    @Timed
    public void deleteDashboard(String dashboardId) {
        this.dashboardSecurity.clearPermissions(dashboardId);
        Dashboard dashboard = this.dashboardRepository.findDashboardById(dashboardId);
        this.dashboardRepository.deleteDashboard(dashboardId);
        this.eventBus().publish((XLReleaseEvent)new DashboardDeletedEvent(dashboard));
    }

    @Timed
    public Seq<Descriptor> getDashboardTemplates(TileScope scope) {
        return (Seq)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(DescriptorRegistry.getSubtypes((Type)Type.valueOf(Dashboard.class))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getDescriptor(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)desc -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$getDashboardTemplates$2(scope, desc)))).toList().sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLabel(), (Ordering)Ordering.String$.MODULE$);
    }

    @Timed
    public void evictTilesCache(Dashboard dashboard) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.cacheManager.getCacheNames()).asScala()).foreach((Function1 & Serializable & scala.Serializable)cacheName -> {
            DashboardService.$anonfun$evictTilesCache$1(this, dashboard, cacheName);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Dashboard> decorateWithEffectiveSecurity(Seq<Dashboard> dashboards) {
        this.dashboardSecurityDecorator.decorate((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(dashboards).asJava());
        return dashboards;
    }

    private void validate(Dashboard dashboard) {
        block0: {
            if (dashboard.isReleaseDashboard()) break block0;
            Checks.checkArgument((boolean)Strings.isNotBlank((String)dashboard.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            this.dashboardSecurity.validate(dashboard);
        }
    }

    private void setOwnerIfMissing(Dashboard dashboard) {
        block0: {
            if (dashboard.hasOwner()) break block0;
            dashboard.setOwner(Permissions.getAuthenticatedUserName());
        }
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<Role> currentRoles() {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala();
    }

    private Object provisionDashboard(Dashboard dashboard) {
        if (Strings.isNotBlank((String)dashboard.getTemplateLocation())) {
            Dashboard template = (Dashboard)CiSerializerHelper$.MODULE$.deserialize(ScriptHelper.readScript((String)dashboard.getTemplateLocation()), null);
            dashboard.setTiles(template.getTiles());
        }
        return Strings.isNotBlank((String)dashboard.getScriptLocation()) ? this.executeProvisionScript(dashboard) : BoxedUnit.UNIT;
    }

    private Dashboard executeProvisionScript(Dashboard dashboard) {
        Dashboard dashboard2;
        if (dashboard.hasConfigurationScript()) {
            XlrScriptContext scriptContext = this.createScriptContext(dashboard);
            String script = ScriptHelper.getScript((ConfigurationItem)dashboard);
            this.scriptService.executeScriptWithWriter(script, scriptContext, false, true);
            dashboard2 = (Dashboard)((Object)scriptContext.getAttribute("dashboard"));
        } else {
            dashboard2 = dashboard;
        }
        return dashboard2;
    }

    /*
     * WARNING - void declaration
     */
    private XlrScriptContext createScriptContext(Dashboard dashboard) {
        void var2_2;
        XlrScriptContext scriptContext = new XlrScriptContext();
        scriptContext.addApi();
        scriptContext.setAttribute("dashboard", (Object)dashboard, 100);
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$getDashboardTemplates$2(TileScope scope$1, Descriptor desc) {
        return !desc.isVirtual() && ((Dashboard)desc.newInstance("dummy")).isSupportedOn(scope$1);
    }

    public static final /* synthetic */ boolean $anonfun$evictTilesCache$2(Dashboard dashboard$1, SimpleKey key) {
        return key.toString().contains(dashboard$1.getId());
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$3(DashboardService $this, String cacheName$1, SimpleKey key) {
        $this.cacheManager.getCache(cacheName$1).evict((Object)key);
    }

    public static final /* synthetic */ void $anonfun$evictTilesCache$1(DashboardService $this, Dashboard dashboard$1, String cacheName) {
        Cache cache = (Cache)$this.cacheManager.getCache(cacheName).getNativeCache();
        ((IterableLike)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(cache.asMap()).asScala()).keys().filter((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)DashboardService.$anonfun$evictTilesCache$2(dashboard$1, key)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
            DashboardService.$anonfun$evictTilesCache$3($this, cacheName, key);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public DashboardService(DelegatingDashboardRepository dashboardRepository, DashboardSecurity dashboardSecurity, DashboardSecurityDecorator dashboardSecurityDecorator, CacheManager cacheManager, RoleService roleService, JythonScriptService scriptService, XLReleaseEventBus eventBus, CiIdService ciIdService) {
        this.dashboardRepository = dashboardRepository;
        this.dashboardSecurity = dashboardSecurity;
        this.dashboardSecurityDecorator = dashboardSecurityDecorator;
        this.cacheManager = cacheManager;
        this.roleService = roleService;
        this.scriptService = scriptService;
        this.eventBus = eventBus;
        this.ciIdService = ciIdService;
    }
}

