/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.views.ArchivingSettingsView;
import com.xebialabs.xlrelease.views.ReportsSettingsView;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SettingsResource {
    private PermissionChecker permissions;
    private ConfigurationRepository configurationRepository;
    private ConfigurationService configurationService;

    @Autowired
    public SettingsResource(PermissionChecker permissionChecker, ConfigurationRepository configurationRepository, ConfigurationService configurationService) {
        this.permissions = permissionChecker;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
    }

    @GET
    @Timed
    @Path(value="reports")
    public ReportsSettingsView getReportsSettings() {
        ReportsSettings reportsSettings = (ReportsSettings)((Object)this.configurationRepository.read("Configuration/reports/ReportsSettings"));
        return new ReportsSettingsView(reportsSettings);
    }

    @GET
    @Timed
    @Path(value="polling-interval")
    public Integer getPollingInterval() {
        PollingSettings pollingSettings = (PollingSettings)((Object)this.configurationRepository.read("Configuration/settings/PollingSettings"));
        return pollingSettings.getPollingInterval();
    }

    @GET
    @Timed
    @Path(value="archiving-settings")
    public ArchivingSettingsView getArchivingSettings() {
        ArchivingSettings archivingSettings = (ArchivingSettings)((Object)this.configurationRepository.read("Configuration/settings/ArchivingSettings"));
        return new ArchivingSettingsView(archivingSettings);
    }

    @GET
    @Timed
    @Path(value="theme")
    public ThemeSettings getThemeSettings() {
        return this.configurationService.getThemeSettings();
    }

    @GET
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration read(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        if (id.equals("Configuration/settings/ThemeSettings")) {
            return this.getThemeSettings();
        }
        return this.configurationRepository.read(id);
    }

    @POST
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration create(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurationService.createOrUpdate(id, configurationItem);
    }

    @PUT
    @Timed
    @Path(value="ci/{ID:Configuration.*}")
    public BaseConfiguration update(@PathParam(value="ID") String id, BaseConfiguration configurationItem) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurationService.createOrUpdate(id, configurationItem);
    }
}

