/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.AnnualCalendar;
import org.quartz.impl.calendar.BaseCalendar;
import org.quartz.impl.calendar.CronCalendar;
import org.quartz.impl.calendar.DailyCalendar;
import org.quartz.impl.calendar.HolidayCalendar;
import org.quartz.impl.calendar.MonthlyCalendar;
import org.quartz.impl.calendar.WeeklyCalendar;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzCalendars$ {
    public static QuartzCalendars$ MODULE$;
    private final Exception.Catch<Nothing$> catchMissing;
    private final Exception.Catch<Nothing$> catchWrongType;
    private final Exception.Catch<Nothing$> catchParseErr;

    static {
        new QuartzCalendars$();
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return this.catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return this.catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return this.catchParseErr;
    }

    public scala.collection.immutable.Map<String, org.quartz.Calendar> apply(Config config, TimeZone defaultTimezone) {
        return (scala.collection.immutable.Map)this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)config.getConfig("calendars").root()).asScala()).toMap(Predef$.MODULE$.$conforms()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            String key = (String)tuple2._1();
            ConfigValue value = (ConfigValue)tuple2._2();
            if (!(value instanceof ConfigObject)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            ConfigObject configObject = (ConfigObject)value;
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)this.parseCalendar(key, configObject.toConfig(), defaultTimezone))));
        }, Map$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
    }

    public Calendar parseFmt(String raw, SimpleDateFormat fmt, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(fmt.parse(raw));
        return c;
    }

    public AnnualCalendar parseAnnualCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getStringList("excludeDates"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Annual calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List dates = (List)right.value();
        Buffer buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1 & Serializable & scala.Serializable)d -> {
            Calendar dt;
            Either either = this.catchParseErr().either((Function0 & Serializable & scala.Serializable)() -> this.parseFmt((String)d, dateFmt, tz));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date '%s' in Annual Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Calendar calendar = dt = (Calendar)right.value();
            return calendar;
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer excludeDates = buffer;
        AnnualCalendar cal = new AnnualCalendar();
        cal.setDaysExcluded(new ArrayList((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(excludeDates).asJava()));
        return cal;
    }

    public HolidayCalendar parseHolidayCalendar(String name, Config config, TimeZone tz) {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd");
        dateFmt.setTimeZone(tz);
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getStringList("excludeDates"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDates' for Holiday Calendar '%s'. You must provide a list of ISO-8601 compliant dates ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List dates = (List)right.value();
        Buffer buffer = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dates).asScala()).map((Function1 & Serializable & scala.Serializable)d -> {
            Date dt;
            Either either = this.catchParseErr().either((Function0 & Serializable & scala.Serializable)() -> this.parseFmt((String)d, dateFmt, tz).getTime());
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid date '%s' in Holiday Calendar '%s' - 'excludeDates'. You must provide an ISO-8601 compliant date ('YYYY-MM-DD').")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Date date = dt = (Date)right.value();
            return date;
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer excludeDates = buffer;
        HolidayCalendar cal = new HolidayCalendar();
        excludeDates.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            cal.addExcludedDate(x$1);
            return BoxedUnit.UNIT;
        });
        return cal;
    }

    public DailyCalendar parseDailyCalendar(String name, Config config) {
        String startTime = this.parseTimeEntry$1("exclude.startTime", name, config);
        String endTime = this.parseTimeEntry$1("exclude.endTime", name, config);
        return new DailyCalendar(startTime, endTime);
    }

    public WeeklyCalendar parseWeeklyCalendar(String name, Config config) {
        WeeklyCalendar cal;
        block3: {
            Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getIntList("excludeDays"));
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Weekly Calendar '%s'. You must provide a list of Integers between 1 and 7.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            List days = (List)right.value();
            Buffer buffer = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
            Buffer excludeDays = buffer;
            boolean excludeWeekends = BoxesRunTime.unboxToBoolean((Object)this.catchMissing().opt((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> config.getBoolean("excludeWeekends")).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
            Predef$.MODULE$.require(excludeDays.forall((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)QuartzCalendars$.$anonfun$parseWeeklyCalendar$5(d))), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 7")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            cal = new WeeklyCalendar();
            excludeDays.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                cal.setDayExcluded(Predef$.MODULE$.Integer2int(x$1), true);
                return BoxedUnit.UNIT;
            });
            if (excludeWeekends) break block3;
            if (excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)7)) || excludeDays.contains((Object)BoxesRunTime.boxToInteger((int)1))) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Weekly Calendar '%s' - Cannot set 'excludeWeekends' to false when you have explicitly excluded Saturday (7) or Sunday (1)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            cal.setDayExcluded(1, false);
            cal.setDayExcluded(7, false);
        }
        return cal;
    }

    public MonthlyCalendar parseMonthlyCalendar(String name, Config config) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getIntList("excludeDays"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeDays' for Monthly Calendar '%s'. You must provide a list of Integers between 1 and 31.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List days = (List)right.value();
        Buffer buffer = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(days).asScala();
        Buffer excludeDays = buffer;
        Predef$.MODULE$.require(excludeDays.forall((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)QuartzCalendars$.$anonfun$parseMonthlyCalendar$3(d))), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Monthly Calendar '%s' - 'excludeDays' must consist of a list of Integers between 1 and 31")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        MonthlyCalendar cal = new MonthlyCalendar();
        excludeDays.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            cal.setDayExcluded(Predef$.MODULE$.Integer2int(x$2), true);
            return BoxedUnit.UNIT;
        });
        return cal;
    }

    public CronCalendar parseCronCalendar(String name, Config config) {
        String string;
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config.getString("excludeExpression"));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'excludeExpression' for Cron Calendar '%s'. You must provide a valid Quartz CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String expr = (String)right.value();
            Either either2 = this.catchParseErr().either((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CronExpression.validateExpression((String)expr));
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable t = (Throwable)left.value();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid 'excludeExpression' for Cron Calendar '%s'. Failed to validate CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (!(either2 instanceof Right)) {
                throw new MatchError((Object)either2);
            }
            string = expr;
        } else {
            throw new MatchError((Object)either);
        }
        String string2 = string;
        String exclude = string2;
        CronCalendar cal = new CronCalendar(exclude);
        return cal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public org.quartz.Calendar parseCalendar(String name, Config config, TimeZone defaultTimezone) {
        AnnualCalendar annualCalendar;
        TimeZone timezone = (TimeZone)this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> TimeZone.getTimeZone(config.getString("timezone"))).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultTimezone);
        Option description = this.catchMissing().opt((Function0 & Serializable & scala.Serializable)() -> config.getString("description"));
        Either either = this.catchMissing().either((Function0 & Serializable & scala.Serializable)() -> config.getString("type"));
        if (either instanceof Left) {
            throw new IllegalArgumentException("Calendar Type must be defined for " + name);
        }
        if (!(either instanceof Right)) throw new MatchError((Object)either);
        Right right = (Right)either;
        String typ = (String)right.value();
        String string = typ.toUpperCase();
        if ("ANNUAL".equals(string)) {
            annualCalendar = this.parseAnnualCalendar(name, config, timezone);
        } else if ("HOLIDAY".equals(string)) {
            annualCalendar = this.parseHolidayCalendar(name, config, timezone);
        } else if ("DAILY".equals(string)) {
            annualCalendar = this.parseDailyCalendar(name, config);
        } else if ("MONTHLY".equals(string)) {
            annualCalendar = this.parseMonthlyCalendar(name, config);
        } else if ("WEEKLY".equals(string)) {
            annualCalendar = this.parseWeeklyCalendar(name, config);
        } else {
            if (!"CRON".equals(string)) throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Unknown Quartz Calendar type '%s' for calendar '%s'. Valid types are Annual, Holiday, Daily, Monthly, Weekly, and Cron.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, name})));
            annualCalendar = this.parseCronCalendar(name, config);
        }
        AnnualCalendar cal = annualCalendar;
        description.foreach(arg_0 -> QuartzCalendars$.$anonfun$parseCalendar$5$adapted((BaseCalendar)cal, arg_0));
        cal.setTimeZone(timezone);
        return cal;
    }

    private final String parseTimeEntry$1(String entry, String name$3, Config config$5) {
        String rawTime;
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0 & Serializable & scala.Serializable)() -> config$5.getString(entry));
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry '%s' for Daily Calendar '%s'. You must provide a time in the format 'HH:MM[:SS[:mmm]]'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entry, name$3})), t);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        String string = rawTime = (String)right.value();
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$parseWeeklyCalendar$5(Integer d) {
        return Predef$.MODULE$.Integer2int(d) <= 7 && Predef$.MODULE$.Integer2int(d) >= 1;
    }

    public static final /* synthetic */ boolean $anonfun$parseMonthlyCalendar$3(Integer d) {
        return Predef$.MODULE$.Integer2int(d) <= 31 && Predef$.MODULE$.Integer2int(d) >= 1;
    }

    private QuartzCalendars$() {
        MODULE$ = this;
        this.catchMissing = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
        this.catchWrongType = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
        this.catchParseErr = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));
    }

    public static final /* synthetic */ Object $anonfun$parseCalendar$5$adapted(BaseCalendar cal$4, String x$1) {
        cal$4.setDescription(x$1);
        return BoxedUnit.UNIT;
    }
}

