/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.license.service;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.license.Clock;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseCiCounter;
import com.xebialabs.license.LicenseEditionException;
import com.xebialabs.license.LicenseParseException;
import com.xebialabs.license.LicensePeriodExpiredException;
import com.xebialabs.license.LicenseProductException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion3;
import com.xebialabs.license.LicenseVersionException;
import com.xebialabs.license.LicenseViolationException;
import com.xebialabs.license.RealClock;
import com.xebialabs.license.UnregisteredLicenseExpiredException;
import com.xebialabs.license.service.DefaultLicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseCiCounterFactory;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseTransaction;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLicenseService
implements LicenseService {
    protected static final Logger log = LoggerFactory.getLogger(AbstractLicenseService.class);
    protected static final int MINIMUM_LICENSE_VERSION = 3;
    protected final Clock clock;
    protected final File licenseFile;
    protected final String product;
    protected final Set<String> allowedEditions = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(LicenseVersion3.Edition.Trial.name(), LicenseVersion3.Edition.Enterprise.name(), LicenseVersion3.Edition.Unregistered.name())));
    protected License license;
    protected LicenseCiCounter ciCounter;
    protected LicenseCiCounterFactory ciCounterFactory = new DefaultLicenseCiCounterFactory();
    protected RepositoryMetadataService repositoryMetadataService;

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService) {
        this(licensePath, product, repositoryMetadataService, new RealClock());
    }

    public AbstractLicenseService(String licensePath, String product, RepositoryMetadataService repositoryMetadataService, Clock clock) {
        this.product = product;
        this.licenseFile = new File(licensePath);
        this.repositoryMetadataService = (RepositoryMetadataService)Checks.checkNotNull((Object)repositoryMetadataService, (String)"repositoryMetadataService");
        this.clock = clock;
    }

    public void initialize(LicenseCiCounterFactory ciCounterFactory) {
        this.ciCounterFactory = ciCounterFactory;
        this.reLoadCiCounter();
    }

    protected void logLicenseError(File licenseFile) {
        log.warn("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
        log.warn("*** Place a valid license in {} to continue using the product.", (Object)licenseFile.getAbsolutePath());
    }

    protected void logLicenseVersionError(License license, int minimumLicenseVersion) {
        log.error("*** Your license is version {}, but a minimum version of {} is required", (Object)license.getLicenseVersion(), (Object)minimumLicenseVersion);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    protected void reLoadCiCounter() {
        log.debug("Loading license CI counter using current license.");
        this.ciCounter = this.ciCounterFactory.create(this.license);
        log.debug("License contains CIs: {}", (Object)this.ciCounter.allowedCiAmounts());
        log.debug("License CI counter loaded and contains {} allowed CIs.", (Object)this.ciCounter.allowedCiAmounts().size());
    }

    protected void logLicenseEditionError(License license) {
        log.error("*** Your license has edition {}, but only {} is allowed", (Object)license.getStringValue(LicenseProperty.EDITION), this.allowedEditions);
        log.error("*** Please contact your XebiaLabs sales representative to obtain a valid license.");
    }

    public String getProduct() {
        return this.product;
    }

    public LicenseCiCounter getCounter() {
        if (this.ciCounter == null) {
            throw new IllegalStateException("ciCounter is null. Did you forget to initialize the license server?");
        }
        return this.ciCounter;
    }

    public boolean isLicenseExpired() {
        return this.license.isDateExpired(new LocalDate(this.clock.millis()));
    }

    public Period getValidPeriod() {
        LocalDate localDateValue = this.license.getLocalDateValue(LicenseProperty.EXPIRES_AFTER);
        LocalDate now = new LocalDate(this.clock.millis());
        if (now.isAfter((ReadablePartial)localDateValue)) {
            return Period.ZERO;
        }
        return new Period((ReadablePartial)now, (ReadablePartial)localDateValue, PeriodType.days());
    }

    public void validate() throws LicenseViolationException {
        this.validateLicenseProperties(this.license);
        this.ciCounter.validate();
    }

    public void validate(License license) throws LicenseViolationException {
        this.validateLicenseProperties(license);
        LicenseCiCounter tmpCiCounter = this.ciCounterFactory.create(license);
        tmpCiCounter.validate();
    }

    public void reload() throws LicenseViolationException, LicenseParseException {
        this.license = this.readLicense(this.licenseFile);
        this.reLoadCiCounter();
        this.validate();
    }

    public License getLicense() {
        return this.license;
    }

    public LicenseTransaction startTransaction() {
        return new LicenseTransaction();
    }

    public void rollbackTransaction(LicenseTransaction transaction) {
        for (Type type : transaction.getCiCountTypes()) {
            this.ciCounter.getAtomicCiCount(type).addAndGet(-transaction.getCiCount(type));
        }
    }

    protected void validateLicenseProperties(License license) throws LicenseViolationException {
        if (license.isDummyLicense()) {
            return;
        }
        String licenseProduct = license.getStringValue(LicenseProperty.PRODUCT);
        if (!this.product.equals(licenseProduct)) {
            throw new LicenseProductException(String.format("license is issued for %s, but used in %s", licenseProduct, this.product));
        }
        if (license.isDateExpired(new LocalDate(this.clock.millis()))) {
            if (license.isAtLeastVersion(3) && license.getStringValue(LicenseProperty.EDITION).equals(LicenseVersion3.Edition.Unregistered.name())) {
                throw new UnregisteredLicenseExpiredException("the unregistered version of the license has expired");
            }
            throw new LicensePeriodExpiredException("the license has expired");
        }
        if (!license.isAtLeastVersion(3)) {
            throw new LicenseVersionException(String.format("for this version of %s, a license version %d or higher is required", license.getStringValue(LicenseProperty.PRODUCT), 3));
        }
        if (!this.isValidEdition(license)) {
            throw new LicenseEditionException(String.format("for this version of %s, the license must be one of %s", license.getStringValue(LicenseProperty.PRODUCT), this.allowedEditions));
        }
        String stringValue = license.getStringValue(LicenseProperty.REPOSITORY_ID);
        if (Strings.isNotEmpty((String)stringValue)) {
            this.repositoryMetadataService.validateAndStoreRepositoryId(stringValue);
        }
    }

    protected boolean isValidEdition(License license) {
        return this.allowedEditions.contains(license.getStringValue(LicenseProperty.EDITION));
    }

    protected abstract License readLicense(File var1) throws LicenseParseException, LicenseViolationException;
}

