/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Metadata(description="Global variables container", root=Metadata.ConfigurationItemRoot.CONFIGURATION, versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class GlobalVariables
extends BaseConfigurationItem
implements InternalMetadata {
    public static final String GLOBAL_VARIABLES_ID = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/variables/global";
    @Property(asContainment=true, required=false, description="List of global variable CIs")
    private List<Variable> variables = Lists.newArrayList();

    public GlobalVariables() {
        this.setId(GLOBAL_VARIABLES_ID);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        ArrayList sorted = Lists.newArrayList(this.variables);
        sorted.sort((left, right) -> {
            String keyLeft = Strings.nullToEmpty((String)(left == null ? null : left.getKey()));
            String keyRight = Strings.nullToEmpty((String)(right == null ? null : right.getKey()));
            return keyLeft.compareToIgnoreCase(keyRight);
        });
        return sorted;
    }

    public Map<String, Variable> getVariablesByKeys() {
        return VariableHelper.indexByKey(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getStringVariableValues() {
        return VariableHelper.getStringVariableValues(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getPasswordVariableValues() {
        return VariableHelper.getPasswordStringVariableValues(this.variables);
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
        this.setGlobalVariableDefaults();
    }

    public Variable addVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkGlobalVariableValidity();
        Preconditions.checkArgument((!this.getVariablesByKeys().containsKey(variable.getKey()) ? 1 : 0) != 0, (String)"A variable already exists by key '%s'", (Object)variable.getKey());
        this.variables.add(variable);
        this.setGlobalVariableDefaults();
        return variable;
    }

    private void setGlobalVariableDefaults() {
        for (Variable v : this.variables) {
            v.setRequiresValue(false);
            v.setShowOnReleaseStart(false);
        }
    }
}

