/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.password;

import org.springframework.security.crypto.codec.Utf8;

class PasswordEncoderUtils {
    static boolean equals(String expected, String actual) {
        byte[] expectedBytes = PasswordEncoderUtils.bytesUtf8(expected);
        byte[] actualBytes = PasswordEncoderUtils.bytesUtf8(actual);
        int expectedLength = expectedBytes == null ? -1 : expectedBytes.length;
        int actualLength = actualBytes == null ? -1 : actualBytes.length;
        int result = expectedLength == actualLength ? 0 : 1;
        for (int i = 0; i < actualLength; ++i) {
            byte expectedByte = expectedLength <= 0 ? (byte)0 : expectedBytes[i % expectedLength];
            byte actualByte = actualBytes[i % actualLength];
            result |= expectedByte ^ actualByte;
        }
        return result == 0;
    }

    private static byte[] bytesUtf8(String s) {
        if (s == null) {
            return null;
        }
        return Utf8.encode(s);
    }

    private PasswordEncoderUtils() {
    }
}

