/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.snapshot.local;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.dispatch.MessageDispatcher;
import akka.event.LoggingAdapter;
import akka.pattern.CircuitBreaker;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.Persistence;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotMetadata$;
import akka.persistence.SnapshotSelectionCriteria;
import akka.persistence.serialization.Snapshot;
import akka.persistence.serialization.package$;
import akka.persistence.snapshot.SnapshotStore;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.util.ByteString$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t]h!\u0002\u00192\u0001UJ\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u000bU\u0003A\u0011\u0001,\t\u000fi\u0003!\u0019!C\u00057\"1A\r\u0001Q\u0001\nqCq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003g\u0011\u0019a\u0007\u0001)A\u0005O\"9Q\u000e\u0001b\u0001\n\u0013q\u0007BB;\u0001A\u0003%q\u000eC\u0004w\u0001\t\u0007I\u0011B<\t\u000f\u0005\u0005\u0001\u0001)A\u0005q\"I\u00111\u0001\u0001C\u0002\u0013%\u0011Q\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\n\u0003c\u0001\u0001\u0019!C\u0005\u0003gA\u0001\"a\u0010\u0001A\u0003&\u0011\u0011\u0004\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!a%\u0001\t\u0003\n)\nC\u0004\u0002\u0014\u0002!\t%!'\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0005\b\u00033\u0004A\u0011CAn\u0011\u001d\t\t\u000f\u0001C\t\u0003GDq!!?\u0001\t#\tY\u0010C\u0004\u0003\n\u0001!\tBa\u0003\t\u000f\tm\u0001\u0001\"\u0003\u0003\u001e!9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B.\u0001\u0011E!Q\f\u0005\n\u0005K\u0002\u0011\u0013!C\t\u0005OBqA!\u001f\u0001\t\u0013\u0011Y\bC\u0004\u0003\u0002\u0002!\tEa!\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u001a1!\u0011\u0012\u0001\u0007\u0005\u0017C!\"a\u0018%\u0005\u0003\u0005\u000b\u0011BA1\u0011\u0019)F\u0005\"\u0001\u0003 \"I!Q\u0015\u0013C\u0002\u0013\u0005!q\u0015\u0005\t\u0005[#\u0003\u0015!\u0003\u0003*\"9!q\u0016\u0013\u0005\u0002\tEfA\u0002B`\u0001\u0019\u0011\t\r\u0003\u0006\u0003D*\u0012\t\u0011)A\u0005\u0003SAa!\u0016\u0016\u0005\u0002\t\u0015\u0007b\u0002BfU\u00115!Q\u001a\u0005\b\u0005_SC\u0011\u0001Bn\u0011\u001d\u0011\t\u000f\u0001C\u0005\u0005G\u0014!\u0003T8dC2\u001cf.\u00199tQ>$8\u000b^8sK*\u0011!gM\u0001\u0006Y>\u001c\u0017\r\u001c\u0006\u0003iU\n\u0001b\u001d8baNDw\u000e\u001e\u0006\u0003m]\n1\u0002]3sg&\u001cH/\u001a8dK*\t\u0001(\u0001\u0003bW.\f7\u0003\u0002\u0001;\u0001\u0012\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!C\u001b\u0005\u0019\u0014BA\"4\u00055\u0019f.\u00199tQ>$8\u000b^8sKB\u0011Q\tS\u0007\u0002\r*\u0011qiN\u0001\u0006C\u000e$xN]\u0005\u0003\u0013\u001a\u0013A\"Q2u_JdunZ4j]\u001e\faaY8oM&<7\u0001\u0001\t\u0003\u001bNk\u0011A\u0014\u0006\u0003\u0015>S!\u0001U)\u0002\u0011QL\b/Z:bM\u0016T\u0011AU\u0001\u0004G>l\u0017B\u0001+O\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"aV-\u0011\u0005a\u0003Q\"A\u0019\t\u000b)\u0013\u0001\u0019\u0001'\u0002\u001f\u0019KG.\u001a8b[\u0016\u0004\u0016\r\u001e;fe:,\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f\u0001\"\\1uG\"Lgn\u001a\u0006\u0003Cr\nA!\u001e;jY&\u00111M\u0018\u0002\u0006%\u0016<W\r_\u0001\u0011\r&dWM\\1nKB\u000bG\u000f^3s]\u0002\nQ\u0003]3sg&\u001cH/\u001a8dK&#7\u000b^1si&#\u00070F\u0001h!\tY\u0004.\u0003\u0002jy\t\u0019\u0011J\u001c;\u0002-A,'o]5ti\u0016t7-Z%e'R\f'\u000f^%eq\u0002\nq\"\\1y\u0019>\fG-\u0011;uK6\u0004Ho]\u0001\u0011[\u0006DHj\\1e\u0003R$X-\u001c9ug\u0002\n\u0001c\u001d;sK\u0006lG)[:qCR\u001c\u0007.\u001a:\u0016\u0003=\u0004\"\u0001]:\u000e\u0003ET!A]\u001c\u0002\u0011\u0011L7\u000f]1uG\"L!\u0001^9\u0003#5+7o]1hK\u0012K7\u000f]1uG\",'/A\ttiJ,\u0017-\u001c#jgB\fGo\u00195fe\u0002\n1\u0001Z5s+\u0005A\bCA=\u007f\u001b\u0005Q(BA>}\u0003\tIwNC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(\u0001\u0002$jY\u0016\fA\u0001Z5sA\u000512/\u001a:jC2L'0\u0019;j_:,\u0005\u0010^3og&|g.\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e]\nQb]3sS\u0006d\u0017N_1uS>t\u0017\u0002BA\t\u0003\u0017\u0011QbU3sS\u0006d\u0017N_1uS>t\u0017aF:fe&\fG.\u001b>bi&|g.\u0012=uK:\u001c\u0018n\u001c8!\u0003\u0019\u0019\u0018M^5oOV\u0011\u0011\u0011\u0004\t\u0007\u00037\t)#!\u000b\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005\rB(\u0001\u0006d_2dWm\u0019;j_:LA!a\n\u0002\u001e\t\u00191+\u001a;\u0011\t\u0005-\u0012QF\u0007\u0002k%\u0019\u0011qF\u001b\u0003!Ms\u0017\r]:i_RlU\r^1eCR\f\u0017AC:bm&twm\u0018\u0013fcR!\u0011QGA\u001e!\rY\u0014qG\u0005\u0004\u0003sa$\u0001B+oSRD\u0011\"!\u0010\u0011\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'A\u0004tCZLgn\u001a\u0011\u0002\u00131|\u0017\rZ!ts:\u001cGCBA#\u0003;\n9\b\u0005\u0004\u0002H\u00055\u0013\u0011K\u0007\u0003\u0003\u0013R1!a\u0013=\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001f\nIE\u0001\u0004GkR,(/\u001a\t\u0006w\u0005M\u0013qK\u0005\u0004\u0003+b$AB(qi&|g\u000e\u0005\u0003\u0002,\u0005e\u0013bAA.k\t\u00012+\u001a7fGR,Gm\u00158baNDw\u000e\u001e\u0005\b\u0003?\u0012\u0002\u0019AA1\u00035\u0001XM]:jgR,gnY3JIB!\u00111MA9\u001d\u0011\t)'!\u001c\u0011\u0007\u0005\u001dD(\u0004\u0002\u0002j)\u0019\u00111N&\u0002\rq\u0012xn\u001c;?\u0013\r\ty\u0007P\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0014Q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=D\bC\u0004\u0002zI\u0001\r!a\u001f\u0002\u0011\r\u0014\u0018\u000e^3sS\u0006\u0004B!a\u000b\u0002~%\u0019\u0011qP\u001b\u00033Ms\u0017\r]:i_R\u001cV\r\\3di&|gn\u0011:ji\u0016\u0014\u0018.Y\u0001\ng\u00064X-Q:z]\u000e$b!!\"\u0002\b\u0006-\u0005CBA$\u0003\u001b\n)\u0004C\u0004\u0002\nN\u0001\r!!\u000b\u0002\u00115,G/\u00193bi\u0006Da\u0001N\nA\u0002\u00055\u0005cA\u001e\u0002\u0010&\u0019\u0011\u0011\u0013\u001f\u0003\u0007\u0005s\u00170A\u0006eK2,G/Z!ts:\u001cG\u0003BAC\u0003/Cq!!#\u0015\u0001\u0004\tI\u0003\u0006\u0004\u0002\u0006\u0006m\u0015Q\u0014\u0005\b\u0003?*\u0002\u0019AA1\u0011\u001d\tI(\u0006a\u0001\u0003w\nQC]3dK&4X\r\u00157vO&t\u0017J\u001c;fe:\fG.\u0006\u0002\u0002$B!\u0011QUAT\u001b\u0005\u0001\u0011\u0002BAU\u0003W\u0013qAU3dK&4X-C\u0002\u0002.\u001a\u0013Q!Q2u_J\fQb\u001d8baNDw\u000e\u001e$jY\u0016\u001cH\u0003BAZ\u0003s\u0003R!a\u0007\u00026bLA!a.\u0002\u001e\t\u00191+Z9\t\u000f\u0005%u\u00031\u0001\u0002*\u0005!An\\1e)\u0011\ty,a2\u0011\r\u0005\u0005\u00171YA)\u001b\u0005\u0001\u0017bAAcA\n\u0019AK]=\t\u000f\u0005%\u0005\u00041\u0001\u0002JB1\u00111DA[\u0003SA3\u0001GAg!\u0011\ty-!6\u000e\u0005\u0005E'bAAjy\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0017\u0011\u001b\u0002\bi\u0006LGN]3d\u0003\u0011\u0019\u0018M^3\u0015\r\u0005U\u0012Q\\Ap\u0011\u001d\tI)\u0007a\u0001\u0003SAa\u0001N\rA\u0002\u00055\u0015a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$B!!:\u0002pB!\u0011q]Av\u001b\t\tIOC\u0002\u0002\u000eUJA!!<\u0002j\nA1K\\1qg\"|G\u000fC\u0004\u0002rj\u0001\r!a=\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0004s\u0006U\u0018bAA|u\nY\u0011J\u001c9viN#(/Z1n\u0003%\u0019XM]5bY&TX\r\u0006\u0004\u00026\u0005u(q\u0001\u0005\b\u0003\u007f\\\u0002\u0019\u0001B\u0001\u00031yW\u000f\u001e9viN#(/Z1n!\rI(1A\u0005\u0004\u0005\u000bQ(\u0001D(viB,Ho\u0015;sK\u0006l\u0007B\u0002\u001b\u001c\u0001\u0004\t)/\u0001\txSRDw*\u001e;qkR\u001cFO]3b[R!!Q\u0002B\r)\rA(q\u0002\u0005\b\u0005#a\u0002\u0019\u0001B\n\u0003\u0005\u0001\bcB\u001e\u0003\u0016\t\u0005\u0011QG\u0005\u0004\u0005/a$!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\tI\t\ba\u0001\u0003S\tqb^5uQ&s\u0007/\u001e;TiJ,\u0017-\\\u000b\u0005\u0005?\u00119\u0003\u0006\u0003\u0003\"\t]B\u0003\u0002B\u0012\u0005g\u0001BA!\n\u0003(1\u0001Aa\u0002B\u0015;\t\u0007!1\u0006\u0002\u0002)F!!QFAG!\rY$qF\u0005\u0004\u0005ca$a\u0002(pi\"Lgn\u001a\u0005\b\u0005#i\u0002\u0019\u0001B\u001b!\u001dY$QCAz\u0005GAq!!#\u001e\u0001\u0004\tI#\u0001\u0006xSRD7\u000b\u001e:fC6,bA!\u0010\u0003L\t\u0005CC\u0002B \u0005\u000b\u00129\u0006\u0005\u0003\u0003&\t\u0005Ca\u0002B\"=\t\u0007!1\u0006\u0002\u0002\u0005\"9!q\t\u0010A\u0002\t%\u0013AB:ue\u0016\fW\u000e\u0005\u0003\u0003&\t-Ca\u0002B'=\t\u0007!q\n\u0002\u0002\u0003F!!Q\u0006B)!\rI(1K\u0005\u0004\u0005+R(!C\"m_N,\u0017M\u00197f\u0011\u001d\u0011\tB\ba\u0001\u00053\u0002ra\u000fB\u000b\u0005\u0013\u0012y$\u0001\u000bt]\u0006\u00048\u000f[8u\r&dWMR8s/JLG/\u001a\u000b\u0006q\n}#\u0011\r\u0005\b\u0003\u0013{\u0002\u0019AA\u0015\u0011%\u0011\u0019g\bI\u0001\u0002\u0004\t\t'A\u0005fqR,gn]5p]\u0006q2O\\1qg\"|GOR5mK\u001a{'o\u0016:ji\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005SRC!!\u0019\u0003l-\u0012!Q\u000e\t\u0005\u0005_\u0012)(\u0004\u0002\u0003r)!!1OAi\u0003%)hn\u00195fG.,G-\u0003\u0003\u0003x\tE$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t2O\\1qg\"|G/T3uC\u0012\fG/Y:\u0015\r\u0005%'Q\u0010B@\u0011\u001d\ty&\ta\u0001\u0003CBq!!\u001f\"\u0001\u0004\tY(\u0001\u0005qe\u0016\u001cF/\u0019:u)\t\t)$A\u0006t]\u0006\u00048\u000f[8u\t&\u0014H#\u0001=\u0003-Ms\u0017\r]:i_R4\u0015\u000e\\3oC6,g)\u001b7uKJ\u001cR\u0001\nBG\u00053\u0003BAa$\u0003\u00166\u0011!\u0011\u0013\u0006\u0004\u0005'c\u0018\u0001\u00027b]\u001eLAAa&\u0003\u0012\n1qJ\u00196fGR\u00042!\u001fBN\u0013\r\u0011iJ\u001f\u0002\u000f\r&dWM\\1nK\u001aKG\u000e^3s)\u0011\u0011\tKa)\u0011\u0007\u0005\u0015F\u0005C\u0004\u0002`\u0019\u0002\r!!\u0019\u0002)\u0015t7m\u001c3fIB+'o]5ti\u0016t7-Z%e+\t\u0011I\u000b\u0005\u0003\u0003\u0010\n-\u0016\u0002BA:\u0005#\u000bQ#\u001a8d_\u0012,G\rU3sg&\u001cH/\u001a8dK&#\u0007%\u0001\u0004bG\u000e,\u0007\u000f\u001e\u000b\u0007\u0005g\u0013ILa/\u0011\u0007m\u0012),C\u0002\u00038r\u0012qAQ8pY\u0016\fg\u000eC\u0003wS\u0001\u0007\u0001\u0010C\u0004\u0003>&\u0002\r!!\u0019\u0002\t9\fW.\u001a\u0002\u001c':\f\u0007o\u001d5piN+\u0017O\u0014:GS2,g.Y7f\r&dG/\u001a:\u0014\u000b)\u0012iI!'\u0002\u00055$G\u0003\u0002Bd\u0005\u0013\u00042!!*+\u0011\u001d\u0011\u0019\r\fa\u0001\u0003S\tq!\\1uG\",7\u000f\u0006\u0005\u00034\n='1\u001bBl\u0011\u001d\u0011\t.\fa\u0001\u0003C\n1\u0001]5e\u0011\u001d\u0011).\fa\u0001\u0003C\n1a\u001d8s\u0011\u001d\u0011I.\fa\u0001\u0003C\n1\u0001^7t)\u0019\u0011\u0019L!8\u0003`\")aO\fa\u0001q\"9!Q\u0018\u0018A\u0002\u0005\u0005\u0014aD3yiJ\f7\r^'fi\u0006$\u0017\r^1\u0015\t\t\u0015(1\u001f\t\u0006w\u0005M#q\u001d\t\nw\t%\u0018\u0011\rBw\u0005[L1Aa;=\u0005\u0019!V\u000f\u001d7fgA\u00191Ha<\n\u0007\tEHH\u0001\u0003M_:<\u0007b\u0002B{_\u0001\u0007\u0011\u0011M\u0001\tM&dWM\\1nK\u0002")
public class LocalSnapshotStore
implements SnapshotStore {
    private final Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    private final int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    private final int maxLoadAttempts;
    private final MessageDispatcher streamDispatcher;
    private final File dir;
    private final Serialization serializationExtension;
    private Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    private final Persistence akka$persistence$snapshot$SnapshotStore$$extension;
    private final boolean akka$persistence$snapshot$SnapshotStore$$publish;
    private final CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker;
    private final PartialFunction<Object, BoxedUnit> receiveSnapshotStore;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public final PartialFunction<Object, BoxedUnit> receive() {
        return SnapshotStore.receive$(this);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void postStop() throws Exception {
        Actor.postStop$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    @Override
    public Persistence akka$persistence$snapshot$SnapshotStore$$extension() {
        return this.akka$persistence$snapshot$SnapshotStore$$extension;
    }

    @Override
    public boolean akka$persistence$snapshot$SnapshotStore$$publish() {
        return this.akka$persistence$snapshot$SnapshotStore$$publish;
    }

    @Override
    public CircuitBreaker akka$persistence$snapshot$SnapshotStore$$breaker() {
        return this.akka$persistence$snapshot$SnapshotStore$$breaker;
    }

    @Override
    public final PartialFunction<Object, BoxedUnit> receiveSnapshotStore() {
        return this.receiveSnapshotStore;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$extension_$eq(Persistence x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$extension = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$publish_$eq(boolean x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$publish = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$akka$persistence$snapshot$SnapshotStore$$breaker_$eq(CircuitBreaker x$1) {
        this.akka$persistence$snapshot$SnapshotStore$$breaker = x$1;
    }

    @Override
    public final void akka$persistence$snapshot$SnapshotStore$_setter_$receiveSnapshotStore_$eq(PartialFunction<Object, BoxedUnit> x$1) {
        this.receiveSnapshotStore = x$1;
    }

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Regex akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern;
    }

    public int akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx;
    }

    private int maxLoadAttempts() {
        return this.maxLoadAttempts;
    }

    private MessageDispatcher streamDispatcher() {
        return this.streamDispatcher;
    }

    private File dir() {
        return this.dir;
    }

    private Serialization serializationExtension() {
        return this.serializationExtension;
    }

    public Set<SnapshotMetadata> akka$persistence$snapshot$local$LocalSnapshotStore$$saving() {
        return this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving;
    }

    public void akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq(Set<SnapshotMetadata> x$1) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = x$1;
    }

    @Override
    public Future<Option<SelectedSnapshot>> loadAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq metadata = (Seq)((IterableLike)this.snapshotMetadatas(persistenceId, criteria).sorted(SnapshotMetadata$.MODULE$.ordering())).takeRight(this.maxLoadAttempts());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option s;
            Try<Option<SelectedSnapshot>> try_ = this.load((Seq<SnapshotMetadata>)metadata);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw e;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Option option = s = (Option)success.value();
            return option;
        }, (ExecutionContext)this.streamDispatcher());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Future<BoxedUnit> saveAsync(SnapshotMetadata metadata, Object snapshot) {
        void var3_3;
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$plus((Object)metadata)));
        Future completion = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.save(metadata, snapshot), (ExecutionContext)this.streamDispatcher());
        return var3_3;
    }

    @Override
    public Future<BoxedUnit> deleteAsync(SnapshotMetadata metadata) {
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)this.snapshotFiles(metadata).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete()), Seq$.MODULE$.canBuildFrom()), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$3(x$3);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public Future<BoxedUnit> deleteAsync(String persistenceId, SnapshotSelectionCriteria criteria) {
        Seq<SnapshotMetadata> metadatas = this.snapshotMetadatas(persistenceId, criteria);
        return Future$.MODULE$.sequence((TraversableOnce)metadatas.map((Function1 & Serializable & scala.Serializable)metadata -> this.deleteAsync((SnapshotMetadata)metadata), Seq$.MODULE$.canBuildFrom()), akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)IndexedSeq$.MODULE$), (ExecutionContext)this.streamDispatcher()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            LocalSnapshotStore.$anonfun$deleteAsync$5(x$4);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.streamDispatcher());
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receivePluginInternal() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalSnapshotStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SaveSnapshotSuccess) {
                    SaveSnapshotSuccess saveSnapshotSuccess = (SaveSnapshotSuccess)A1;
                    SnapshotMetadata metadata = saveSnapshotSuccess.metadata();
                    this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving_$eq((Set<SnapshotMetadata>)((Set)this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().$minus((Object)metadata)));
                    object = BoxedUnit.UNIT;
                } else {
                    object = A1 instanceof SaveSnapshotFailure ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsSuccess ? BoxedUnit.UNIT : (A1 instanceof DeleteSnapshotsFailure ? BoxedUnit.UNIT : function1.apply(x1)));
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof SaveSnapshotSuccess ? true : (object instanceof SaveSnapshotFailure ? true : (object instanceof DeleteSnapshotsSuccess ? true : object instanceof DeleteSnapshotsFailure));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    private Seq<File> snapshotFiles(SnapshotMetadata metadata) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.snapshotDir().listFiles(new SnapshotSeqNrFilenameFilter(this, metadata)))).toVector();
    }

    private Try<Option<SelectedSnapshot>> load(Seq<SnapshotMetadata> metadata) {
        Success success;
        block3: {
            Option option;
            block4: {
                Success success2;
                block5: {
                    Try try_;
                    block6: {
                        Throwable e;
                        while (true) {
                            if (None$.MODULE$.equals(option = metadata.lastOption())) {
                                success = new Success((Object)None$.MODULE$);
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            SnapshotMetadata md = (SnapshotMetadata)some.value();
                            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Snapshot)this.withInputStream(md, (Function1 & Serializable & scala.Serializable)inputStream -> this.deserialize((InputStream)inputStream)));
                            if (try_ instanceof Success) {
                                Success success3 = (Success)try_;
                                Snapshot s = (Snapshot)success3.value();
                                success2 = new Success((Object)new Some((Object)new SelectedSnapshot(md, s.data())));
                                break block5;
                            }
                            if (!(try_ instanceof Failure)) break block6;
                            Failure failure = (Failure)try_;
                            e = failure.exception();
                            Seq remaining = (Seq)metadata.init();
                            this.log().error(e, "Error loading snapshot [{}], remaining attempts: [{}]", (Object)md, (Object)BoxesRunTime.boxToInteger((int)remaining.size()));
                            if (remaining.isEmpty()) break;
                            metadata = remaining;
                        }
                        success2 = new Failure(e);
                        break block5;
                    }
                    throw new MatchError((Object)try_);
                }
                success = success2;
                break block3;
            }
            throw new MatchError((Object)option);
        }
        return success;
    }

    public void save(SnapshotMetadata metadata, Object snapshot) {
        File tmpFile = this.withOutputStream(metadata, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            this.serialize(x$5, new Snapshot(snapshot));
            return BoxedUnit.UNIT;
        });
        tmpFile.renameTo(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()));
    }

    public Snapshot deserialize(InputStream inputStream) {
        return (Snapshot)this.serializationExtension().deserialize(package$.MODULE$.streamToBytes(inputStream), Snapshot.class).get();
    }

    public void serialize(OutputStream outputStream, Snapshot snapshot) {
        outputStream.write((byte[])this.serializationExtension().serialize((Object)snapshot).get());
    }

    /*
     * WARNING - void declaration
     */
    public File withOutputStream(SnapshotMetadata metadata, Function1<OutputStream, BoxedUnit> p) {
        void var3_3;
        File tmpFile = this.snapshotFileForWrite(metadata, "tmp");
        this.withStream(new BufferedOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0])), p);
        return var3_3;
    }

    private <T> T withInputStream(SnapshotMetadata metadata, Function1<InputStream, T> p) {
        return this.withStream(new BufferedInputStream(Files.newInputStream(this.snapshotFileForWrite(metadata, this.snapshotFileForWrite$default$2()).toPath(), new OpenOption[0])), p);
    }

    private <A extends Closeable, B> B withStream(A stream, Function1<A, B> p) {
        Object object;
        try {
            object = p.apply(stream);
        }
        finally {
            stream.close();
        }
        return (B)object;
    }

    public File snapshotFileForWrite(SnapshotMetadata metadata, String extension) {
        return new File(this.snapshotDir(), new StringBuilder(11).append("snapshot-").append(URLEncoder.encode(metadata.persistenceId(), ByteString$.MODULE$.UTF_8())).append("-").append(metadata.sequenceNr()).append("-").append(metadata.timestamp()).append(extension).toString());
    }

    public String snapshotFileForWrite$default$2() {
        return "";
    }

    private Seq<SnapshotMetadata> snapshotMetadatas(String persistenceId, SnapshotSelectionCriteria criteria) {
        File[] files = this.snapshotDir().listFiles(new SnapshotFilenameFilter(persistenceId));
        return files == null ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).flatMap((Function1 & Serializable & scala.Serializable)filename -> Option$.MODULE$.option2Iterable(this.extractMetadata((String)filename).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String pid = (String)tuple3._1();
            long snr = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long tms = BoxesRunTime.unboxToLong((Object)tuple3._3());
            SnapshotMetadata snapshotMetadata = new SnapshotMetadata(URLDecoder.decode(pid, ByteString$.MODULE$.UTF_8()), snr, tms);
            return snapshotMetadata;
        })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(SnapshotMetadata.class))))).filter((Function1 & Serializable & scala.Serializable)md -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$snapshotMetadatas$4(this, criteria, md))))).toVector();
    }

    public void preStart() {
        this.snapshotDir();
        Actor.preStart$((Actor)this);
    }

    private File snapshotDir() {
        if (!(this.dir().isDirectory() || this.dir().mkdirs() || this.dir().isDirectory())) {
            throw new IOException(new StringBuilder(38).append("Failed to create snapshot directory [").append(this.dir().getCanonicalPath()).append("]").toString());
        }
        return this.dir();
    }

    private Option<Tuple3<String, Object, Object>> extractMetadata(String filename) {
        None$ none$;
        int sequenceNumberEndIdx = filename.lastIndexOf(45);
        int persistenceIdEndIdx = filename.lastIndexOf(45, sequenceNumberEndIdx - 1);
        String timestampString = filename.substring(sequenceNumberEndIdx + 1);
        if (this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() >= persistenceIdEndIdx || new StringOps(Predef$.MODULE$.augmentString(timestampString)).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LocalSnapshotStore.$anonfun$extractMetadata$1(BoxesRunTime.unboxToChar((Object)x$7))))) {
            none$ = None$.MODULE$;
        } else {
            String persistenceId = filename.substring(this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx(), persistenceIdEndIdx);
            long sequenceNumber = new StringOps(Predef$.MODULE$.augmentString(filename.substring(persistenceIdEndIdx + 1, sequenceNumberEndIdx))).toLong();
            long timestamp = new StringOps(Predef$.MODULE$.augmentString(filename.substring(sequenceNumberEndIdx + 1))).toLong();
            none$ = new Some((Object)new Tuple3((Object)persistenceId, (Object)BoxesRunTime.boxToLong((long)sequenceNumber), (Object)BoxesRunTime.boxToLong((long)timestamp)));
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$3(Seq x$3) {
    }

    public static final /* synthetic */ void $anonfun$deleteAsync$5(Seq x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$snapshotMetadatas$4(LocalSnapshotStore $this, SnapshotSelectionCriteria criteria$1, SnapshotMetadata md) {
        return criteria$1.matches(md) && !$this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving().contains((Object)md);
    }

    public static final /* synthetic */ boolean $anonfun$extractMetadata$1(char x$7) {
        return !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$7));
    }

    public LocalSnapshotStore(Config config) {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        SnapshotStore.$init$(this);
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern = new StringOps(Predef$.MODULE$.augmentString("^snapshot-(.+)-(\\d+)-(\\d+)")).r();
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx = 9;
        this.maxLoadAttempts = BoxesRunTime.unboxToInt((Object)Helpers.Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring((Object)BoxesRunTime.boxToInteger((int)config.getInt("max-load-attempts"))), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 > 1, (Function0 & Serializable & scala.Serializable)() -> "max-load-attempts must be >= 1"));
        this.streamDispatcher = this.context().system().dispatchers().lookup(config.getString("stream-dispatcher"));
        this.dir = new File(config.getString("dir"));
        this.serializationExtension = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.akka$persistence$snapshot$local$LocalSnapshotStore$$saving = Set$.MODULE$.empty();
    }

    public final class SnapshotFilenameFilter
    implements FilenameFilter {
        private final String encodedPersistenceId;

        public String encodedPersistenceId() {
            return this.encodedPersistenceId;
        }

        @Override
        public boolean accept(File dir, String name) {
            int persistenceIdEndIdx = name.lastIndexOf(45, name.lastIndexOf(45) - 1);
            return LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx() + this.encodedPersistenceId().length() == persistenceIdEndIdx && name.startsWith(this.encodedPersistenceId(), LocalSnapshotStore.this.akka$persistence$snapshot$local$LocalSnapshotStore$$persistenceIdStartIdx());
        }

        public SnapshotFilenameFilter(String persistenceId) {
            if (LocalSnapshotStore.this == null) {
                throw null;
            }
            this.encodedPersistenceId = URLEncoder.encode(persistenceId);
        }
    }

    public final class SnapshotSeqNrFilenameFilter
    implements FilenameFilter {
        private final SnapshotMetadata md;
        private final /* synthetic */ LocalSnapshotStore $outer;

        private final boolean matches(String pid, String snr, String tms) {
            return pid.equals(URLEncoder.encode(this.md.persistenceId())) && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(snr)).toLong() == $this.md.sequenceNr() && ($this.md.timestamp() == 0L || new StringOps(Predef$.MODULE$.augmentString(tms)).toLong() == $this.md.timestamp())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean bl;
            String string = name;
            Option option = this.$outer.akka$persistence$snapshot$local$LocalSnapshotStore$$FilenamePattern().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(3) == 0) {
                String pid = (String)((LinearSeqOptimized)option.get()).apply(0);
                String snr = (String)((LinearSeqOptimized)option.get()).apply(1);
                String tms = (String)((LinearSeqOptimized)option.get()).apply(2);
                bl = this.matches(pid, snr, tms);
            } else {
                bl = false;
            }
            return bl;
        }

        public SnapshotSeqNrFilenameFilter(LocalSnapshotStore $outer, SnapshotMetadata md) {
            this.md = md;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

