/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.DependencyBuilder;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.DependencyCreatedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyDeletedEvent;
import com.xebialabs.xlrelease.domain.events.DependencyUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyCandidateCollector;
import com.xebialabs.xlrelease.service.LockedTaskOperationChecks$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseTreeBuilder;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.ReleaseTreeItem;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0012%\u00015B\u0001b\u0011\u0001\u0003\u0006\u0004%\t\u0001\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000b\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003O\u0011!\u0011\u0006A!b\u0001\n\u0003\u0019\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011a\u0003!Q1A\u0005\u0002eC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011)\u0019!C\u0001?\"Aa\r\u0001B\u0001B\u0003%\u0001\r\u0003\u0005h\u0001\t\u0015\r\u0011\"\u0001i\u0011!a\u0007A!A!\u0002\u0013I\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011\u00018\t\u0011I\u0004!\u0011!Q\u0001\n=D\u0001b\u001d\u0001\u0003\u0006\u0004%\t\u0001\u001e\u0005\tq\u0002\u0011\t\u0011)A\u0005k\")\u0011\u0010\u0001C\u0001u\"I\u0011q\u0005\u0001C\u0002\u0013\u0005\u0011\u0011\u0006\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002,!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!!2\u0001\t\u0003\t9\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"I\u0011Q\u001f\u0001\u0012\u0002\u0013%\u0011q\u001f\u0005\n\u0005\u0017\u0001\u0011\u0013!C\u0005\u0005\u001bAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001c\u0001!\tA!\b\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!1\t\u0001\u0005\u0002\t\u0015\u0003b\u0002B(\u0001\u0011E!\u0011\u000b\u0005\b\u0005+\u0002A\u0011\u0003B,\u0005E!U\r]3oI\u0016t7-_*feZL7-\u001a\u0006\u0003K\u0019\nqa]3sm&\u001cWM\u0003\u0002(Q\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003S)\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\n1aY8n\u0007\u0001\u0019R\u0001\u0001\u00185qm\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b7\u001b\u0005!\u0013BA\u001c%\u0005I\u0011V\r\\3bg\u0016$&/Z3Ck&dG-\u001a:\u0011\u0005UJ\u0014B\u0001\u001e%\u0005q!U\r]3oI\u0016t7-_\"b]\u0012LG-\u0019;f\u0007>dG.Z2u_J\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\u000bMdg\r\u000e6\u000b\u0003\u0001\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u0005v\u0012q\u0001T8hO&tw-A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012!\u0012\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001a\n!B]3q_NLGo\u001c:z\u0013\tQuIA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005!\"/\u001a7fCN,7+Z1sG\"\u001cVM\u001d<jG\u0016,\u0012A\u0014\t\u0003k=K!\u0001\u0015\u0013\u0003)I+G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f\u0003U\u0011X\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\u0002\n!\u0003\u001d7b]&#X-\u001c*fa>\u001c\u0018\u000e^8ssV\tA\u000b\u0005\u0002G+&\u0011ak\u0012\u0002\u0013!2\fg.\u0013;f[J+\u0007o\\:ji>\u0014\u00180A\nqY\u0006t\u0017\n^3n%\u0016\u0004xn]5u_JL\b%\u0001\u000beKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u000b\u00025B\u0011aiW\u0005\u00039\u001e\u0013A\u0003R3qK:$WM\\2z%\u0016\u0004xn]5u_JL\u0018!\u00063fa\u0016tG-\u001a8dsJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\tKZ,g\u000e\u001e\"vgV\t\u0001\r\u0005\u0002bI6\t!M\u0003\u0002dM\u00051QM^3oiNL!!\u001a2\u0003#ac%+\u001a7fCN,WI^3oi\n+8/A\u0005fm\u0016tGOQ;tA\u0005qA/Y:l%\u0016\u0004xn]5u_JLX#A5\u0011\u0005\u0019S\u0017BA6H\u00059!\u0016m]6SKB|7/\u001b;pef\fq\u0002^1tWJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\fG&LEmU3sm&\u001cW-F\u0001p!\t)\u0004/\u0003\u0002rI\tY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003A\t'o\u00195jm&twmU3sm&\u001cW-F\u0001v!\t)d/\u0003\u0002xI\t\u0001\u0012I]2iSZLgnZ*feZL7-Z\u0001\u0012CJ\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0007|yvtx0!\u0001\u0002\u0004\u0005\u0015\u0011q\u0001\t\u0003k\u0001AQaQ\tA\u0002\u0015CQ\u0001T\tA\u00029CQAU\tA\u0002QCQ\u0001W\tA\u0002iCQAX\tA\u0002\u0001DQaZ\tA\u0002%DQ!\\\tA\u0002=DQa]\tA\u0002UD3!EA\u0006!\u0011\ti!a\t\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!\"\u00198o_R\fG/[8o\u0015\u0011\t)\"a\u0006\u0002\u000f\u0019\f7\r^8ss*!\u0011\u0011DA\u000e\u0003\u0015\u0011W-\u00198t\u0015\u0011\ti\"a\b\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!\t\u0002\u0007=\u0014x-\u0003\u0003\u0002&\u0005=!!C!vi><\u0018N]3e\u0003a\t7\r^5wK\u0012+\u0007/\u001a8eK:\u001c\u0017p\u0015;biV\u001cXm]\u000b\u0003\u0003W\u0001b!!\f\u0002>\u0005\rc\u0002BA\u0018\u0003sqA!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ka\u0013A\u0002\u001fs_>$h(C\u00012\u0013\r\tY\u0004M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty$!\u0011\u0003\u0007M+\u0017OC\u0002\u0002<A\u0002B!!\u0012\u0002N9!\u0011qIA%!\r\t\t\u0004M\u0005\u0004\u0003\u0017\u0002\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002P\u0005E#AB*ue&twMC\u0002\u0002LA\n\u0011$Y2uSZ,G)\u001a9f]\u0012,gnY=Ti\u0006$Xo]3tA\u000511M]3bi\u0016$b!!\u0017\u0002f\u0005=\u0004\u0003BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c%\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003G\niF\u0001\u0006EKB,g\u000eZ3oGfDq!a\u001a\u0015\u0001\u0004\tI'\u0001\u0003hCR,\u0007\u0003BA.\u0003WJA!!\u001c\u0002^\tAq)\u0019;f)\u0006\u001c8\u000eC\u0004\u0002rQ\u0001\r!a\u0011\u0002%Q\f'oZ3u\u0013\u0012|%OV1sS\u0006\u0014G.\u001a\u0015\u0004)\u0005U\u0004\u0003BA<\u0003\u0007k!!!\u001f\u000b\t\u0005E\u00111\u0010\u0006\u0005\u0003{\ny(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005\u0005%&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t))!\u001f\u0003\u000bQKW.\u001a3\u0002\u0019U\u0004H-\u0019;f)\u0006\u0014x-\u001a;\u0015\r\u0005e\u00131RAH\u0011\u001d\ti)\u0006a\u0001\u0003\u0007\nA\u0002Z3qK:$WM\\2z\u0013\u0012Dq!!\u001d\u0016\u0001\u0004\t\u0019\u0005K\u0002\u0016\u0003k\na\u0001Z3mKR,G\u0003BAL\u0003;\u00032aLAM\u0013\r\tY\n\r\u0002\u0005+:LG\u000fC\u0004\u0002 Z\u0001\r!a\u0011\u0002\u0005%$\u0007f\u0001\f\u0002v\u0005)r-\u001a;D_6\u0004H.\u001a;bE2,w)\u0019;f\u0013\u0012\u001cH\u0003BAT\u0003o\u0003b!!+\u00024\u0006\rSBAAV\u0015\u0011\ti+a,\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003c\u000bAA[1wC&!\u0011QWAV\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\u0005\b\u0003s;\u0002\u0019AA^\u0003\u001d!\u0018M]4fiN\u0004b!!+\u00024\u0006u\u0006\u0003BA.\u0003\u007fKA!!1\u0002^\tA\u0001\u000b\\1o\u0013R,W\u000eK\u0002\u0018\u0003k\n\u0011DZ5oI\u0006\u001bG/\u001b<f\u0013:\u001cw.\\5oO\u001e\u000bG/Z%egR!\u0011\u0011ZAh!\u0019\tI+a3\u0002D%!\u0011QZAV\u0005\u0011a\u0015n\u001d;\t\u000f\u0005E\u0007\u00041\u0001\u0002D\u0005A\u0001/\u0019:f]RLE\rK\u0002\u0019\u0003k\n!cZ3u\r\u0006LG.\u00192mK\u001e\u000bG/Z%egR!\u0011qUAm\u0011\u001d\tY.\u0007a\u0001\u0003w\u000ba\"\u00192peR,G\rV1sO\u0016$8\u000fK\u0002\u001a\u0003k\nADZ5oI\u0006cG.\u00138d_6Lgn\u001a#fa\u0016tG-\u001a8ds&#7\u000f\u0006\u0005\u0002,\u0005\r\u0018q]Av\u0011\u001d\t)O\u0007a\u0001\u0003W\t\u0011\u0002^1sO\u0016$\u0018\nZ:\t\u0013\u0005%(\u0004%AA\u0002\u0005-\u0012\u0001C:uCR,8/Z:\t\u0013\u00055(\u0004%AA\u0002\u0005=\u0018a\u0005:fM\u0016\u0014XM\\2j]\u001e\u001c\u0005.\u001b7ee\u0016t\u0007cA\u0018\u0002r&\u0019\u00111\u001f\u0019\u0003\u000f\t{w\u000e\\3b]\u00061c-\u001b8e\u00032d\u0017J\\2p[&tw\rR3qK:$WM\\2z\u0013\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e(\u0006BA\u0016\u0003w\\#!!@\u0011\t\u0005}(qA\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#\u0001\u0014\u0002\u0002B\u0005\u0005\u0003\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u00192\u0017N\u001c3BY2LenY8nS:<G)\u001a9f]\u0012,gnY=JIN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001fQC!a<\u0002|\u0006Yb-\u001b8e\u0003\u000e$\u0018N^3PkR<w.\u001b8h)\u0006\u0014x-\u001a;JIN$B!!3\u0003\u0016!9!qC\u000fA\u0002\u0005\r\u0013!\u0003:fY\u0016\f7/Z%eQ\ri\u0012QO\u0001\u000fO\u0016$(+\u001a7fCN,GK]3f)\u0011\u0011yBa\u000b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQ1A!\n'\u0003\u00151\u0018.Z<t\u0013\u0011\u0011ICa\t\u0003\u0017I+G.Z1tKR\u0013X-\u001a\u0005\b\u0005/q\u0002\u0019AA\"Q\rq\u0012QO\u0001\u001ckB$\u0017\r^3HCR,'+\u001a4fe\u0016t7-\u001b8h!\"\f7/Z:\u0015\r\u0005]%1\u0007B\u001c\u0011\u001d\u0011)d\ba\u0001\u0003\u0007\naaZ1uK&#\u0007b\u0002B\u001d?\u0001\u0007!1H\u0001\u0011_JLw-\u001b8U_J+7\u000f^8sK\u0012\u0004\u0002\"!+\u0003>\u0005u\u0016QX\u0005\u0005\u0005\u007f\tYKA\u0002NCBD3aHA;\u0003M\t'o\u00195jm\u0016$U\r]3oI\u0016t7-[3t)\u0019\t9Ja\u0012\u0003J!9!q\u0003\u0011A\u0002\u0005\r\u0003b\u0002B&A\u0001\u0007\u00111F\u0001\u000eI\u0016\u0004XM\u001c3f]\u000eL\u0018\nZ:)\u0007\u0001\n)(A\u000fgS:$\u0017J\u001c)s_\u001e\u0014Xm]:J]\u000e|W.\u001b8h\u000f\u0006$X-\u00133t)\u0011\tYCa\u0015\t\u000f\u0005\u0015\u0018\u00051\u0001\u0002,\u0005Q\u0011n\u001d+f[Bd\u0017\r^3\u0015\t\u0005=(\u0011\f\u0005\b\u0003\u001b\u0013\u0003\u0019AA\"Q\r\u0001!Q\f\t\u0005\u0005?\u0012)'\u0004\u0002\u0003b)!!1MA\u000e\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005O\u0012\tGA\u0004TKJ4\u0018nY3")
public class DependencyService
implements ReleaseTreeBuilder,
DependencyCandidateCollector,
Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleaseSearchService releaseSearchService;
    private final PlanItemRepository planItemRepository;
    private final DependencyRepository dependencyRepository;
    private final XLReleaseEventBus eventBus;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final ArchivingService archivingService;
    private final Seq<String> activeDependencyStatuses;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    @Timed
    public List<Release> findAllDependencyCandidates(String gateId) {
        return DependencyCandidateCollector.findAllDependencyCandidates$(this, gateId);
    }

    @Override
    @Timed
    public Release getDependencyCandidate(String gateId, String targetReleaseId) {
        return DependencyCandidateCollector.getDependencyCandidate$(this, gateId, targetReleaseId);
    }

    @Override
    public Seq<String> getReferencedCis(String gateReleaseId) {
        return DependencyCandidateCollector.getReferencedCis$(this, gateReleaseId);
    }

    @Override
    public boolean isReferencable(PlanItem planItem, Seq<String> referencedIds) {
        return DependencyCandidateCollector.isReferencable$(this, planItem, referencedIds);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, PlanItem item) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, item);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, TaskGroup taskGroup) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, taskGroup);
    }

    @Override
    public ReleaseTreeItem toTreeItem(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases, GateTask gateTask) {
        return ReleaseTreeBuilder.toTreeItem$((ReleaseTreeBuilder)this, releaseId, dependentReleases, gateTask);
    }

    @Override
    public Object loadDependentRelease(Dependency dependency, String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.loadDependentRelease$(this, dependency, releaseId, dependentReleases);
    }

    @Override
    public PartialFunction<Task, ReleaseTreeItem> taskMatcher(String releaseId, scala.collection.mutable.Map<String, ReleaseTreeItem> dependentReleases) {
        return ReleaseTreeBuilder.taskMatcher$(this, releaseId, dependentReleases);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DependencyService dependencyService = this;
        synchronized (dependencyService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseSearchService releaseSearchService() {
        return this.releaseSearchService;
    }

    public PlanItemRepository planItemRepository() {
        return this.planItemRepository;
    }

    @Override
    public DependencyRepository dependencyRepository() {
        return this.dependencyRepository;
    }

    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public Seq<String> activeDependencyStatuses() {
        return this.activeDependencyStatuses;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Dependency create(GateTask gate, String targetIdOrVariable) {
        void var3_3;
        LockedTaskOperationChecks$.MODULE$.checkCreateDependency((Task)gate);
        Dependency dependency = DependencyBuilder.newDependency().withId(this.ciIdService().getUniqueId(Type.valueOf(Dependency.class), gate.getId())).build();
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
        } else {
            Object target = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTarget(target);
        }
        gate.addDependency(dependency);
        dependency.setGateTask(gate);
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().create(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyCreatedEvent(dependency));
        return var3_3;
    }

    @Timed
    public Dependency updateTarget(String dependencyId, String targetIdOrVariable) {
        String gateId = Ids.getParentId((String)dependencyId);
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        LockedTaskOperationChecks$.MODULE$.checkUpdateDependency((Task)gate);
        Dependency dependency = gate.getDependencies().stream().filter(d -> {
            String string = dependencyId;
            String string2 = d.getId();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).findFirst().orElseThrow(() -> new NotFoundException(String.format("Dependency with Id '%s' not found.", dependencyId), new Object[0]));
        Dependency original = CiCloneHelper.cloneCi(dependency);
        Checks.checkArgument((!dependency.isDone() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be updated", (Object[])new Object[0]);
        if (VariableHelper$.MODULE$.containsVariables(targetIdOrVariable)) {
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(null);
        } else {
            Object newTarget = this.planItemRepository().findById(targetIdOrVariable);
            dependency.setTargetId(targetIdOrVariable);
            dependency.setTarget(newTarget);
        }
        Release release = gate.getRelease();
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService());
        this.dependencyRepository().update(release, dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, dependency));
        return dependency;
    }

    @Timed
    public void delete(String id) {
        Dependency dependency = this.dependencyRepository().findById(id);
        GateTask gate = dependency.getGateTask();
        LockedTaskOperationChecks$.MODULE$.checkDeleteDependency((Task)gate);
        Checks.checkArgument((!dependency.isDone() || gate.isPlanned() ? 1 : 0) != 0, (String)"Dependency has already been resolved and cannot be deleted", (Object[])new Object[0]);
        this.dependencyRepository().delete(dependency);
        this.eventBus().publish((XLReleaseEvent)new DependencyDeletedEvent(dependency));
    }

    @Timed
    public Collection<String> getCompletableGateIds(Collection<PlanItem> targets) {
        Seq doneTargetIds = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(targets).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isDone()))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)this.findInProgressIncomingGateIds((Seq<String>)doneTargetIds).map((Function1 & Serializable & scala.Serializable)id -> (GateTask)this.taskRepository().findById((String)id), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isCompletable()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public List<String> findActiveIncomingGateIds(String parentId) {
        Seq seq;
        if (this.planItemRepository().exists(parentId)) {
            seq = (Seq)((SeqLike)((TraversableLike)this.findAllIncomingDependencyIds((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{parentId}))), this.activeDependencyStatuses(), true).filterNot((Function1 & Serializable & scala.Serializable)dependencyId -> BoxesRunTime.boxToBoolean((boolean)this.isTemplate(dependencyId)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Plan item ").append(parentId).append(" not found. It is either archived, or does not exist. Returning no dependencies").toString());
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(seq).asJava();
    }

    @Timed
    public Collection<String> getFailableGateIds(Collection<PlanItem> abortedTargets) {
        return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(this.findInProgressIncomingGateIds((Seq<String>)((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(abortedTargets).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Seq$.MODULE$.canBuildFrom())))).asJava();
    }

    private Seq<String> findAllIncomingDependencyIds(Seq<String> targetIds, Seq<String> statuses, boolean referencingChildren) {
        return (Seq)this.dependencyRepository().findAllIncomingDependencies(targetIds, statuses, referencingChildren).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getId(), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> findAllIncomingDependencyIds$default$2() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private boolean findAllIncomingDependencyIds$default$3() {
        return false;
    }

    @Timed
    public List<String> findActiveOutgoingTargetIds(String releaseId) {
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.dependencyRepository().findByReleaseId(releaseId)).asScala()).filter((Function1 & Serializable & scala.Serializable)dep -> BoxesRunTime.boxToBoolean((boolean)DependencyService.$anonfun$findActiveOutgoingTargetIds$1(dep)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getTargetId(), Buffer$.MODULE$.canBuildFrom())).distinct()).asJava();
    }

    @Timed
    public ReleaseTree getReleaseTree(String releaseId) {
        ReleaseTree releaseTree;
        if (this.archivingService().exists(releaseId)) {
            releaseTree = new ReleaseTree();
        } else {
            scala.collection.mutable.Map dependentReleases = Map$.MODULE$.empty();
            Release release = this.releaseRepository().findById(releaseId);
            this.toTreeItem(releaseId, (scala.collection.mutable.Map<String, ReleaseTreeItem>)dependentReleases, (PlanItem)release);
            ReleaseTree tree = new ReleaseTree();
            tree.releaseId_$eq(releaseId);
            tree.dependentReleases_$eq((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)dependentReleases.values().toList()).asJava());
            releaseTree = tree;
        }
        return releaseTree;
    }

    @Timed
    public void updateGateReferencingPhases(String gateId, Map<PlanItem, PlanItem> originToRestored) {
        GateTask gate = (GateTask)this.taskRepository().findById(gateId);
        Release release = gate.getRelease();
        gate.getDependencies().forEach(dependency -> {
            block0: {
                PlanItem target = dependency.getTarget();
                if (!originToRestored.containsKey(target)) break block0;
                Dependency original = CiCloneHelper.cloneCi(dependency);
                dependency.setTarget((PlanItem)originToRestored.get(target));
                Dependency updatedDependency = this.dependencyRepository().update(release, (Dependency)dependency);
                this.eventBus().publish((XLReleaseEvent)new DependencyUpdatedEvent(original, updatedDependency));
            }
        });
    }

    @Timed
    public void archiveDependencies(String releaseId, Seq<String> dependencyIds) {
        Release referencingRelease = this.releaseRepository().findById(releaseId);
        Buffer dependenciesToArchive = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(referencingRelease.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)dependencyIds.contains((Object)d.getId())));
        dependenciesToArchive.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.archive();
            return BoxedUnit.UNIT;
        });
        this.dependencyRepository().archive(referencingRelease, (Seq<Dependency>)dependenciesToArchive);
    }

    public Seq<String> findInProgressIncomingGateIds(Seq<String> targetIds) {
        return (Seq)((SeqLike)this.findAllIncomingDependencyIds(targetIds, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TaskStatus.IN_PROGRESS.name()}))), this.findAllIncomingDependencyIds$default$3()).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getParentId((String)x$1), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    public boolean isTemplate(String dependencyId) {
        return this.releaseRepository().isTemplate(Ids.releaseIdFrom((String)dependencyId));
    }

    public static final /* synthetic */ boolean $anonfun$findActiveOutgoingTargetIds$1(Dependency dep) {
        return dep.hasResolvedTarget() && !dep.isDone();
    }

    @Autowired
    public DependencyService(ReleaseRepository releaseRepository, ReleaseSearchService releaseSearchService, PlanItemRepository planItemRepository, DependencyRepository dependencyRepository, XLReleaseEventBus eventBus, TaskRepository taskRepository, CiIdService ciIdService, ArchivingService archivingService) {
        this.releaseRepository = releaseRepository;
        this.releaseSearchService = releaseSearchService;
        this.planItemRepository = planItemRepository;
        this.dependencyRepository = dependencyRepository;
        this.eventBus = eventBus;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.archivingService = archivingService;
        ReleaseTreeBuilder.$init$(this);
        DependencyCandidateCollector.$init$(this);
        Logging.$init$((Logging)this);
        this.activeDependencyStatuses = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TaskStatus.ACTIVE_STATUSES)).toSeq().$colon$plus((Object)TaskStatus.PLANNED, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom());
    }
}

