/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.dsl.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plumbing.serialization.PortableConfigurationReference;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.artifact.ArtifactEnricher;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromDsl;
import com.xebialabs.xlrelease.domain.events.PermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.dsl.service.CiProcessor;
import com.xebialabs.xlrelease.dsl.service.CiTreeVisitor;
import com.xebialabs.xlrelease.dsl.service.DslError;
import com.xebialabs.xlrelease.dsl.service.DslProcessingContext;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Option;

@Service
public class DslService
implements ApiService {
    private static final Logger logger = LoggerFactory.getLogger(DslService.class);
    private TeamService teamService;
    private WorkDirFactory workDirFactory;
    private CiIdService ciIdService;
    private FolderService folderService;
    private CiProcessor ciProcessor;
    private PasswordEncrypter passwordEncrypter;
    private PermissionChecker permissionChecker;
    private ReleaseRepository releaseRepository;
    private ReleaseService releaseService;
    private ReleaseActorService releaseActorService;
    private ConfigurationRepository configurationRepository;
    private XLReleaseEventBus eventBus;

    @Autowired
    public DslService(WorkDirFactory workdirFactory, CiIdService ciIdService, TeamService teamService, FolderService folderService, CiProcessor ciProcessor, PasswordEncrypter passwordEncrypter, PermissionChecker permissionChecker, ReleaseRepository releaseRepository, ReleaseService releaseService, ReleaseActorService releaseActorService, ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.ciIdService = ciIdService;
        this.workDirFactory = workdirFactory;
        this.teamService = teamService;
        this.folderService = folderService;
        this.ciProcessor = ciProcessor;
        this.passwordEncrypter = passwordEncrypter;
        this.permissionChecker = permissionChecker;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.releaseActorService = releaseActorService;
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
    }

    @Timed
    public Release createRelease(Release parentRelease, Release release, Map<String, Object> additionalProperties) {
        DslProcessingContext processingContext = new DslProcessingContext();
        processingContext.setParentRelease(parentRelease);
        String folderIdOrPath = (String)additionalProperties.get("folder");
        Directory container = this.getContainer(folderIdOrPath, parentRelease);
        String containerId = container == null ? null : container.getId();
        this.permissionChecker.checkIsAllowedToCreateReleaseInFolder(containerId);
        if (release.getOwner() == null && parentRelease != null) {
            release.setOwner(parentRelease.getScriptUsername());
        }
        this.processReleaseTeamsAndPermissions(parentRelease, release);
        release.setStatus(ReleaseStatus.PLANNED);
        this.create((ConfigurationItem)container, (ConfigurationItem)release, release.getTeams(), processingContext);
        release.updateRealFlagStatus();
        this.initReleaseCalendarLinkToken(release);
        LocalDateTime releaseStart = release.getScheduledStartDate() != null ? LocalDateTime.fromDateFields((Date)release.getScheduledStartDate()) : LocalDateTime.now();
        this.releaseService.setDatesFromTemplate(release, release, releaseStart);
        this.encryptPasswords((ConfigurationItem)release);
        this.releaseRepository.update(release);
        this.releaseActorService.activate(release.getId());
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new CreatedFromDsl()));
        this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(release.getTeams()));
        return release;
    }

    @Timed
    public Release createTemplate(Release parentRelease, Release template, Map<String, Object> additionalProperties) {
        DslProcessingContext processingContext = new DslProcessingContext();
        processingContext.setParentRelease(parentRelease);
        String folderIdOrPath = (String)additionalProperties.get("folder");
        Directory container = this.getContainer(folderIdOrPath, parentRelease);
        processingContext.setContainer((ConfigurationItem)container);
        if (processingContext.getContainer() != null) {
            this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, processingContext.getContainer().getId());
        } else {
            this.permissionChecker.check(XLReleasePermissions.CREATE_TEMPLATE);
        }
        if (template.getOwner() == null && parentRelease != null) {
            template.setOwner(parentRelease.getScriptUsername());
        }
        this.processTemplateTeamsAndPermissions(processingContext, template);
        this.create((ConfigurationItem)container, (ConfigurationItem)template, template.getTeams(), processingContext);
        LocalDateTime releaseStart = template.getScheduledStartDate() != null ? LocalDateTime.fromDateFields((Date)template.getScheduledStartDate()) : LocalDateTime.now();
        this.releaseService.setDatesFromTemplate(template, template, releaseStart);
        this.encryptPasswords((ConfigurationItem)template);
        this.releaseRepository.update(template);
        this.releaseActorService.activate(template.getId());
        this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(template, (ReleaseCreationSource)new CreatedFromDsl()));
        this.eventBus.publish((XLReleaseEvent)new PermissionsUpdatedEvent(template.getTeams()));
        return template;
    }

    @Timed
    public Release importTemplate(Release template, String containerId) {
        DslProcessingContext processingContext = new DslProcessingContext();
        processingContext.setImport(true);
        Folder container = null;
        if (!Ids.isRoot((String)containerId)) {
            container = this.folderService.findById(containerId, Integer.valueOf(0));
        }
        processingContext.setContainer((ConfigurationItem)container);
        this.create((ConfigurationItem)container, (ConfigurationItem)template, template.getTeams(), processingContext);
        return template;
    }

    private void processReleaseTeamsAndPermissions(Release parent, Release release) {
        if (release.getTeams().isEmpty() && !Ids.isInFolder((String)parent.getId())) {
            Team defaultReleaseAdminTeam = TeamBuilder.newTeam().withTeamName("Release Admin").withPermissions(XLReleasePermissions.getReleasePermissions()).withMembers(new String[]{parent.getScriptUsername()}).build();
            release.addTeam(defaultReleaseAdminTeam);
        }
    }

    private void processTemplateTeamsAndPermissions(DslProcessingContext processingContext, Release template) {
        if (processingContext.getContainer() != null) {
            template.setTeams(Collections.emptyList());
        } else if (template.getTeams().isEmpty()) {
            Team defaultTemplateOwnerTeam = TeamBuilder.newTeam().withTeamName("Template Owner").withPermissions(XLReleasePermissions.getTemplateOnlyPermissions()).withMembers(new String[]{processingContext.getParentRelease().getScriptUsername()}).build();
            ArrayList<String> releaseAdminTemplatePermissions = new ArrayList<String>(XLReleasePermissions.getReleasePermissions());
            releaseAdminTemplatePermissions.add(XLReleasePermissions.VIEW_TEMPLATE.getPermissionName());
            Team defaultReleaseAdminTeam = TeamBuilder.newTeam().withTeamName("Release Admin").withPermissions(releaseAdminTemplatePermissions).build();
            template.setTeams(Arrays.asList(defaultTemplateOwnerTeam, defaultReleaseAdminTeam));
        } else {
            template.getTeams().forEach(team -> team.getPermissions().retainAll(XLReleasePermissions.getTemplatePermissions()));
        }
    }

    private void encryptPasswords(ConfigurationItem item) {
        logger.debug("Encrypting password properties of `{}`", (Object)item.getId());
        CiTreeVisitor.of(item).with(ci -> CiHelper.forFields((ConfigurationItem)ci, PropertyDescriptor::isPassword, this::encrypt));
    }

    private void encrypt(ConfigurationItem ci, PropertyDescriptor pd) {
        logger.debug("Encrypting password property `{}` of `{}`", (Object)pd.getFqn(), (Object)ci.getId());
        String passwordValue = (String)pd.get(ci);
        if (passwordValue != null) {
            String encryptedValue = this.passwordEncrypter.ensureEncrypted(passwordValue);
            pd.set(ci, (Object)encryptedValue);
        }
    }

    private Directory getContainer(String id) {
        String releaseId = Ids.releaseIdFrom((String)id);
        String parentId = Ids.getParentId((String)releaseId);
        if (Ids.isRoot((String)parentId)) {
            return null;
        }
        return this.folderService.findById(parentId, Integer.valueOf(0));
    }

    private Directory getContainer(String folderIdOrPath, Release parentRelease) {
        if (StringUtils.hasText((String)folderIdOrPath)) {
            if (!this.folderService.exists(folderIdOrPath)) {
                Folder folder = this.folderService.findByPath(folderIdOrPath, 0);
                if (null == folder) {
                    throw new DslError("No folder found with title or id '%s'.", folderIdOrPath);
                }
                return folder;
            }
            return this.folderService.findById(folderIdOrPath, Integer.valueOf(0));
        }
        return this.getContainer(parentRelease.getId());
    }

    private void create(ConfigurationItem parentContainer, ConfigurationItem ci, List<Team> teams, DslProcessingContext processingContext) {
        processingContext.setContainer(parentContainer);
        this.createCis(this.getNestedCisAndPopulateWithId(parentContainer, ci, processingContext), teams, processingContext);
    }

    private void createCis(List<ConfigurationItem> cis, List<Team> teams, DslProcessingContext processingContext) {
        List<Variable> newVariables = this.buildVariablesIfNeeded(cis);
        cis.addAll(newVariables);
        this.createCisAttachmentsAndNoTeams(cis, processingContext);
        this.saveTeams(teams, processingContext);
    }

    private List<ConfigurationItem> getNestedCisAndPopulateWithId(ConfigurationItem parent, ConfigurationItem ci, DslProcessingContext processingContext) {
        ArrayList<ConfigurationItem> listWithNested = new ArrayList<ConfigurationItem>();
        listWithNested.add(ci);
        this.createId(ci, parent);
        this.ciProcessor.process(processingContext, ci);
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                Collection<ConfigurationItem> children = this.getChildren(ci, property);
                listWithNested.addAll(this.getNestedCis(ci, children, processingContext));
            }
            if (kind != PropertyKind.CI) continue;
            Object unresolvedCiRef = property.get(ci);
            if (unresolvedCiRef instanceof PortableConfigurationReference) {
                PortableConfigurationReference reference = (PortableConfigurationReference)unresolvedCiRef;
                Option folderIdOption = Option.apply((Object)processingContext.getContainer()).map(ConfigurationItem::getId);
                BaseConfiguration resolvedConfigurationItem = (BaseConfiguration)reference.resolve(this.configurationRepository, ResolutionContext.apply((Option)folderIdOption)).getOrElse(() -> {
                    throw new DslError("No CI found for the type '%s' and title '%s'", reference.ciType().toString(), reference.title());
                });
                property.set(ci, (Object)resolvedConfigurationItem);
                continue;
            }
            ConfigurationItem ciRef = (ConfigurationItem)unresolvedCiRef;
            if (ciRef == null) continue;
            if (this.isChild(ciRef, ci) || property.getReferencedType().instanceOf(Type.valueOf(PythonScript.class))) {
                listWithNested.addAll(this.getNestedCisAndPopulateWithId(ci, ciRef, processingContext));
                continue;
            }
            property.set(ci, (Object)ciRef);
        }
        return listWithNested;
    }

    private List<ConfigurationItem> getNestedCis(ConfigurationItem parent, Collection<? extends ConfigurationItem> cis, DslProcessingContext processingContext) {
        ArrayList<ConfigurationItem> listWithNested = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem configurationItem : cis) {
            listWithNested.addAll(this.getNestedCisAndPopulateWithId(parent, configurationItem, processingContext));
        }
        return listWithNested;
    }

    private Collection<ConfigurationItem> getChildren(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        if (property.isAsContainment()) {
            return references;
        }
        return references.stream().filter(ci -> this.isChild((ConfigurationItem)ci, parent)).collect(Collectors.toList());
    }

    private boolean isChild(ConfigurationItem ci, ConfigurationItem parent) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(ci))) continue;
            return true;
        }
        return false;
    }

    private void createId(ConfigurationItem ci, ConfigurationItem parent) {
        String id;
        String parentId;
        String string = parentId = null == parent ? Ids.ROOT_FOLDER_ID : parent.getId();
        if (ci.getType().equals((Object)Type.valueOf(Dashboard.class))) {
            Checks.checkNotNull((Object)parent, (String)"Dashboard must have parent");
            id = parentId + "/" + "summary";
        } else if (ci.getType().isSubTypeOf(Type.valueOf(ValueProviderConfiguration.class))) {
            Checks.checkNotNull((Object)parent, (String)"ValueProviderConfiguration must be stored under Variable");
            id = parentId + "/valueProvider";
        } else {
            id = this.ciIdService.getUniqueId(ci.getType(), parentId);
        }
        ci.setId(id);
    }

    private void createCisAttachmentsAndNoTeams(List<ConfigurationItem> cis, DslProcessingContext processingContext) {
        List cisWithoutTeams = cis.stream().filter(ci -> !ci.getType().instanceOf(Type.valueOf(Team.class))).collect(Collectors.toList());
        WorkDir workDir = this.workDirFactory.newWorkDir("external");
        if (!processingContext.isImport()) {
            WorkDirTemplate.cleanOnFinally((WorkDir)workDir, workDir1 -> {
                cisWithoutTeams.forEach(ci -> {
                    if (ci instanceof Release) {
                        this.releaseRepository.create((Release)ci, (ReleaseCreationSource)new CreatedFromDsl());
                    }
                });
                return null;
            });
        }
    }

    private void enrichSourceArtifacts(List<ConfigurationItem> cisWithoutTeams, WorkDir workDir) {
        for (ConfigurationItem ci : cisWithoutTeams) {
            if (!(ci instanceof SourceArtifact)) continue;
            SourceArtifact sourceArtifact = (SourceArtifact)ci;
            if (sourceArtifact.getFileUri() != null) {
                new ArtifactEnricher((Artifact)sourceArtifact, workDir).enrich();
                continue;
            }
            throw new IllegalStateException(String.format("Unable to create source artifact for %s", sourceArtifact.getId()));
        }
    }

    private List<Variable> buildVariablesIfNeeded(List<ConfigurationItem> entities) {
        return entities.stream().filter(entity -> entity.getType().equals((Object)Type.valueOf(Release.class))).flatMap(entity -> {
            Release release = (Release)entity;
            return VariablePersistenceHelper.scanAndBuildNewVariables((Release)release, (VisitableItem)release, (CiIdService)this.ciIdService).stream();
        }).collect(Collectors.toList());
    }

    private void saveTeams(Collection<Team> entities, DslProcessingContext processingContext) {
        HashMap<String, List> containersToTeams = new HashMap<String, List>();
        entities.forEach(team -> {
            String containerId = Ids.getParentId((String)team.getId());
            team.setId(null);
            containersToTeams.computeIfAbsent(containerId, s -> new ArrayList()).add(team);
        });
        if (!processingContext.isImport()) {
            containersToTeams.forEach((containerId, containerTeams) -> this.teamService.saveTeamsToPlatform(containerId, containerTeams));
        }
    }

    private void initReleaseCalendarLinkToken(Release release) {
        Long token = UUID.randomUUID().getMostSignificantBits();
        release.setCalendarLinkToken(token.toString());
    }

    public String serviceName() {
        return "dsl";
    }
}

