/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.security.sql;

import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.xlplatform.repository.sql.Database;
import com.xebialabs.xlplatform.security.sql.db.Tables;
import com.xebialabs.xlplatform.security.sql.db.Tables$;
import com.xebialabs.xlplatform.security.sql.package$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import slick.ast.BaseTypedType;
import slick.ast.TypedCollectionTypeConstructor$;
import slick.ast.TypedType;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.LiteralColumn;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.Shape$;
import slick.lifted.StringColumnExtensionMethods$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u00015\u0011abU9m+N,'oU3sm&\u001cWM\u0003\u0002\u0004\t\u0005\u00191/\u001d7\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u001dA\u0011A\u0003=ma2\fGOZ8s[*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0005\u000191R\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t92$D\u0001\u0019\u0015\t)\u0011D\u0003\u0002\u001b\u0011\u0005AA-\u001a9m_fLG/\u0003\u0002\u001d1\tYQk]3s'\u0016\u0014h/[2f!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0003tY\u001a$$NC\u0001#\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u0013 \u0005\u001daunZ4j]\u001eD\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0011g\u0016\u001cWO]5us\u0012\u000bG/\u00192bg\u0016\u0004\"\u0001\u000b\u0017\u000e\u0003%R!a\u0001\u0016\u000b\u0005-2\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Q&\u000b\u0002\t\t\u0006$\u0018MY1tK\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0005I\u0002Q\"\u0001\u0002\t\u000b\u0019r\u0003\u0019A\u0014\t\u000fU\u0002!\u0019!C\u0001m\u00059\u0001O]8gS2,W#A\u001c\u0011\u0005ajT\"A\u001d\u000b\u0005iZ\u0014\u0001\u00026eE\u000eT\u0011\u0001P\u0001\u0006g2L7m[\u0005\u0003}e\u00121B\u00133cGB\u0013xNZ5mK\"1\u0001\t\u0001Q\u0001\n]\n\u0001\u0002\u001d:pM&dW\r\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0003=\u0001\u0018m]:x_J$WI\\2pI\u0016\u0014X#\u0001#\u0011\u0005])\u0015B\u0001$\u0019\u0005U\u0019\u0006*\u0011\u001a6mA\u000b7o]<pe\u0012,enY8eKJDa\u0001\u0013\u0001!\u0002\u0013!\u0015\u0001\u00059bgN<xN\u001d3F]\u000e|G-\u001a:!\u0011\u001dQ\u0005A1A\u0005\n-\u000baBS\"S?\u0006#U*\u0013(`+N+%+F\u0001M!\tyQ*\u0003\u0002O!\t11\u000b\u001e:j]\u001eDa\u0001\u0015\u0001!\u0002\u0013a\u0015a\u0004&D%~\u000bE)T%O?V\u001bVI\u0015\u0011\u0006\tI\u0003\u0001a\u0015\u0002\u0002#B)A+W0js:\u0011Qk\u0016\b\u0003-Rj\u0011\u0001A\u0005\u00031v\n1!\u00199j\u0013\tQ6LA\u0003Rk\u0016\u0014\u00180\u0003\u0002];\n9\u0011\t\\5bg\u0016\u001c(B\u00010<\u0003\u0019a\u0017N\u001a;fIB\u0011\u0001M\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G\n\t!\u0001\u001a2\n\u0005\u0015\u0014\u0017A\u0002+bE2,7/\u0003\u0002hQ\n)Qk]3sg*\u0011QM\u0019\t\u0005U6|w.D\u0001l\u0015\u0005a\u0017!B:dC2\f\u0017B\u00018l\u0005\u0019!V\u000f\u001d7feA\u0011\u0001o\u001e\b\u0003cV\u0004\"A]6\u000e\u0003MT!\u0001\u001e\u0007\u0002\rq\u0012xn\u001c;?\u0013\t18.\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001dbT!A^6\u0011\u0005i|hBA>~\u001d\t\u0011H0C\u0001m\u0013\tq8.A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00111\u0001\u0002\u0004'\u0016\f(B\u0001@l\u0011\u001d\t9\u0001\u0001C\u0005\u0003\u0013\t!c\u00195fG.4\u0016\r\\5e+N,'O\\1nKR!\u00111BA\t!\rQ\u0017QB\u0005\u0004\u0003\u001fY'\u0001B+oSRDq!a\u0005\u0002\u0006\u0001\u0007q.\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u001d\t9\u0002\u0001C\u0005\u00033\t1BZ5mi\u0016\u0014Xk]3sgR1\u00111DA\u0011\u0003O\u0001r!!\b\u0002 }K\u00170D\u0001^\u0013\tQV\f\u0003\u0005\u0002$\u0005U\u0001\u0019AA\u0013\u0003\u0015\tX/\u001a:z!\t1\u0016\u000bC\u0004\u0002\u0014\u0005U\u0001\u0019A8\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005A!/Z1e+N,'\u000f\u0006\u0003\u00020\u0005U\u0003#\u00026\u00022\u0005U\u0012bAA\u001aW\n1q\n\u001d;j_:\u0004B!a\u000e\u0002R9\u0019\u0011\u0011\b3\u000f\t\u0005m\u0012q\n\b\u0005\u0003{\tiE\u0004\u0003\u0002@\u0005-c\u0002BA!\u0003\u0013rA!a\u0011\u0002H9\u0019!/!\u0012\n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0002d\u0005%\u0019\u00111\u000b5\u0003\tU\u001bXM\u001d\u0005\b\u0003'\tI\u00031\u0001p\u0011\u001d\tI\u0006\u0001C!\u00037\n!bY8v]R,6/\u001a:t)\u0011\ti&a\u0019\u0011\u0007)\fy&C\u0002\u0002b-\u0014A\u0001T8oO\"9\u00111CA,\u0001\u0004y\u0007bBA4\u0001\u0011\u0005\u0013\u0011N\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005-\u00111NA7\u0011\u001d\t\u0019\"!\u001aA\u0002=Dq!a\u001c\u0002f\u0001\u0007q.\u0001\u0005qCN\u001cxo\u001c:e\u0011\u001d\t\u0019\b\u0001C!\u0003k\nAA]3bIR!\u0011qOA?!\r9\u0012\u0011P\u0005\u0004\u0003wB\"\u0001\u0003*fa>,6/\u001a:\t\u000f\u0005M\u0011\u0011\u000fa\u0001_\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015!\u00047jgR,6/\u001a:oC6,7\u000f\u0006\u0005\u0002\u0006\u0006E\u00151SAU!\u0015\t9)!$p\u001b\t\tIIC\u0002\u0002\fJ\tA!\u001e;jY&!\u0011qRAE\u0005\u0011a\u0015n\u001d;\t\u000f\u0005M\u0011q\u0010a\u0001_\"A\u0011QSA@\u0001\u0004\t9*\u0001\u0004qC\u001eLgn\u001a\t\u0005\u00033\u000b)+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\r!Go\u001c\u0006\u00041\u0006\u0005&bAAR3\u00051QM\\4j]\u0016LA!a*\u0002\u001c\n1\u0001+Y4j]\u001eD\u0001\"a+\u0002\u0000\u0001\u0007\u0011QV\u0001\u0006_J$WM\u001d\t\u0005\u00033\u000by+\u0003\u0003\u00022\u0006m%\u0001C(sI\u0016\u0014\u0018N\\4\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u00026R\u0011\u0011Q\u0011\u0005\b\u0003s\u0003A\u0011IA^\u00039iw\u000eZ5gsB\u000b7o]<pe\u0012$b!a\u0003\u0002>\u0006}\u0006bBA\n\u0003o\u0003\ra\u001c\u0005\b\u0003\u0003\f9\f1\u0001p\u0003-qWm\u001e)bgN<xN\u001d3\t\u000f\u0005e\u0006\u0001\"\u0011\u0002FRA\u00111BAd\u0003\u0013\fY\rC\u0004\u0002\u0014\u0005\r\u0007\u0019A8\t\u000f\u0005\u0005\u00171\u0019a\u0001_\"9\u0011QZAb\u0001\u0004y\u0017aC8mIB\u000b7o]<pe\u0012Dq!!5\u0001\t\u0003\n\u0019.\u0001\u0004eK2,G/\u001a\u000b\u0005\u0003\u0017\t)\u000eC\u0004\u0002\u0014\u0005=\u0007\u0019A8\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\u0006a\u0011-\u001e;iK:$\u0018nY1uKR1\u00111BAo\u0003?Dq!a\u0005\u0002X\u0002\u0007q\u000eC\u0004\u0002p\u0005]\u0007\u0019A8")
public class SqlUserService
implements UserService,
Logging {
    private final Database securityDatabase;
    private final JdbcProfile profile;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String JCR_ADMIN_USER;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserService sqlUserService = this;
        synchronized (sqlUserService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public JdbcProfile profile() {
        return this.profile;
    }

    private SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private String JCR_ADMIN_USER() {
        return this.JCR_ADMIN_USER;
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        Option<Tuple2<String, String>> option = this.readUser(username);
        if (option instanceof Some) {
            throw new UserAlreadyExistsException(username);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Query<Tables.Users, Tuple2<String, String>, Seq> filterUsers(Query<Tables.Users, Tuple2<String, String>, Seq> query, String username2) {
        return (Query)Option$.MODULE$.apply((Object)username2).map((Function1 & Serializable & scala.Serializable)username -> query.filter((Function1 & Serializable & scala.Serializable)x$1 -> {
            Rep qual$1 = this.profile().api().stringColumnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$1.username())));
            LiteralColumn x$10 = this.profile().api().valueToConstColumn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username.toLowerCase()})), (TypedType)this.profile().api().stringColumnType());
            char x$11 = StringColumnExtensionMethods$.MODULE$.like$default$2$extension(qual$1);
            return StringColumnExtensionMethods$.MODULE$.like$extension(qual$1, (Rep)x$10, x$11, OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType()));
        }, CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).getOrElse((Function0 & Serializable & scala.Serializable)() -> query);
    }

    private Option<Tuple2<String, String>> readUser(String username) {
        return ((TraversableLike)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$2 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$2.username())), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username.toLowerCase(), (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)user -> new Tuple2(user.username(), user.password()), Shape$.MODULE$.tuple2Shape(Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))))).result())).headOption();
    }

    public long countUsers(String username) {
        return BoxesRunTime.unboxToInt((Object)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.QueryActionExtensionMethodsImpl)this.profile().api().recordQueryActionExtensionMethods((Object)this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)Tables$.MODULE$.users(), username).length(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().intColumnType()))).result()));
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        String pwd = this.passwordEncoder().encode((CharSequence)password);
        this.securityDatabase.runAwait(DBIOAction$.MODULE$.seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{((JdbcActionComponent.SimpleInsertActionComposer)this.profile().api().queryInsertActionExtensionMethods(Tables$.MODULE$.users())).$plus$eq((Object)new Tuple2((Object)username, (Object)pwd))})));
    }

    public RepoUser read(String username) {
        return (RepoUser)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> new RepoUser((String)user._1(), this.JCR_ADMIN_USER().equals(user._1()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such user: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})), new Object[0]);
        });
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        List filters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)query -> this.filterUsers((Query<Tables.Users, Tuple2<String, String>, Seq>)query, username), (Function1 & Serializable & scala.Serializable)query -> order == null || order.isAscending() ? query.sortBy((Function1 & Serializable & scala.Serializable)x$3 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$3.username())), (TypedType)this.profile().api().stringColumnType()).asc(), (Function1)Predef$.MODULE$.$conforms()) : query.sortBy((Function1 & Serializable & scala.Serializable)x$4 -> this.profile().api().columnToOrdered(StringColumnExtensionMethods$.MODULE$.toLowerCase$extension(this.profile().api().stringColumnExtensionMethods(x$4.username())), (TypedType)this.profile().api().stringColumnType()).desc(), (Function1)Predef$.MODULE$.$conforms()), (Function1 & Serializable & scala.Serializable)query -> paging == null ? query : query.drop((paging.page() - 1) * paging.resultsPerPage()).take(paging.resultsPerPage())}));
        return package$.MODULE$.ListExtensions(((TraversableOnce)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(((Query)filters.foldLeft((Object)Tables$.MODULE$.users().to(TypedCollectionTypeConstructor$.MODULE$.forColl(Predef$.MODULE$.fallbackStringCanBuildFrom(), ClassTag$.MODULE$.apply(Seq.class))), (Function2 & Serializable & scala.Serializable)(acc, filter) -> (Query)filter.apply(acc))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public java.util.List<String> listUsernames() {
        return package$.MODULE$.ListExtensions(((TraversableOnce)this.securityDatabase.runAwait((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)this.profile().api().streamableQueryActionExtensionMethods(Tables$.MODULE$.users().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.username(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType())))).result())).toList()).asJavaMutable();
    }

    public void modifyPassword(String username, String newPassword) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryUpdateActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$7 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$7.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.password(), Shape$.MODULE$.repColumnShape((BaseTypedType)this.profile().api().stringColumnType()))).update((Object)this.passwordEncoder().encode((CharSequence)newPassword)));
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$3(this, username, newPassword, oldPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.securityDatabase.runAwait((DBIOAction)this.profile().api().queryDeleteActionExtensionMethods(Tables$.MODULE$.users().filter((Function1 & Serializable & scala.Serializable)x$9 -> new BaseColumnExtensionMethods(this.profile().api().columnExtensionMethods(x$9.username(), (BaseTypedType)this.profile().api().stringColumnType())).$eq$eq$eq((Rep)this.profile().api().valueToConstColumn((Object)username, (TypedType)this.profile().api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)this.profile().api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete());
    }

    public void authenticate(String username, String password) {
        Tuple2 user = (Tuple2)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot authenticate ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        });
        if (!this.passwordEncoder().matches((CharSequence)password, (String)user._2())) {
            throw new AuthenticationFailureException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong credentials supplied for user ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username})));
        }
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$3(SqlUserService $this, String username$5, String newPassword$1, String oldPassword$1, Tuple2 user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, (String)user._2())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$5, newPassword$1);
    }

    public SqlUserService(Database securityDatabase) {
        this.securityDatabase = securityDatabase;
        Logging.$init$((Logging)this);
        this.profile = securityDatabase.config().databaseType().profile();
        this.passwordEncoder = new SHA256PasswordEncoder();
        this.JCR_ADMIN_USER = "admin";
    }
}

