/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.function.Function;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerFormLoginAuthenticationConverter
implements Function<ServerWebExchange, Mono<Authentication>> {
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    @Override
    public Mono<Authentication> apply(ServerWebExchange exchange) {
        return exchange.getFormData().map(data -> this.createAuthentication((MultiValueMap<String, String>)data));
    }

    private UsernamePasswordAuthenticationToken createAuthentication(MultiValueMap<String, String> data) {
        String username = (String)data.getFirst((Object)this.usernameParameter);
        String password = (String)data.getFirst((Object)this.passwordParameter);
        return new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
    }

    public void setUsernameParameter(String usernameParameter) {
        Assert.notNull((Object)usernameParameter, (String)"usernameParameter cannot be null");
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        Assert.notNull((Object)passwordParameter, (String)"passwordParameter cannot be null");
        this.passwordParameter = passwordParameter;
    }
}

