/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.email;

import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.notifications.configuration.trigger.RecipientSettings;
import com.xebialabs.xlrelease.notifications.package$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.PrincipalInfoResolver;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011a#R7bS2\u0014VmY5qS\u0016tGOU3t_24XM\u001d\u0006\u0003\u0007\u0011\tQ!Z7bS2T!!\u0002\u0004\u0002\u001b9|G/\u001b4jG\u0006$\u0018n\u001c8t\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0017I|G.Z*feZL7-\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t\u0001b]3dkJLG/\u001f\u0006\u00037!\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003;a\u00111BU8mKN+'O^5dK\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0006uK\u0006l7+\u001a:wS\u000e,\u0007CA\u0011%\u001b\u0005\u0011#BA\u0012\u0007\u0003\u001d\u0019XM\u001d<jG\u0016L!!\n\u0012\u0003\u0017Q+\u0017-\\*feZL7-\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005\u0011Ro]3s!J|g-\u001b7f'\u0016\u0014h/[2f!\t\t\u0013&\u0003\u0002+E\t\u0011Rk]3s!J|g-\u001b7f'\u0016\u0014h/[2f\u0011!a\u0003A!A!\u0002\u0013i\u0013!\u00069sS:\u001c\u0017\u000e]1m\u0013:4wNU3t_24XM\u001d\t\u0003C9J!a\f\u0012\u0003+A\u0013\u0018N\\2ja\u0006d\u0017J\u001c4p%\u0016\u001cx\u000e\u001c<fe\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"RaM\u001b7oa\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQ!\u0006\u0019A\u0002YAQa\b\u0019A\u0002\u0001BQa\n\u0019A\u0002!BQ\u0001\f\u0019A\u00025B#\u0001\r\u001e\u0011\u0005m2U\"\u0001\u001f\u000b\u0005ur\u0014AC1o]>$\u0018\r^5p]*\u0011q\bQ\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\t%)A\u0003cK\u0006t7O\u0003\u0002D\t\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001F\u0003\ry'oZ\u0005\u0003\u000fr\u0012\u0011\"Q;u_^L'/\u001a3\t\u000b%\u0003A\u0011\u0001&\u0002#I,7o\u001c7wKJ+7-\u001b9jK:$8\u000f\u0006\u0004L3\u00124\u0007\u000e\u001d\t\u0004\u0019N3fBA'R!\tq\u0005#D\u0001P\u0015\t\u0001F\"\u0001\u0004=e>|GOP\u0005\u0003%B\ta\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\r\u0019V\r\u001e\u0006\u0003%B\u0001\"\u0001T,\n\u0005a+&AB*ue&tw\rC\u0003[\u0011\u0002\u00071,A\u0003s_2,7\u000fE\u0002]CZs!!X0\u000f\u00059s\u0016\"A\t\n\u0005\u0001\u0004\u0012a\u00029bG.\fw-Z\u0005\u0003E\u000e\u0014A\u0001T5ti*\u0011\u0001\r\u0005\u0005\u0006K\"\u0003\raW\u0001\fO2|'-\u00197S_2,7\u000fC\u0003h\u0011\u0002\u00071,A\u0003vg\u0016\u00148\u000fC\u0003j\u0011\u0002\u0007!.\u0001\u0005qY\u0006t\u0017\n^3n!\tYg.D\u0001m\u0015\tig!\u0001\u0004e_6\f\u0017N\\\u0005\u0003_2\u0014\u0001\u0002\u00157b]&#X-\u001c\u0005\bc\"\u0003\n\u00111\u0001s\u00035)\u0007p\u00197vI\u0016\fU\u000f\u001e5peB\u0011qb]\u0005\u0003iB\u0011qAQ8pY\u0016\fg\u000eC\u0003w\u0001\u0011%q/\u0001\u0006qCJ\u001cXMU8mKN$Ba\u0013=\u007f\u007f\")\u00110\u001ea\u0001u\u0006Y\u0011m]:jO:lWM\u001c;t!\ra\u0016m\u001f\t\u0003/qL!! \r\u0003\tI{G.\u001a\u0005\u00065V\u0004\ra\u0017\u0005\u0006SV\u0004\rA\u001b\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u00039\u0001\u0018M]:f)\u0006\u001c8NU8mKN$raSA\u0004\u0003#\t\u0019\u0002\u0003\u0005\u0002\n\u0005\u0005\u0001\u0019AA\u0006\u0003\u0011!\u0018m]6\u0011\u0007-\fi!C\u0002\u0002\u00101\u0014A\u0001V1tW\"1!,!\u0001A\u0002mCa!_A\u0001\u0001\u0004Q\bbBA\f\u0001\u0011%\u0011\u0011D\u0001\u0012a\u0006\u00148/\u001a*fY\u0016\f7/\u001a*pY\u0016\u001cHcB&\u0002\u001c\u0005\u0015\u0012q\u0005\u0005\t\u0003;\t)\u00021\u0001\u0002 \u00059!/\u001a7fCN,\u0007cA6\u0002\"%\u0019\u00111\u00057\u0003\u000fI+G.Z1tK\"1!,!\u0006A\u0002mCa!_A\u000b\u0001\u0004Q\bbBA\u0016\u0001\u0011%\u0011QF\u0001\u0012O\u0016$(+\u001a7fCN,W*Z7cKJ\u001cHCBA\u0018\u0003k\t9\u0004\u0005\u0003\u0010\u0003cY\u0015bAA\u001a!\t1q\n\u001d;j_:D\u0001\"!\b\u0002*\u0001\u0007\u0011q\u0004\u0005\u0007s\u0006%\u0002\u0019\u0001>\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005\u0001\u0002/\u0019:tK\u001ecwNY1m%>dWm\u001d\u000b\u00067\u0006}\u0012\u0011\t\u0005\u0007s\u0006e\u0002\u0019\u0001>\t\r\u0015\fI\u00041\u0001\\\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000f\nQbZ3u\u00032dW*Z7cKJ\u001cH#B&\u0002J\u0005M\u0003\u0002CA&\u0003\u0007\u0002\r!!\u0014\u0002\tQ,\u0017-\u001c\t\u0004W\u0006=\u0013bAA)Y\n!A+Z1n\u0011\u0019I\u00181\ta\u0001u\"I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011L\u0001\u001ce\u0016\u001cx\u000e\u001c<f%\u0016\u001c\u0017\u000e]5f]R\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005m#f\u0001:\u0002^-\u0012\u0011q\f\t\u0005\u0003C\nI'\u0004\u0002\u0002d)!\u0011QMA4\u0003%)hn\u00195fG.,GM\u0003\u0002>!%!\u00111NA2\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005U$)\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!\u001f\u0002t\t91+\u001a:wS\u000e,\u0007")
public class EmailRecipientResolver {
    private final RoleService roleService;
    private final TeamService teamService;
    private final UserProfileService userProfileService;
    private final PrincipalInfoResolver principalInfoResolver;

    public Set<String> resolveRecipients(List<String> roles, List<String> globalRoles, List<String> users, PlanItem planItem, boolean excludeAuthor) {
        List assignments = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.readRoleAssignments()).asScala()).toList();
        Set allPrincipals = (Set)this.parseRoles((List<Role>)assignments, roles, planItem).$plus$plus(this.parseGlobalRoles((List<Role>)assignments, globalRoles)).$plus$plus(users).$minus$minus((GenTraversableOnce)(excludeAuthor ? Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{User.AUTHENTICATED_USER.getName()})) : Nil$.MODULE$));
        return (Set)((TraversableLike)allPrincipals.map((Function1 & Serializable & scala.Serializable)x$1 -> $this.principalInfoResolver.getNotificationEmailOf(x$1), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$2(x$1)));
    }

    public boolean resolveRecipients$default$5() {
        return false;
    }

    private Set<String> parseRoles(List<Role> assignments, List<String> roles, PlanItem planItem) {
        Set<String> set;
        PlanItem planItem2 = planItem;
        if (planItem2 instanceof Task) {
            Task task = (Task)planItem2;
            set = this.parseTaskRoles(task, roles, assignments);
        } else if (planItem2 instanceof Release) {
            Release release = (Release)planItem2;
            set = this.parseReleaseRoles(release, roles, assignments);
        } else {
            throw new MatchError((Object)planItem2);
        }
        return set;
    }

    private Set<String> parseTaskRoles(Task task, List<String> roles, List<Role> assignments) {
        ObjectRef parsed;
        block3: {
            parsed = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
            boolean shouldSendToTaskOwner = roles.contains((Object)"Task Owner");
            Option taskOwner = Option$.MODULE$.apply((Object)task.getOwner());
            if (shouldSendToTaskOwner && taskOwner.isDefined()) {
                parsed.elem = (Set)((Set)parsed.elem).$plus(taskOwner.get());
            }
            if (roles.contains((Object)"Task Team") || shouldSendToTaskOwner && taskOwner.isEmpty()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.teamService.findTeamByName(Ids.releaseIdFrom((String)task.getId()), task.getTeam()))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    parsed.elem = (Set)((Set)parsed.elem).$plus$plus(this.getAllMembers(x$3, (List<Role>)assignments));
                    return BoxedUnit.UNIT;
                });
            }
            if (roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) {
                parsed.elem = (Set)((Set)parsed.elem).$plus$plus((GenTraversableOnce)this.getReleaseMembers(task.getRelease(), assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            }
            if (!roles.contains((Object)"Watcher")) break block3;
            Set<String> watchers = package$.MODULE$.TaskWithNotificationFields(task).getWatchers();
            watchers.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                parsed.elem = (Set)((Set)parsed.elem).$plus((Object)x$4);
                return BoxedUnit.UNIT;
            });
        }
        return (Set)parsed.elem;
    }

    private Set<String> parseReleaseRoles(Release release, List<String> roles, List<Role> assignments) {
        Set parsed;
        block0: {
            parsed = Predef$.MODULE$.Set().empty();
            if (!roles.contains((Object)RecipientSettings.RELEASE_ADMIN_ROLE_NAME)) break block0;
            parsed = (Set)parsed.$plus$plus((GenTraversableOnce)this.getReleaseMembers(release, assignments).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
        }
        return parsed;
    }

    private Option<Set<String>> getReleaseMembers(Release release, List<Role> assignments) {
        Option effectiveTeams = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(release)).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getReleaseMembers$1(x$5)));
        return effectiveTeams.map((Function1 & Serializable & scala.Serializable)x$6 -> this.getAllMembers((Team)x$6, assignments));
    }

    private List<String> parseGlobalRoles(List<Role> assignments, List<String> globalRoles) {
        List<String> list = globalRoles;
        Object object = Nil$.MODULE$.equals(list) ? Nil$.MODULE$ : (List)((List)assignments.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)globalRoles.contains((Object)r.getName())))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getPrincipals()).asScala()).toList(), List$.MODULE$.canBuildFrom());
        return object;
    }

    private Set<String> getAllMembers(Team team, List<Role> assignments) {
        Set teamMembers = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getMembers()).asScala()).toSet();
        List roleMembers = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(team.getRoles()).asScala()).toList().flatMap((Function1 & Serializable & scala.Serializable)roleName -> (List)assignments.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$getAllMembers$2(roleName, x$8))).toList().flatMap((Function1 & Serializable & scala.Serializable)role -> (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(role.getPrincipals()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)principal -> {
            $this.userProfileService.discover(principal);
            return principal;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        return (Set)teamMembers.$plus$plus((GenTraversableOnce)roleMembers);
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$resolveRecipients$2(String x$1) {
        return Option$.MODULE$.apply((Object)x$1).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EmailRecipientResolver.$anonfun$resolveRecipients$3(x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$getReleaseMembers$1(Team x$5) {
        String string = x$5.getTeamName();
        String string2 = "Release Admin";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAllMembers$2(String roleName$1, Role x$8) {
        String string = x$8.getName();
        String string2 = roleName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Autowired
    public EmailRecipientResolver(RoleService roleService, TeamService teamService, UserProfileService userProfileService, PrincipalInfoResolver principalInfoResolver) {
        this.roleService = roleService;
        this.teamService = teamService;
        this.userProfileService = userProfileService;
        this.principalInfoResolver = principalInfoResolver;
    }
}

