/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.domain.events.RevisionDeletedEvent;
import com.xebialabs.xlrelease.versioning.templates.domain.events.VersionCreatedEvent;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u001dc\u0001B\u0001\u0003\u00015\u0011\u0001\u0004\u00122UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0005uK6\u0004H.\u0019;fg*\u0011QAB\u0001\u000bm\u0016\u00148/[8oS:<'BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0017)\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dKB\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0006g24GG\u001b\u0006\u0002;\u0005AqM]5{u2,G-\u0003\u0002 5\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u00025Q,W\u000e\u001d7bi\u0016\u0014VM^5tS>t'+\u001a9pg&$xN]=\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\u0012\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0005\n\u0002\u001b)\u0016l\u0007\u000f\\1uKJ+g/[:j_:\u0014V\r]8tSR|'/\u001f\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005qB/Z7qY\u0006$XMU3wSNLwN\u001c#bi\u0006\u0014V\r]8tSR|'/\u001f\t\u0003G-J!\u0001\f\u0013\u0003=Q+W\u000e\u001d7bi\u0016\u0014VM^5tS>tG)\u0019;b%\u0016\u0004xn]5u_JL\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\u0002=I,G.Z1tKZ+'o]5p]&twmU3sS\u0006d\u0017N_1uS>t\u0007CA\u000b1\u0013\t\t$A\u0001\u0010SK2,\u0017m]3WKJ\u001c\u0018n\u001c8j]\u001e\u001cVM]5bY&T\u0018\r^5p]\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]2\u0011aB:feZL7-Z\u0005\u0003sY\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW\r\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0003E\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0003{}j\u0011A\u0010\u0006\u0003K\u0019I!\u0001\u0011 \u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0003-!\u0018m]6TKJ4\u0018nY3\u0011\u0005U\"\u0015BA#7\u0005-!\u0016m]6TKJ4\u0018nY3\t\u0011\u001d\u0003!\u0011!Q\u0001\n!\u000b1\u0002^3b[N+'O^5dKB\u0011Q'S\u0005\u0003\u0015Z\u00121\u0002V3b[N+'O^5dK\"AA\n\u0001B\u0001B\u0003%Q*\u0001\rsKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016\u0004\"AT*\u000e\u0003=S!\u0001U)\u0002\u000fU\u0004xM]1eK*\u0011!\u000bC\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017B\u0001+P\u0005a\u0011V\r]8tSR|'/\u001f,feNLwN\\*feZL7-\u001a\u0005\t-\u0002\u0011\t\u0011)A\u0005/\u0006AQM^3oi\n+8\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[\r\u00051QM^3oiNL!\u0001X-\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0003a!W\r]3oI\u0016t7-\u001f+be\u001e,GOU3t_24XM\u001d\t\u0003{\u0001L!!\u0019 \u00031\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010V1sO\u0016$(+Z:pYZ,'\u000fC\u0003d\u0001\u0011\u0005A-\u0001\u0004=S:LGO\u0010\u000b\fK\u001a<\u0007.\u001b6lY6tw\u000e\u0005\u0002\u0016\u0001!)\u0011E\u0019a\u0001E!)\u0011F\u0019a\u0001U!)aF\u0019a\u0001_!)1G\u0019a\u0001i!)1H\u0019a\u0001y!)!I\u0019a\u0001\u0007\")qI\u0019a\u0001\u0011\")AJ\u0019a\u0001\u001b\")aK\u0019a\u0001/\")aL\u0019a\u0001?\"\u0012!-\u001d\t\u0003evl\u0011a\u001d\u0006\u0003iV\f!\"\u00198o_R\fG/[8o\u0015\t1x/A\u0004gC\u000e$xN]=\u000b\u0005aL\u0018!\u00022fC:\u001c(B\u0001>|\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001?\u0002\u0007=\u0014x-\u0003\u0002\u007fg\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u00031\u0019\u0018M^3SKZL7/[8o)!\t)!a\u0003\u0002\u001c\u0005U\u0002cA\b\u0002\b%\u0019\u0011\u0011\u0002\t\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001by\b\u0019AA\b\u0003!!X-\u001c9mCR,\u0007\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Ua!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u00033\t\u0019BA\u0004SK2,\u0017m]3\t\u000f\u0005uq\u00101\u0001\u0002 \u0005!Qo]3s!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0004\u0003K\u0001RBAA\u0014\u0015\r\tI\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[\u0001\u0002bBA\u001c\u007f\u0002\u0007\u0011qD\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\tY\u0004\u0001C!\u0003{\t1b]1wKZ+'o]5p]RQ\u0011qHA)\u0003+\n9&a\u0017\u0011\r\u0005\u0005\u0013qIA&\u001b\t\t\u0019EC\u0002\u0002FA\tA!\u001e;jY&!\u0011\u0011JA\"\u0005\r!&/\u001f\t\u0004\u001f\u00055\u0013bAA(!\t\u0019\u0011J\u001c;\t\u0011\u0005M\u0013\u0011\ba\u0001\u0003?\t!\u0002^3na2\fG/Z%e\u0011!\ti\"!\u000fA\u0002\u0005}\u0001\u0002CA-\u0003s\u0001\r!a\b\u0002\u0017Y,'o]5p]:\u000bW.\u001a\u0005\t\u0003o\tI\u00041\u0001\u0002 !9\u0011q\f\u0001\u0005\n\u0005\u0005\u0014AD2sK\u0006$XMU3wSNLwN\u001c\u000b\u000b\u0003G\n\u0019(!\u001e\u0002x\u0005m\u0004\u0003BA3\u0003_j!!a\u001a\u000b\t\u0005%\u00141N\u0001\u0005I\u0006$\u0018MC\u0002\u0002n\u0011\n1\u0002]3sg&\u001cH/\u001a8dK&!\u0011\u0011OA4\u0005A!V-\u001c9mCR,'+\u001a<jg&|g\u000e\u0003\u0005\u0002\u000e\u0005u\u0003\u0019AA\b\u0011!\ti\"!\u0018A\u0002\u0005}\u0001\u0002CA=\u0003;\u0002\r!a\b\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u000b\u0003{\ni\u0006%AA\u0002\u0005}\u0011a\u0002<feNLwN\u001c\u0005\b\u0003\u0003\u0003A\u0011IAB\u0003\u001d\u0011Xm\u001d;pe\u0016$b!a\u0004\u0002\u0006\u0006\u001d\u0005\u0002CA*\u0003\u007f\u0002\r!a\b\t\u0011\u0005%\u0015q\u0010a\u0001\u0003\u0017\n!B]3wSNLwN\\%e\u0011\u001d\ti\t\u0001C!\u0003\u001f\u000bA\u0001\\8bIR1\u0011qBAI\u0003'C\u0001\"!#\u0002\f\u0002\u0007\u00111\n\u0005\t\u0003+\u000bY\t1\u0001\u0002\u0018\u000691m\u001c8uKb$\b\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\u0005\u0005\u00161U\u0001\ta2,XNY5oO*\u0019\u0011Q\u0015\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRLA!!+\u0002\u001c\n\t\"+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\u00055\u0006\u0001\"\u0011\u00020\u0006qA-\u001a7fi\u0016\u0014VM^5tS>tGCBA\u0003\u0003c\u000b\u0019\f\u0003\u0005\u0002T\u0005-\u0006\u0019AA\u0010\u0011!\tI)a+A\u0002\u0005-\u0003bBA\\\u0001\u0011\u0005\u0013\u0011X\u0001\u0010I\u0016dW\r^3SKZL7/[8ogR1\u0011QAA^\u0003{C\u0001\"a\u0015\u00026\u0002\u0007\u0011q\u0004\u0005\t\u0003\u007f\u000b)\f1\u0001\u0002B\u0006Y!/\u001a<jg&|g.\u00133t!\u0019\t\u0019-!4\u0002L9!\u0011QYAe\u001d\u0011\t)#a2\n\u0003EI1!a3\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a4\u0002R\n\u00191+Z9\u000b\u0007\u0005-\u0007\u0003C\u0004\u0002V\u0002!I!a6\u0002/A\u0014xnY3tgJ+7\u000f^8sK\u0012$V-\u001c9mCR,GCBA\u0003\u00033\fi\u000e\u0003\u0005\u0002\\\u0006M\u0007\u0019AA\b\u0003A\u0011Xm\u001d;pe\u0016$G+Z7qY\u0006$X\r\u0003\u0005\u0002`\u0006M\u0007\u0019AA\b\u0003=\u0019WO\u001d:f]R$V-\u001c9mCR,\u0007bBAr\u0001\u0011%\u0011Q]\u0001\u0014aJ|7-Z:t\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003\u001f\t9\u000f\u0003\u0005\u0002\\\u0006\u0005\b\u0019AA\b\u0011\u001d\tY\u000f\u0001C\u0005\u0003[\f\u0011\u0003\\8bI2\u000bG/Z:u-\u0016\u00148/[8o)\u0011\ty/!>\u0011\u000b=\t\t0a\u0004\n\u0007\u0005M\bC\u0001\u0004PaRLwN\u001c\u0005\t\u0003'\nI\u000f1\u0001\u0002 !9\u0011\u0011 \u0001\u0005\n\u0005m\u0018A\u0003=meZ+'o]5p]V\u0011\u0011q\u0004\u0005\n\u0003\u007f\u0004\u0011\u0013!C\u0005\u0005\u0003\t\u0001d\u0019:fCR,'+\u001a<jg&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019A\u000b\u0003\u0002 \t\u00151F\u0001B\u0004!\u0011\u0011IA!\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Q\u0004\u0012\u0002\u0002B\n\u0005\u0017\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2fQ\r\u0001!q\u0003\t\u0005\u00053\u00119#\u0004\u0002\u0003\u001c)!!Q\u0004B\u0010\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\t\t\u0005\"1E\u0001\u0004gFd'b\u0001B\u0013\r\u0005\u0011AMY\u0005\u0005\u0005S\u0011YBA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001!Q\u0006\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019AOa\r\u000b\u0007\u0005U\u00150\u0003\u0003\u00038\tE\"a\u0002)sS6\f'/\u001f\u0015\u0004\u0001\tm\u0002\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\u0007\t\u0005\u00130\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0012\u0003@\t91+\u001a:wS\u000e,\u0007")
public class DbTemplateStorageService
implements TemplateStorageService,
Logging {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DbTemplateStorageService dbTemplateStorageService = this;
        synchronized (dbTemplateStorageService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public void saveRevision(Release template, String user, String message) {
        this.createRevision(template, user, message, this.createRevision$default$4());
    }

    @Override
    public Try<Object> saveVersion(String templateId, String user, String versionName, String message) {
        Release template = this.releaseService.findById(templateId);
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            TemplateRevision version = this.createRevision(template, user, message, versionName);
            $this.templateRevisionRepository.deleteRevisionsForVersion(version);
            $this.eventBus.publish((XLReleaseEvent)new VersionCreatedEvent(templateId, versionName));
            return version.id();
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DbTemplateStorageService $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    this.$outer.logger().error((Function0 & Serializable & scala.Serializable)() -> "Unable to create new template version", (Function0 & Serializable & scala.Serializable)() -> exception);
                    object = new Failure((Throwable)exception);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private TemplateRevision createRevision(Release template, String user, String description, String version) {
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(version != null ? TemplateRevisionType$.MODULE$.VERSION() : TemplateRevisionType$.MODULE$.REVISION());
        templateRevision.version_$eq(version);
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    private String createRevision$default$4() {
        return null;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        Release currentTemplate = this.releaseService.findById(templateId);
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        Release previousTemplate = this.load(revisionId, context);
        this.processRestoredTemplate(previousTemplate, currentTemplate);
        Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
        this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId, ResolutionContext context) {
        Release release;
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion(), context);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading ", ", see logs for more details"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            Release template = (Release)some2.value();
            release = this.processDependencies(template);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Revision id ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
            }
            throw new MatchError(option);
        }
        Release release2 = release;
        return release2;
    }

    @Override
    public void deleteRevision(String templateId, int revisionId) {
        this.templateRevisionRepository.deleteRevisions(templateId, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{revisionId}))));
        this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId, revisionId));
    }

    @Override
    public void deleteRevisions(String templateId, Seq<Object> revisionIds) {
        this.templateRevisionRepository.deleteRevisions(templateId, revisionIds);
        revisionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> $this.eventBus.publish((XLReleaseEvent)new RevisionDeletedEvent(templateId, id)));
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setRunningTriggeredReleasesCount(currentTemplate.getRunningTriggeredReleasesCount());
        this.processDependencies(restoredTemplate);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private Option<Release> loadLatestVersion(String templateId) {
        ResolutionContext context = Ids.isInFolder((String)templateId) ? ResolutionContext$.MODULE$.apply(Ids.getParentId((String)templateId)) : ResolutionContext$.MODULE$.GLOBAL();
        return this.templateRevisionRepository.latestVersion(templateId).map((Function1 & Serializable & scala.Serializable)template -> this.load(template.id(), context));
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        return version == null ? "0.0.0" : version.getVersion();
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, TaskService taskService, TeamService teamService, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        Logging.$init$((Logging)this);
    }
}

