/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.ARecord;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.AsyncDnsResolver$SrvType$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B\u0001\u0003\u0005\u0019Q!\u0001E!ts:\u001cGI\\:SKN|GN^3s\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002e]NT!a\u0002\u0005\u0002\u0005%|'\"A\u0005\u0002\t\u0005\\7.Y\n\u0005\u0001-\tr\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0003%Ui\u0011a\u0005\u0006\u0003)!\tQ!Y2u_JL!AF\n\u0003\u000b\u0005\u001bGo\u001c:\u0011\u0005IA\u0012BA\r\u0014\u00051\t5\r^8s\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013i\u0012\u0001C:fiRLgnZ:\u0004\u0001A\u0011adH\u0007\u0002\t%\u0011\u0001\u0005\u0002\u0002\f\t:\u001c8+\u001a;uS:<7\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0019\u0017m\u00195f!\t!S%D\u0001\u0003\u0013\t1#AA\u0007Bgft7\r\u00128t\u0007\u0006\u001c\u0007.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005i1\r\\5f]R4\u0015m\u0019;pef\u0004R\u0001\u0004\u0016-_\rK!aK\u0007\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\n.\u0013\tq3CA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z!\r\u0001\u0004h\u000f\b\u0003cYr!AM\u001b\u000e\u0003MR!\u0001\u000e\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011BA\u001c\u000e\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\t1K7\u000f\u001e\u0006\u0003o5\u0001\"\u0001P!\u000e\u0003uR!AP \u0002\u00079,GOC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$!E%oKR\u001cvnY6fi\u0006#GM]3tgB\u0019\u0001\u0007\u000f#\u0011\u0005I)\u0015B\u0001$\u0014\u0005!\t5\r^8s%\u00164\u0007\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005C\u0001\u0013\u0001\u0011\u0015Yr\t1\u0001\u001e\u0011\u0015\u0011s\t1\u0001$\u0011\u0015As\t1\u0001*\u0011\u001dy\u0005A1A\u0005\u0004A\u000b!!Z2\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002W'\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\t\ra\u0003\u0001\u0015!\u0003R\u0003\r)7\r\t\u0005\b5\u0002\u0011\r\u0011b\u0001\\\u0003\u001d!\u0018.\\3pkR,\u0012\u0001\u0018\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\"\tA!\u001e;jY&\u0011\u0011M\u0018\u0002\b)&lWm\\;u\u0011\u0019\u0019\u0007\u0001)A\u00059\u0006AA/[7f_V$\b\u0005C\u0004f\u0001\t\u0007I\u0011\u00014\u0002\u00179\fW.Z*feZ,'o]\u000b\u0002_!1\u0001\u000e\u0001Q\u0001\n=\nAB\\1nKN+'O^3sg\u0002BqA\u001b\u0001A\u0002\u0013%1.A\u0005sKF,Xm\u001d;JIV\tA\u000e\u0005\u0002\r[&\u0011a.\u0004\u0002\u0006'\"|'\u000f\u001e\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u00035\u0011X-];fgRLEm\u0018\u0013fcR\u0011!/\u001e\t\u0003\u0019ML!\u0001^\u0007\u0003\tUs\u0017\u000e\u001e\u0005\bm>\f\t\u00111\u0001m\u0003\rAH%\r\u0005\u0007q\u0002\u0001\u000b\u0015\u00027\u0002\u0015I,\u0017/^3ti&#\u0007\u0005C\u0003{\u0001\u0011%10\u0001\u0004oKb$\u0018\n\u001a\u000b\u0002Y\"9Q\u0010\u0001b\u0001\n\u0013q\u0018!\u0003:fg>dg/\u001a:t+\u0005\u0019\u0005bBA\u0001\u0001\u0001\u0006IaQ\u0001\u000be\u0016\u001cx\u000e\u001c<feN\u0004\u0003bBA\u0003\u0001\u0011\u0005\u0013qA\u0001\be\u0016\u001cW-\u001b<f+\t\tI\u0001\u0005\u0003\u0002\f\u00055Q\"\u0001\u0001\n\u0007\u0005=QCA\u0004SK\u000e,\u0017N^3\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016\u00059!/Z:pYZ,G\u0003CA\f\u0003W\ty$a\u0016\u0011\u000bI\u000bI\"!\b\n\u0007\u0005m1K\u0001\u0004GkR,(/\u001a\t\u0005\u0003?\t)CD\u0002\u001f\u0003CI1!a\t\u0005\u0003-!en\u001d)s_R|7m\u001c7\n\t\u0005\u001d\u0012\u0011\u0006\u0002\t%\u0016\u001cx\u000e\u001c<fI*\u0019\u00111\u0005\u0003\t\u0011\u00055\u0012\u0011\u0003a\u0001\u0003_\tAA\\1nKB!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$!\u000e\u0011\u0005Ij\u0011bAA\u001c\u001b\u00051\u0001K]3eK\u001aLA!a\u000f\u0002>\t11\u000b\u001e:j]\u001eT1!a\u000e\u000e\u0011!\t\t%!\u0005A\u0002\u0005\r\u0013a\u0003:fcV,7\u000f\u001e+za\u0016\u0004B!!\u0012\u0002T9!\u0011qIA\u0011\u001d\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0004e\u00055\u0013\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\u0011\t)&!\u000b\u0003\u0017I+\u0017/^3tiRK\b/\u001a\u0005\u0007{\u0006E\u0001\u0019A\"\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^\u0005a1/\u001a8e#V,7\u000f^5p]R1\u0011qLA:\u0003o\u0002RAUA\r\u0003C\u0002B!a\u0019\u0002n9!\u0011QMA5\u001d\u0011\t9%a\u001a\n\u0005\r!\u0011bAA6\u0005\u0005IAI\\:DY&,g\u000e^\u0005\u0005\u0003_\n\tH\u0001\u0004B]N<XM\u001d\u0006\u0004\u0003W\u0012\u0001bBA;\u00033\u0002\r\u0001R\u0001\te\u0016\u001cx\u000e\u001c<fe\"A\u0011\u0011PA-\u0001\u0004\tY(A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005\r\u0014QP\u0005\u0005\u0003\u007f\n\tHA\u0006E]N\fV/Z:uS>t\u0007bBA\n\u0001\u0011%\u00111\u0011\u000b\t\u0003/\t))a\"\u0002\n\"A\u0011QFAA\u0001\u0004\ty\u0003\u0003\u0005\u0002B\u0005\u0005\u0005\u0019AA\"\u0011\u001d\t)(!!A\u0002\u0011C3\u0001AAG!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0015\u0011\u0013\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018n\u0002\u0005\u0002\u001c\nA\tABAO\u0003A\t5/\u001f8d\t:\u001c(+Z:pYZ,'\u000fE\u0002%\u0003?3q!\u0001\u0002\t\u0002\u0019\t\tkE\u0002\u0002 .Aq\u0001SAP\t\u0003\t)\u000b\u0006\u0002\u0002\u001e\"Q\u0011\u0011VAP\u0005\u0004%I!a+\u0002\u0017%\u0004h\u000fN!eIJ,7o]\u000b\u0003\u0003[\u0003B!a,\u000286\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\tyV\"\u0003\u0003\u0002:\u0006E&!\u0002*fO\u0016D\b\"CA_\u0003?\u0003\u000b\u0011BAW\u00031I\u0007O\u001e\u001bBI\u0012\u0014Xm]:!\u0011)\t\t-a(C\u0002\u0013%\u00111V\u0001\fSB4h'\u00113ee\u0016\u001c8\u000fC\u0005\u0002F\u0006}\u0005\u0015!\u0003\u0002.\u0006a\u0011\u000e\u001d<7\u0003\u0012$'/Z:tA!A\u0011\u0011ZAP\t\u0013\tY-A\u0007jg&sW\r^!eIJ,7o\u001d\u000b\u0005\u0003\u001b\f\u0019\u000eE\u0002\r\u0003\u001fL1!!5\u000e\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\f\u0002H\u0002\u0007\u0011q\u0006\u0005\u000b\u0003/\fyJ1A\u0005\n\u0005e\u0017!B#naRLXCAA0\u0011%\ti.a(!\u0002\u0013\ty&\u0001\u0004F[B$\u0018\u0010\t\u0004\u000b\u0003C\fy\n%A\u0012\"\u0005\r(!C)vKJLH+\u001f9f'\r\tynC\u0015\t\u0003?\f9Oa\u0018\u0003\u0004\u001aA\u0011\u0011^AP\u0011\u000b\u000bYO\u0001\u0005JaZ$D+\u001f9f'%\t9oCAw\u0003c\f9\u0010\u0005\u0003\u0002p\u0006}WBAAP!\ra\u00111_\u0005\u0004\u0003kl!a\u0002)s_\u0012,8\r\u001e\t\u0004\u0019\u0005e\u0018bAA~\u001b\ta1+\u001a:jC2L'0\u00192mK\"9\u0001*a:\u0005\u0002\u0005}HC\u0001B\u0001!\u0011\ty/a:\t\u0015\t\u0015\u0011q]A\u0001\n\u0003\u00129!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001fy\u0014\u0001\u00027b]\u001eLA!a\u000f\u0003\u000e!Q!QCAt\u0003\u0003%\tAa\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\te\u0001c\u0001\u0007\u0003\u001c%\u0019!QD\u0007\u0003\u0007%sG\u000f\u0003\u0006\u0003\"\u0005\u001d\u0018\u0011!C\u0001\u0005G\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003&\t-\u0002c\u0001\u0007\u0003(%\u0019!\u0011F\u0007\u0003\u0007\u0005s\u0017\u0010C\u0005w\u0005?\t\t\u00111\u0001\u0003\u001a!Q!qFAt\u0003\u0003%\tE!\r\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\r\u0011\r\tU\"1\bB\u0013\u001b\t\u00119DC\u0002\u0003:5\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iDa\u000e\u0003\u0011%#XM]1u_JD!B!\u0011\u0002h\u0006\u0005I\u0011\u0001B\"\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAg\u0005\u000bB\u0011B\u001eB \u0003\u0003\u0005\rA!\n\t\u0015\t%\u0013q]A\u0001\n\u0003\u0012Y%\u0001\u0005iCND7i\u001c3f)\t\u0011I\u0002\u0003\u0006\u0003P\u0005\u001d\u0018\u0011!C!\u0005#\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013A!B!\u0016\u0002h\u0006\u0005I\u0011\u0002B,\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\te\u0003\u0003\u0002B\u0006\u00057JAA!\u0018\u0003\u000e\t1qJ\u00196fGR4\u0001B!\u0019\u0002 \"\u0015%1\r\u0002\t\u0013B4h\u0007V=qKNI!qL\u0006\u0002n\u0006E\u0018q\u001f\u0005\b\u0011\n}C\u0011\u0001B4)\t\u0011I\u0007\u0005\u0003\u0002p\n}\u0003B\u0003B\u0003\u0005?\n\t\u0011\"\u0011\u0003\b!Q!Q\u0003B0\u0003\u0003%\tAa\u0006\t\u0015\t\u0005\"qLA\u0001\n\u0003\u0011\t\b\u0006\u0003\u0003&\tM\u0004\"\u0003<\u0003p\u0005\u0005\t\u0019\u0001B\r\u0011)\u0011yCa\u0018\u0002\u0002\u0013\u0005#\u0011\u0007\u0005\u000b\u0005\u0003\u0012y&!A\u0005\u0002\teD\u0003BAg\u0005wB\u0011B\u001eB<\u0003\u0003\u0005\rA!\n\t\u0015\t%#qLA\u0001\n\u0003\u0012Y\u0005\u0003\u0006\u0003P\t}\u0013\u0011!C!\u0005#B!B!\u0016\u0003`\u0005\u0005I\u0011\u0002B,\r!\u0011))a(\t\u0006\n\u001d%aB*smRK\b/Z\n\n\u0005\u0007[\u0011Q^Ay\u0003oDq\u0001\u0013BB\t\u0003\u0011Y\t\u0006\u0002\u0003\u000eB!\u0011q\u001eBB\u0011)\u0011)Aa!\u0002\u0002\u0013\u0005#q\u0001\u0005\u000b\u0005+\u0011\u0019)!A\u0005\u0002\t]\u0001B\u0003B\u0011\u0005\u0007\u000b\t\u0011\"\u0001\u0003\u0016R!!Q\u0005BL\u0011%1(1SA\u0001\u0002\u0004\u0011I\u0002\u0003\u0006\u00030\t\r\u0015\u0011!C!\u0005cA!B!\u0011\u0003\u0004\u0006\u0005I\u0011\u0001BO)\u0011\tiMa(\t\u0013Y\u0014Y*!AA\u0002\t\u0015\u0002B\u0003B%\u0005\u0007\u000b\t\u0011\"\u0011\u0003L!Q!q\nBB\u0003\u0003%\tE!\u0015\t\u0015\tU#1QA\u0001\n\u0013\u00119f\u0002\u0005\u0003*\u0006}\u0005R\u0011B\u0001\u0003!I\u0005O\u001e\u001bUsB,w\u0001\u0003BW\u0003?C)I!\u001b\u0002\u0011%\u0003hO\u000e+za\u0016<\u0001B!-\u0002 \"\u0015%QR\u0001\b'J4H+\u001f9f\r\u001d\u0011),a(A\u0005o\u0013aCU3t_24XMR1jY\u0016$W\t_2faRLwN\\\n\t\u0005g\u0013I,!=\u0002xB\u0019\u0001Ga/\n\u0007\tu&HA\u0005Fq\u000e,\u0007\u000f^5p]\"Y!\u0011\u0019BZ\u0005+\u0007I\u0011\u0001Bb\u0003\ri7oZ\u000b\u0003\u0003_A1Ba2\u00034\nE\t\u0015!\u0003\u00020\u0005!Qn]4!\u0011\u001dA%1\u0017C\u0001\u0005\u0017$BA!4\u0003PB!\u0011q\u001eBZ\u0011!\u0011\tM!3A\u0002\u0005=\u0002B\u0003Bj\u0005g\u000b\t\u0011\"\u0001\u0003V\u0006!1m\u001c9z)\u0011\u0011iMa6\t\u0015\t\u0005'\u0011\u001bI\u0001\u0002\u0004\ty\u0003\u0003\u0006\u0003\\\nM\u0016\u0013!C\u0001\u0005;\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003`*\"\u0011q\u0006BqW\t\u0011\u0019\u000f\u0005\u0003\u0003f\n5XB\u0001Bt\u0015\u0011\u0011IOa;\u0002\u0013Ut7\r[3dW\u0016$'bAAJ\u001b%!!q\u001eBt\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u000b\u0011\u0019,!A\u0005B\t\u001d\u0001B\u0003B\u000b\u0005g\u000b\t\u0011\"\u0001\u0003\u0018!Q!\u0011\u0005BZ\u0003\u0003%\tAa>\u0015\t\t\u0015\"\u0011 \u0005\nm\nU\u0018\u0011!a\u0001\u00053A!Ba\f\u00034\u0006\u0005I\u0011\tB\u0019\u0011)\u0011\tEa-\u0002\u0002\u0013\u0005!q \u000b\u0005\u0003\u001b\u001c\t\u0001C\u0005w\u0005{\f\t\u00111\u0001\u0003&!Q!\u0011\nBZ\u0003\u0003%\tEa\u0013\t\u0015\r\u001d!1WA\u0001\n\u0003\u001aI!\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u001b\u001cY\u0001C\u0005w\u0007\u000b\t\t\u00111\u0001\u0003&\u001dQ1qBAP\u0003\u0003E\ta!\u0005\u0002-I+7o\u001c7wK\u001a\u000b\u0017\u000e\\3e\u000bb\u001cW\r\u001d;j_:\u0004B!a<\u0004\u0014\u0019Q!QWAP\u0003\u0003E\ta!\u0006\u0014\r\rM1qCA|!!\u0019Iba\b\u00020\t5WBAB\u000e\u0015\r\u0019i\"D\u0001\beVtG/[7f\u0013\u0011\u0019\tca\u0007\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004I\u0007'!\ta!\n\u0015\u0005\rE\u0001B\u0003B(\u0007'\t\t\u0011\"\u0012\u0003R!Q11FB\n\u0003\u0003%\ti!\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t57q\u0006\u0005\t\u0005\u0003\u001cI\u00031\u0001\u00020!Q11GB\n\u0003\u0003%\ti!\u000e\u0002\u000fUt\u0017\r\u001d9msR!1qGB\u001f!\u0015a1\u0011HA\u0018\u0013\r\u0019Y$\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0015\r}2\u0011GA\u0001\u0002\u0004\u0011i-A\u0002yIAB!B!\u0016\u0004\u0014\u0005\u0005I\u0011\u0002B,Q\u0011\ty*!$)\t\u0005e\u0015Q\u0012")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final AsyncDnsCache cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    String name = resolve2.name();
                    DnsProtocol.RequestType mode = resolve2.requestType();
                    akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolve(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ARecord record;
                InetAddress address = InetAddress.getByName(name);
                ARecord aRecord = record = new ARecord(name, Integer.MAX_VALUE, address);
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
            }));
        } else {
            Future future2;
            List<ActorRef> list = resolvers;
            if (Nil$.MODULE$.equals(list)) {
                future2 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(39).append("Timed out resolving ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ActorRef head = (ActorRef)colon2.head();
                List tail = colon2.tl$access$1();
                future2 = this.resolve(name, requestType, head).recoverWith((PartialFunction)new scala.Serializable(this, name, requestType, tail){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$2;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Future<DnsProtocol.Resolved> future;
                        A1 A1 = x2;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable t = (Throwable)option.get();
                            this.$outer.log().error(t, "Resolve failed. Trying next name server");
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply(x2);
                        }
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$2 = name$2;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.onFailure((PartialFunction)new scala.Serializable(this, resolver, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;
            private final ActorRef resolver$1;
            private final DnsClient.DnsQuestion message$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    package$.MODULE$.actorRef2Scala(this.resolver$1).$bang(new DnsClient.DropRequest(this.message$1.id()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
                this.message$1 = message$1;
            }
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            Future future2;
            Future ipv4Recs;
            Future future3;
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv4 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            if (ipv4) {
                Future future4;
                Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r2 = (DnsClient.Answer)some.value();
                    this.log().debug("Ipv4 cached {}", r2);
                    future4 = Future$.MODULE$.successful((Object)r2);
                } else if (None$.MODULE$.equals(option)) {
                    future4 = this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName));
                } else {
                    throw new MatchError(option);
                }
                future3 = future4;
            } else {
                future3 = ipv4Recs = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            if (ipv6) {
                Future future5;
                Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r3 = (DnsClient.Answer)some.value();
                    this.log().debug("Ipv6 cached {}", r3);
                    future5 = Future$.MODULE$.successful((Object)r3);
                } else if (None$.MODULE$.equals(option)) {
                    future5 = this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName));
                } else {
                    throw new MatchError(option);
                }
                future2 = future5;
            } else {
                future2 = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            Future ipv6Recs = future2;
            future = ipv4Recs.flatMap((Function1 & Serializable & scala.Serializable)ipv4Records -> {
                block0: {
                    if (!ipv4Records.rrs().nonEmpty()) break block0;
                    int minTtl4 = ((ResourceRecord)ipv4Records.rrs().minBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.ttl()), (Ordering)Ordering.Int$.MODULE$)).ttl();
                    $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$), (DnsClient.Answer)ipv4Records, minTtl4);
                }
                return ipv6Recs.map((Function1 & Serializable & scala.Serializable)ipv6Records -> {
                    block0: {
                        if (!ipv6Records.rrs().nonEmpty()) break block0;
                        int minTtl6 = ((ResourceRecord)ipv6Records.rrs().minBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.ttl()), (Ordering)Ordering.Int$.MODULE$)).ttl();
                        $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$), (DnsClient.Answer)ipv6Records, minTtl6);
                    }
                    return (Seq)ipv4Records.rrs().$plus$plus(ipv6Records.rrs(), Seq$.MODULE$.canBuildFrom());
                }, (ExecutionContext)this.ec()).map((Function1 & Serializable & scala.Serializable)recs -> DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)recs), (ExecutionContext)this.ec());
            }, (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            Future future6;
            Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$SrvType$.MODULE$));
            if (option instanceof Some) {
                Some some = (Some)option;
                DnsClient.Answer r4 = (DnsClient.Answer)some.value();
                future6 = Future$.MODULE$.successful((Object)new DnsProtocol.Resolved(name, r4.rrs(), r4.additionalRecs()));
            } else if (None$.MODULE$.equals(option)) {
                future6 = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1 & Serializable & scala.Serializable)r -> {
                    if (r.rrs().nonEmpty()) {
                        int minTtl = ((ResourceRecord)r.rrs().minBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.ttl()), (Ordering)Ordering.Int$.MODULE$)).ttl();
                        $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$SrvType$.MODULE$), (DnsClient.Answer)r, minTtl);
                    }
                    return new DnsProtocol.Resolved(name, r.rrs(), r.additionalRecs());
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(option);
            }
            future = future6;
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.log().debug("Using name servers [{}]", this.nameServers());
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static interface QueryType {
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

