/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.environments.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentFilters;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;
import com.xebialabs.xlrelease.environments.repository.EnvironmentRepository;
import com.xebialabs.xlrelease.environments.service.EnvironmentSecurity;
import com.xebialabs.xlrelease.environments.service.EnvironmentStageService;
import com.xebialabs.xlrelease.environments.service.package$;
import com.xebialabs.xlrelease.service.FolderService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011!#\u00128wSJ|g.\\3oiN+'O^5dK*\u00111\u0001B\u0001\bg\u0016\u0014h/[2f\u0015\t)a!\u0001\u0007f]ZL'o\u001c8nK:$8O\u0003\u0002\b\u0011\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u0013)\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\u0006g24GG\u001b\u0006\u00023\u0005AqM]5{u2,G-\u0003\u0002\u001c-\t9Aj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002+\u0015tg/\u001b:p]6,g\u000e\u001e*fa>\u001c\u0018\u000e^8ssB\u0011qDI\u0007\u0002A)\u0011\u0011\u0005B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0012!\u0005U)eN^5s_:lWM\u001c;SKB|7/\u001b;pefD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0014K:4\u0018N]8o[\u0016tGoU3dkJLG/\u001f\t\u0003O!j\u0011AA\u0005\u0003S\t\u00111#\u00128wSJ|g.\\3oiN+7-\u001e:jifD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\fe>dWmU3sm&\u001cW\r\u0005\u0002.e5\taF\u0003\u00020a\u0005A1/Z2ve&$\u0018P\u0003\u00022\u0011\u0005AA-\u001a9m_fLG/\u0003\u00024]\tY!k\u001c7f'\u0016\u0014h/[2f\u0011!)\u0004A!A!\u0002\u00131\u0014!\u00044pY\u0012,'oU3sm&\u001cW\r\u0005\u00028s5\t\u0001H\u0003\u0002\u0004\r%\u0011!\b\u000f\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\t\u0011q\u0002!\u0011!Q\u0001\nu\nq#\u001a8wSJ|g.\\3oiN#\u0018mZ3TKJ4\u0018nY3\u0011\u0005\u001dr\u0014BA \u0003\u0005])eN^5s_:lWM\u001c;Ti\u0006<WmU3sm&\u001cW\rC\u0003B\u0001\u0011\u0005!)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0007\u0012+ei\u0012%\u0011\u0005\u001d\u0002\u0001\"B\u000fA\u0001\u0004q\u0002\"B\u0013A\u0001\u00041\u0003\"B\u0016A\u0001\u0004a\u0003\"B\u001bA\u0001\u00041\u0004\"\u0002\u001fA\u0001\u0004i\u0004F\u0001!K!\tYe+D\u0001M\u0015\tie*\u0001\u0006b]:|G/\u0019;j_:T!a\u0014)\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011KU\u0001\u0006E\u0016\fgn\u001d\u0006\u0003'R\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002+\u0006\u0019qN]4\n\u0005]c%!C!vi><\u0018N]3e\u0011\u0015I\u0006\u0001\"\u0001[\u0003I\u0019X-\u0019:dQ\u0016sg/\u001b:p]6,g\u000e^:\u0015\u0005mS\u0007c\u0001/bG6\tQL\u0003\u0002_?\u0006!Q\u000f^5m\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\t1K7\u000f\u001e\t\u0003I\"l\u0011!\u001a\u0006\u0003\u000b\u0019T!a\u001a\u0004\u0002\r\u0011|W.Y5o\u0013\tIWMA\u0006F]ZL'o\u001c8nK:$\b\"B6Y\u0001\u0004a\u0017AE3om&\u0014xN\\7f]R4\u0015\u000e\u001c;feN\u0004\"!\u001c;\u000e\u00039T!a\u001c9\u0002\r\u0019LG\u000e^3s\u0015\t\t(/\u0001\u0002wc)\u00111OB\u0001\u0004CBL\u0017BA;o\u0005I)eN^5s_:lWM\u001c;GS2$XM]:)\u0005a;\bC\u0001=\u007f\u001b\u0005I(BA'{\u0015\tYH0A\u0004nKR\u0014\u0018nY:\u000b\u0005uT\u0011\u0001C2pI\u0006D\u0017\r\\3\n\u0005}L(!\u0002+j[\u0016$\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0014M&tG-\u00128wSJ|g.\\3oi\nK\u0018\n\u001a\u000b\u0004G\u0006\u001d\u0001\u0002CA\u0005\u0003\u0003\u0001\r!a\u0003\u0002\u001b\u0015tg/\u001b:p]6,g\u000e^%e!\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\t\u0004\u0003#\u0001RBAA\n\u0015\r\t)\u0002D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0001#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003;\tyB\u0001\u0004TiJLgn\u001a\u0006\u0004\u00033\u0001\u0002fAA\u0001o\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012!E2sK\u0006$X-\u00128wSJ|g.\\3oiR\u00191-!\u000b\t\u000f\u0005-\u00121\u0005a\u0001G\u0006YQM\u001c<je>tW.\u001a8uQ\r\t\u0019c\u001e\u0005\b\u0003c\u0001A\u0011AA\u001a\u0003E)\b\u000fZ1uK\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0004G\u0006U\u0002bBA\u0016\u0003_\u0001\ra\u0019\u0015\u0004\u0003_9\bbBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u0012I\u0016dW\r^3F]ZL'o\u001c8nK:$H\u0003BA \u0003\u000b\u00022aDA!\u0013\r\t\u0019\u0005\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002\n\u0005e\u0002\u0019AA\u0006Q\r\tId\u001e\u0005\b\u0003\u0017\u0002A\u0011BA'\u0003!1\u0018\r\\5eCR,G\u0003BA \u0003\u001fBq!a\u000b\u0002J\u0001\u00071\rC\u0004\u0002T\u0001!I!!\u0016\u0002\u001bY\fG.\u001b3bi\u0016$\u0016\u000e\u001e7f)\u0011\ty$a\u0016\t\u000f\u0005-\u0012\u0011\u000ba\u0001G\"9\u00111\f\u0001\u0005\n\u0005u\u0013a\u0005<bY&$\u0017\r^3EKN\u001c'/\u001b9uS>tG\u0003BA \u0003?Bq!a\u000b\u0002Z\u0001\u00071\rK\u0002\u0001\u0003G\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S\u0012\u0016AC:uKJ,w\u000e^=qK&!\u0011QNA4\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class EnvironmentService
implements Logging {
    private final EnvironmentRepository environmentRepository;
    private final EnvironmentSecurity environmentSecurity;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        EnvironmentService environmentService = this;
        synchronized (environmentService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public List<Environment> searchEnvironments(EnvironmentFilters environmentFilters) {
        this.environmentSecurity.checkView();
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.environmentRepository.searchEnvironments(environmentFilters, package$.MODULE$.defaultPage())).asJava();
    }

    @Timed
    public Environment findEnvironmentById(String environmentId) {
        this.environmentSecurity.checkView();
        return this.environmentRepository.findEnvironmentById(environmentId);
    }

    @Timed
    public Environment createEnvironment(Environment environment) {
        this.environmentSecurity.checkCreate();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Creating a new environment");
        this.validate(environment);
        return this.environmentRepository.createEnvironment(environment);
    }

    @Timed
    public Environment updateEnvironment(Environment environment) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating environment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environment})));
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getId()), (String)"ID is required", (Object[])new Object[0]);
        this.validate(environment);
        return this.environmentRepository.updateEnvironment(environment);
    }

    @Timed
    public void deleteEnvironment(String environmentId) {
        this.environmentSecurity.checkEdit();
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting environment [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{environmentId})));
        this.environmentRepository.deleteEnvironment(environmentId);
    }

    private void validate(Environment environment) {
        this.validateTitle(environment);
        this.validateDescription(environment);
        Checks.checkArgument((boolean)Option$.MODULE$.apply((Object)environment.getStage()).exists((Function1 & Serializable & scala.Serializable)stage -> BoxesRunTime.boxToBoolean((boolean)EnvironmentService.$anonfun$validate$1(stage))), (String)"Environment stage ID is required", (Object[])new Object[0]);
    }

    private void validateTitle(Environment environment) {
        Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Title cannot be blank", (Object[])new Object[0]);
    }

    private void validateDescription(Environment environment) {
        block0: {
            if (environment.getDescription() == null) break block0;
            Checks.checkArgument((boolean)StringUtils.hasText((String)environment.getTitle()), (String)"Description cannot be blank", (Object[])new Object[0]);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validate$1(EnvironmentStage stage) {
        return StringUtils.hasText((String)stage.getId());
    }

    @Autowired
    public EnvironmentService(EnvironmentRepository environmentRepository, EnvironmentSecurity environmentSecurity, RoleService roleService, FolderService folderService, EnvironmentStageService environmentStageService) {
        this.environmentRepository = environmentRepository;
        this.environmentSecurity = environmentSecurity;
        Logging.$init$((Logging)this);
    }
}

