/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.activity.DefaultTaskFieldsComparator;
import com.xebialabs.xlrelease.activity.TaskFieldsComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Task;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskFieldsComparatorService {
    private static final Logger logger = LoggerFactory.getLogger(TaskFieldsComparatorService.class);
    private Map<Class<? extends Task>, TaskFieldsComparator<? extends Task>> taskFieldsComparatorsPerType;
    private DefaultTaskFieldsComparator defaultTaskFieldsComparator;

    @Autowired
    public TaskFieldsComparatorService(List<? extends TaskFieldsComparator<? extends Task>> taskFieldsComparators, DefaultTaskFieldsComparator defaultTaskFieldsComparator) {
        this.taskFieldsComparatorsPerType = this.mapTaskFieldsComparators(taskFieldsComparators);
        this.defaultTaskFieldsComparator = defaultTaskFieldsComparator;
    }

    public <T extends Task> List<ActivityLogEntry> getLogs(T original, T updated) {
        Checks.checkArgument((boolean)original.getClass().equals(updated.getClass()), (String)"Cannot compare tasks of different type: %s and %s", (Object[])new Object[]{original.getClass(), updated.getClass()});
        if (this.taskFieldsComparatorsPerType.containsKey(original.getClass())) {
            TaskFieldsComparator<? extends Task> comparator = this.taskFieldsComparatorsPerType.get(original.getClass());
            return comparator.getLogs(original, updated);
        }
        logger.debug(String.format("Using default task fields comparator for task type %s", original.getClass()));
        return this.defaultTaskFieldsComparator.getLogs(original, updated);
    }

    private Map<Class<? extends Task>, TaskFieldsComparator<?>> mapTaskFieldsComparators(List<? extends TaskFieldsComparator<? extends Task>> taskFieldsComparators) {
        HashMap comparatorsPerType = new HashMap(taskFieldsComparators.size());
        taskFieldsComparators.forEach(comparator -> {
            Class taskType = comparator.getTaskClass();
            if (comparatorsPerType.containsKey(taskType)) {
                throw new IllegalStateException(String.format("Two fields comparators are registered for the same task type %s: %s and %s", taskType, comparatorsPerType.get(taskType), comparator));
            }
            comparatorsPerType.put((Class<? extends Task>)taskType, (TaskFieldsComparator<?>)comparator);
        });
        return comparatorsPerType;
    }
}

