/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.notifications.handlers;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.TaskDueSoonEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskRetriedEvent;
import com.xebialabs.xlrelease.domain.events.TaskStartedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskWaitingForInputEvent;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.notifications.ActiveTaskAssigned;
import com.xebialabs.xlrelease.notifications.ActiveTaskUnassigned;
import com.xebialabs.xlrelease.notifications.ManualTaskStarted;
import com.xebialabs.xlrelease.notifications.ManualTaskStartedWithoutAssignee;
import com.xebialabs.xlrelease.notifications.NotificationService;
import com.xebialabs.xlrelease.notifications.TaskDueSoon;
import com.xebialabs.xlrelease.notifications.TaskFailed;
import com.xebialabs.xlrelease.notifications.TaskFlagged;
import com.xebialabs.xlrelease.notifications.TaskOverdue;
import com.xebialabs.xlrelease.notifications.TaskWaitingForInput;
import com.xebialabs.xlrelease.notifications.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u00015\u0011A\u0004V1tW:{G/\u001b4jG\u0006$\u0018n\u001c8Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\u0006\r\u0005ian\u001c;jM&\u001c\u0017\r^5p]NT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005\u0019bn\u001c;jM&\u001c\u0017\r^5p]N+'O^5dKB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\u0014\u001d>$\u0018NZ5dCRLwN\\*feZL7-\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005uy\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"B\u000b\u001b\u0001\u00041\u0002F\u0001\u000e\"!\t\u0011S&D\u0001$\u0015\t!S%\u0001\u0006b]:|G/\u0019;j_:T!AJ\u0014\u0002\u000f\u0019\f7\r^8ss*\u0011\u0001&K\u0001\u0006E\u0016\fgn\u001d\u0006\u0003U-\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002Y\u0005\u0019qN]4\n\u00059\u001a#!C!vi><\u0018N]3e\u0011\u0015\u0001\u0004\u0001\"\u00012\u00035yg\u000eV1tWV\u0003H-\u0019;fIR\u0011!'\u000e\t\u0003\u001fMJ!\u0001\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006m=\u0002\raN\u0001\u0006KZ,g\u000e\u001e\t\u0003quj\u0011!\u000f\u0006\u0003um\na!\u001a<f]R\u001c(B\u0001\u001f\u0007\u0003\u0019!w.\\1j]&\u0011a(\u000f\u0002\u0011)\u0006\u001c8.\u00169eCR,G-\u0012<f]RD#a\f!\u0011\u0005\u0005\u001bU\"\u0001\"\u000b\u0005i2\u0011B\u0001#C\u0005%\u0019VOY:de&\u0014W\rC\u0003G\u0001\u0011\u0005q)A\u0007p]R\u000b7o[*uCJ$X\r\u001a\u000b\u0003e!CQAN#A\u0002%\u0003\"\u0001\u000f&\n\u0005-K$\u0001\u0005+bg.\u001cF/\u0019:uK\u0012,e/\u001a8uQ\t)\u0005\tC\u0003O\u0001\u0011\u0005q*A\u0007p]R\u000b7o\u001b*fiJLW\r\u001a\u000b\u0003eACQAN'A\u0002E\u0003\"\u0001\u000f*\n\u0005MK$\u0001\u0005+bg.\u0014V\r\u001e:jK\u0012,e/\u001a8uQ\ti\u0005\tC\u0003W\u0001\u0011\u0005q+\u0001\u0007p]R\u000b7o\u001b$bS2,G\r\u0006\u000231\")a'\u0016a\u00013B\u0011\u0001HW\u0005\u00037f\u0012q\u0002V1tW\u001a\u000b\u0017\u000e\\3e\u000bZ,g\u000e\u001e\u0015\u0003+\u0002CQA\u0018\u0001\u0005\u0002}\u000bQc\u001c8UCN\\w+Y5uS:<gi\u001c:J]B,H\u000f\u0006\u00023A\")a'\u0018a\u0001CB\u0011\u0001HY\u0005\u0003Gf\u0012\u0001\u0004V1tW^\u000b\u0017\u000e^5oO\u001a{'/\u00138qkR,e/\u001a8uQ\ti\u0006\tC\u0003g\u0001\u0011\u0005q-A\u0007p]R\u000b7o[(wKJ$W/\u001a\u000b\u0003e!DQAN3A\u0002%\u0004\"\u0001\u000f6\n\u0005-L$\u0001\u0005+bg.|e/\u001a:ek\u0016,e/\u001a8uQ\t)\u0007\tC\u0003o\u0001\u0011\u0005q.A\u0007p]R\u000b7o\u001b#vKN{wN\u001c\u000b\u0003eADQAN7A\u0002E\u0004\"\u0001\u000f:\n\u0005ML$\u0001\u0005+bg.$U/Z*p_:,e/\u001a8uQ\ti\u0007\tC\u0003w\u0001\u0011%q/A\fo_RLg-_'b]V\fG\u000eV1tWN#\u0018M\u001d;fIR\u0011!\u0007\u001f\u0005\u0006sV\u0004\rA_\u0001\u0005i\u0006\u001c8\u000e\u0005\u0002|y6\t1(\u0003\u0002~w\t!A+Y:lQ\t\u0001q\u0010E\u0002B\u0003\u0003I1!a\u0001C\u00055)e/\u001a8u\u0019&\u001cH/\u001a8fe\"\u001a\u0001!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004*\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003#\tYAA\u0005D_6\u0004xN\\3oi\u0002")
public class TaskNotificationEventHandler {
    private final NotificationService notificationService;

    @Subscribe
    public void onTaskUpdated(TaskUpdatedEvent event) {
        block6: {
            Tuple2 tuple2 = new Tuple2((Object)event.original(), (Object)event.updated());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Task original = (Task)tuple2._1();
            Task updated = (Task)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)original, (Object)updated);
            Tuple2 tuple23 = tuple22;
            Task original2 = (Task)tuple23._1();
            Task updated2 = (Task)tuple23._2();
            if (!updated2.isActive()) break block6;
            if (Option$.MODULE$.apply((Object)original2.getOwner()).isDefined() && Option$.MODULE$.apply((Object)updated2.getOwner()).isEmpty()) {
                this.notificationService.notify(new ActiveTaskUnassigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
            } else {
                String string = original2.getOwner();
                String string2 = updated2.getOwner();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.notificationService.notify(new ActiveTaskAssigned((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
                }
            }
            FlagStatus flagStatus = original2.getFlagStatus();
            FlagStatus flagStatus2 = updated2.getFlagStatus();
            if (flagStatus == null ? flagStatus2 != null : !flagStatus.equals(flagStatus2)) {
                FlagStatus flagStatus3 = updated2.getFlagStatus();
                FlagStatus flagStatus4 = FlagStatus.OK;
                if (flagStatus3 == null ? flagStatus4 != null : !flagStatus3.equals(flagStatus4)) {
                    this.notificationService.notify(new TaskFlagged((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)updated2))));
                }
            }
        }
    }

    @Subscribe
    public void onTaskStarted(TaskStartedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @Subscribe
    public void onTaskRetried(TaskRetriedEvent event) {
        this.notifyManualTaskStarted(event.task());
    }

    @Subscribe
    public void onTaskFailed(TaskFailedEvent event) {
        block0: {
            if (event.task().isTaskGroup()) break block0;
            this.notificationService.notify(new TaskFailed((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
        }
    }

    @Subscribe
    public void onTaskWaitingForInput(TaskWaitingForInputEvent event) {
        this.notificationService.notify(new TaskWaitingForInput((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    @Subscribe
    public void onTaskOverdue(TaskOverdueEvent event) {
        block0: {
            Task task = event.task();
            Option dueDate = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(task.getOrCalculateDueDate()));
            if (!task.isInProgress() || !task.hasStartDate() || !dueDate.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.after(task.getStartDate())))) break block0;
            this.notificationService.notify(new TaskOverdue((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
        }
    }

    @Subscribe
    public void onTaskDueSoon(TaskDueSoonEvent event) {
        this.notificationService.notify(new TaskDueSoon((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)event.task()))));
    }

    private void notifyManualTaskStarted(Task task) {
        block2: {
            if (task.isAutomated() || task.isTaskGroup()) break block2;
            if (Option$.MODULE$.apply((Object)task.getOwner()).isEmpty() && Option$.MODULE$.apply((Object)task.getTeam()).isEmpty() && package$.MODULE$.TaskWithNotificationFields(task).sendNotificationWhenStarted()) {
                this.notificationService.notify(new ManualTaskStartedWithoutAssignee((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            } else {
                this.notificationService.notify(new ManualTaskStarted((List<Task>)((List)com.xebialabs.xlrelease.notifications.handlers.package$.MODULE$.wrapTask().apply((Object)task))));
            }
        }
    }

    @Autowired
    public TaskNotificationEventHandler(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

