/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001-\u00111\u0005\u00177QKJ\u001c\u0018n\u001d;f]R$vn[3o%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7O\u0003\u0002\u0004\t\u0005q\u0011-\u001e;iK:$\u0018nY1uS>t'BA\u0003\u0007\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\b\u0011\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bei\u0011A\u0004\u0006\u0003\u001fA\t!B]3nK6\u0014WM]7f\u0015\t\u0019\u0011C\u0003\u0002\u0013'\u0005\u0019q/\u001a2\u000b\u0005Q)\u0012\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005Y9\u0012aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003a\t1a\u001c:h\u0013\tQbB\u0001\u000eBEN$(/Y2u%\u0016lW-\u001c2fe6+7+\u001a:wS\u000e,7\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\rYW-\u001f\t\u0003=\u001dr!aH\u0013\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011A\u0002\u001fs_>$hHC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014$\u0011!Y\u0003A!A!\u0002\u0013a\u0013AE;tKJ$U\r^1jYN\u001cVM\u001d<jG\u0016\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0017U\u001cXM\u001d3fi\u0006LGn\u001d\u0006\u0003cM\tAaY8sK&\u00111G\f\u0002\u0013+N,'\u000fR3uC&d7oU3sm&\u001cW\r\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0003=!xn[3o%\u0016\u0004xn]5u_JL\bCA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003)\u0011X\r]8tSR|'/_\u0005\u0003wa\u0012qdQ;ti>l\u0007+\u001a:tSN$XM\u001c;U_.,gNU3q_NLGo\u001c:z\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q!q(\u0011\"D!\t\u0001\u0005!D\u0001\u0003\u0011\u0015aB\b1\u0001\u001e\u0011\u0015YC\b1\u0001-\u0011\u0015)D\b1\u00017\u0011\u001d)\u0005A1A\u0005\n\u0019\u000bQ\u0003R#G\u0003VcEkX*F%&+5k\u0018'F\u001d\u001e#\u0006*F\u0001H!\tA\u0015*D\u0001$\u0013\tQ5EA\u0002J]RDa\u0001\u0014\u0001!\u0002\u00139\u0015A\u0006#F\r\u0006+F\nV0T\u000bJKUiU0M\u000b:;E\u000b\u0013\u0011\t\u000f9\u0003!\u0019!C\u0005\r\u0006!B)\u0012$B+2#v\fV(L\u000b:{F*\u0012(H)\"Ca\u0001\u0015\u0001!\u0002\u00139\u0015!\u0006#F\r\u0006+F\nV0U\u001f.+ej\u0018'F\u001d\u001e#\u0006\n\t\u0005\b%\u0002\u0001\r\u0011\"\u0003G\u00031\u0019XM]5fg2+gn\u001a;i\u0011\u001d!\u0006\u00011A\u0005\nU\u000b\u0001c]3sS\u0016\u001cH*\u001a8hi\"|F%Z9\u0015\u0005YK\u0006C\u0001%X\u0013\tA6E\u0001\u0003V]&$\bb\u0002.T\u0003\u0003\u0005\raR\u0001\u0004q\u0012\n\u0004B\u0002/\u0001A\u0003&q)A\u0007tKJLWm\u001d'f]\u001e$\b\u000e\t\u0005\b=\u0002\u0001\r\u0011\"\u0003G\u0003-!xn[3o\u0019\u0016tw\r\u001e5\t\u000f\u0001\u0004\u0001\u0019!C\u0005C\u0006yAo\\6f]2+gn\u001a;i?\u0012*\u0017\u000f\u0006\u0002WE\"9!lXA\u0001\u0002\u00049\u0005B\u00023\u0001A\u0003&q)\u0001\u0007u_.,g\u000eT3oORD\u0007\u0005C\u0003g\u0001\u0011%q-\u0001\u0004h_B\u000b7\u000f\u001e\u000b\u0004QB\u0014\bCA5o\u001b\u0005Q'BA6m\u0003\u0011)H/\u001b7\u000b\u00035\fAA[1wC&\u0011qN\u001b\u0002\u0005\t\u0006$X\rC\u0003rK\u0002\u0007\u0001.A\u0005hSZ,g\u000eR1uK\")1/\u001aa\u0001i\u0006AA/[7f\u0013:l5\u000f\u0005\u0002Ik&\u0011ao\t\u0002\u0005\u0019>tw\rC\u0003y\u0001\u0011%\u00110\u0001\u0005h_\u001a+H/\u001e:f)\rA'p\u001f\u0005\u0006c^\u0004\r\u0001\u001b\u0005\u0006g^\u0004\r\u0001\u001e\u0005\u0006{\u0002!\tE`\u0001\u000f_:dunZ5o'V\u001c7-Z:t)\u00191v0a\u0006\u0002\"!9\u0011\u0011\u0001?A\u0002\u0005\r\u0011a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u000b\t\u0019\"\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011AG\u000f\u001e9\u000b\t\u00055\u0011qB\u0001\bg\u0016\u0014h\u000f\\3u\u0015\t\t\t\"A\u0003kCZ\f\u00070\u0003\u0003\u0002\u0016\u0005\u001d!A\u0005%uiB\u001cVM\u001d<mKR\u0014V-];fgRDq!!\u0007}\u0001\u0004\tY\"\u0001\u0005sKN\u0004xN\\:f!\u0011\t)!!\b\n\t\u0005}\u0011q\u0001\u0002\u0014\u0011R$\boU3sm2,GOU3ta>t7/\u001a\u0005\b\u0003Ga\b\u0019AA\u0013\u0003a\u0019XoY2fgN4W\u000f\\!vi\",g\u000e^5dCRLwN\u001c\t\u0005\u0003O\tI#D\u00011\u0013\r\tY\u0003\r\u0002\u000f\u0003V$\b.\u001a8uS\u000e\fG/[8o\u0011\u001d\ty\u0003\u0001C!\u0003c\ta\u0003\u001d:pG\u0016\u001c8/Q;u_2{w-\u001b8D_>\\\u0017.\u001a\u000b\t\u0003g\tI$a\u0011\u0002FA\u0019Q&!\u000e\n\u0007\u0005]bFA\u0006Vg\u0016\u0014H)\u001a;bS2\u001c\b\u0002CA\u001e\u0003[\u0001\r!!\u0010\u0002\u0019\r|wn[5f)>\\WM\\:\u0011\t!\u000by$H\u0005\u0004\u0003\u0003\u001a#!B!se\u0006L\b\u0002CA\u0001\u0003[\u0001\r!a\u0001\t\u0011\u0005e\u0011Q\u0006a\u0001\u00037Aq!!\u0013\u0001\t\u0003\nY%\u0001\u0004m_\u001e|W\u000f\u001e\u000b\b-\u00065\u0013qJA)\u0011!\t\t!a\u0012A\u0002\u0005\r\u0001\u0002CA\r\u0003\u000f\u0002\r!a\u0007\t\u000f\r\t9\u00051\u0001\u0002&!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0013AE4f]\u0016\u0014\u0018\r^3TKJLWm\u001d#bi\u0006,\u0012!\b\u0005\b\u00037\u0002A\u0011CA,\u0003E9WM\\3sCR,Gk\\6f]\u0012\u000bG/\u0019\u0005\b\u0003?\u0002A\u0011BA1\u0003%\tG\rZ\"p_.LW\rF\u0004W\u0003G\ni'a\u001c\t\u0011\u0005\u0015\u0014Q\fa\u0001\u0003O\nQ\u0001^8lK:\u00042!DA5\u0013\r\tYG\u0004\u0002\u001a!\u0016\u00148/[:uK:$(+Z7f[\n,'/T3U_.,g\u000e\u0003\u0005\u0002\u0002\u0005u\u0003\u0019AA\u0002\u0011!\tI\"!\u0018A\u0002\u0005m\u0001bBA:\u0001\u0011\u0005\u0011QO\u0001\u0010g\u0016$8+\u001a:jKNdUM\\4uQR\u0019a+a\u001e\t\rI\u000b\t\b1\u0001H\u0011\u001d\tY\b\u0001C\u0001\u0003{\nab]3u)>\\WM\u001c'f]\u001e$\b\u000eF\u0002W\u0003\u007fBaAXA=\u0001\u00049\u0005bBAB\u0001\u0011\u0005\u0013QQ\u0001\u0018g\u0016$Hk\\6f]Z\u000bG.\u001b3jif\u001cVmY8oIN$2AVAD\u0011\u001d\tI)!!A\u0002\u001d\u000bA\u0003^8lK:4\u0016\r\\5eSRL8+Z2p]\u0012\u001c\b\u0002DAG\u0001A\u0005\t\u0011!A\u0005\u0002\u0005=\u0015a\u00069s_R,7\r^3eI\u001d,GoQ8pW&,g*Y7f)\u0011\t\t*!(\u0015\u0005\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\u0007\u0005eE.\u0001\u0003mC:<\u0017b\u0001\u0015\u0002\u0018\"A!,a#\u0002\u0002\u0003\u0007q\b\u0003\u0007\u0002\"\u0002\u0001\n\u0011!A\u0001\n\u0003\t\u0019+\u0001\fqe>$Xm\u0019;fI\u0012\"WmY8eK\u000e{wn[5f)\u0011\t)+a+\u0015\t\u0005\u001d\u0016\u0011\u0016\t\u0006\u0011\u0006}\u00121\u0013\u0005\n5\u0006}\u0015\u0011!a\u0001\u0003'C\u0001BWAP\u0003\u0003\u0005\ra\u0010")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String x$12) {
        return x$1.decodeCookie(x$12);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String username = successfulAuthentication.getName();
        this.logger.debug((Object)("Creating new persistent login for user " + username));
        PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
        try {
            this.tokenRepository.createNewToken(persistentToken);
            this.addCookie(persistentToken, request, response);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain " + 2 + " tokens, but contained '" + Arrays.asList((Object[])new String[][]{cookieTokens}) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing persistent login token for user '" + token.getUsername() + "', series '" + token.getSeries() + "'"));
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])request.getCookies())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, x$1))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$2(this, c);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.seriesLength())));
    }

    public String generateTokenData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.tokenLength())));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        this.setCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}), this.getTokenValiditySeconds(), request, response);
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).headOption().foreach((Function1 & Serializable & scala.Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository) {
        this.tokenRepository = tokenRepository;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
    }
}

