/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.ServerState;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ServerService;
import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;
import com.xebialabs.deployit.engine.spi.event.LicenseReloadCollectedEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStartEvent;
import com.xebialabs.deployit.engine.spi.event.MaintenanceStopEvent;
import com.xebialabs.deployit.engine.spi.event.RepositoryGarbageCollectedEvent;
import com.xebialabs.deployit.engine.spi.event.SystemStoppedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsAuthenticationFinder;
import com.xebialabs.deployit.security.authentication.viewas.ViewAsData;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.gc.GarbageCollectionService;
import com.xebialabs.license.service.LicenseService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;

@Controller
public class ServerResource
extends AbstractSecuredResource
implements ServerService {
    @Autowired
    private GarbageCollectionService garbageCollectionService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private List<ViewAsAuthenticationFinder> viewAsAuthenticationFinders;
    @Autowired
    private RoleService roleService;
    @Autowired
    ViewAsData viewAsData;
    private Map<String, String> productLogos = new HashMap<String, String>(){
        {
            this.put("xl-deploy", "xl-deploy-logo.svg");
            this.put("xl-release", "xl-release-logo.svg");
        }
    };

    public void shutdown() {
        this.checkPermission(PlatformPermissions.ADMIN);
        EventBusHolder.publish((Object)new SystemStoppedEvent());
        EventBusHolder.publish((Object)new ShutdownEvent());
    }

    public void startMaintenance() {
        this.checkPermission(PlatformPermissions.ADMIN);
        EventBusHolder.publish((Object)new MaintenanceStartEvent());
    }

    public void stopMaintenance() {
        this.checkPermission(PlatformPermissions.ADMIN);
        EventBusHolder.publish((Object)new MaintenanceStopEvent());
    }

    public com.xebialabs.deployit.engine.api.dto.ServerState getState() {
        String currentMode = ServerState.getInstance().getCurrentMode().toString();
        com.xebialabs.deployit.engine.api.dto.ServerState state = new com.xebialabs.deployit.engine.api.dto.ServerState();
        state.setCurrentMode(currentMode);
        return state;
    }

    public ServerInfo getInfo() {
        ClassPathResource resource = new ClassPathResource("com/xebialabs/deployit/release.properties");
        Properties release = new Properties();
        try {
            release.load(resource.getInputStream());
            ServerInfo si = new ServerInfo();
            si.setVersion(release.getProperty("version"));
            for (String plugin : PluginVersions.getRegisteredPlugins()) {
                si.getPluginsInfo().add(new ServerPluginInfo(plugin, PluginVersions.getVersionFor((String)plugin)));
            }
            si.setClasspathEntries(ServerResource.getServerClassPath());
            return si;
        }
        catch (IOException e) {
            throw new DeployitException((Throwable)e);
        }
    }

    public void logout() {
    }

    public void viewAs(String username, List<String> roles) {
        this.checkPermission(PlatformPermissions.ADMIN);
        if (username != null && roles != null && !roles.isEmpty()) {
            throw new RuntimeException("Use the View As feature with either username or roles");
        }
        this.viewAsData.setUser(null);
        this.viewAsData.setRoles(null);
        if (username != null && !username.equals("")) {
            this.viewAsData.setUser(this.authenticateViewAs(username));
        } else if (roles != null && !roles.isEmpty()) {
            this.viewAsData.setRoles(this.roleService.getRoles().stream().filter(r -> roles.contains(r.getName())).collect(Collectors.toList()));
        }
    }

    private Authentication authenticateViewAs(String username) {
        for (ViewAsAuthenticationFinder viewAsAuthentication : this.viewAsAuthenticationFinders) {
            Authentication authentication = viewAsAuthentication.search(username);
            if (authentication == null) continue;
            return authentication;
        }
        throw new RuntimeException("Unknown user: '" + username + "'.");
    }

    private static List<String> getServerClassPath() {
        String classpath = System.getProperty("java.class.path");
        return Arrays.asList(classpath.split(System.getProperty("path.separator")));
    }

    public void gc() {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.garbageCollectionService.runGarbageCollector();
        EventBusHolder.publish((Object)new RepositoryGarbageCollectedEvent());
    }

    public void licenseReload() {
        this.checkPermission(PlatformPermissions.ADMIN);
        this.licenseService.reload();
        EventBusHolder.publish((Object)new LicenseReloadCollectedEvent());
    }

    public Response getLogo(String productName) {
        String logoFileName = this.productLogos.get(productName);
        if (logoFileName == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            File logo = Paths.get("conf", logoFileName).toFile();
            FileInputStream fis = new FileInputStream(logo);
            StreamingOutput output = stream -> {
                stream.write(IOUtils.toByteArray((InputStream)fis));
                fis.close();
            };
            return Response.ok((Object)output, (String)"image/svg+xml").build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

