/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.client.ClusterClientReceptionist$;
import akka.cluster.client.ClusterReceptionist$;
import akka.cluster.client.ClusterReceptionistSettings$;
import akka.cluster.pubsub.DistributedPubSub;
import akka.cluster.pubsub.DistributedPubSub$;
import akka.cluster.pubsub.DistributedPubSubMediator;
import akka.cluster.pubsub.DistributedPubSubMediator$Subscribe$;
import akka.cluster.pubsub.DistributedPubSubMediator$Unsubscribe$;
import com.typesafe.config.Config;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u00055q!B\u0001\u0003\u0011\u0003I\u0011!G\"mkN$XM]\"mS\u0016tGOU3dKB$\u0018n\u001c8jgRT!a\u0001\u0003\u0002\r\rd\u0017.\u001a8u\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u001d\tA!Y6lC\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!!G\"mkN$XM]\"mS\u0016tGOU3dKB$\u0018n\u001c8jgR\u001cBa\u0003\b\u0015eB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u00042!\u0006\r\u001b\u001b\u00051\"BA\f\u0007\u0003\u0015\t7\r^8s\u0013\tIbCA\u0006FqR,gn]5p]&#\u0007C\u0001\u0006\u001c\r\u0011a!A\u0001\u000f\u0014\u0007mqQ\u0004\u0005\u0002\u0016=%\u0011qD\u0006\u0002\n\u000bb$XM\\:j_:D\u0001\"I\u000e\u0003\u0002\u0003\u0006IAI\u0001\u0007gf\u001cH/Z7\u0011\u0005U\u0019\u0013B\u0001\u0013\u0017\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011\u001513\u0004\"\u0001(\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\u000b\u0005\u0006C\u0015\u0002\rA\t\u0005\bUm\u0011\r\u0011\"\u0003,\u0003\u0019\u0019wN\u001c4jOV\tA\u0006\u0005\u0002.g5\taF\u0003\u0002+_)\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001\u000e\u0018\u0003\r\r{gNZ5h\u0011\u001914\u0004)A\u0005Y\u000591m\u001c8gS\u001e\u0004\u0003b\u0002\u001d\u001c\u0005\u0004%I!O\u0001\u0005e>dW-F\u0001;!\ry1(P\u0005\u0003yA\u0011aa\u00149uS>t\u0007C\u0001 F\u001d\ty4\t\u0005\u0002A!5\t\u0011I\u0003\u0002C\u0011\u00051AH]8pizJ!\u0001\u0012\t\u0002\rA\u0013X\rZ3g\u0013\t1uI\u0001\u0004TiJLgn\u001a\u0006\u0003\tBAa!S\u000e!\u0002\u0013Q\u0014!\u0002:pY\u0016\u0004\u0003\"B&\u001c\t\u0003a\u0015\u0001D5t)\u0016\u0014X.\u001b8bi\u0016$W#A'\u0011\u0005=q\u0015BA(\u0011\u0005\u001d\u0011un\u001c7fC:DQ!U\u000e\u0005\nI\u000ba\u0002];c'V\u0014W*\u001a3jCR|'/F\u0001T!\t)B+\u0003\u0002V-\tA\u0011i\u0019;peJ+g\rC\u0003X7\u0011\u0005\u0001,A\bsK\u001eL7\u000f^3s'\u0016\u0014h/[2f)\tIF\f\u0005\u0002\u00105&\u00111\f\u0005\u0002\u0005+:LG\u000fC\u0003\u0018-\u0002\u00071\u000bC\u0003_7\u0011\u0005q,A\tv]J,w-[:uKJ\u001cVM\u001d<jG\u0016$\"!\u00171\t\u000b]i\u0006\u0019A*\t\u000b\t\\B\u0011A2\u0002%I,w-[:uKJ\u001cVOY:de&\u0014WM\u001d\u000b\u00043\u00124\u0007\"B3b\u0001\u0004i\u0014!\u0002;pa&\u001c\u0007\"B\fb\u0001\u0004\u0019\u0006\"\u00025\u001c\t\u0003I\u0017\u0001F;oe\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000fF\u0002ZU.DQ!Z4A\u0002uBQaF4A\u0002MCq!\\\u000eC\u0002\u0013%!+\u0001\u0007sK\u000e,\u0007\u000f^5p]&\u001cH\u000f\u0003\u0004p7\u0001\u0006IaU\u0001\u000ee\u0016\u001cW\r\u001d;j_:L7\u000f\u001e\u0011\t\u000bE\\B\u0011\u0001*\u0002\u0015UtG-\u001a:ms&tw\r\u0005\u0002\u0016g&\u0011AO\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0006M-!\tA\u001e\u000b\u0002\u0013!)\u0001p\u0003C!s\u0006\u0019q-\u001a;\u0015\u0005iQ\b\"B\u0011x\u0001\u0004Y\bCA\u000b}\u0013\tihCA\u0006BGR|'oU=ti\u0016l\u0007BB@\f\t\u0003\n\t!\u0001\u0004m_>\\W\u000f\u001d\u000b\u0003\u0003\u0007q!A\u0003\u0001\t\u000f\u0005\u001d1\u0002\"\u0011\u0002\n\u0005y1M]3bi\u0016,\u0005\u0010^3og&|g\u000eF\u0002\u001b\u0003\u0017Aa!IA\u0003\u0001\u0004\u0011\u0003")
public final class ClusterClientReceptionist
implements Extension {
    private final ExtendedActorSystem system;
    private final Config config;
    private final Option<String> role;
    private final ActorRef receptionist;

    public static Extension apply(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.apply(actorSystem);
    }

    public static ClusterClientReceptionist createExtension(ExtendedActorSystem extendedActorSystem) {
        return ClusterClientReceptionist$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ClusterClientReceptionist$ lookup() {
        return ClusterClientReceptionist$.MODULE$.lookup();
    }

    public static ClusterClientReceptionist get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return ClusterClientReceptionist$.MODULE$.get(actorSystem);
    }

    private Config config() {
        return this.config;
    }

    private Option<String> role() {
        return this.role;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTerminated() {
        if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated()) return true;
        Set set = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles();
        if (this.role().forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)))) return false;
        return true;
    }

    private ActorRef pubSubMediator() {
        return ((DistributedPubSub)DistributedPubSub$.MODULE$.apply((ActorSystem)this.system)).mediator();
    }

    public void registerService(ActorRef actor) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Put x$48 = new DistributedPubSubMediator.Put(actor);
        ActorRef x$49 = qual$1.$bang$default$2((Object)x$48);
        qual$1.$bang((Object)x$48, x$49);
    }

    public void unregisterService(ActorRef actor) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Remove x$50 = new DistributedPubSubMediator.Remove(actor.path().toStringWithoutAddress());
        ActorRef x$51 = qual$2.$bang$default$2((Object)x$50);
        qual$2.$bang((Object)x$50, x$51);
    }

    public void registerSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Subscribe x$52 = DistributedPubSubMediator$Subscribe$.MODULE$.apply(topic, actor);
        ActorRef x$53 = qual$3.$bang$default$2((Object)x$52);
        qual$3.$bang((Object)x$52, x$53);
    }

    public void unregisterSubscriber(String topic, ActorRef actor) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.pubSubMediator());
        DistributedPubSubMediator.Unsubscribe x$54 = DistributedPubSubMediator$Unsubscribe$.MODULE$.apply(topic, actor);
        ActorRef x$55 = qual$4.$bang$default$2((Object)x$54);
        qual$4.$bang((Object)x$54, x$55);
    }

    private ActorRef receptionist() {
        return this.receptionist;
    }

    public ActorRef underlying() {
        return this.receptionist();
    }

    public ClusterClientReceptionist(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.config = system.settings().config().getConfig("akka.cluster.client.receptionist");
        String string = this.config().getString("role");
        Object object = "".equals(string) ? None$.MODULE$ : new Some((Object)string);
        this.role = object;
        if (this.isTerminated()) {
            actorRef = system.deadLetters();
        } else {
            String name = this.config().getString("name");
            String string2 = this.config().getString("use-dispatcher");
            String string3 = "".equals(string2) ? "akka.actor.default-dispatcher" : string2;
            String dispatcher = string3;
            ActorRef mediator = this.pubSubMediator();
            actorRef = system.systemActorOf(ClusterReceptionist$.MODULE$.props(mediator, ClusterReceptionistSettings$.MODULE$.apply(this.config())).withDispatcher(dispatcher), name);
        }
        this.receptionist = actorRef;
    }
}

