/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.xml.WriteWithoutPasswordCiConverter;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.RepositoryAdapter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirContext;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.ArchivedReleases$;
import com.xebialabs.xlrelease.db.ArchivedReleasesSearch;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.repository.DependencyRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.service.ArchivedActivityLogsSerializer;
import com.xebialabs.xlrelease.service.ArchivingService$;
import com.xebialabs.xlrelease.service.CommentService;
import com.xebialabs.xlrelease.service.CompletedReleaseExportService;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@Transactional(value="reportingTransactionManager", propagation=Propagation.REQUIRED, isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
@ScalaSignature(bytes="\u0006\u0001\r]w!B\u00193\u0011\u0003Yd!B\u001f3\u0011\u0003q\u0004\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001\u0006\"B7\u0002\t\u0003qg\u0001B\u001f3\u0001mD\u0001\u0002`\u0003\u0003\u0006\u0004%\t! \u0005\n\u0003\u0013)!\u0011!Q\u0001\nyD!\"a\u0003\u0006\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\t\u0019\"\u0002B\u0001B\u0003%\u0011Q\u0003\u0005\n\u00037)!\u0011!Q\u0001\n\u0019D!\"!\b\u0006\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t)#\u0002B\u0001B\u0003%\u0011q\u0005\u0005\u000b\u0003c)!\u0011!Q\u0001\n\u0005M\u0002BCA\u001d\u000b\t\u0005\t\u0015!\u0003\u0002<!Q\u0011qI\u0003\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005=SA!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002X\u0015\u0011\t\u0011)A\u0005\u00033B!\"a\u0018\u0006\u0005\u0003\u0005\u000b\u0011BA1\u0011\u0019iU\u0001\"\u0001\u0002h!9\u0011QT\u0003\u0005\u0002\u0005}\u0005bBA`\u000b\u0011%\u0011\u0011\u0019\u0005\b\u0003\u000f,A\u0011BAe\u0011\u001d\ti-\u0002C\u0001\u0003\u001fDq!!6\u0006\t\u0003\t9\u000eC\u0004\u0002V\u0016!\t!a7\t\u000f\u0005-X\u0001\"\u0001\u0002n\"9\u00111_\u0003\u0005\u0002\u0005U\bb\u0002B\u0002\u000b\u0011\u0005!Q\u0001\u0005\b\u0005')A\u0011\u0001B\u000b\u0011\u001d\u0011I#\u0002C\u0001\u0005WAqAa\r\u0006\t\u0003\u0011)\u0004C\u0004\u0003<\u0015!\tA!\u0010\t\u000f\t\u0015S\u0001\"\u0001\u0003H!9!QJ\u0003\u0005\u0002\t=\u0003b\u0002B,\u000b\u0011\u0005!\u0011\f\u0005\b\u0005K*A\u0011\u0001B4\u0011\u001d\u0011\u0019(\u0002C\u0001\u0005kBqAa\u001d\u0006\t\u0003\u0011\t\u000bC\u0004\u00036\u0016!\tAa.\t\u000f\tUW\u0001\"\u0001\u0003X\"91qA\u0003\u0005\u0002\r%\u0001bBB\b\u000b\u0011\u00051\u0011\u0003\u0005\b\u0005g*A\u0011BB\u0010\u0011\u001d\u0019I#\u0002C\u0005\u0007WA\u0011ba\r\u0006#\u0003%Ia!\u000e\t\u000f\r%S\u0001\"\u0003\u0004L!91\u0011P\u0003\u0005\n\rm\u0004bBBA\u000b\u0011%11Q\u0001\u0011\u0003J\u001c\u0007.\u001b<j]\u001e\u001cVM\u001d<jG\u0016T!a\r\u001b\u0002\u000fM,'O^5dK*\u0011QGN\u0001\nq2\u0014X\r\\3bg\u0016T!a\u000e\u001d\u0002\u0013a,'-[1mC\n\u001c(\"A\u001d\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005q\nQ\"\u0001\u001a\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,7cA\u0001@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u000bMdg\r\u000e6\u000b\u0003)\u000b\u0001b\u001a:jujdW\rZ\u0005\u0003\u0019\u001e\u0013q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002w\u0005QB-Z:fe&\fG.\u001b>f\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKR\u0019\u0011k\u00163\u0011\u0005I+V\"A*\u000b\u0005Q#\u0014A\u00023p[\u0006Lg.\u0003\u0002W'\n9!+\u001a7fCN,\u0007\"\u0002-\u0004\u0001\u0004I\u0016a\u0003:fY\u0016\f7/\u001a&t_:\u0004\"AW1\u000f\u0005m{\u0006C\u0001/B\u001b\u0005i&B\u00010;\u0003\u0019a$o\\8u}%\u0011\u0001-Q\u0001\u0007!J,G-\u001a4\n\u0005\t\u001c'AB*ue&twM\u0003\u0002a\u0003\")Qm\u0001a\u0001M\u0006Q!/\u001a9pg&$xN]=\u0011\u0005\u001d\\W\"\u00015\u000b\u0005\u0015L'B\u000167\u0003!!W\r\u001d7ps&$\u0018B\u00017i\u0005E\u0011V\r]8tSR|'/_!eCB$XM]\u0001\rO\u0016$Xj\u001c8uQf+\u0017M\u001d\u000b\u00033>DQ\u0001\u001d\u0003A\u0002E\f\u0011b\u001d;beR$\u0015\r^3\u0011\u0005ILX\"A:\u000b\u0005Q,\u0018\u0001\u0002;j[\u0016T!A^<\u0002\t)|G-\u0019\u0006\u0002q\u0006\u0019qN]4\n\u0005i\u001c(\u0001\u0003#bi\u0016$\u0016.\\3\u0014\u0007\u0015yT)\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\ta\u0010E\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\rA'\u0001\u0002eE&!\u0011qAA\u0001\u0005A\t%o\u00195jm\u0016$'+\u001a7fCN,7/A\tbe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0002\na#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:TK\u0006\u00148\r\u001b\t\u0004\u007f\u0006=\u0011\u0002BA\t\u0003\u0003\u0011a#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:TK\u0006\u00148\r[\u0001\u001fCJ\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\u00042\u0001PA\f\u0013\r\tIB\r\u0002\u001f\u0003J\u001c\u0007.\u001b<fI\u0006\u001bG/\u001b<jifdunZ:TKJL\u0017\r\\5{KJ\f\u0011C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003y\u0019w.\u001c9mKR,GMU3mK\u0006\u001cXm]#ya>\u0014HoU3sm&\u001cW\rE\u0002=\u0003CI1!a\t3\u0005u\u0019u.\u001c9mKR,GMU3mK\u0006\u001cX-\u0012=q_J$8+\u001a:wS\u000e,\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011FA\u0017\u001b\t\tYC\u0003\u0002fi%!\u0011qFA\u0016\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0015I\u0016\u0004XM\u001c3f]\u000eL(+\u001a9pg&$xN]=\u0011\t\u0005%\u0012QG\u0005\u0005\u0003o\tYC\u0001\u000bEKB,g\u000eZ3oGf\u0014V\r]8tSR|'/_\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\u001b\u0002\r\u0005\u001cGo\u001c:t\u0013\u0011\t)%a\u0010\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\u001dQ,\u0017-\u001c*fa>\u001c\u0018\u000e^8ssB!\u0011\u0011FA&\u0013\u0011\ti%a\u000b\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006Q1/Z2ve\u0016$7)[:\u0011\t\u0005%\u00121K\u0005\u0005\u0003+\nYC\u0001\u0006TK\u000e,(/\u001a3DSN\f1D]3mK\u0006\u001cX-\u0012=uK:\u001c\u0018n\u001c8t%\u0016\u0004xn]5u_JL\b\u0003BA\u0015\u00037JA!!\u0018\u0002,\tY\"+\u001a7fCN,W\t\u001f;f]NLwN\\:SKB|7/\u001b;pef\fabY8n[\u0016tGoU3sm&\u001cW\rE\u0002=\u0003GJ1!!\u001a3\u00059\u0019u.\\7f]R\u001cVM\u001d<jG\u0016$\"$!\u001b\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u0003\"\u0001P\u0003\t\u000bq\u001c\u0002\u0019\u0001@\t\u000f\u0005-1\u00031\u0001\u0002\u000e!9\u00111C\nA\u0002\u0005U\u0001BBA\u000e'\u0001\u0007a\rC\u0004\u0002\u001eM\u0001\r!a\b\t\u000f\u0005\u00152\u00031\u0001\u0002(!9\u0011\u0011G\nA\u0002\u0005M\u0002bBA\u001d'\u0001\u0007\u00111\b\u0005\b\u0003\u000f\u001a\u0002\u0019AA%\u0011\u001d\tye\u0005a\u0001\u0003#Bq!a\u0016\u0014\u0001\u0004\tI\u0006C\u0004\u0002`M\u0001\r!!\u0019)\u0007M\t)\t\u0005\u0003\u0002\b\u0006eUBAAE\u0015\u0011\tY)!$\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0010\u0006E\u0015a\u00024bGR|'/\u001f\u0006\u0005\u0003'\u000b)*A\u0003cK\u0006t7OC\u0002\u0002\u0018^\fqb\u001d9sS:<gM]1nK^|'o[\u0005\u0005\u00037\u000bIIA\u0005BkR|w/\u001b:fI\u0006q\u0011M]2iSZ,'+\u001a7fCN,G\u0003BAQ\u0003O\u00032\u0001QAR\u0013\r\t)+\u0011\u0002\u0005+:LG\u000f\u0003\u0004\u0002*R\u0001\r!W\u0001\ne\u0016dW-Y:f\u0013\u0012D3\u0001FAW!\u0011\ty+a/\u000e\u0005\u0005E&\u0002BAF\u0003gSA!!.\u00028\u00069Q.\u001a;sS\u000e\u001c(bAA]q\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002>\u0006E&!\u0002+j[\u0016$\u0017AE1sG\"Lg/Z!ui\u0006\u001c\u0007.\\3oiN$B!!)\u0002D\"1\u0011QY\u000bA\u0002E\u000bqA]3mK\u0006\u001cX-A\nbe\u000eD\u0017N^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002\"\u0006-\u0007BBAc-\u0001\u0007\u0011+A\tqe\u0016\f%o\u00195jm\u0016\u0014V\r\\3bg\u0016$B!!)\u0002R\"1\u0011QY\fA\u0002EC3aFAW\u0003)9W\r\u001e*fY\u0016\f7/\u001a\u000b\u0004#\u0006e\u0007BBAU1\u0001\u0007\u0011\fF\u0003R\u0003;\fy\u000e\u0003\u0004\u0002*f\u0001\r!\u0017\u0005\b\u0003CL\u0002\u0019AAr\u0003IIgn\u00197vI\u0016\u0004&/Z!sG\"Lg/\u001a3\u0011\u0007\u0001\u000b)/C\u0002\u0002h\u0006\u0013qAQ8pY\u0016\fg\u000eK\u0002\u001a\u0003[\u000bqbZ3u%\u0016dW-Y:f)&$H.\u001a\u000b\u00043\u0006=\bBBAU5\u0001\u0007\u0011\fK\u0002\u001b\u0003[\u000b\u0001bZ3u!\"\f7/\u001a\u000b\u0005\u0003o\fi\u0010E\u0002S\u0003sL1!a?T\u0005\u0015\u0001\u0006.Y:f\u0011\u0019\typ\u0007a\u00013\u00069\u0001\u000f[1tK&#\u0007fA\u000e\u0002.\u00069q-\u001a;UCN\\G\u0003\u0002B\u0004\u0005\u001b\u00012A\u0015B\u0005\u0013\r\u0011Ya\u0015\u0002\u0005)\u0006\u001c8\u000e\u0003\u0004\u0003\u0010q\u0001\r!W\u0001\u0007i\u0006\u001c8.\u00133)\u0007q\ti+A\u0006hKR4\u0016M]5bE2,G\u0003\u0002B\f\u0005G\u0001BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;\u0019\u0016!\u0003<be&\f'\r\\3t\u0013\u0011\u0011\tCa\u0007\u0003\u0011Y\u000b'/[1cY\u0016DaA!\n\u001e\u0001\u0004I\u0016A\u0003<be&\f'\r\\3JI\"\u001aQ$!,\u0002\r\u0015D\u0018n\u001d;t)\u0011\t\u0019O!\f\t\r\t=b\u00041\u0001Z\u0003\u0011\u0019\u0017.\u00133)\u0007y\ti+A\tfq&\u001cHo\u001d)sK\u0006\u00138\r[5wK\u0012$B!a9\u00038!1!qF\u0010A\u0002eC3aHAW\u00031)\u00070[:ug\nKh*Y7f)\u0011\t\u0019Oa\u0010\t\r\t\u0005\u0003\u00051\u0001Z\u0003-\u0011X\r\\3bg\u0016t\u0015-\\3)\u0007\u0001\ni+\u0001\tdQ\u0016\u001c7NT8u\u0003J\u001c\u0007.\u001b<fIR!\u0011\u0011\u0015B%\u0011\u0019\u0011y#\ta\u00013\"\u001a\u0011%!,\u0002!\u0005$H/Y2i[\u0016tG/\u0012=jgR\u001cH\u0003BAr\u0005#BaAa\u0015#\u0001\u0004I\u0016\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007f\u0001\u0012\u0002.\u0006iq-\u001a;BiR\f7\r[7f]R$BAa\u0017\u0003bA\u0019!K!\u0018\n\u0007\t}3K\u0001\u0006BiR\f7\r[7f]RDaAa\u0015$\u0001\u0004I\u0006fA\u0012\u0002.\u0006\u0019r-\u001a;BiR\f7\r[7f]R|\u0005\u000f^5p]R!!\u0011\u000eB8!\u0015\u0001%1\u000eB.\u0013\r\u0011i'\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\r\tMC\u00051\u0001ZQ\r!\u0013QV\u0001\u000fg\u0016\f'o\u00195SK2,\u0017m]3t)\u0011\u00119Ha\"\u0011\u000b\te$1Q)\u000e\u0005\tm$\u0002\u0002B?\u0005\u007f\nA!\u001e;jY*\u0011!\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0006\nm$\u0001\u0002'jgRDqA!#&\u0001\u0004\u0011Y)A\u0004gS2$XM]:\u0011\t\t5%1T\u0007\u0003\u0005\u001fSAA!%\u0003\u0014\u0006)am\u001c:ng*!!Q\u0013BL\u0003\t1\u0018GC\u0002\u0003\u001aR\n1!\u00199j\u0013\u0011\u0011iJa$\u0003\u001fI+G.Z1tKN4\u0015\u000e\u001c;feND3!JAW)!\u00119Ha)\u0003&\n=\u0006b\u0002BEM\u0001\u0007!1\u0012\u0005\b\u0005O3\u0003\u0019\u0001BU\u0003\u0015a\u0017.\\5u!\r\u0001%1V\u0005\u0004\u0005[\u000b%\u0001\u0002'p]\u001eDqA!-'\u0001\u0004\u0011I+\u0001\u0004pM\u001a\u001cX\r\u001e\u0015\u0004M\u00055\u0016!F2pk:$(+\u001a7fCN,7OQ=Ti\u0006$Xo\u001d\u000b\u0005\u0005s\u0013\t\u000eE\u0004[\u0005w\u0013yLa3\n\u0007\tu6MA\u0002NCB\u0004BA!1\u0003H6\u0011!1\u0019\u0006\u0004\u0005\u000b\u001c\u0016AB:uCR,8/\u0003\u0003\u0003J\n\r'!\u0004*fY\u0016\f7/Z*uCR,8\u000fE\u0002A\u0005\u001bL1Aa4B\u0005\rIe\u000e\u001e\u0005\b\u0005\u0013;\u0003\u0019\u0001BFQ\r9\u0013QV\u0001\u0019M&tG-\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:f\u0013\u0012\u001cHC\u0002Bm\u0005W\u0014)\u0010E\u0003\u0003\\\n\u0015\u0018L\u0004\u0003\u0003^\n\u0005hb\u0001/\u0003`&\t!)C\u0002\u0003d\u0006\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003h\n%(aA*fc*\u0019!1]!\t\u000f\t5\b\u00061\u0001\u0003p\u0006!A-\u0019;f!\u0011\u0011IH!=\n\t\tM(1\u0010\u0002\u0005\t\u0006$X\rC\u0004\u0003x\"\u0002\rA!?\u0002\u0011A\fw-Z*ju\u0016\u0004BAa?\u0004\u00025\u0011!Q \u0006\u0005\u0005\u007f\u0014y(\u0001\u0003mC:<\u0017\u0002BB\u0002\u0005{\u0014q!\u00138uK\u001e,'\u000fK\u0002)\u0003[\u000ba$\u0019:dQ&4X-\u00117m\u0013:\u001cw.\\5oO\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0015\t\u0005\u000561\u0002\u0005\u0007\u0003SK\u0003\u0019A-)\u0007%\ni+\u0001\u0006hKR\fE\u000e\u001c+bON$Baa\u0005\u0004\u001aA)!\u0011PB\u000b3&!1q\u0003B>\u0005\r\u0019V\r\u001e\u0005\b\u00077Q\u0003\u0019\u0001Bf\u0003-a\u0017.\\5u\u001dVl'-\u001a:)\u0007)\ni\u000b\u0006\u0005\u0003x\r\u000521EB\u0014\u0011\u001d\u0011Ii\u000ba\u0001\u0005\u0017CqAa*,\u0001\u0004\u0019)\u0003E\u0003A\u0005W\u0012I\u000bC\u0004\u00032.\u0002\ra!\n\u0002!\u001d,GOU3mK\u0006\u001cXm\u00149uS>tGCBB\u0017\u0007_\u0019\t\u0004\u0005\u0003A\u0005W\n\u0006BBAUY\u0001\u0007\u0011\fC\u0005\u0002b2\u0002\n\u00111\u0001\u0002d\u0006Qr-\u001a;SK2,\u0017m]3PaRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0007\u0016\u0005\u0003G\u001cId\u000b\u0002\u0004<A!1QHB#\u001b\t\u0019yD\u0003\u0003\u0004B\r\r\u0013!C;oG\",7m[3e\u0015\r\tY)Q\u0005\u0005\u0007\u000f\u001ayDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabZ3u%\u0016dW-Y:f\u0013R,W.\u0006\u0003\u0004N\r]C\u0003BB(\u0007k\"Ba!\u0015\u0004jA)\u0001Ia\u001b\u0004TA!1QKB,\u0019\u0001!qa!\u0017/\u0005\u0004\u0019YFA\u0001U#\u0011\u0019ifa\u0019\u0011\u0007\u0001\u001by&C\u0002\u0004b\u0005\u0013qAT8uQ&tw\rE\u0002S\u0007KJ1aa\u001aT\u0005!\u0001F.\u00198Ji\u0016l\u0007bBB6]\u0001\u00071QN\u0001\bO\u0016$\u0018\n^3n!\u0019\u00015qN)\u0004t%\u00191\u0011O!\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0002!\u0004pe\u001b\u0019\u0006\u0003\u0004\u0004x9\u0002\r!W\u0001\u0007SR,W.\u00133\u0002#\u001d,GOV1sS\u0006\u0014G.Z(qi&|g\u000e\u0006\u0003\u0004~\r}\u0004#\u0002!\u0003l\t]\u0001B\u0002B\u0013_\u0001\u0007\u0011,\u0001\u0010be\u000eD\u0017N^3BY2|U\u000f^4pS:<G)\u001a9f]\u0012,gnY5fgR!1QQBG!\u0019\u0011YN!:\u0004\bB\u0019!k!#\n\u0007\r-5K\u0001\u0006EKB,g\u000eZ3oGfDa!!21\u0001\u0004\t\u0006fE\u0003\u0004\u0012\u000e}5\u0011UBS\u0007O\u001b\tla-\u0004>\u000e}\u0006\u0003BBJ\u00077k!a!&\u000b\t\u0005-5q\u0013\u0006\u0005\u00073\u000b)*A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BBO\u0007+\u0013Q\u0002\u0016:b]N\f7\r^5p]\u0006d\u0017!\u0002<bYV,\u0017EABR\u0003m\u0011X\r]8si&tw\r\u0016:b]N\f7\r^5p]6\u000bg.Y4fe\u0006Y\u0001O]8qC\u001e\fG/[8oI\t\u0019I+\u0003\u0003\u0004,\u000e5\u0016\u0001\u0003*F#VK%+\u0012#\u000b\t\r=6QS\u0001\f!J|\u0007/Y4bi&|g.A\u0005jg>d\u0017\r^5p]\u0012\u00121QW\u0005\u0005\u0007o\u001bI,\u0001\bS\u000b\u0006#ulQ(N\u001b&#F+\u0012#\u000b\t\rm6QS\u0001\n\u0013N|G.\u0019;j_:\f1B]8mY\n\f7m\u001b$pe2\u00121\u0011Y\u0012\u0003\u0007\u0007\u0004BAa7\u0004F&!1q\u0019Bu\u0005%!\u0006N]8xC\ndW\rK\u0002\u0006\u0007\u0017\u0004Ba!4\u0004T6\u00111q\u001a\u0006\u0005\u0007#\f)*\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAa!6\u0004P\n91+\u001a:wS\u000e,\u0007")
public class ArchivingService
implements Logging {
    private final ArchivedReleases archivedReleases;
    private final ArchivedReleasesSearch archivedReleasesSearch;
    private final ArchivedActivityLogsSerializer archivedActivityLogsSerializer;
    private final RepositoryAdapter repositoryAdapter;
    private final CompletedReleaseExportService completedReleasesExportService;
    private final ReleaseRepository releaseRepository;
    private final DependencyRepository dependencyRepository;
    private final ReleaseActorService releaseActorService;
    private final TeamRepository teamRepository;
    private final SecuredCis securedCis;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final CommentService commentService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public static String getMonthYear(DateTime dateTime) {
        return ArchivingService$.MODULE$.getMonthYear(dateTime);
    }

    public static Release deserializeArchivedRelease(String string, RepositoryAdapter repositoryAdapter) {
        return ArchivingService$.MODULE$.deserializeArchivedRelease(string, repositoryAdapter);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArchivingService archivingService = this;
        synchronized (archivingService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Timed
    public void archiveRelease(String releaseId) {
        Release release = (Release)this.repositoryAdapter.read(releaseId);
        if (release == null) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Release '").append(releaseId).append("' cannot be read from active database, not archiving.").toString());
            if (!this.releaseRepository.exists(releaseId) && this.existsPreArchived(releaseId)) {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Setting Release '").append(releaseId).append("' preArchived flag to false as it is no longer in the active database.").toString());
                this.archivedReleases().setPreArchived(releaseId, false);
            }
        } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ReleaseStatus.INACTIVE_STATUSES)).contains((Object)release.getStatus())) {
            if (this.existsPreArchived(releaseId)) {
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Archiving dependencies for '").append(releaseId).append("'").toString());
                this.releaseExtensionsRepository.decorate(release);
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)task -> {
                    this.commentService.decorate(task);
                    return BoxedUnit.UNIT;
                });
                java.util.List<Team> updatedTeams = this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId()));
                release.setTeams(updatedTeams);
                if (!release.isTutorial()) {
                    this.archiveAttachments(release);
                }
                this.archiveDependencies(release);
                this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Updating activity logs and releaseJson for '").append(releaseId).append("'").toString());
                String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
                String activityLogsJson = this.archivedActivityLogsSerializer.serializeActivityLogsOf(release.getId());
                if (!this.archivedReleases().update(releaseId, serializedRelease, activityLogsJson, false)) {
                    this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not update archived Release '").append(releaseId).append("'.").toString());
                } else {
                    this.archivedReleases().updateViewers(releaseId, (Seq<Team>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(updatedTeams).asScala()));
                }
                if (this.releaseRepository.exists(releaseId)) {
                    this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Deleting '").append(releaseId).append("' from active database").toString());
                    this.releaseRepository.delete(releaseId);
                }
            } else if (!release.isTutorial()) {
                throw new IllegalStateException("Only pre-archived releases can be archived");
            }
        } else {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Trying to pre-archive a release with invalid status ").append(release.getStatus()).toString());
            throw new IllegalStateException("Only inactive releases can be archived");
        }
    }

    private void archiveAttachments(Release release) {
        this.logger().trace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Archiving attachments for '").append(release.getId()).append("'").toString());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAttachments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)attachment -> {
            ArchivingService.$anonfun$archiveAttachments$2(this, release, attachment);
            return BoxedUnit.UNIT;
        });
    }

    private void archiveDependencies(Release release) {
        Seq<Dependency> archivedDependencies = this.archiveAllOutgoingDependencies(release);
        this.dependencyRepository.archive(release, archivedDependencies);
        this.archiveAllIncomingDependencies(release.getId());
    }

    @Timed
    public void preArchiveRelease(Release release) {
        if (this.existsPreArchived(release.getId())) {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append(release).append(" is already pre-archived, nothing to do").toString());
        } else {
            release.setTeams(this.teamRepository.getTeams(this.securedCis.getEffectiveSecuredCi(release.getId())));
            String serializedRelease = CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release, (ConfigurationItemConverter)new WriteWithoutPasswordCiConverter());
            if (!release.isTutorial()) {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("copying release ").append(release).append(" to archive database, marked as pre-archived").toString());
                this.archivedReleases().insert(release, serializedRelease, "", true);
                this.releaseRepository.setPreArchived(release.getId(), true);
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Running release ").append(release.getId()).append(" through export hooks").toString());
            } else {
                this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Deleting tutorial release ").append(release).append(" instead of pre-archiving").toString());
                this.releaseRepository.delete(release.getId());
            }
            this.completedReleasesExportService.sendThroughExportHooks(release, serializedRelease);
        }
    }

    public Release getRelease(String releaseId) {
        return this.getRelease(releaseId, false);
    }

    @Timed
    public Release getRelease(String releaseId, boolean includePreArchived) {
        return (Release)this.getReleaseOption(releaseId, includePreArchived).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public String getReleaseTitle(String releaseId) {
        return (String)this.archivedReleases().getReleaseTitle(releaseId, this.archivedReleases().getReleaseTitle$default$2()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(releaseId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Phase getPhase(String phaseId) {
        return (Phase)this.getReleaseItem(phaseId, (Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getPhase(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)phaseId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Task getTask(String taskId) {
        return (Task)this.getReleaseItem(taskId, (Function1 & Serializable & scala.Serializable)x$2 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$2.getTask(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)taskId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Variable getVariable(String variableId) {
        return (Variable)this.getVariableOption(variableId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(34).append("Could not find archived release [").append(Ids.releaseIdFrom((String)variableId)).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public boolean exists(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().exists(ciId) : (Ids.isPhaseId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$3.getPhase(x$1)).isDefined() : (Ids.isTaskId((String)ciId) ? this.getReleaseItem(ciId, (Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$4.getTask(x$1)).isDefined() : (Ids.isVariableId((String)ciId) ? this.getVariableOption(ciId).isDefined() : false)));
    }

    @Timed
    public boolean existsPreArchived(String ciId) {
        return Ids.isReleaseId((String)ciId) ? this.archivedReleases().existsPreArchived(ciId) : false;
    }

    @Timed
    public boolean existsByName(String releaseName) {
        return this.archivedReleases().existsByName(releaseName);
    }

    @Timed
    public void checkNotArchived(String ciId) {
        if (this.archivedReleases().exists(Ids.releaseIdFrom((String)ciId))) {
            throw new Checks.IncorrectArgumentException(new StringBuilder(56).append("You cannot perform this operation on archived release [").append(Ids.releaseIdFrom((String)ciId)).append("]").toString(), new Object[0]);
        }
    }

    @Timed
    public boolean attachmentExists(String attachmentId) {
        return this.archivedReleases().attachmentExists(attachmentId);
    }

    @Timed
    public Attachment getAttachment(String attachmentId) {
        return (Attachment)this.getAttachmentOption(attachmentId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(37).append("Could not find archived attachment [").append(attachmentId).append("]").toString(), new Object[0]);
        });
    }

    @Timed
    public Option<Attachment> getAttachmentOption(String attachmentId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)attachmentId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> Option$.MODULE$.apply((Object)release.getAttachment(attachmentId)).flatMap((Function1 & Serializable & scala.Serializable)attachment -> this.archivedReleases().getAttachment(attachmentId).map((Function1 & Serializable & scala.Serializable)overthereFile -> {
            attachment.setFile(overthereFile);
            return attachment;
        })));
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters) {
        return this.searchReleases(filters, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    @Timed
    public java.util.List<Release> searchReleases(ReleasesFilters filters, long limit, long offset) {
        return this.searchReleases(filters, (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)));
    }

    @Timed
    public Map<ReleaseStatus, Object> countReleasesByStatus(ReleasesFilters filters) {
        return this.archivedReleasesSearch.countReleasesByStatus(filters);
    }

    @Timed
    public Seq<String> findArchivableReleaseIds(Date date, Integer pageSize) {
        return this.archivedReleases().findArchivableReleaseIds(date, Predef$.MODULE$.Integer2int(pageSize));
    }

    @Timed
    public void archiveAllIncomingDependencies(String releaseId) {
        Seq<Dependency> incomingDependencies = this.dependencyRepository.findAllIncomingDependencies((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{releaseId}))), (Seq<String>)((Seq)Seq$.MODULE$.empty()), true);
        incomingDependencies.groupBy((Function1 & Serializable & scala.Serializable)d -> Ids.normalizeId((String)Ids.releaseIdFrom((String)d.getId()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArchivingService.$anonfun$archiveAllIncomingDependencies$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.archivedReleases().findAllTags(limitNumber)).asJava();
    }

    private java.util.List<Release> searchReleases(ReleasesFilters filters, Option<Object> limit, Option<Object> offset) {
        List<String> releaseJsons = this.archivedReleasesSearch.searchReleases(filters, limit, offset);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)releaseJsons.map((Function1 & Serializable & scala.Serializable)json -> ArchivingService$.MODULE$.deserializeArchivedRelease((String)json, $this.repositoryAdapter), List$.MODULE$.canBuildFrom())).asJava();
    }

    private Option<Release> getReleaseOption(String releaseId, boolean includePreArchived) {
        return this.archivedReleases().getRelease(releaseId, includePreArchived).map((Function1 & Serializable & scala.Serializable)releaseJson -> {
            void var3_3;
            Release release = ArchivingService$.MODULE$.deserializeArchivedRelease((String)releaseJson, $this.repositoryAdapter);
            Map<String, String> attachmentsFileNames = this.archivedReleases().getAttachmentsFileNames(release.getId());
            release.getAttachments().forEach(attachment -> {
                Option option = attachmentsFileNames.get((Object)ArchivedReleases$.MODULE$.shortenId(attachment.getId()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String filename = (String)some.value();
                    attachment.setFile((OverthereFile)SourceArtifactFile.withNullableWorkDir((String)filename, (SourceArtifact)attachment, null));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Could not find attachment ").append(attachment.getId()).append(" of release ").append(releaseId).append(" in the attachments table").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option);
                }
            });
            return var3_3;
        });
    }

    private boolean getReleaseOption$default$2() {
        return false;
    }

    private <T extends PlanItem> Option<T> getReleaseItem(String itemId, Function1<Release, Function1<String, T>> getItem) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)itemId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)r -> Option$.MODULE$.apply(((Function1)getItem.apply(r)).apply((Object)itemId)));
    }

    private Option<Variable> getVariableOption(String variableId) {
        return this.getReleaseOption(Ids.releaseIdFrom((String)variableId), this.getReleaseOption$default$2()).flatMap((Function1 & Serializable & scala.Serializable)release -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getVariables()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$getVariableOption$2(variableId, x$6))));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Dependency> archiveAllOutgoingDependencies(Release release) {
        void var2_2;
        Buffer dependencies = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(release.getAllGates()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getDependencies()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ArchivingService.$anonfun$archiveAllOutgoingDependencies$2(x$8)));
        dependencies.foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.archive();
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$4(ArchivingService $this, Release release$2, Attachment attachment$1, WorkDir workDir$1, InputStream data) {
        try {
            $this.archivedReleases().insertAttachment(release$2.getId(), new ArchivedReleases.AttachmentInfo(attachment$1.getId(), attachment$1.getFile().getName(), data));
        }
        finally {
            data.close();
            workDir$1.delete();
            WorkDirContext.clear();
        }
    }

    public static final /* synthetic */ void $anonfun$archiveAttachments$2(ArchivingService $this, Release release$2, Attachment attachment) {
        WorkDirContext.initWorkdir();
        WorkDir workDir = WorkDirContext.get();
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> attachment.getFile().getInputStream()).foreach((Function1 & Serializable & scala.Serializable)data -> {
            ArchivingService.$anonfun$archiveAttachments$4($this, release$2, attachment, workDir, data);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$archiveAllIncomingDependencies$2(ArchivingService $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String referencingReleaseId = (String)tuple2._1();
        Seq rawDependenciesToArchive = (Seq)tuple2._2();
        $this.releaseActorService.archiveDependencies(referencingReleaseId, (Seq<String>)((Seq)rawDependenciesToArchive.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Seq$.MODULE$.canBuildFrom())));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableOption$2(String variableId$2, Variable x$6) {
        String string = x$6.getId();
        String string2 = variableId$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$archiveAllOutgoingDependencies$2(Dependency x$8) {
        return !x$8.isArchived();
    }

    @Autowired
    public ArchivingService(ArchivedReleases archivedReleases, ArchivedReleasesSearch archivedReleasesSearch, ArchivedActivityLogsSerializer archivedActivityLogsSerializer, RepositoryAdapter repositoryAdapter, CompletedReleaseExportService completedReleasesExportService, ReleaseRepository releaseRepository, DependencyRepository dependencyRepository, ReleaseActorService releaseActorService, TeamRepository teamRepository, SecuredCis securedCis, ReleaseExtensionsRepository releaseExtensionsRepository, CommentService commentService) {
        this.archivedReleases = archivedReleases;
        this.archivedReleasesSearch = archivedReleasesSearch;
        this.archivedActivityLogsSerializer = archivedActivityLogsSerializer;
        this.repositoryAdapter = repositoryAdapter;
        this.completedReleasesExportService = completedReleasesExportService;
        this.releaseRepository = releaseRepository;
        this.dependencyRepository = dependencyRepository;
        this.releaseActorService = releaseActorService;
        this.teamRepository = teamRepository;
        this.securedCis = securedCis;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.commentService = commentService;
        Logging.$init$((Logging)this);
    }
}

