/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperations;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.script.ScriptVariableProcessorFactory;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.utils.Collectors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ScriptVariables {
    private VariableService variableService;
    private PasswordEncrypter passwordEncrypter;
    private CiIdService ciIdService;
    private XLReleaseEventBus eventBus;

    ScriptVariables(VariableService variableService, PasswordEncrypter passwordEncrypter, CiIdService ciIdService, XLReleaseEventBus eventBus) {
        this.variableService = variableService;
        this.passwordEncrypter = passwordEncrypter;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
    }

    Map<String, Variable> initialReleaseVariables(Release release) {
        return this.encryptAndNormalize(this.cloneReleaseVariables(release));
    }

    Map<String, Variable> initialGlobalVariables() {
        return this.encryptAndNormalize(this.cloneGlobalVariables());
    }

    Map<String, Object> releaseVariables(Release release) {
        return this.toVariableValues(this.cloneReleaseVariables(release));
    }

    Map<String, Object> globalVariables() {
        return this.toVariableValues(this.cloneGlobalVariables());
    }

    VariablesChanges detectReleaseVariablesChanges(Task task, DefaultScriptService.ScriptTaskResults scriptTaskResults) {
        Map<String, Object> releaseVariables = scriptTaskResults.getReleaseVariables();
        Map<String, Variable> previousReleaseVariables = scriptTaskResults.getInitialReleaseVariables();
        return ScriptVariableProcessorFactory.releaseVariableProcessor(this.ciIdService, task.getRelease()).processVariablesAndUpdateInContainer(releaseVariables, previousReleaseVariables);
    }

    VariablesChanges detectGlobalVariablesChanges(Task task, DefaultScriptService.ScriptTaskResults scriptTaskResults) {
        Map<String, Object> globalVariables = scriptTaskResults.getGlobalVariables();
        Map<String, Variable> previousGlobalVariables = scriptTaskResults.getInitialGlobalVariables();
        return ScriptVariableProcessorFactory.globalVariablesProcessor(this.ciIdService, task, this.variableService.findGlobalVariablesOrEmpty()).processVariablesAndUpdateInContainer(globalVariables, previousGlobalVariables);
    }

    void processReleaseVariablesChanges(Release release, VariablesChanges releaseVariablesChanges) {
        ArrayList<Variable> updatedList = new ArrayList<Variable>(release.getVariables());
        updatedList.removeAll(releaseVariablesChanges.deletedVariables);
        releaseVariablesChanges.updatedVariables.forEach(updated -> {
            int index = updatedList.indexOf(updated);
            if (index >= 0) {
                updatedList.set(index, (Variable)updated);
            }
        });
        updatedList.addAll(releaseVariablesChanges.createdVariables);
        this.variableService.updateReleaseVariables(release, updatedList);
    }

    void processGlobalVariablesChanges(VariablesChanges globalVariablesChanges) {
        globalVariablesChanges.deletedVariables.forEach(v -> this.variableService.deleteGlobalVariable(v.getId()));
        globalVariablesChanges.createdVariables.forEach(this.variableService::addGlobalVariable);
        globalVariablesChanges.updatedVariables.forEach(this.variableService::updateGlobalVariable);
        XLReleaseOperations.publishEvents(globalVariablesChanges.operations, this.eventBus);
    }

    private Map<String, Variable> cloneGlobalVariables() {
        Map previousGlobalVariables = this.variableService.findGlobalVariablesOrEmpty().getVariablesByKeys();
        this.cloneVariableValue(previousGlobalVariables);
        return previousGlobalVariables;
    }

    private Map<String, Variable> cloneReleaseVariables(Release release) {
        Map previousReleaseVariables = release.getVariablesByKeys();
        this.cloneVariableValue(previousReleaseVariables);
        return previousReleaseVariables;
    }

    private void cloneVariableValue(Map<String, Variable> variablesMap) {
        variablesMap.entrySet().forEach(entry -> {
            CiHelper.eraseTokens((ConfigurationItem)((ConfigurationItem)entry.getValue()));
            entry.setValue(CiCloneHelper.cloneCi((ConfigurationItem)entry.getValue()));
        });
    }

    private Map<String, Variable> encryptAndNormalize(Map<String, Variable> variables) {
        return (Map)variables.entrySet().stream().map(this::encryptPasswords).map(this::normalizeEmptyValues).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Object> toVariableValues(Map<String, Variable> variables) {
        return (Map)this.encryptAndNormalize(variables).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Variable)entry.getValue()).getValue()));
    }

    private Map.Entry<String, Variable> encryptPasswords(Map.Entry<String, Variable> entry) {
        entry.setValue(this.encryptPassword(entry.getValue()));
        return entry;
    }

    private Map.Entry<String, Variable> normalizeEmptyValues(Map.Entry<String, Variable> entry) {
        Variable v = entry.getValue();
        v.setUntypedValue(Optional.ofNullable(v.getValue()).orElse(v.getEmptyValue()));
        return entry;
    }

    private Variable encryptPassword(Variable variable) {
        if (variable.isPassword() && !variable.isValueEmpty() && !this.passwordEncrypter.isEncrypted(variable.getValueAsString())) {
            variable.setUntypedValue((Object)this.passwordEncrypter.encrypt(variable.getValueAsString()));
        }
        return variable;
    }

    public static class VariablesChanges {
        List<Variable> createdVariables = new ArrayList<Variable>();
        List<Variable> updatedVariables = new ArrayList<Variable>();
        List<Variable> deletedVariables = new ArrayList<Variable>();
        Map<String, Variable> updatedVariablesMap = new HashMap<String, Variable>();
        List<XLReleaseOperation> operations = new ArrayList<XLReleaseOperation>();
    }
}

