/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.GlobalVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.GlobalVariableCreateOperation;
import com.xebialabs.xlrelease.events.GlobalVariableDeleteOperation;
import com.xebialabs.xlrelease.events.GlobalVariableUpdateOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableCreateOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableDeleteOperation;
import com.xebialabs.xlrelease.events.ReleaseVariableUpdateOperation;
import com.xebialabs.xlrelease.events.VariableCreateOperation;
import com.xebialabs.xlrelease.events.VariableDeleteOperation;
import com.xebialabs.xlrelease.events.VariableUpdateOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.script.ScriptVariables;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.utils.Collectors;
import com.xebialabs.xlrelease.variable.VariableFactory;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

abstract class ScriptVariableProcessorFactory {
    ScriptVariableProcessorFactory() {
    }

    static ScriptVariableProcessorFactory globalVariablesProcessor(CiIdService ciIdService, Task task, GlobalVariables globals) {
        return new GlobalVariablesProcessor(ciIdService, task, globals);
    }

    static ScriptVariableProcessorFactory releaseVariableProcessor(CiIdService ciIdService, Release release) {
        return new ReleaseVariablesProcessor(ciIdService, release);
    }

    ScriptVariables.VariablesChanges processVariablesAndUpdateInContainer(Map<String, Object> contextVariables, Map<String, Variable> initialVariables) {
        ScriptVariables.VariablesChanges changes = new ScriptVariables.VariablesChanges();
        Map initialVariableValues = (Map)initialVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable(((Variable)e.getValue()).getValue()).orElse(((Variable)e.getValue()).getEmptyValue())));
        MapDifference difference = Maps.difference(contextVariables, (Map)initialVariableValues);
        difference.entriesInCommon().keySet().forEach(key -> changes.updatedVariablesMap.put((String)key, (Variable)initialVariables.get(key)));
        for (Map.Entry createdVariable : difference.entriesOnlyOnLeft().entrySet()) {
            Variable addedVariable = this.newVariable((String)createdVariable.getKey(), createdVariable.getValue());
            changes.operations.add((XLReleaseOperation)this.createOperation(addedVariable));
            changes.createdVariables.add(addedVariable);
            changes.updatedVariablesMap.put((String)createdVariable.getKey(), addedVariable);
        }
        for (Map.Entry deletedVariable : difference.entriesOnlyOnRight().entrySet()) {
            Variable variable = initialVariables.get(VariableHelper.withoutVariableSyntax((String)((String)deletedVariable.getKey())));
            changes.operations.add((XLReleaseOperation)this.deleteOperation(variable));
            changes.deletedVariables.add(variable);
        }
        for (Map.Entry updatedVariable : difference.entriesDiffering().entrySet()) {
            Object newValue = ((MapDifference.ValueDifference)updatedVariable.getValue()).leftValue();
            Variable variable = initialVariables.get(VariableHelper.withoutVariableSyntax((String)((String)updatedVariable.getKey())));
            Variable original = CiCloneHelper.cloneCi(variable);
            variable.setUntypedValue(newValue);
            changes.operations.add((XLReleaseOperation)this.updateOperation(original, variable));
            changes.updatedVariables.add(variable);
            changes.updatedVariablesMap.put((String)updatedVariable.getKey(), variable);
        }
        return changes;
    }

    abstract Variable newVariable(String var1, Object var2);

    abstract VariableUpdateOperation updateOperation(Variable var1, Variable var2);

    abstract VariableCreateOperation createOperation(Variable var1);

    abstract VariableDeleteOperation deleteOperation(Variable var1);

    private static class GlobalVariablesProcessor
    extends ScriptVariableProcessorFactory {
        private CiIdService ciIdService;
        private String taskId;
        private GlobalVariables globalVariables;

        GlobalVariablesProcessor(CiIdService ciIdService, Task task, GlobalVariables globalVariables) {
            this.ciIdService = ciIdService;
            this.globalVariables = globalVariables;
            this.taskId = task.getId();
        }

        @Override
        Variable newVariable(String key, Object value) {
            Variable variable = this.globalVariables.addVariable(VariableFactory.createVariableByValueType((String)key, (Object)value, (boolean)false, (boolean)true));
            VariablePersistenceHelper.fixUpVariableIds(this.globalVariables.getId(), this.globalVariables.getVariables(), this.ciIdService);
            return variable;
        }

        @Override
        VariableUpdateOperation updateOperation(Variable original, Variable updated) {
            return new GlobalVariableUpdateOperation(original, updated, this.taskId);
        }

        @Override
        VariableCreateOperation createOperation(Variable newVariable) {
            return new GlobalVariableCreateOperation(newVariable, this.taskId);
        }

        @Override
        VariableDeleteOperation deleteOperation(Variable deletedVariable) {
            return new GlobalVariableDeleteOperation(deletedVariable, this.taskId);
        }
    }

    private static class ReleaseVariablesProcessor
    extends ScriptVariableProcessorFactory {
        private CiIdService ciIdService;
        private Release release;

        ReleaseVariablesProcessor(CiIdService ciIdService, Release release) {
            this.ciIdService = ciIdService;
            this.release = release;
        }

        @Override
        Variable newVariable(String key, Object value) {
            Variable variable = VariableFactory.createVariableByValueType((String)key, (Object)value, (boolean)false, (boolean)false);
            this.release.checkVariableCanBeAdded(variable);
            VariablePersistenceHelper.fixUpVariableIds(this.release.getId(), Collections.singletonList(variable), this.ciIdService);
            return variable;
        }

        @Override
        VariableUpdateOperation updateOperation(Variable original, Variable updated) {
            return new ReleaseVariableUpdateOperation(original, updated);
        }

        @Override
        VariableCreateOperation createOperation(Variable newVariable) {
            return new ReleaseVariableCreateOperation(newVariable);
        }

        @Override
        VariableDeleteOperation deleteOperation(Variable deletedVariable) {
            return new ReleaseVariableDeleteOperation(deletedVariable);
        }
    }
}

