/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.io.Resources;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.script.Jsr223EngineFactory;
import com.xebialabs.xlrelease.script.ScriptExecutor;
import com.xebialabs.xlrelease.script.ScriptPermissionsProvider;
import com.xebialabs.xlrelease.script.jython.SandboxAwarePackageManager;
import com.xebialabs.xlrelease.script.security.RuntimePermission;
import com.xebialabs.xlrelease.script.security.ScriptCodeSource;
import com.xebialabs.xlrelease.script.security.ScriptPermissions;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Jsr223ScriptExecutor
implements ScriptExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ScriptEngine unrestrictedEngine;
    protected ScriptEngine restrictedEngine;
    protected ScriptPermissionsProvider scriptPermissionsProvider;
    protected XlrConfig xlrConfig;

    public Jsr223ScriptExecutor(Jsr223EngineFactory engineFactory, ScriptPermissionsProvider scriptPermissionsProvider, XlrConfig xlrConfig) {
        this.unrestrictedEngine = engineFactory.getScriptEngine(false);
        this.restrictedEngine = engineFactory.getScriptEngine(true);
        this.scriptPermissionsProvider = scriptPermissionsProvider;
        this.xlrConfig = xlrConfig;
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext) throws Exception {
        return this.evalScript(script, scriptContext, true);
    }

    @Override
    public Object evalScriptWithApi(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScript(script, scriptContext, checkPolicyPermissions);
    }

    @Override
    public Object evalScript(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) throws Exception {
        return this.evalScriptPrivileged(script, scriptContext, checkPolicyPermissions ? this.getAccessControlContext() : null);
    }

    protected abstract Object evalScriptPrivileged(String var1, ScriptContext var2, AccessControlContext var3) throws Exception;

    protected Object doPrivileged(String script, ScriptContext scriptContext, AccessControlContext accessControlContext) throws Exception {
        try {
            ScriptEngine engine = this.configureSandboxAndGetEngine(accessControlContext != null);
            Object object = AccessController.doPrivileged(() -> engine.eval(script.intern(), scriptContext), accessControlContext);
            return object;
        }
        catch (PrivilegedActionException exceptionWrapper) {
            this.logger.debug("PrivilegedActionException: ", (Throwable)exceptionWrapper);
            throw exceptionWrapper.getException();
        }
        finally {
            SandboxAwarePackageManager.setSandboxed(false);
        }
    }

    protected void loadAndEval(String resourcePath, ScriptContext scriptContext, boolean checkPolicyPermissions) {
        String script = this.loadScript(resourcePath);
        this.evalUtilityScript(script, scriptContext, checkPolicyPermissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalUtilityScript(String script, ScriptContext scriptContext, boolean checkPolicyPermissions) {
        try {
            this.configureSandboxAndGetEngine(checkPolicyPermissions).eval(script, scriptContext);
        }
        catch (ScriptException e) {
            this.logger.warn("Unable to evaluate utility script '{}'", (Object)script, (Object)e);
        }
        finally {
            SandboxAwarePackageManager.setSandboxed(false);
        }
    }

    private String loadScript(String resourcePath) {
        try {
            URL resourceUrl = Resources.getResource((String)resourcePath);
            return Resources.toString((URL)resourceUrl, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to load %s", resourcePath), e);
        }
    }

    protected AccessControlContext getAccessControlContext() {
        ProtectionDomain domain = new ProtectionDomain(new ScriptCodeSource(), this.extendsMinimalPermissionsWith(this.scriptPermissionsProvider.getScriptPermissions()));
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new PropertyPermission("line.separator", "read"));
        minimalPermissions.add(new PropertyPermission("file.encoding", "read"));
        minimalPermissions.add(new java.lang.RuntimePermission("createClassLoader"));
        minimalPermissions.add(new java.lang.RuntimePermission("getProtectionDomain"));
        minimalPermissions.add(new java.lang.RuntimePermission("getClassLoader"));
        minimalPermissions.add(new SecurityPermission("insertProvider.BC"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.util.calendar"));
        this.addSandboxPermissions(minimalPermissions);
        this.addInternalAccessPermissions(minimalPermissions);
        this.addJythonLibrariesReadPermission(minimalPermissions);
        this.addJsonSmartLibraryPermissions(minimalPermissions);
        this.addOvertherePermissions(minimalPermissions);
        this.addWorkDirPermissions(minimalPermissions);
        this.addJavaHomeSecurityLibPermissions(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                Permission permission = this.resolvePermissionIfNecessary(permissionEnumeration.nextElement());
                minimalPermissions.add(permission);
            }
        }
        return minimalPermissions;
    }

    private void addSandboxPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.security.Permissions"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.dsl"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.dsl.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.deployit.plugin.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.api"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.api.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.configuration"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.risk.configuration.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.repository.PhaseVersion"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.views.ImportResult"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugins.dashboard.domain"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugins.dashboard.domain.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("javax.ws.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ArithmeticException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ArrayIndexOutOfBoundsException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Boolean"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Byte"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Character"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.CharSequence"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Cloneable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Comparable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Double"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Enum"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Error"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Exception"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Float"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.FunctionalInterface"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalAccessException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalArgumentException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IllegalStateException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.IndexOutOfBoundsException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Integer"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.InterruptedException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Iterable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Long"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Math"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.NullPointerException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Number"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.NumberFormatException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Object"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Runnable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.RuntimeException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Short"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.String"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.StringBuffer"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.StringBuilder"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.SecurityException"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.System"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Throwable"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.Void"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.text"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.text.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.time"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.time.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.net"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.net.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.math"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.math.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.util"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.util.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.sql"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.sql.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ref"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.lang.ref.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.io"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("java.io.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("groovy.lang.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.codehaus.groovy.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("scala.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("org.slf4j.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("ch.qos.logback.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("default.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin.webhook"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xebialabs.xlrelease.plugin.webhook.*"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus.jyson"));
        minimalPermissions.add(ScriptPermissions.grantedClassAccess("com.xhaus.jyson.*"));
    }

    private void addInternalAccessPermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new AuthPermission("modifyPrincipals"));
        minimalPermissions.add(new AuthPermission("modifyPublicCredentials"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessDeclaredMembers"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessUserInformation"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.security.util"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.security.x509"));
        minimalPermissions.add(new ReflectPermission("suppressAccessChecks"));
        minimalPermissions.add(new java.lang.RuntimePermission("accessClassInPackage.sun.reflect"));
    }

    private void addOvertherePermissions(Permissions minimalPermissions) {
        minimalPermissions.add(new NetPermission("specifyStreamHandler"));
        minimalPermissions.add(new PropertyPermission("jcifs.properties", "read"));
    }

    private void addJythonLibrariesReadPermission(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("jython-standalone", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("os.name", "read"));
        minimalPermissions.add(new PropertyPermission("os.arch", "read"));
    }

    private void addJsonSmartLibraryPermissions(Permissions minimalPermissions) {
        this.addReadPermissionOnJar("json-smart", minimalPermissions);
        minimalPermissions.add(new PropertyPermission("JSON_SMART_SIMPLE", "read"));
    }

    private void addWorkDirPermissions(Permissions minimalPermissions) {
        String userDir = System.getProperty("user.dir");
        String workdirPath = Paths.get(userDir, this.xlrConfig.repository().workDir()).toString();
        minimalPermissions.add(new FilePermission(workdirPath + File.separator + "-", "delete"));
    }

    private void addJavaHomeSecurityLibPermissions(Permissions minimalPermissions) {
        String javaHome = System.getProperty("java.home");
        String javaHomePath = Paths.get(javaHome, new String[0]).toString();
        String libSecurityPath = Stream.of(javaHomePath, "lib", "security", "-").collect(Collectors.joining(File.separator));
        minimalPermissions.add(new FilePermission(libSecurityPath, "read"));
    }

    private void addReadPermissionOnJar(String jarName, Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*" + jarName + "[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            String group = matcher.group();
            minimalPermissions.add(new FilePermission(group, "read"));
            this.logger.debug("Minimal permission added on: {}", (Object)group);
        }
    }

    private Permission resolvePermissionIfNecessary(Permission permission) {
        if (permission instanceof UnresolvedPermission) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)permission;
            if (RuntimePermission.class.getName().equals(unresolvedPermission.getUnresolvedType())) {
                return new RuntimePermission(unresolvedPermission.getUnresolvedName(), unresolvedPermission.getUnresolvedActions());
            }
        }
        return permission;
    }

    protected ScriptEngine configureSandboxAndGetEngine(boolean checkPolicyPermissions) {
        SandboxAwarePackageManager.setSandboxed(this.isRestricted(checkPolicyPermissions));
        if (this.isRestricted(checkPolicyPermissions)) {
            return this.restrictedEngine;
        }
        return this.unrestrictedEngine;
    }

    protected boolean isRestricted(boolean checkPolicyPermissions) {
        return checkPolicyPermissions && this.xlrConfig.isScriptSandboxEnabled() && System.getSecurityManager() != null;
    }
}

