/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.est.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.python.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.python.bouncycastle.asn1.x500.RDN;
import org.python.bouncycastle.asn1.x500.X500Name;
import org.python.bouncycastle.asn1.x500.style.BCStyle;
import org.python.bouncycastle.est.ESTException;
import org.python.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import org.python.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsseDefaultHostnameAuthorizer
implements JsseHostnameAuthorizer {
    private final Set<String> knownSuffixes;

    public JsseDefaultHostnameAuthorizer(Set<String> set) {
        this.knownSuffixes = set;
    }

    @Override
    public boolean verified(String string2, SSLSession sSLSession) throws IOException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(sSLSession.getPeerCertificates()[0].getEncoded()));
            return this.verify(string2, x509Certificate);
        }
        catch (Exception exception) {
            if (exception instanceof ESTException) {
                throw (ESTException)exception;
            }
            throw new ESTException(exception.getMessage(), exception);
        }
    }

    public boolean verify(String string2, X509Certificate x509Certificate) throws IOException {
        RDN[] rDNArray;
        try {
            rDNArray = x509Certificate.getSubjectAlternativeNames();
            if (rDNArray != null) {
                block6: for (List<?> list : rDNArray) {
                    switch (((Number)list.get(0)).intValue()) {
                        case 2: {
                            if (!JsseDefaultHostnameAuthorizer.isValidNameMatch(string2, list.get(1).toString(), this.knownSuffixes)) continue block6;
                            return true;
                        }
                        case 7: {
                            if (!InetAddress.getByName(string2).equals(InetAddress.getByName(list.get(1).toString()))) continue block6;
                            return true;
                        }
                    }
                    throw new RuntimeException("Unable to handle ");
                }
                return false;
            }
        }
        catch (Exception exception) {
            throw new ESTException(exception.getMessage(), exception);
        }
        if (x509Certificate.getSubjectX500Principal() == null) {
            return false;
        }
        rDNArray = X500Name.getInstance(x509Certificate.getSubjectX500Principal().getEncoded()).getRDNs();
        for (int i = 0; i != rDNArray.length; ++i) {
            RDN rDN = rDNArray[i];
            AttributeTypeAndValue[] attributeTypeAndValueArray = rDN.getTypesAndValues();
            for (int j = 0; j != attributeTypeAndValueArray.length; ++j) {
                AttributeTypeAndValue attributeTypeAndValue = attributeTypeAndValueArray[j];
                if (!attributeTypeAndValue.getType().equals(BCStyle.CN)) continue;
                return JsseDefaultHostnameAuthorizer.isValidNameMatch(string2, rDN.getFirst().getValue().toString(), this.knownSuffixes);
            }
        }
        return false;
    }

    public static boolean isValidNameMatch(String string2, String string3, Set<String> set) throws IOException {
        if (string3.contains("*")) {
            int n = string3.indexOf(42);
            if (n == string3.lastIndexOf("*")) {
                if (string3.contains("..") || string3.charAt(string3.length() - 1) == '*') {
                    return false;
                }
                int n2 = string3.indexOf(46, n);
                if (set != null && set.contains(Strings.toLowerCase(string3.substring(n2)))) {
                    throw new IOException("Wildcard `" + string3 + "` matches known public suffix.");
                }
                String string4 = Strings.toLowerCase(string3.substring(n + 1));
                String string5 = Strings.toLowerCase(string2);
                if (string5.equals(string4)) {
                    return false;
                }
                if (string4.length() > string5.length()) {
                    return false;
                }
                if (n > 0) {
                    if (string5.startsWith(string3.substring(0, n - 1)) && string5.endsWith(string4)) {
                        return string5.substring(n, string5.length() - string4.length()).indexOf(46) < 0;
                    }
                    return false;
                }
                String string6 = string5.substring(0, string5.length() - string4.length());
                if (string6.indexOf(46) > 0) {
                    return false;
                }
                return string5.endsWith(string4);
            }
            return false;
        }
        return string2.equalsIgnoreCase(string3);
    }
}

