/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.dashboard.api.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.plugins.dashboard.domain.TileScope;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardSecurity;
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardService;
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView;
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView$;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@Path(value="/dashboards")
@Controller
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001E\u0011\u0011\u0003R1tQ\n|\u0017M\u001d3SKN|WO]2f\u0015\t\u0019A!\u0001\u0005j]R,'O\\1m\u0015\t)a!A\u0002ba&T!a\u0002\u0005\u0002\u0013\u0011\f7\u000f\u001b2pCJ$'BA\u0005\u000b\u0003\u001d\u0001H.^4j]NT!a\u0003\u0007\u0002\u0013ad'/\u001a7fCN,'BA\u0007\u000f\u0003%AXMY5bY\u0006\u00147OC\u0001\u0010\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\u0005\t3\u0001\u0011)\u0019!C\u00015\u0005\u0001B-Y:iE>\f'\u000fZ*feZL7-Z\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011aDB\u0001\bg\u0016\u0014h/[2f\u0013\t\u0001SD\u0001\tECND'm\\1sIN+'O^5dK\"A!\u0005\u0001B\u0001B\u0003%1$A\teCND'm\\1sIN+'O^5dK\u0002B\u0001\u0002\n\u0001\u0003\u0006\u0004%\t!J\u0001\u0012I\u0006\u001c\bNY8be\u0012\u001cVmY;sSRLX#\u0001\u0014\u0011\u0005q9\u0013B\u0001\u0015\u001e\u0005E!\u0015m\u001d5c_\u0006\u0014HmU3dkJLG/\u001f\u0005\tU\u0001\u0011\t\u0011)A\u0005M\u0005\u0011B-Y:iE>\f'\u000fZ*fGV\u0014\u0018\u000e^=!\u0011!a\u0003A!b\u0001\n\u0007i\u0013aF2p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u000b\u0003)\u0011X\r]8tSR|'/_\u0005\u0003gA\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\t\u0011U\u0002!\u0011!Q\u0001\n9\n\u0001dY8oM&<WO]1uS>t'+\u001a9pg&$xN]=!\u0011!9\u0004A!b\u0001\n\u0007A\u0014\u0001D8cU\u0016\u001cG/T1qa\u0016\u0014X#A\u001d\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005yz\u0014a\u00026bG.\u001cxN\u001c\u0006\u0003\u0001:\t\u0011BZ1ti\u0016\u0014\b0\u001c7\n\u0005\t[$\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\b\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u001b=\u0014'.Z2u\u001b\u0006\u0004\b/\u001a:!\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0019a\u0014N\\5u}Q)\u0001JS&M\u001bB\u0011\u0011\nA\u0007\u0002\u0005!)\u0011$\u0012a\u00017!)A%\u0012a\u0001M!)A&\u0012a\u0002]!)q'\u0012a\u0002s!\u0012Qi\u0014\t\u0003!nk\u0011!\u0015\u0006\u0003%N\u000b!\"\u00198o_R\fG/[8o\u0015\t!V+A\u0004gC\u000e$xN]=\u000b\u0005Y;\u0016!\u00022fC:\u001c(B\u0001-Z\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"\u0001.\u0002\u0007=\u0014x-\u0003\u0002]#\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006=\u0002!\taX\u0001\u0007g\u0016\f'o\u00195\u0015\t\u0001t\u0017\u0011\u0003\t\u0004C\u001aDW\"\u00012\u000b\u0005\r$\u0017\u0001B;uS2T\u0011!Z\u0001\u0005U\u00064\u0018-\u0003\u0002hE\n!A*[:u!\tIG.D\u0001k\u0015\tYg!A\u0003wS\u0016<8/\u0003\u0002nU\niA)Y:iE>\f'\u000f\u001a,jK^DQa\\/A\u0002A\f\u0001\u0002]1sK:$\u0018\n\u001a\t\u0003cbt!A\u001d<\u0011\u0005M$R\"\u0001;\u000b\u0005U\u0004\u0012A\u0002\u001fs_>$h(\u0003\u0002x)\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9H\u0003\u000b\u0004oy\u00065\u0011q\u0002\t\u0004{\u0006%Q\"\u0001@\u000b\u0007}\f\t!\u0001\u0002sg*!\u00111AA\u0003\u0003\t98O\u0003\u0002\u0002\b\u0005)!.\u0019<bq&\u0019\u00111\u0002@\u0003\u0015E+XM]=QCJ\fW.A\u0003wC2,X-I\u0001p\u0011\u0019\t\u0019\"\u0018a\u0001a\u0006)A/\u001b;mK\":\u0011\u0011\u0003?\u0002\u000e\u0005]\u0011EAA\nQ\ri\u00161\u0004\t\u0004{\u0006u\u0011bAA\u0010}\n\u0019q)\u0012+\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005aq-\u001a;ECND'm\\1sIR\u0019\u0001.a\n\t\u000f\u0005%\u0012\u0011\u0005a\u0001a\u0006YA-Y:iE>\f'\u000fZ%eQ!\t9#!\f\u0002\u000e\u0005M\u0002cA?\u00020%\u0019\u0011\u0011\u0007@\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017EAA\u0015Q!\t\t#a\u000e\u0002\u000e\u0005u\u0002cA?\u0002:%\u0019\u00111\b@\u0003\tA\u000bG\u000f[\u0011\u0003\u0003\u007f\taf\u001f3bg\"\u0014w.\u0019:e\u0013\u0012T\u0014\t\u001d9mS\u000e\fG/[8og:RCP\f\u0016ECND'm\\1sInsv&L/+{\"\"\u0011\u0011EA\u000e\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nq\"\u001e9eCR,G)Y:iE>\f'\u000f\u001a\u000b\u0006Q\u0006%\u0013Q\n\u0005\b\u0003S\t\u0019\u00051\u0001qQ!\tI%!\f\u0002\u000e\u0005M\u0002BB\u0004\u0002D\u0001\u0007\u0001\u000e\u000b\u0005\u0002D\u0005]\u0012QBA\u001fQ\u0011\t\u0019%a\u0015\u0011\u0007u\f)&C\u0002\u0002Xy\u00141\u0001U+U\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\nqb\u0019:fCR,G)Y:iE>\f'\u000f\u001a\u000b\u0004Q\u0006}\u0003BB\u0004\u0002Z\u0001\u0007\u0001\u000e\u000b\u0003\u0002Z\u0005\r\u0004cA?\u0002f%\u0019\u0011q\r@\u0003\tA{5\u000b\u0016\u0005\b\u0003W\u0002A\u0011AA7\u0003=!W\r\\3uK\u0012\u000b7\u000f\u001b2pCJ$G\u0003BA8\u0003k\u00022aEA9\u0013\r\t\u0019\b\u0006\u0002\u0005+:LG\u000fC\u0004\u0002*\u0005%\u0004\u0019\u00019)\u0011\u0005U\u0014QFA\u0007\u0003gA\u0003\"!\u001b\u00028\u00055\u0011Q\b\u0015\u0005\u0003S\ni\bE\u0002~\u0003\u007fJ1!!!\u007f\u0005\u0019!U\tT#U\u000b\"9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015!\u00047jgR$V-\u001c9mCR,7\u000f\u0006\u0003\u0002\n\u0006\u0005\u0006\u0003B1g\u0003\u0017\u0003B!!$\u0002\u001e6\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0004sK\u001adWm\u0019;\u000b\u0007\u0015\t)J\u0003\u0003\u0002\u0018\u0006e\u0015A\u00029mk\u001eLgNC\u0002\u0002\u001c2\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0005\u0003?\u000byI\u0001\u0006EKN\u001c'/\u001b9u_JD\u0001\"a)\u0002\u0004\u0002\u0007\u0011QU\u0001\u0006g\u000e|\u0007/\u001a\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u0016\u0004\u0002\r\u0011|W.Y5o\u0013\u0011\ty+!+\u0003\u0013QKG.Z*d_B,\u0007\u0006CAQ\u0003g\u000bi!!/\u0011\u0007u\f),C\u0002\u00028z\u0014A\u0002R3gCVdGOV1mk\u0016\f#!a/\u0002\u000fI+E*R!T\u000b\":\u0011\u0011\u0015?\u0002\u000e\u0005}\u0016EAARQ!\t\u0019)a\u000e\u0002\u000e\u0005\r\u0017EAAc\u0003)yC/Z7qY\u0006$Xm\u001d\u0015\u0005\u0003\u0007\u000bY\u0002K\u0004\u0001\u0003\u0017\fi!!5\u0011\u0007u\fi-C\u0002\u0002Pz\u0014\u0001bQ8ogVlWm\u001d\u0017\u0003\u0003'\f#!!6\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007f\u0002\u0001\u0002Z\u00065\u0011q\u001c\t\u0004{\u0006m\u0017bAAo}\nA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002T\"\u001a\u0001!a9\u0011\t\u0005\u0015\u00181^\u0007\u0003\u0003OT1!!;X\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0003[\f9O\u0001\u0006D_:$(o\u001c7mKJDs\u0001AA\u001c\u0003\u001b\t\t0\t\u0002\u0002t\u0006Yq\u0006Z1tQ\n|\u0017M\u001d3t\u0001")
public class DashboardResource {
    private final DashboardService dashboardService;
    private final DashboardSecurity dashboardSecurity;
    private final ConfigurationRepository configurationRepository;
    private final ObjectMapper objectMapper;

    public DashboardService dashboardService() {
        return this.dashboardService;
    }

    public DashboardSecurity dashboardSecurity() {
        return this.dashboardSecurity;
    }

    public ConfigurationRepository configurationRepository() {
        return this.configurationRepository;
    }

    public ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    @GET
    public List<DashboardView> search(@QueryParam(value="parentId") String parentId, @QueryParam(value="title") String title) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.dashboardService().search(parentId, title).map((Function1 & Serializable & scala.Serializable)x$1 -> DashboardView$.MODULE$.apply((Dashboard)((Object)x$1)), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @GET
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public DashboardView getDashboard(@PathParam(value="dashboardId") String dashboardId) {
        this.dashboardSecurity().checkView(dashboardId);
        return DashboardView$.MODULE$.apply(this.dashboardService().findDashboardById(dashboardId));
    }

    @PUT
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public DashboardView updateDashboard(@PathParam(value="dashboardId") String dashboardId, DashboardView dashboard) {
        this.dashboardSecurity().checkEdit(dashboardId);
        dashboard.id_$eq(dashboardId);
        Dashboard updatedDashboard = this.dashboardService().updateDashboard(DashboardView$.MODULE$.toDashboard(dashboard, this.configurationRepository(), this.objectMapper()));
        return DashboardView$.MODULE$.apply(updatedDashboard);
    }

    @POST
    public DashboardView createDashboard(DashboardView dashboard) {
        this.dashboardSecurity().checkCreate(dashboard.parentId());
        dashboard.id_$eq(null);
        Dashboard createdDashboard = this.dashboardService().createDashboard(DashboardView$.MODULE$.toDashboard(dashboard, this.configurationRepository(), this.objectMapper()));
        return DashboardView$.MODULE$.apply(createdDashboard);
    }

    @DELETE
    @Path(value="{dashboardId:Applications.*|.*Dashboard[^/-]*}")
    public void deleteDashboard(@PathParam(value="dashboardId") String dashboardId) {
        this.dashboardSecurity().checkEdit(dashboardId);
        this.dashboardService().deleteDashboard(dashboardId);
    }

    @GET
    @Path(value="/templates")
    public List<Descriptor> listTemplates(@QueryParam(value="scope") @DefaultValue(value="RELEASE") TileScope scope) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.dashboardService().getDashboardTemplates(scope)).asJava();
    }

    @Autowired
    public DashboardResource(DashboardService dashboardService, DashboardSecurity dashboardSecurity, ConfigurationRepository configurationRepository, ObjectMapper objectMapper) {
        this.dashboardService = dashboardService;
        this.dashboardSecurity = dashboardSecurity;
        this.configurationRepository = configurationRepository;
        this.objectMapper = objectMapper;
    }
}

