/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.TaskFailOperation;
import com.xebialabs.xlrelease.events.TaskGroupFailingOperation;
import com.xebialabs.xlrelease.events.TaskRetryOperation;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Task Group (Parallel or Sequential)", versioned=false, virtual=true)
public abstract class TaskGroup
extends Task
implements TaskContainer {
    @Property(asContainment=true, required=false)
    protected List<Task> tasks = Lists.newArrayList();

    @Override
    @PublicApiMember
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    @PublicApiMember
    public abstract void setTasks(List<Task> var1);

    @PublicApiMember
    public Task getTask(Integer index) {
        return this.tasks.get(index);
    }

    @Override
    @PublicApiMember
    public List<Task> getAllTasks() {
        ArrayList<Task> allTasks = new ArrayList<Task>(super.getAllTasks());
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                allTasks.addAll(task.getAllTasks());
            }
        }
        return allTasks;
    }

    @Override
    public List<PlanItem> getChildren() {
        ArrayList<PlanItem> children = new ArrayList<PlanItem>();
        if (this.tasks != null) {
            for (Task task : this.tasks) {
                children.addAll(task.getAllTasks());
            }
        }
        return children;
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        for (Task task : this.tasks) {
            task.accept(visitor);
        }
    }

    private boolean containsTaskId(String targetId, Task subTask) {
        return subTask.getAllTasks().stream().anyMatch(task -> task.getId().equals(targetId));
    }

    protected abstract Changes tryToStartPlanningTargets(Task var1);

    protected abstract Changes startSubTasksIfPreconditionNotInProgress();

    @Override
    public Changes startNow(String targetId, boolean shouldBePending) {
        Changes changes = new Changes();
        if (this.getId().equals(targetId)) {
            changes.addAll(super.startNow(this.getId(), shouldBePending));
            if (this.status == TaskStatus.FAILED || this.status == TaskStatus.PENDING) {
                return changes;
            }
            changes.addAll(this.startSubTasksIfPreconditionNotInProgress());
        } else {
            for (Task subTask : this.tasks) {
                if (!this.containsTaskId(targetId, subTask)) continue;
                changes.addAll(subTask.startNow(targetId, shouldBePending));
                break;
            }
        }
        this.updateGroupStatusIfNecessary(changes);
        return changes;
    }

    @Override
    public Changes markAsDone(String targetId, TaskStatus status) {
        Changes changes = new Changes();
        if (this.getId().equals(targetId)) {
            changes.addAll(super.markAsDone(targetId, status));
            for (Task subTask : this.tasks) {
                changes.addAll(subTask.markAsDone(subTask.getId(), status));
            }
        } else {
            for (Task subTask : this.tasks) {
                if (!this.containsTaskId(targetId, subTask)) continue;
                changes.addAll(subTask.markAsDone(targetId, status));
                changes.addAll(this.tryToStartPlanningTargets(subTask));
                break;
            }
            this.updateGroupStatusIfNecessary(changes);
        }
        return changes;
    }

    @Override
    public Changes fail(String targetId, String failReason) {
        return this.fail(targetId, failReason, User.AUTHENTICATED_USER);
    }

    @Override
    public Changes fail(String targetId, String failReason, User user) {
        Changes changes = new Changes();
        if (this.getId().equals(targetId)) {
            changes.addAll(super.fail(targetId, failReason, user));
            this.setFailuresCount(this.getFailuresCount() + 1);
        } else {
            for (Task subTask : this.tasks) {
                if (!this.containsTaskId(targetId, subTask)) continue;
                changes.addAll(subTask.fail(targetId, failReason, user));
                break;
            }
            this.updateGroupStatusIfNecessary(changes);
        }
        return changes;
    }

    @Override
    public Changes abort() {
        Changes changes = super.abort();
        for (Task subTask : this.tasks) {
            changes.addAll(subTask.abort());
        }
        return changes;
    }

    @Override
    public Changes resetToPlanned() {
        Changes changes = super.resetToPlanned();
        for (Task task : this.getTasks()) {
            changes.addAll(task.resetToPlanned());
        }
        return changes;
    }

    @Override
    public Changes retry(String targetId) {
        Changes changes = new Changes();
        if (this.getId().equals(targetId)) {
            changes.addAll(super.retry(targetId));
            if (this.status != TaskStatus.FAILED && this.status != TaskStatus.PENDING) {
                changes.addAll(this.startSubTasksIfPreconditionNotInProgress());
                this.updateGroupStatusIfNecessary(changes);
            }
        } else {
            for (Task subTask : this.tasks) {
                if (!this.containsTaskId(targetId, subTask)) continue;
                changes = subTask.retry(targetId);
                changes.addAll(this.tryToStartPlanningTargets(subTask));
                break;
            }
            this.updateGroupStatusIfNecessary(changes);
        }
        return changes;
    }

    protected void updateGroupStatusIfNecessary(Changes changes) {
        if (this.isPreconditionInProgress()) {
            return;
        }
        TaskStatus newGroupStatus = TaskGroup.computeGroupStatus(this.tasks);
        if (newGroupStatus != this.getStatus()) {
            this.setStatus(newGroupStatus);
            if (newGroupStatus == TaskStatus.IN_PROGRESS && !this.hasStartDate()) {
                this.setStartDate(new Date());
            }
            if (newGroupStatus == TaskStatus.COMPLETED) {
                this.setEndDate(new Date());
                changes.addAll(super.markAsDone(this.getId(), this.status));
            } else {
                if (newGroupStatus == TaskStatus.FAILED) {
                    this.setFailuresCount(this.getFailuresCount() + 1);
                }
                changes.addOperation(this.getOperationForNewStatus(newGroupStatus));
            }
            changes.update(this);
        }
    }

    @VisibleForTesting
    static TaskStatus computeGroupStatus(List<Task> tasks) {
        boolean hasFailures = false;
        boolean hasInProgress = false;
        for (Task subTask : tasks) {
            if (subTask.isPending() || subTask.isWaitingForInput() || subTask.isPreconditionInProgress() || subTask.isInProgress() || subTask.isFailing() || subTask.isFailureHandlerInProgress() || subTask.isFacetInProgress()) {
                hasInProgress = true;
            }
            if (!subTask.isFailed() && !subTask.isFailing()) continue;
            hasFailures = true;
        }
        if (hasFailures && hasInProgress) {
            return TaskStatus.FAILING;
        }
        if (hasFailures) {
            return TaskStatus.FAILED;
        }
        if (hasInProgress) {
            return TaskStatus.IN_PROGRESS;
        }
        return TaskStatus.COMPLETED;
    }

    private XLReleaseOperation getOperationForNewStatus(TaskStatus status) {
        switch (status) {
            case FAILED: {
                return new TaskFailOperation(this, "at least one subtask failed");
            }
            case IN_PROGRESS: {
                return new TaskRetryOperation(this);
            }
            case FAILING: {
                return new TaskGroupFailingOperation(this);
            }
        }
        throw new IllegalArgumentException(status.name());
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct();
    }

    public boolean isSkippableOrRetriable() {
        for (PlanItem planItem : this.getChildren()) {
            Task task = (Task)planItem;
            if (task.isPlanned() || task.isDoneInAdvance()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getFlaggedCount() {
        int flagsCount = 0;
        for (Task subTask : this.getAllTasks()) {
            if (!subTask.hasBeenFlagged()) continue;
            ++flagsCount;
        }
        return flagsCount;
    }

    @Override
    public int getDelayedCount() {
        int delaysCount = 0;
        for (Task subTask : this.getAllTasks()) {
            if (!subTask.hasBeenDelayed()) continue;
            ++delaysCount;
        }
        return delaysCount;
    }

    @Override
    protected List<String> getUnboundRequiredVariables() {
        return Collections.emptyList();
    }

    @Override
    public boolean failOnRecovery() {
        return false;
    }

    @Override
    public void deleteTask(Task task) {
        if (!this.tasks.remove(task)) {
            this.tasks.forEach(t -> t.deleteTask(task));
        }
    }

    @Override
    public void addTask(Task task, int position) {
        this.getTasks().add(position, task);
        task.setContainer(this);
    }

    @Override
    public boolean isFailureHandlerEnabled() {
        return false;
    }
}

