/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.repository.ReleaseTriggerRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u001db\u0001B\u0001\u0003\u0001-\u0011QBR8mI\u0016\u00148+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u001d\u0019XM\u001d<jG\u0016T!!\u0002\u0004\u0002\u0013ad'/\u001a7fCN,'BA\u0004\t\u0003%AXMY5bY\u0006\u00147OC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oO\"A1\u0004\u0001B\u0001B\u0003%A$A\u0004g_2$WM]:\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}!\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011\u0011E\b\u0002\u0011\r>dG-\u001a:SKB|7/\u001b;pefD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\fi\u0016\fWnU3sm&\u001cW\r\u0005\u0002&M5\t!!\u0003\u0002(\u0005\tYA+Z1n'\u0016\u0014h/[2f\u0011!I\u0003A!A!\u0002\u0013Q\u0013!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011QdK\u0005\u0003Yy\u0011\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0011!q\u0003A!A!\u0002\u0013y\u0013a\u0003;bg.\u001cVM\u001d<jG\u0016\u0004\"!\n\u0019\n\u0005E\u0012!a\u0003+bg.\u001cVM\u001d<jG\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"!H\u001b\n\u0005Yr\"aF\"p]\u001aLw-\u001e:bi&|gNU3q_NLGo\u001c:z\u0011!A\u0004A!A!\u0002\u0013I\u0014aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"!\n\u001e\n\u0005m\u0012!aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0015e\u0016dW-Y:f'\u0016\f'o\u00195TKJ4\u0018nY3\u0011\u0005\u0015z\u0014B\u0001!\u0003\u0005Q\u0011V\r\\3bg\u0016\u001cV-\u0019:dQN+'O^5dK\"A!\t\u0001B\u0001B\u0003%1)A\u0006qKJl\u0017n]:j_:\u001c\bC\u0001#H\u001b\u0005)%B\u0001$\u0005\u0003!\u0019XmY;sSRL\u0018B\u0001%F\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\u0006AQM^3oi\n+8\u000f\u0005\u0002M\u001f6\tQJ\u0003\u0002O\t\u00051QM^3oiNL!\u0001U'\u0003#ac%+\u001a7fCN,WI^3oi\n+8\u000f\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0003e\u0011X\r\\3bg\u0016$&/[4hKJ\u001c(+\u001a9pg&$xN]=\u0011\u0005u!\u0016BA+\u001f\u0005a\u0011V\r\\3bg\u0016$&/[4hKJ\u0014V\r]8tSR|'/\u001f\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017eS6\fX/_?\u0002\f'm\u0019\t\u0003K\u0001AQa\u0007,A\u0002qAQa\t,A\u0002\u0011BQ!\u000b,A\u0002)BQA\f,A\u0002=BQa\r,A\u0002QBQ\u0001\u000f,A\u0002eBQ!\u0010,A\u0002yBQA\u0011,A\u0002\rCQA\u0013,A\u0002-CQA\u0015,A\u0002MCQ!\u001a\u0001\u0005\u0002\u0019\f\u0011c\u00195fG.4u\u000e\u001c3fe\u0016C\u0018n\u001d;t)\t9'\u000e\u0005\u0002\u000eQ&\u0011\u0011N\u0004\u0002\u0005+:LG\u000fC\u0003lI\u0002\u0007A.\u0001\u0005g_2$WM]%e!\tiGO\u0004\u0002oeB\u0011qND\u0007\u0002a*\u0011\u0011OC\u0001\u0007yI|w\u000e\u001e \n\u0005Mt\u0011A\u0002)sK\u0012,g-\u0003\u0002vm\n11\u000b\u001e:j]\u001eT!a\u001d\b)\u0005\u0011D\bcA=\u0002\u00025\t!P\u0003\u0002|y\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005ut\u0018aB7fiJL7m\u001d\u0006\u0003\u007f\"\t\u0001bY8eC\"\fG.Z\u0005\u0004\u0003\u0007Q(!\u0002+j[\u0016$\u0007bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0007KbL7\u000f^:\u0015\t\u0005-\u0011\u0011\u0003\t\u0004\u001b\u00055\u0011bAA\b\u001d\t9!i\\8mK\u0006t\u0007BB6\u0002\u0006\u0001\u0007A\u000eK\u0002\u0002\u0006aDq!a\u0006\u0001\t\u0003\tI\"\u0001\u0005hKR$\u0016\u000e\u001e7f)\ra\u00171\u0004\u0005\u0007W\u0006U\u0001\u0019\u00017)\u0007\u0005U\u0001\u0010C\u0004\u0002\"\u0001!\t!a\t\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$b!!\n\u00026\u0005]\u0002\u0003BA\u0014\u0003ci!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0007M>dG-\u001a:\u000b\u0007\u0005=B!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003g\tIC\u0001\u0004G_2$WM\u001d\u0005\u0007W\u0006}\u0001\u0019\u00017\t\u0015\u0005e\u0012q\u0004I\u0001\u0002\u0004\tY$A\u0003eKB$\b\u000e\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000b\nAA[1wC&!\u0011\u0011JA \u0005\u001dIe\u000e^3hKJD3!a\by\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n!BZ5oI\nK\b+\u0019;i)\u0019\t)#a\u0015\u0002X!9\u0011QKA'\u0001\u0004a\u0017\u0001\u00029bi\"D!\"!\u000f\u0002NA\u0005\t\u0019AA-!\ri\u00111L\u0005\u0004\u0003;r!aA%oi\"\u001a\u0011Q\n=\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f\u0005\u0019B.[:u-&,w/\u00192mK\u001a{G\u000eZ3sgRA\u0011qMA:\u0003o\n\t\t\u0005\u0004\u0002j\u0005=\u0014QE\u0007\u0003\u0003WRA!!\u001c\u0002D\u0005!Q\u000f^5m\u0013\u0011\t\t(a\u001b\u0003\t1K7\u000f\u001e\u0005\b\u0003k\n\t\u00071\u0001m\u0003!\u0001\u0018M]3oi&#\u0007\u0002CA=\u0003C\u0002\r!a\u001f\u0002\tA\fw-\u001a\t\u0004;\u0005u\u0014bAA@=\t!\u0001+Y4f\u0011)\t\u0019)!\u0019\u0011\u0002\u0003\u0007\u00111B\u0001\u0018I\u0016\u001cwN]1uK^KG\u000f\u001b)fe6L7o]5p]ND3!!\u0019y\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017\u000bA!\\8wKR1\u0011QEAG\u0003\u001fCaa[AD\u0001\u0004a\u0007bBAI\u0003\u000f\u0003\r\u0001\\\u0001\f]\u0016<\b+\u0019:f]RLE\rK\u0002\u0002\bbDq!a&\u0001\t\u0003\tI*\u0001\u0004sK:\fW.\u001a\u000b\u0007\u0003K\tY*!(\t\r-\f)\n1\u0001m\u0011\u001d\ty*!&A\u00021\fqA\\3x\u001d\u0006lW\rK\u0002\u0002\u0016bDq!!*\u0001\t\u0003\t9+A\btK\u0006\u00148\r\u001b+f[Bd\u0017\r^3t)\u0019\tI+a-\u00026B1\u0011\u0011NA8\u0003W\u0003B!!,\u000206\u0011\u0011QF\u0005\u0005\u0003c\u000biCA\u0004SK2,\u0017m]3\t\r-\f\u0019\u000b1\u0001m\u0011!\tI(a)A\u0002\u0005m\u0004fAARq\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0016AD:fCJ\u001c\u0007NU3mK\u0006\u001cXm\u001d\u000b\t\u0003\u007f\u000bY-!4\u0002fB!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F\u0012\taa]3be\u000eD\u0017\u0002BAe\u0003\u0007\u00141CU3mK\u0006\u001cXmU3be\u000eD'+Z:vYRDaa[A]\u0001\u0004a\u0007\u0002CAh\u0003s\u0003\r!!5\u0002\u000f\u0019LG\u000e^3sgB!\u00111[Aq\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!\u00024pe6\u001c(\u0002BAn\u0003;\f!A^\u0019\u000b\u0007\u0005}G!A\u0002ba&LA!a9\u0002V\ny!+\u001a7fCN,7OR5mi\u0016\u00148\u000f\u0003\u0006\u0002z\u0005e\u0006\u0013!a\u0001\u0003wB3!!/y\u0011\u001d\tY\u000f\u0001C\u0001\u0003[\fA\"\\8wKR+W\u000e\u001d7bi\u0016$r\u0001\\Ax\u0003c\f)\u0010\u0003\u0004l\u0003S\u0004\r\u0001\u001c\u0005\b\u0003g\fI\u000f1\u0001m\u0003)!X-\u001c9mCR,\u0017\n\u001a\u0005\u000b\u0003o\fI\u000f%AA\u0002\u0005-\u0011\u0001E:i_VdG-T3sO\u0016$V-Y7tQ\r\tI\u000f\u001f\u0005\b\u0003{\u0004A\u0011AA\u0000\u0003\u0019\u0019'/Z1uKR1\u0011Q\u0005B\u0001\u0005\u0007Aq!!\u001e\u0002|\u0002\u0007A\u000e\u0003\u0005\u0002,\u0005m\b\u0019AA\u0013Q\r\tY\u0010\u001f\u0005\b\u0003{\u0004A\u0011\u0001B\u0005)!\t)Ca\u0003\u0003\u000e\t=\u0001bBA;\u0005\u000f\u0001\r\u0001\u001c\u0005\t\u0003W\u00119\u00011\u0001\u0002&!A!\u0011\u0003B\u0004\u0001\u0004\tY!\u0001\nde\u0016\fG/\u001a#fM\u0006,H\u000e\u001e+fC6\u001c\bf\u0001B\u0004q\"9!q\u0003\u0001\u0005\u0002\te\u0011A\u00023fY\u0016$X\rF\u0002h\u00057Aaa\u001bB\u000b\u0001\u0004a\u0007f\u0001B\u000bq\"9!\u0011\u0005\u0001\u0005\n\t\r\u0012AC7fe\u001e,G+Z1ngR9qM!\n\u0003(\t%\u0002BB6\u0003 \u0001\u0007A\u000eC\u0004\u0002t\n}\u0001\u0019\u00017\t\u0011\t-\"q\u0004a\u0001\u0005[\tQ\u0002^3na2\fG/\u001a+fC6\u001c\bC\u0002B\u0018\u0005s\u0011yD\u0004\u0003\u00032\tUbbA8\u00034%\tq\"C\u0002\u000389\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003<\tu\"aA*fc*\u0019!q\u0007\b\u0011\t\u00055&\u0011I\u0005\u0005\u0005\u0007\niC\u0001\u0003UK\u0006l\u0007b\u0002B$\u0001\u0011%!\u0011J\u0001\re\u0016\u0004H.Y2f)\u0016\fWn\u001d\u000b\u0006O\n-#Q\n\u0005\u0007W\n\u0015\u0003\u0019\u00017\t\u000f\u0005M(Q\ta\u0001Y\"9!\u0011\u000b\u0001\u0005\n\tM\u0013aG7fe\u001e,G+Z7qY\u0006$X-\u00118e\r>dG-\u001a:UK\u0006l7\u000f\u0006\u0004\u0003.\tU#\u0011\f\u0005\t\u0005/\u0012y\u00051\u0001\u0003.\u0005Yam\u001c7eKJ$V-Y7t\u0011!\u0011YCa\u0014A\u0002\t5\u0002b\u0002B/\u0001\u0011%!qL\u0001\u000ee\u0016\u001cX\r\u001e+bg.$V-Y7\u0015\u0007\u001d\u0014\t\u0007C\u0004\u0002t\nm\u0003\u0019\u00017\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h\u0005q2M]3bi\u0016$UMZ1vYR$V-Y7t\r>\u0014H\u000b[3G_2$WM\u001d\u000b\u0006O\n%$1\u000e\u0005\t\u0003W\u0011\u0019\u00071\u0001\u0002&!9\u0011Q\u000fB2\u0001\u0004a\u0007b\u0002B8\u0001\u0011\u0005!\u0011O\u0001 O\u0016$hj\u001c8J]\",'/\u001b;fI\u001a{G\u000eZ3s%\u00164WM]3oG\u0016\u001cHC\u0002B:\u0005\u0013\u0013Y\t\u0005\u0004\u0003v\t}$1Q\u0007\u0003\u0005oRAA!\u001f\u0003|\u00059Q.\u001e;bE2,'b\u0001B?\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\u0005%q\u000f\u0002\u0004'\u0016$\b\u0003BAW\u0005\u000bKAAa\"\u0002.\t\t\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r-\u0014i\u00071\u0001m\u0011\u001d\u0011iI!\u001cA\u00021\f1B\\3xM>dG-\u001a:JI\"9!\u0011\u0013\u0001\u0005\n\tM\u0015!F2iK\u000e\\gi\u001c7eKJ\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\bO\nU%q\u0013BQ\u0011\u0019Y'q\u0012a\u0001Y\"A!\u0011\u0014BH\u0001\u0004\u0011Y*A\toK^4w\u000e\u001c3fe&#w\n\u001d;j_:\u0004B!\u0004BOY&\u0019!q\u0014\b\u0003\r=\u0003H/[8o\u0011\u001d\u0011\u0019Ka$A\u00021\f\u0011b\u001c9fe\u0006$\u0018n\u001c8\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\u0006i1M]3bi\u0016$U\r^1jYN$\"Ba+\u00030\nU&\u0011\u0019Bc!\u0011\tiD!,\n\u0007U\fy\u0004\u0003\u0005\u00032\n\u0015\u0006\u0019\u0001BZ\u00039\t7\r^5wKJ+G.Z1tKN\u0004bAa\f\u0003:\u0005-\u0006\u0002\u0003B\\\u0005K\u0003\rA!/\u0002\u001f\u0015t\u0017M\u00197fIR\u0013\u0018nZ4feN\u0004bAa\f\u0003:\tm\u0006\u0003BAW\u0005{KAAa0\u0002.\tq!+\u001a7fCN,GK]5hO\u0016\u0014\b\u0002\u0003Bb\u0005K\u0003\rAa-\u00021\u0005,Ho\\*uCJ$\b+\u001a8eS:<'+\u001a7fCN,7\u000f\u0003\u0005\u0003H\n\u0015\u0006\u0019\u0001Be\u0003-IgN^1mS\u0012\u0014VMZ:\u0011\r\t-'Q\u001aBB\u001b\t\u0011Y(\u0003\u0003\u0003\u0002\nm\u0004b\u0002Bi\u0001\u0011%!1[\u0001\u0018G\",7m\u001b+f[Bd\u0017\r^3DC:\u0014U-T8wK\u0012$Ra\u001aBk\u0005/Dq!a=\u0003P\u0002\u0007A\u000e\u0003\u0004l\u0005\u001f\u0004\r\u0001\u001c\u0005\b\u00057\u0004A\u0011\u0002Bo\u0003I9W\r\u001e*v]:Lgn\u001a*fY\u0016\f7/Z:\u0015\t\tM&q\u001c\u0005\u0007W\ne\u0007\u0019\u00017\t\u000f\t\r\b\u0001\"\u0003\u0003f\u0006\u0011r-\u001a;F]\u0006\u0014G.\u001a3Ue&<w-\u001a:t)\u0011\u0011ILa:\t\u000f\t%(\u0011\u001da\u0001Y\u0006Q\u0011M\\2fgR|'/\u00133\t\u000f\t5\b\u0001\"\u0003\u0003p\u0006Yr-\u001a;BkR|7\u000b^1siB+g\u000eZ5oOJ+G.Z1tKN$BAa-\u0003r\"11Na;A\u00021D\u0011B!>\u0001#\u0003%\tAa>\u0002-5|g/\u001a+f[Bd\u0017\r^3%I\u00164\u0017-\u001e7uIM*\"A!?+\t\u0005-!1`\u0016\u0003\u0005{\u0004BAa@\u0004\b5\u00111\u0011\u0001\u0006\u0005\u0007\u0007\u0019)!A\u0005v]\u000eDWmY6fI*\u00111PD\u0005\u0005\u0007\u0013\u0019\tAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!\u0004\u0001#\u0003%\taa\u0004\u0002%\u0019Lg\u000e\u001a\"z\u0013\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0007#QC!a\u000f\u0003|\"I1Q\u0003\u0001\u0012\u0002\u0013\u00051qC\u0001\u0015M&tGMQ=QCRDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\re!\u0006BA-\u0005wD\u0011b!\b\u0001#\u0003%\tAa>\u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIMB\u0011b!\t\u0001#\u0003%\taa\t\u00021M,\u0017M]2i%\u0016dW-Y:fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004&)\"\u00111\u0010B~\u0001")
public class FolderService
implements Logging {
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ReleaseTriggerRepository releaseTriggersRepository;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Folder ", " cannot be found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Ids.ROOT_FOLDER_ID})), new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})), new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Folder findByPath(String path, int depth) {
        void var3_3;
        Folder found = this.folders.findByPath(path, depth);
        this.permissions.check(XLReleasePermissions.VIEW_FOLDER, found.getId());
        return var3_3;
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        this.permissions.checkViewFolder(parentId);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.folders.listViewableFolders(parentId, page, decorateWithPermissions)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        return this.folders.rename(folderId, newName);
    }

    @Timed
    public List<Release> searchTemplates(String folderId, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), page.depth()).getReleases();
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage(), page.depth());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String string;
        String newTemplateId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId, Ids.getName((String)templateId)}));
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string2 = Ids.getParentId((String)templateId);
        String string3 = folderId;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to move template ", " to same folder ", ". Will be ignored."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, folderId})));
            string = templateId;
        } else {
            Buffer templateTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getStoredTeams(templateId)).asScala();
            this.releaseRepository.move(templateId, newTemplateId);
            if (shouldMergeTeams) {
                this.mergeTeams(folderId, newTemplateId, (Seq<Team>)templateTeams);
            } else {
                this.replaceTeams(folderId, newTemplateId);
            }
            this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
            string = newTemplateId;
        }
        return string;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        Folder saved;
        block3: {
            Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
            this.checkFolderExists(parentId);
            this.folders.checkNameIsUnique(parentId, folder.getTitle());
            if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
                folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
            } else {
                folder.setId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parentId, Ids.getName((String)folder.getId())})));
            }
            this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating folder ", " with id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folder.getTitle(), folder.getId()})));
            saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
            if (!createDefaultTeams) break block3;
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.createDefaultTeamsForTheFolder(saved, parentId);
            }
        }
        return saved;
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting folder ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{folderId})));
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(uid, id) -> {
            this.releaseRepository.deleteWithUid(id, BoxesRunTime.unboxToInt((Object)uid));
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void mergeTeams(String folderId, String templateId, Seq<Team> templateTeams) {
        block0: {
            if (!templateTeams.nonEmpty()) break block0;
            Buffer folderTeams = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.teamService.getEffectiveTeams(folderId)).asScala();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable & scala.Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> folderId);
            Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private Seq<Team> mergeTemplateAndFolderTeams(Seq<Team> folderTeams, Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((TraversableOnce)folderTeams.map((Function1 & Serializable & scala.Serializable)team -> new Tuple2((Object)team.getTeamName(), team), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).toSeq());
        templateTeams.foreach((Function1 & Serializable & scala.Serializable)templateTeam -> {
            MapLike mapLike;
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                mapLike = folderTeamsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getMembers()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getMembers()).asScala()).toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getRoles()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getRoles()).asScala()).toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(folderTeam.getPermissions()).asScala()).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(templateTeam.getPermissions()).asScala()).toSet());
                folderTeam.setMembers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberSet.toSeq()).asJava());
                folderTeam.setRoles((List)JavaConverters$.MODULE$.seqAsJavaListConverter(roleSet.toSeq()).asJava());
                folderTeam.setPermissions((List)JavaConverters$.MODULE$.seqAsJavaListConverter(permissionSet.toSeq()).asJava());
                mapLike = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            return mapLike;
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId, null);
        template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
    }

    private void createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(XLReleasePermissions.getFolderPermissions()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.setPermissions(XLReleasePermissions.getReleasePermissions());
        releaseAdmin.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        this.teamService.saveTeamsToPlatform(folder.getId(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Team[]{folderOwner, templateOwner, releaseAdmin}))).asJava());
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$10 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0));
        ReleaseStatus[] x$11 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$12 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$13 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$14 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$15 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        scala.collection.mutable.Seq releases = (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$10, (Either<String, String>)x$12, x$11, x$13, x$14, x$15))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable & scala.Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, folderId, newfolderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        Seq<Release> activeReleases = this.getRunningReleases(folderId);
        Seq<ReleaseTrigger> enabledTriggers = this.getEnabledTriggers(folderId);
        Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || enabledTriggers.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to ", " folder ", ", which has active releases ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, folderId, ((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or pending releases with auto start option enabled: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
            String details = this.createDetails(activeReleases, enabledTriggers, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You cannot ", " this folder. The folder or its subfolders contain ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, details})), new Object[0]);
        }
    }

    private String createDetails(Seq<Release> activeReleases, Seq<ReleaseTrigger> enabledTriggers, Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        String details;
        block3: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active releases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)activeReleases.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (enabledTriggers.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"releases or template with enabled triggers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)enabledTriggers.map((Function1 & Serializable & scala.Serializable)t -> t.getTemplate().getTitle() + "/" + t.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pending releases with auto start: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)autoStartPendingReleases.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getTitle(), Seq$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
            }
            if (!invalidRefs.nonEmpty()) break block3;
            details = details + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configuration references not inherited by the destination folder: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)invalidRefs.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTitle(), Set$.MODULE$.canBuildFrom())).mkString("\"", "\", \"", "\"")}));
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Buffer enabledTriggers = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseTriggersRepository.findEnabledReleaseTriggers(templateId)).asScala();
        if (enabledTriggers.nonEmpty()) {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to move template ", " with enabled triggers ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{templateId, enabledTriggers})));
            throw new ItemInUseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You can't move this template because it has one or more enabled triggers: "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{enabledTriggers.mkString(", ")})), new Object[0]);
        }
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$4(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private Seq<Release> getRunningReleases(String folderId) {
        Page x$16 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$17 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$18 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$19 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$20 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$21 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$16, (Either<String, String>)x$18, x$17, x$19, x$20, x$21))).asScala();
    }

    private Seq<ReleaseTrigger> getEnabledTriggers(String ancestorId) {
        Page x$22 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(2));
        ReleaseStatus[] x$23 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.TEMPLATE});
        Right<String, String> x$24 = ReleaseSearchByParams$.MODULE$.byAncestor(ancestorId);
        String x$25 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$26 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$27 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$22, (Either<String, String>)x$24, x$23, x$25, x$26, x$27))).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getReleaseTriggers()).asScala(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.isEnabled()));
    }

    private Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$28 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1));
        ReleaseStatus[] x$29 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$30 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$31 = true;
        String x$32 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$33 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(this.releaseRepository.search(new ReleaseSearchByParams(x$28, (Either<String, String>)x$30, x$29, x$32, x$33, x$31))).asScala();
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String folderId$8, String newfolderId$1, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableLike)((SetLike)refs.filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable & scala.Serializable)c -> $this.configurationRepository.read(c.getId()), scala.collection.mutable.Set$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)c -> c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$8) ? BoxesRunTime.boxToBoolean((boolean)res$1.add(c)) : BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$4(String folderId$5, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$5.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ReleaseTriggerRepository releaseTriggersRepository) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.releaseTriggersRepository = releaseTriggersRepository;
        Logging.$init$((Logging)this);
    }
}

