/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupMemberPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupRow;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseGroupSqlBuilder;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u00015\u0011\u0011dU9m%\u0016dW-Y:f\u000fJ|W\u000f\u001d*fa>\u001c\u0018\u000e^8ss*\u00111\u0001B\u0001\u0004gFd'BA\u0003\u0007\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003-I+G.Z1tK\u001e\u0013x.\u001e9SKB|7/\u001b;pefD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0018e\u0016dW-Y:f\u000fJ|W\u000f\u001d)feNL7\u000f^3oG\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0002\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003?q\u0011qCU3mK\u0006\u001cXm\u0012:pkB\u0004VM]:jgR,gnY3\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nQD]3mK\u0006\u001cXm\u0012:pkBlU-\u001c2feB+'o]5ti\u0016t7-\u001a\t\u00037\rJ!\u0001\n\u000f\u0003;I+G.Z1tK\u001e\u0013x.\u001e9NK6\u0014WM\u001d)feNL7\u000f^3oG\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0015gFd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0011\u0005!JS\"\u0001\u0002\n\u0005)\u0012!\u0001F*rYJ+\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000f\u0003\u0005-\u0001\t\u0015\r\u0011b\u0001.\u0003I\u0001XM]7jgNLwN\\#oM>\u00148-\u001a:\u0016\u00039\u0002\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0011M,7-\u001e:jifT!a\r\u0005\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\u000e\u0019\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0005\to\u0001\u0011\t\u0011)A\u0005]\u0005\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3sA!A\u0011\b\u0001BC\u0002\u0013\r!(A\u0004eS\u0006dWm\u0019;\u0016\u0003m\u0002\"\u0001P(\u000f\u0005ubeB\u0001 K\u001d\ty\u0004J\u0004\u0002A\u000f:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\tIe!\u0001\u0002eE&\u00111a\u0013\u0006\u0003\u0013\u001aI!!\u0014(\u0002\u0015M\u000bHNQ;jY\u0012,'O\u0003\u0002\u0004\u0017&\u0011\u0001+\u0015\u0002\b\t&\fG.Z2u\u0015\tie\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003<\u0003!!\u0017.\u00197fGR\u0004\u0003\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\u0002!\u0011,7m\u001c:bi>\u00148+\u001a:wS\u000e,W#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005q3\u0011aA1qS&\u0011a,\u0017\u0002!\u0013:$XM\u001d8bY6+G/\u00193bi\u0006$UmY8sCR|'oU3sm&\u001cW\r\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003X\u0003E!WmY8sCR|'oU3sm&\u001cW\r\t\u0005\u0006E\u0002!\taY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0011,gm\u001a5jyB\u0011\u0001\u0006\u0001\u0005\u00063\u0005\u0004\rA\u0007\u0005\u0006C\u0005\u0004\rA\t\u0005\u0006M\u0005\u0004\ra\n\u0005\u0006Y\u0005\u0004\u001dA\f\u0005\u0006s\u0005\u0004\u001da\u000f\u0015\u0005S.L(\u0010\u0005\u0002mo6\tQN\u0003\u0002o_\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005A\f\u0018a\u00024bGR|'/\u001f\u0006\u0003eN\fQAY3b]NT!\u0001^;\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011A^\u0001\u0004_J<\u0017B\u0001=n\u0005%\tV/\u00197jM&,'/A\u0003wC2,X-I\u0001|\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003VC\u0002\u0007q\u000bC\u0003\u007f\u0001\u0011\u0005s0\u0001\u0003sK\u0006$G\u0003BA\u0001\u0003#\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0003he>,\bOC\u0002\u0002\f\u0019\ta\u0001Z8nC&t\u0017\u0002BA\b\u0003\u000b\u0011ABU3mK\u0006\u001cXm\u0012:pkBDq!a\u0005~\u0001\u0004\t)\"A\u0004he>,\b/\u00133\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002C!%\u0019\u0011Q\u0004\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\u0002\u0005\u0015\u0004{\u0006\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055b*A\u0006ue\u0006t7/Y2uS>t\u0017\u0002BA\u0019\u0003W\u0011!\"S:SK\u0006$wJ\u001c7z\u0011\u001d\t)\u0004\u0001C!\u0003o\taa\u0019:fCR,G\u0003BA\u001d\u0003\u007f\u00012aDA\u001e\u0013\r\ti\u0004\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002B\u0005M\u0002\u0019AA\u0001\u00031\u0011X\r\\3bg\u0016<%o\\;q\u0011\u001d\t)\u0005\u0001C!\u0003\u000f\na!\u001e9eCR,G\u0003BA\u001d\u0003\u0013B\u0001\"!\u0011\u0002D\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u001b\u0002A\u0011IA(\u0003\u0019)\u00070[:ugR!\u0011\u0011KA,!\ry\u00111K\u0005\u0004\u0003+\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003'\tY\u00051\u0001\u0002\u0016!\"\u00111JA\u0014\u0011\u001d\ti\u0006\u0001C!\u0003?\na\u0001Z3mKR,G\u0003BA\u001d\u0003CB\u0001\"a\u0005\u0002\\\u0001\u0007\u0011Q\u0003\u0005\b\u0003K\u0002A\u0011IA4\u0003\u0019\u0019X-\u0019:dQRa\u0011\u0011NA>\u0003\u001f\u000bI*a)\u0002.B1\u00111NA;\u0003\u0003qA!!\u001c\u0002r9\u0019!)a\u001c\n\u0003EI1!a\u001d\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001e\u0002z\t\u00191+Z9\u000b\u0007\u0005M\u0004\u0003\u0003\u0005\u0002~\u0005\r\u0004\u0019AA@\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!!\u0002\f6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0003g_Jl7OC\u0002\u0002\nn\u000b!A^\u0019\n\t\u00055\u00151\u0011\u0002\u0014%\u0016dW-Y:f\u000fJ|W\u000f\u001d$jYR,'o\u001d\u0005\t\u0003#\u000b\u0019\u00071\u0001\u0002\u0014\u0006!\u0001/Y4f!\r)\u0012QS\u0005\u0004\u0003/#!\u0001\u0002)bO\u0016D\u0001\"a'\u0002d\u0001\u0007\u0011QT\u0001\b_J$WM\u001d\"z!\u0011\t\t)a(\n\t\u0005\u0005\u00161\u0011\u0002\u0016%\u0016dW-Y:f\u000fJ|W\u000f](sI\u0016\u0014Xj\u001c3f\u0011!\t)+a\u0019A\u0002\u0005\u001d\u0016A\u00039sS:\u001c\u0017\u000e]1mgB1\u00111NAU\u0003+IA!a+\u0002z\tA\u0011\n^3sC\ndW\r\u0003\u0005\u00020\u0006\r\u0004\u0019AAT\u0003\u001d\u0011x\u000e\\3JINDC!a\u0019\u0002(!9\u0011Q\u0017\u0001\u0005B\u0005]\u0016A\b4j]\u0012<%o\\;qgJ+g-\u001a:f]\u000eLgn\u001a*fY\u0016\f7/Z%e)\u0011\tI,a/\u0011\r\u0005-\u0014QOA\u000b\u0011!\ti,a-A\u0002\u0005U\u0011!\u0003:fY\u0016\f7/Z%e\u0011\u001d\t\t\r\u0001C!\u0003\u0007\f1EZ5oI\u0006\u001bG/\u001b<f\u000fJ|W\u000f]:SK\u001a,'/\u001a8dS:<gi\u001c7eKJLE\r\u0006\u0003\u0002F\u00065\u0007CBA6\u0003k\n9\rE\u0002\u001c\u0003\u0013L1!a3\u001d\u00055\u0019\u0015.\u00133XSRDG+\u001b;mK\"A\u0011qZA`\u0001\u0004\t)\"\u0001\u0005g_2$WM]%eQ\u0011\ty,a\n\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006yAo\u001c*fY\u0016\f7/Z$s_V\u00048\u000f\u0006\u0003\u0002j\u0005e\u0007\u0002CAn\u0003'\u0004\r!!8\u0002\tI|wo\u001d\t\u0007\u0003W\n)(a8\u0011\u0007m\t\t/C\u0002\u0002dr\u0011qBU3mK\u0006\u001cXm\u0012:pkB\u0014vn\u001e\u0005\b\u0003O\u0004A\u0011BAu\u00039!xNU3mK\u0006\u001cXm\u0012:pkB$b!!\u0001\u0002l\u0006=\b\u0002CAw\u0003K\u0004\r!a8\u0002\u0007I|w\u000f\u0003\u0005\u0002r\u0006\u0015\b\u0019AA]\u00035qWm\u001e*fY\u0016\f7/Z%eg\"9\u0011Q\u001f\u0001\u0005B\u0005]\u0018\u0001\u00044j]\u00124u\u000e\u001c3fe&#G\u0003BA\u000b\u0003sD\u0001\"a\u0005\u0002t\u0002\u0007\u0011Q\u0003\u0015\u0005\u0003g\f9\u0003C\u0004\u0002\u0000\u0002!IA!\u0001\u0002;\u0011,7m\u001c:bi\u0016<\u0016\u000e\u001e5FM\u001a,7\r^5wKN+7-\u001e:jif$B!!\u001b\u0003\u0004!A!QAA\u007f\u0001\u0004\tI'A\u0007sK2,\u0017m]3He>,\bo\u001d\u0015\u0004\u0001\t%\u0001\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\u0007\t=1/\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa\u0005\u0003\u000e\tQ!+\u001a9pg&$xN]=)\u0007\u0001\u00119\u0002\u0005\u0003\u0002*\te\u0011\u0002\u0002B\u000e\u0003W\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlReleaseGroupRepository
implements ReleaseGroupRepository {
    private final ReleaseGroupPersistence releaseGroupPersistence;
    private final ReleaseGroupMemberPersistence releaseGroupMemberPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(ReleaseGroup releaseGroup) {
        ReleaseGroupRepository.createOrUpdate$(this, releaseGroup);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public ReleaseGroup read(String groupId) {
        return (ReleaseGroup)((Object)this.releaseGroupPersistence.findById(groupId).map((Function1 & Serializable & scala.Serializable)row -> this.toReleaseGroup((ReleaseGroupRow)row, $this.releaseGroupMemberPersistence.findMembersByGroupUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)releaseGroup -> (ReleaseGroup)((Object)((Object)this.decorateWithEffectiveSecurity((Seq<ReleaseGroup>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReleaseGroup[]{releaseGroup})))).head()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})), new Object[0]);
        }));
    }

    @Override
    public void create(ReleaseGroup releaseGroup) {
        Integer groupUid = this.releaseGroupPersistence.insert(releaseGroup);
        this.releaseGroupMemberPersistence.insertMembers(groupUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSet());
    }

    @Override
    public void update(ReleaseGroup releaseGroup) {
        this.releaseGroupPersistence.update(releaseGroup);
        Integer groupUid = (Integer)this.releaseGroupPersistence.getUid(releaseGroup.getId()).get();
        Seq existingMembers = (Seq)this.releaseGroupMemberPersistence.findMembersByGroupUid(groupUid).map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set currentMembers = (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSet().map((Function1 & Serializable & scala.Serializable)x$1 -> Ids.getName((String)x$1), Set$.MODULE$.canBuildFrom());
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)existingMembers, (Iterable)currentMembers);
        this.releaseGroupMemberPersistence.deleteMembers(groupUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.releaseGroupMemberPersistence.insertMembers(groupUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
    }

    @Override
    @IsReadOnly
    public boolean exists(String groupId) {
        return this.releaseGroupPersistence.exists(groupId);
    }

    @Override
    public void delete(String groupId) {
        this.releaseGroupPersistence.delete(groupId);
    }

    @Override
    @IsReadOnly
    public Seq<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds) {
        Seq<ReleaseGroupRow> seq;
        if (filters.hasStatuses()) {
            Tuple2 sqlWithParams = new ReleaseGroupSqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle()).withOneOfStatuses((Seq<ReleaseGroupStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).withPermission((Option<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? None$.MODULE$ : new Some((Object)XLReleasePermissions.VIEW_RELEASE_GROUP)), principals, roleIds).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.releaseGroupPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<ReleaseGroupRow>)Seq$.MODULE$.empty();
        }
        Seq<ReleaseGroupRow> groupRows = seq;
        Seq<ReleaseGroup> releaseGroups = this.toReleaseGroups(groupRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? releaseGroups : this.decorateWithEffectiveSecurity(releaseGroups);
    }

    @Override
    public Seq<String> findGroupsReferencingReleaseId(String releaseId) {
        return this.releaseGroupMemberPersistence.findGroupsReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolderId(String folderId) {
        return this.releaseGroupMemberPersistence.findActiveGroupsReferencingFolderId(folderId);
    }

    private Seq<ReleaseGroup> toReleaseGroups(Seq<ReleaseGroupRow> rows) {
        Map<Object, Seq<String>> releaseIdsByGroup = this.releaseGroupMemberPersistence.findMembersByGroupUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toReleaseGroup((ReleaseGroupRow)row, (Seq<String>)((Seq)releaseIdsByGroup.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))), Seq$.MODULE$.canBuildFrom());
    }

    private ReleaseGroup toReleaseGroup(ReleaseGroupRow row, Seq<String> newReleaseIds) {
        Option releaseGroupOption = this.sqlRepositoryAdapter.deserialize(row.content());
        Option option = releaseGroupOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading release group ", ", see logs for more details"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)row.ciUid())})), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        ReleaseGroup releaseGroup = (ReleaseGroup)((Object)some.value());
        releaseGroup.setFolderId(FolderId$.MODULE$.absolute$extension(row.folderId()));
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseGroupRepository.$anonfun$toReleaseGroup$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        releaseGroup.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        ReleaseGroup releaseGroup2 = releaseGroup;
        return releaseGroup2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String groupId) {
        return FolderId$.MODULE$.absolute$extension(this.releaseGroupPersistence.findFolderId(groupId));
    }

    private Seq<ReleaseGroup> decorateWithEffectiveSecurity(Seq<ReleaseGroup> releaseGroups) {
        return (Seq)releaseGroups.map((Function1 & Serializable & scala.Serializable)group -> {
            this.decoratorService().decorate((ConfigurationItem)group, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()}))).asJava());
            return group;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$toReleaseGroup$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlReleaseGroupRepository(ReleaseGroupPersistence releaseGroupPersistence, ReleaseGroupMemberPersistence releaseGroupMemberPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.releaseGroupPersistence = releaseGroupPersistence;
        this.releaseGroupMemberPersistence = releaseGroupMemberPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        ReleaseGroupRepository.$init$(this);
    }
}

