/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.TypeHintValue;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeHint {
    private PropertyKind kind;
    private boolean required;
    private String placeHolder;
    private List<TypeHintValue> values = new ArrayList<TypeHintValue>();
    private Set<Validator<?>> validationRules = new HashSet();
    private String copyField;

    public PropertyKind getKind() {
        return this.kind;
    }

    public void setKind(PropertyKind kind) {
        this.kind = kind;
    }

    public List<TypeHintValue> getValues() {
        return this.values;
    }

    public void setValues(List<TypeHintValue> values) {
        this.values = values;
    }

    public Set<Validator<?>> getValidationRules() {
        return this.validationRules;
    }

    public TypeHint copyFrom(TypeHint typeHint) {
        if (typeHint == null) {
            return this;
        }
        this.setKind(typeHint.getKind());
        this.values.addAll(typeHint.values);
        this.validationRules.addAll(typeHint.getValidationRules());
        this.setPlaceHolder(typeHint.getPlaceHolder());
        this.setRequired(typeHint.isRequired());
        this.setCopyField(typeHint.copyField);
        return this;
    }

    public void addEnumValues(List<String> enumValues) {
        if (enumValues != null) {
            this.values.addAll(enumValues.stream().map(value -> TypeHintValue.typeHintValue(value, value)).collect(Collectors.toList()));
        }
    }

    public static TypeHint newTypeHintFrom(TypeHint typeHint) {
        return typeHint == null ? null : new TypeHint().copyFrom(typeHint);
    }

    public String getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(String placeHolder) {
        this.placeHolder = placeHolder;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getCopyField() {
        return this.copyField;
    }

    public void setCopyField(String copyField) {
        this.copyField = copyField;
    }
}

