/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import org.jboss.resteasy.annotations.ContentEncoding;
import org.jboss.resteasy.plugins.interceptors.ServerContentEncodingAnnotationFilter;

@ConstrainedTo(value=RuntimeType.SERVER)
public class ServerContentEncodingAnnotationFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Class declaring = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (declaring == null || method == null) {
            return;
        }
        Set<String> encodings = this.getEncodings(method.getAnnotations());
        if (encodings.size() <= 0 && (encodings = this.getEncodings(declaring.getAnnotations())).size() <= 0) {
            return;
        }
        configurable.register((Object)this.createFilter(encodings));
    }

    protected ServerContentEncodingAnnotationFilter createFilter(Set<String> encodings) {
        return new ServerContentEncodingAnnotationFilter(encodings);
    }

    protected Set<String> getEncodings(Annotation[] annotations) {
        HashSet<String> encodings = new HashSet<String>();
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(ContentEncoding.class)) continue;
            encodings.add(annotation.annotationType().getAnnotation(ContentEncoding.class).value().toLowerCase());
        }
        return encodings;
    }
}

