/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderExpander;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolidatedDictionary {
    private Map<String, DictionaryValue> entries = new HashMap<String, DictionaryValue>();
    private static final Logger logger = LoggerFactory.getLogger(ConsolidatedDictionary.class);

    public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
        ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
        Checks.checkNotNull(dicts, (String)"Should not have null dictionaries");
        for (Dictionary dict : dicts) {
            dictionary.addDictionary(dict);
        }
        MapStringStringView expandedMap = PlaceholderExpander.expand(dictionary.getEntries());
        expandedMap.getWrapped().forEach(dictionary::replaceStringValue);
        return dictionary;
    }

    private void addDictionary(Dictionary d) {
        MapStringStringView dictEntries = MapStringStringView.copy(d.getEntries());
        dictEntries.putAll(MapStringStringView.from(d.getEncryptedEntries()));
        dictEntries.keySet().stream().filter(key -> !this.entries.containsKey(key)).forEach(key -> this.entries.put((String)key, new DictionaryValue(dictEntries.getWrappedValue(key), d.getId())));
    }

    public MapStringStringView getEntries() {
        return new MapStringStringView(this.getWrapped());
    }

    private boolean replaceStringValue(String key, StringValue newValue) {
        DictionaryValue dictionaryValue = this.entries.get(key);
        if (dictionaryValue == null) {
            return false;
        }
        dictionaryValue.value = newValue;
        return true;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public StringValue resolveScannedPlaceholder(String filePlaceholder) {
        DictionaryValue wrappedValue = this.entries.get(filePlaceholder);
        return wrappedValue != null ? wrappedValue.value : null;
    }

    public String resolveScannedPlaceholderDictionaryId(String filePlaceholder) {
        DictionaryValue wrappedValue = this.entries.get(filePlaceholder);
        return wrappedValue != null ? wrappedValue.dictionaryId : null;
    }

    public String get(String key) {
        DictionaryValue wrappedValue = this.entries.get(key);
        return wrappedValue != null ? wrappedValue.value.toString() : null;
    }

    public Map<String, StringValue> getWrapped() {
        return this.entries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DictionaryValue)e.getValue()).value));
    }

    public void resolveDeployedName(EmbeddedDeployedContainer<?, ?> deployed) throws DictionaryValueException {
        String name = deployed.getName();
        if (MustachePlaceholderScanner.hasPlaceholders(name)) {
            MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.getWrapped(), false);
            StringValue sv = placeholderReplacer.replace(name);
            String newName = sv.toPublicFacingValue();
            this.checkNewNameValid(deployed.getId(), newName);
            deployed.setId(IdGenerator.generateId((ConfigurationItem)deployed.getContainer(), (String)newName));
        }
    }

    private void checkNewNameValid(String id, String newName) throws DictionaryValueException {
        if (newName.contains("/")) {
            throw new DictionaryValueException("Replaced name [%s] contains extra slashes, was: [%s]", newName, id);
        }
        if (newName.isEmpty()) {
            throw new DictionaryValueException("Replaced name for [%s] resolved to empty value.", id);
        }
    }

    public Object resolve(Object value, PropertyDescriptor deployablePropDesc) throws DictionaryValueException {
        return this.resolve(value, deployablePropDesc, new HashSet<String>());
    }

    public Object resolve(Object value, PropertyDescriptor deployablePropDesc, Set<String> missingPlaceholdersAggregator) throws DictionaryValueException {
        if (value == null) {
            return null;
        }
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.getWrapped(), false);
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case LIST_OF_CI: 
            case CI: 
            case DATE: 
            case SET_OF_CI: 
            case ENUM: {
                return value;
            }
            case STRING: {
                return placeholderReplacer.replace((String)value);
            }
            case SET_OF_STRING: {
                return this.resolveCollection((Set)value, new SetOfStringView(), placeholderReplacer, missingPlaceholdersAggregator);
            }
            case LIST_OF_STRING: {
                return this.resolveCollection((List)value, new ListOfStringView(), placeholderReplacer, missingPlaceholdersAggregator);
            }
            case MAP_STRING_STRING: {
                return this.resolveMap((Map)value, placeholderReplacer, missingPlaceholdersAggregator);
            }
        }
        throw new IllegalStateException("Unknown property kind: " + deployablePropDesc.getKind());
    }

    private Object resolveMap(Map<String, String> value, MustachePlaceholderReplacer placeholderReplacer, Set<String> missingPlaceholdersAggregator) {
        MapStringStringView resolvedMap = new MapStringStringView();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            try {
                resolvedMap.put(entry.getKey(), placeholderReplacer.replace(entry.getValue()));
            }
            catch (DictionaryValueException e) {
                resolvedMap.put(entry.getKey(), entry.getValue());
                missingPlaceholdersAggregator.addAll(e.getMissingValues());
            }
        }
        return resolvedMap;
    }

    private Collection<String> resolveCollection(Collection<String> value, AbstractStringView<?> resolved, MustachePlaceholderReplacer placeholderReplacer, Set<String> missingPlaceholdersAggregator) {
        for (String s : value) {
            try {
                resolved.add(placeholderReplacer.replace(s));
            }
            catch (DictionaryValueException e) {
                resolved.add(s);
                missingPlaceholdersAggregator.addAll(e.getMissingValues());
            }
        }
        return resolved;
    }

    private class DictionaryValue {
        private StringValue value;
        private String dictionaryId;

        public DictionaryValue(StringValue value, String dictionaryId) {
            this.value = value;
            this.dictionaryId = dictionaryId;
        }
    }
}

