/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.validation;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public final class ValidationMessage {
    private final String ciId;
    private final String propertyName;
    private final String message;
    private final Level level;

    public ValidationMessage(String ciId, String propertyName, String message, String level) {
        this(ciId, propertyName, message, level == null ? null : Level.valueOf(level));
    }

    public ValidationMessage(String ciId, String propertyName, String message, Level level) {
        this.ciId = ciId;
        this.propertyName = propertyName;
        this.message = message;
        this.level = level == null ? Level.ERROR : level;
    }

    public ValidationMessage(String ciId, String propertyName, String message) {
        this(ciId, propertyName, message, (Level)null);
    }

    public static ValidationMessage error(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.ERROR);
    }

    public static ValidationMessage warn(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.WARNING);
    }

    public static ValidationMessage info(String ciId, String propertyName, String message) {
        return new ValidationMessage(ciId, propertyName, message, Level.INFO);
    }

    public String getCiId() {
        return this.ciId;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getMessage() {
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public String toString() {
        return "ValidationMessage[level=" + (Object)((Object)this.level) + ", id=" + this.ciId + ", field=" + this.propertyName + ", message=" + this.message + "]";
    }

    @PublicApiRef
    public static enum Level {
        ERROR,
        WARNING,
        INFO;

    }
}

