/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.db;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateProcedureChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.RenameTableChange;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.DropForeignKeyConstraintStatement;
import liquibase.statement.core.DropIndexStatement;
import liquibase.statement.core.DropProcedureStatement;
import liquibase.statement.core.DropSequenceStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.DropViewStatement;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001-\u0011a\u0003\u0017'SK2,\u0017m]3EE&s\u0017\u000e^5bY&TXM\u001d\u0006\u0003\u0007\u0011\t!\u0001\u001a2\u000b\u0005\u00151\u0011!\u0003=me\u0016dW-Y:f\u0015\t9\u0001\"A\u0005yK\nL\u0017\r\\1cg*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0012\u0001C4sSjTH.\u001a3\n\u0005e!\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011)\u0019!C\u00019\u0005AAMY\"p]\u001aLw-F\u0001\u001e!\tqRE\u0004\u0002 GA\u0011\u0001ED\u0007\u0002C)\u0011!EC\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011r\u0011A\u0002)sK\u0012,g-\u0003\u0002'O\t11\u000b\u001e:j]\u001eT!\u0001\n\b\t\u0011%\u0002!\u0011!Q\u0001\nu\t\u0011\u0002\u001a2D_:4\u0017n\u001a\u0011\t\u0011-\u0002!Q1A\u0005\u00021\n!\u0002Z1uCN{WO]2f+\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002e\u0005)!.\u0019<bq&\u0011Ag\f\u0002\u000b\t\u0006$\u0018mU8ve\u000e,\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0017\u0011\fG/Y*pkJ\u001cW\r\t\u0005\u0006q\u0001!\t!O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ibT\b\u0005\u0002<\u00015\t!\u0001C\u0003\u001co\u0001\u0007Q\u0004C\u0003,o\u0001\u0007Q\u0006C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0003j]&$H#A!\u0011\u00055\u0011\u0015BA\"\u000f\u0005\u0011)f.\u001b;\t\u000b\u0015\u0003A\u0011\u0001!\u0002\u000f\u0011\u0014x\u000e]!mY\")q\t\u0001C\u0001\u0011\u0006i\u0011n]%oSRL\u0017\r\\5{K\u0012,\u0012!\u0013\t\u0003\u001b)K!a\u0013\b\u0003\u000f\t{w\u000e\\3b]\")Q\n\u0001C\u0001\u0001\u0006aAM]8q\u001bf$\u0016M\u00197fg\")q\n\u0001C\u0005!\u0006\u0001Bn\\4Ee>\u00048\u000b^1uK6,g\u000e\u001e\u000b\u0003\u0003FCQA\u0015(A\u0002M\u000bQ\u0002\u001a:paN#\u0018\r^3nK:$\bC\u0001+Z\u001b\u0005)&B\u0001,X\u0003%\u0019H/\u0019;f[\u0016tGOC\u0001Y\u0003%a\u0017.];jE\u0006\u001cX-\u0003\u0002[+\na1+\u001d7Ti\u0006$X-\\3oi\")A\f\u0001C\u0005;\u0006!2M]3bi\u0016$%o\u001c9Ti\u0006$X-\\3oiN$\"AX4\u0011\u0007}#7K\u0004\u0002aE:\u0011\u0001%Y\u0005\u0002\u001f%\u00111MD\u0001\ba\u0006\u001c7.Y4f\u0013\t)gMA\u0002TKFT!a\u0019\b\t\u000b!\\\u0006\u0019A5\u0002#\u0011\fG/\u00192bg\u0016\u001c\u0005.\u00198hK2{w\r\u0005\u0002k[6\t1N\u0003\u0002m/\u0006I1\r[1oO\u0016dwnZ\u0005\u0003].\u0014\u0011\u0003R1uC\n\f7/Z\"iC:<W\rT8h\u0011\u0015\u0001\b\u0001\"\u0003r\u0003%!'o\u001c9Pe\u0012,'/F\u0001s!\u0011i1oU;\n\u0005Qt!!\u0003$v]\u000e$\u0018n\u001c82!\tia/\u0003\u0002x\u001d\t\u0019\u0011J\u001c;\t\u000be\u0004A\u0011\u0002>\u0002%\rD\u0017M\\4fgJ\u001aH/\u0019;f[\u0016tGo]\u000b\u0002wB!Qb\u001d?_!\ri\u0018\u0011A\u0007\u0002}*\u0011qpV\u0001\u0007G\"\fgnZ3\n\u0007\u0005\raP\u0001\u0004DQ\u0006tw-\u001a\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0003m!W\r\\3uK\u0012\u000bG/\u00192bg\u0016\u001c\u0005.\u00198hK2{wMU8xgR\u0019\u0011)a\u0003\t\u000fa\u000b)\u00011\u0001\u0002\u000eA!\u0011qBA\t\u001b\u00059\u0016bAA\n/\nIA*[9vS\n\f7/\u001a\u0005\b\u0003/\u0001A\u0011BA\r\u0003=!wnV5uQ2K\u0017/^5cCN,W\u0003BA\u000e\u0003C!B!!\b\u00024A!\u0011qDA\u0011\u0019\u0001!\u0001\"a\t\u0002\u0016\t\u0007\u0011Q\u0005\u0002\u0002)F!\u0011qEA\u0017!\ri\u0011\u0011F\u0005\u0004\u0003Wq!a\u0002(pi\"Lgn\u001a\t\u0004\u001b\u0005=\u0012bAA\u0019\u001d\t\u0019\u0011I\\=\t\u0011\u0005U\u0012Q\u0003a\u0001\u0003o\t\u0001bY1mY\n\f7m\u001b\t\u0007\u001bM\fi!!\b")
public class XLReleaseDbInitializer
implements Logging {
    private final String dbConfig;
    private final DataSource dataSource;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        XLReleaseDbInitializer xLReleaseDbInitializer = this;
        synchronized (xLReleaseDbInitializer) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String dbConfig() {
        return this.dbConfig;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public void init() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.update("");
            return BoxedUnit.UNIT;
        });
    }

    public void dropAll() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            liquibase.dropAll();
            return BoxedUnit.UNIT;
        });
    }

    public boolean isInitialized() {
        return BoxesRunTime.unboxToBoolean(this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$isInitialized$1(liquibase))));
    }

    public void dropMyTables() {
        this.doWithLiquibase((Function1 & Serializable & scala.Serializable)liquibase -> {
            XLReleaseDbInitializer.$anonfun$dropMyTables$1(this, liquibase);
            return BoxedUnit.UNIT;
        });
    }

    private void logDropStatement(SqlStatement dropStatement) {
        String string;
        SqlStatement sqlStatement = dropStatement;
        if (sqlStatement instanceof DropTableStatement) {
            DropTableStatement dropTableStatement = (DropTableStatement)sqlStatement;
            string = dropTableStatement.getTableName();
        } else if (sqlStatement instanceof DropForeignKeyConstraintStatement) {
            DropForeignKeyConstraintStatement dropForeignKeyConstraintStatement = (DropForeignKeyConstraintStatement)sqlStatement;
            string = dropForeignKeyConstraintStatement.getConstraintName();
        } else if (sqlStatement instanceof DropViewStatement) {
            DropViewStatement dropViewStatement = (DropViewStatement)sqlStatement;
            string = dropViewStatement.getViewName();
        } else if (sqlStatement instanceof DropSequenceStatement) {
            DropSequenceStatement dropSequenceStatement = (DropSequenceStatement)sqlStatement;
            string = dropSequenceStatement.getSequenceName();
        } else if (sqlStatement instanceof DropProcedureStatement) {
            DropProcedureStatement dropProcedureStatement = (DropProcedureStatement)sqlStatement;
            string = dropProcedureStatement.getProcedureName();
        } else if (sqlStatement instanceof DropIndexStatement) {
            DropIndexStatement dropIndexStatement = (DropIndexStatement)sqlStatement;
            string = dropIndexStatement.getIndexName();
        } else {
            string = sqlStatement.toString();
        }
        String entityName = string;
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entityName})));
    }

    private Seq<SqlStatement> createDropStatements(DatabaseChangeLog databaseChangeLog) {
        List changeSets = databaseChangeLog.getChangeSets();
        return (Seq)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(changeSets).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getChanges()).asScala(), Buffer$.MODULE$.canBuildFrom())).flatMap(this.changes2statements(), Buffer$.MODULE$.canBuildFrom())).sortBy(this.dropOrder(), (Ordering)Ordering.Int$.MODULE$);
    }

    private Function1<SqlStatement, Object> dropOrder() {
        return (Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)XLReleaseDbInitializer.$anonfun$dropOrder$1(x0$2));
    }

    private Function1<Change, Seq<SqlStatement>> changes2statements() {
        return (Function1 & Serializable & scala.Serializable)x0$3 -> {
            Seq seq;
            Change change = x0$3;
            if (change instanceof CreateTableChange) {
                CreateTableChange createTableChange = (CreateTableChange)change;
                Buffer dropStatements = (Buffer)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(createTableChange.getColumns()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$changes2statements$2(x$2)))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$changes2statements$3(x$3)))).map((Function1 & Serializable & scala.Serializable)col -> new DropForeignKeyConstraintStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), col.getConstraints().getForeignKeyName()), Buffer$.MODULE$.canBuildFrom());
                seq = (Seq)dropStatements.$colon$plus((Object)new DropTableStatement(createTableChange.getCatalogName(), createTableChange.getSchemaName(), createTableChange.getTableName(), true), Buffer$.MODULE$.canBuildFrom());
            } else if (change instanceof RenameTableChange) {
                RenameTableChange renameTableChange = (RenameTableChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropTableStatement[]{new DropTableStatement(renameTableChange.getCatalogName(), renameTableChange.getSchemaName(), renameTableChange.getNewTableName(), true)}));
            } else if (change instanceof AddForeignKeyConstraintChange) {
                AddForeignKeyConstraintChange addForeignKeyConstraintChange = (AddForeignKeyConstraintChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropForeignKeyConstraintStatement[]{new DropForeignKeyConstraintStatement(addForeignKeyConstraintChange.getBaseTableCatalogName(), addForeignKeyConstraintChange.getBaseTableSchemaName(), addForeignKeyConstraintChange.getBaseTableName(), addForeignKeyConstraintChange.getConstraintName())}));
            } else if (change instanceof CreateViewChange) {
                CreateViewChange createViewChange = (CreateViewChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropViewStatement[]{new DropViewStatement(createViewChange.getCatalogName(), createViewChange.getSchemaName(), createViewChange.getViewName())}));
            } else if (change instanceof CreateSequenceChange) {
                CreateSequenceChange createSequenceChange = (CreateSequenceChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropSequenceStatement[]{new DropSequenceStatement(createSequenceChange.getCatalogName(), createSequenceChange.getSchemaName(), createSequenceChange.getSequenceName())}));
            } else if (change instanceof CreateProcedureChange) {
                CreateProcedureChange createProcedureChange = (CreateProcedureChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropProcedureStatement[]{new DropProcedureStatement(createProcedureChange.getCatalogName(), createProcedureChange.getSchemaName(), createProcedureChange.getProcedureName())}));
            } else if (change instanceof CreateIndexChange) {
                CreateIndexChange createIndexChange = (CreateIndexChange)change;
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DropIndexStatement[]{new DropIndexStatement(createIndexChange.getIndexName(), createIndexChange.getCatalogName(), createIndexChange.getSchemaName(), createIndexChange.getTableName(), createIndexChange.getAssociatedWith())}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return seq;
        };
    }

    private void deleteDatabaseChangeLogRows(Liquibase liquibase) {
        Database database = liquibase.getDatabase();
        liquibase.getDatabaseChangeLog().getChangeSets().forEach(changeSet -> {
            DeleteStatement deleteStatement = new DeleteStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
            deleteStatement.setWhere("FILENAME = ?");
            deleteStatement.addWhereParameter((Object)changeSet.getFilePath());
            try {
                try {
                    ExecutorService.getInstance().getExecutor(database).execute((SqlStatement)deleteStatement);
                }
                catch (DatabaseException e) {
                    this.logger().debug((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
                }
            }
            finally {
                database.commit();
            }
        });
    }

    private <T> T doWithLiquibase(Function1<Liquibase, T> callback) {
        Object object;
        try (Connection connection = this.dataSource().getConnection();){
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
            Liquibase liquibase = new Liquibase(this.dbConfig(), (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            object = callback.apply((Object)liquibase);
        }
        return (T)object;
    }

    public static final /* synthetic */ boolean $anonfun$isInitialized$1(Liquibase liquibase) {
        return SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(liquibase.getDatabase());
    }

    public static final /* synthetic */ boolean $anonfun$dropMyTables$2(boolean doExecDropSequencesAndTriggers$1, SqlStatement x0$1) {
        SqlStatement sqlStatement = x0$1;
        boolean bl = sqlStatement instanceof DropSequenceStatement ? true : sqlStatement instanceof DropProcedureStatement;
        boolean bl2 = bl ? doExecDropSequencesAndTriggers$1 : true;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$3(XLReleaseDbInitializer $this, Database database$1, SqlStatement dropStatement) {
        try {
            try {
                $this.logDropStatement(dropStatement);
                ExecutorService.getInstance().getExecutor(database$1).execute(dropStatement);
            }
            catch (DatabaseException e) {
                $this.logger().warn((Function0 & Serializable & scala.Serializable)() -> e.getMessage());
            }
        }
        finally {
            database$1.commit();
        }
    }

    public static final /* synthetic */ void $anonfun$dropMyTables$1(XLReleaseDbInitializer $this, Liquibase liquibase) {
        block0: {
            Database database = liquibase.getDatabase();
            boolean doExecDropSequencesAndTriggers = database.getDatabaseProductName().toLowerCase().contains("oracle");
            Seq dropsStatements = (Seq)$this.createDropStatements(liquibase.getDatabaseChangeLog()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XLReleaseDbInitializer.$anonfun$dropMyTables$2(doExecDropSequencesAndTriggers, x0$1)));
            boolean enableForeignKeys = database.supportsForeignKeyDisable() && database.disableForeignKeyChecks();
            dropsStatements.foreach((Function1 & Serializable & scala.Serializable)dropStatement -> {
                XLReleaseDbInitializer.$anonfun$dropMyTables$3($this, database, dropStatement);
                return BoxedUnit.UNIT;
            });
            $this.deleteDatabaseChangeLogRows(liquibase);
            if (!enableForeignKeys) break block0;
            liquibase.getDatabase().enableForeignKeyChecks();
        }
    }

    public static final /* synthetic */ int $anonfun$dropOrder$1(SqlStatement x0$2) {
        SqlStatement sqlStatement = x0$2;
        int n = sqlStatement instanceof DropForeignKeyConstraintStatement ? 0 : (sqlStatement instanceof DropIndexStatement ? 1 : (sqlStatement instanceof DropViewStatement ? 2 : 3));
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$changes2statements$2(ColumnConfig x$2) {
        return x$2.getConstraints() != null;
    }

    public static final /* synthetic */ boolean $anonfun$changes2statements$3(ColumnConfig x$3) {
        return x$3.getConstraints().getForeignKeyName() != null;
    }

    public XLReleaseDbInitializer(String dbConfig, DataSource dataSource) {
        this.dbConfig = dbConfig;
        this.dataSource = dataSource;
        Logging.$init$((Logging)this);
    }
}

