/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.dsl.service.DslExporter;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.versioning.TemplateVersioningException;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse;
import com.xebialabs.xlrelease.versioning.templates.CreateVersionResponse$;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.actors.extensions.TemplateVersionExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings;
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings$;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.views.TemplateContentAndPrevious;
import com.xebialabs.xlrelease.versioning.templates.views.VersionView;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@Path(value="/versioning")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u00015\u0011!\u0004V3na2\fG/\u001a,feNLwN\\5oOJ+7o\\;sG\u0016T!a\u0001\u0003\u0002\u0013Q,W\u000e\u001d7bi\u0016\u001c(BA\u0003\u0007\u0003)1XM]:j_:Lgn\u001a\u0006\u0003\u000f!\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005%Q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0006eg2,\u0005\u0010]8si\u0016\u0014\bCA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0007\u0004\u0002\u0007\u0011\u001cH.\u0003\u0002\u001e1\tYAi\u001d7FqB|'\u000f^3s\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013A\u0007;f[Bd\u0017\r^3SKZL7/[8o%\u0016\u0004xn]5u_JL\bCA\u0011%\u001b\u0005\u0011#BA\u0012\u0003\u0003)\u0011X\r]8tSR|'/_\u0005\u0003K\t\u0012!\u0004V3na2\fG/\u001a*fm&\u001c\u0018n\u001c8SKB|7/\u001b;pefD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0017i\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dKB\u0011\u0011FK\u0007\u0002\u0005%\u00111F\u0001\u0002\u0017)\u0016l\u0007\u000f\\1uKN#xN]1hKN+'O^5dK\"AQ\u0006\u0001B\u0001B\u0003%a&A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u00020e5\t\u0001G\u0003\u00022\r\u00051\u0011m\u0019;peNL!a\r\u0019\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\t\u0011U\u0002!\u0011!Q\u0001\nY\n\u0011\u0003]3s[&\u001c8/[8o\u0007\",7m[3s!\t9$(D\u00019\u0015\tId!\u0001\u0005tK\u000e,(/\u001b;z\u0013\tY\u0004HA\tQKJl\u0017n]:j_:\u001c\u0005.Z2lKJD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f!\ty\u0014)D\u0001A\u0015\tIb!\u0003\u0002C\u0001\nq!+\u001a7fCN,7+\u001a:wS\u000e,\u0007\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\u0002/\r|gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL\bC\u0001$I\u001b\u00059%BA\u0012\u0007\u0013\tIuIA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\")1\n\u0001C\u0001\u0019\u00061A(\u001b8jiz\"\u0002\"\u0014(P!F\u00136\u000b\u0016\t\u0003S\u0001AQ!\u0006&A\u0002YAQa\b&A\u0002\u0001BQa\n&A\u0002!BQ!\f&A\u00029BQ!\u000e&A\u0002YBQ!\u0010&A\u0002yBQ\u0001\u0012&A\u0002\u0015C#A\u0013,\u0011\u0005]\u0013W\"\u0001-\u000b\u0005eS\u0016AC1o]>$\u0018\r^5p]*\u00111\fX\u0001\bM\u0006\u001cGo\u001c:z\u0015\tif,A\u0003cK\u0006t7O\u0003\u0002`A\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001b\u0003\ry'oZ\u0005\u0003Gb\u0013\u0011\"Q;u_^L'/\u001a3\t\u000b\u0015\u0004A\u0011\u00014\u0002=\u001d,G\u000fV3na2\fG/\u001a,feNLwN\\8j]\u001e\u001cV\r\u001e;j]\u001e\u001cX#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017A\u00023p[\u0006LgN\u0003\u0002m\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!A\\5\u00035Q+W\u000e\u001d7bi\u00164VM]:j_:LgnZ*fiRLgnZ:)\t\u0011\u0004(p\u001f\t\u0003cbl\u0011A\u001d\u0006\u0003gR\f!A]:\u000b\u0005U4\u0018AA<t\u0015\u00059\u0018!\u00026bm\u0006D\u0018BA=s\u0005\u0011\u0001\u0016\r\u001e5\u0002\u000bY\fG.^3\"\u0003q\f\u0011bL:fiRLgnZ:)\u0005\u0011t\bCA9\u0000\u0013\r\t\tA\u001d\u0002\u0004\u000f\u0016#\u0006bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\rO\u0016$(+\u001a<jg&|gn\u001d\u000b\u0005\u0003\u0013\t)\u0002\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyA]\u0001\u0005G>\u0014X-\u0003\u0003\u0002\u0014\u00055!\u0001\u0003*fgB|gn]3\t\u0011\u0005]\u00111\u0001a\u0001\u00033\t!\u0002^3na2\fG/Z%e!\u0011\tY\"!\u000b\u000f\t\u0005u\u0011Q\u0005\t\u0004\u0003?\u0001RBAA\u0011\u0015\r\t\u0019\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\u0001\u0002\u0006BA\u000b\u0003c\u0001B!a\r\u0002B5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0002jI*!\u00111HA\u001f\u0003!\u0001H.^7cS:<'bAA \u0011\u0005AA-\u001a9m_fLG/\u0003\u0003\u0002D\u0005U\"aB%e!\u0006\u0014\u0018-\u001c\u0015\b\u0003+\t9E_A'!\r\t\u0018\u0011J\u0005\u0004\u0003\u0017\u0012(!\u0003)bi\"\u0004\u0016M]1nC\t\t9\u0002\u000b\u0004\u0002\u0004AT\u0018\u0011K\u0011\u0003\u0003'\nqeL>uK6\u0004H.\u0019;f\u0013\u0012TdF\u000b*fY\u0016\f7/Z.__5j&&`\u0018sKZL7/[8og\"\u001a\u00111\u0001@\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005\u0011r-\u001a;SKZL7/[8o\u0007>tG/\u001a8u)\u0019\tI!!\u0018\u0002d!A\u0011qCA,\u0001\u0004\tI\u0002\u000b\u0003\u0002^\u0005E\u0002fBA/\u0003\u000fR\u0018Q\n\u0005\t\u0003K\n9\u00061\u0001\u0002h\u0005Q!/\u001a<jg&|g.\u00133\u0011\u0007=\tI'C\u0002\u0002lA\u00111!\u00138uQ\u001d\t\u0019'a\u0012{\u0003_\n#!!\u001a)\r\u0005]\u0003O_A:C\t\t)(\u0001\u001f0wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_I,g/[:j_:\u001cxf\u001f:fm&\u001c\u0018n\u001c8JIv|3m\u001c8uK:$\bfAA,}\"9\u00111\u0010\u0001\u0005\u0002\u0005u\u0014!D2sK\u0006$XMV3sg&|g\u000e\u0006\u0004\u0002\n\u0005}\u0014Q\u0011\u0005\t\u0003/\tI\b1\u0001\u0002\u001a!\"\u0011qPA\u0019Q\u001d\ty(a\u0012{\u0003\u001bB\u0001\"a\"\u0002z\u0001\u0007\u0011\u0011R\u0001\fm\u0016\u00148/[8o-&,w\u000f\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\tyIA\u0001\u0006m&,wo]\u0005\u0005\u0003'\u000biIA\u0006WKJ\u001c\u0018n\u001c8WS\u0016<\bFBA=aj\f9*\t\u0002\u0002\u001a\u00061sf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSSp\f<feNLwN\\:)\t\u0005e\u0014Q\u0014\t\u0004c\u0006}\u0015bAAQe\n!\u0001kT*U\u0011\u001d\t)\u000b\u0001C\u0001\u0003O\u000bqB]3ti>\u0014XMU3wSNLwN\u001c\u000b\u0007\u0003\u0013\tI+a,\t\u0011\u0005]\u00111\u0015a\u0001\u00033AC!!+\u00022!:\u0011\u0011VA$u\u00065\u0003\u0002CA3\u0003G\u0003\r!a\u001a)\u000f\u0005=\u0016q\t>\u0002p!2\u00111\u00159{\u0003k\u000b#!a.\u0002y=ZH/Z7qY\u0006$X-\u00133;])\u0012V\r\\3bg\u0016\\flL\u0017^Uu|#/\u001a<jg&|gn]\u0018|e\u00164\u0018n]5p]&#Wp\f:fgR|'/\u001a\u0015\u0005\u0003G\u000bY\fE\u0002r\u0003{K1!a0s\u0005\r\u0001V\u000b\u0016\u0005\b\u0003\u0007\u0004A\u0011AAc\u0003\u001d\u0019w.\u001c9be\u0016$\u0002\"a2\u0002N\u0006M\u0017\u0011\u001e\t\u0005\u0003\u0017\u000bI-\u0003\u0003\u0002L\u00065%A\u0007+f[Bd\u0017\r^3D_:$XM\u001c;B]\u0012\u0004&/\u001a<j_V\u001c\b\u0002CA\f\u0003\u0003\u0004\r!!\u0007)\t\u00055\u0017\u0011\u0007\u0015\b\u0003\u001b\f9E_A'\u0011!\t)'!1A\u0002\u0005\u001d\u0004fBAj\u0003/T\u0018q\u000e\t\u0004c\u0006e\u0017bAAne\nQ\u0011+^3ssB\u000b'/Y7)\u000f\u0005M\u0017q\u001c>\u0002fB\u0019\u0011/!9\n\u0007\u0005\r(O\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u0002h\u0006\t\u0001\u0007\u0003\u0005\u0002l\u0006\u0005\u0007\u0019AA4\u00031!xNU3wSNLwN\\%eQ\u001d\tI/a6{\u0003_\f#!a;)\r\u0005\u0005\u0007O_AzC\t\t)0A\u00130wR,W\u000e\u001d7bi\u0016LEM\u000f\u0018+%\u0016dW-Y:f7z{S&\u0018\u0016~_\r|W\u000e]1sK\"\u001a\u0011\u0011\u0019@\t\u000f\u0005m\b\u0001\"\u0001\u0002~\u0006!r-\u001a;SKN|G.\u001e;j_:\u001cuN\u001c;fqR$B!a@\u0003\fA!!\u0011\u0001B\u0004\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\u0005e\u0012!D:fe&\fG.\u001b>bi&|g.\u0003\u0003\u0003\n\t\r!!\u0005*fg>dW\u000f^5p]\u000e{g\u000e^3yi\"A\u0011qCA}\u0001\u0004\tI\u0002C\u0004\u0003\u0010\u0001!IA!\u0005\u0002!\u001d,G\u000fV3na2\fG/Z!t\tNdG\u0003BA\r\u0005'A\u0001B!\u0006\u0003\u000e\u0001\u0007!qC\u0001\ti\u0016l\u0007\u000f\\1uKB!!\u0011\u0004B\u000f\u001b\t\u0011YB\u0003\u0002k\r%!!q\u0004B\u000e\u0005\u001d\u0011V\r\\3bg\u0016D3\u0001\u0001B\u0012!\u0011\u0011)Ca\u000b\u000e\u0005\t\u001d\"b\u0001B\u0015=\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t5\"q\u0005\u0002\u000b\u0007>tGO]8mY\u0016\u0014\bF\u0002\u0001\u00032i\u00149\u0004E\u0002r\u0005gI1A!\u000es\u0005!\u0019uN\\:v[\u0016\u001cHF\u0001B\u001dC\t\u0011Y$\u0001\tbaBd\u0017nY1uS>twF[:p]\"2\u0001Aa\u0010{\u0005\u000b\u00022!\u001dB!\u0013\r\u0011\u0019E\u001d\u0002\t!J|G-^2fg2\u0012!\u0011\b\u0015\u0006\u0001AT(\u0011J\u0011\u0003\u0005\u0017\n1b\f<feNLwN\\5oO\u0002")
public class TemplateVersioningResource {
    private final DslExporter dslExporter;
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateStorageService templateStorageService;
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ReleaseService releaseService;
    private final ConfigurationRepository configurationRepository;

    @GET
    @Path(value="/settings")
    public TemplateVersioningSettings getTemplateVersionoingSettings() {
        return (TemplateVersioningSettings)this.configurationRepository.read(TemplateVersioningSettings$.MODULE$.TEMPLATE_VERSIONING_ID());
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions")
    public Response getRevisions(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkView(templateId);
        List<TemplateRevision> templateRevisions = this.templateRevisionRepository.find(templateId, new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0)));
        GenericEntity<List<TemplateRevision>> entity = new GenericEntity<List<TemplateRevision>>(null, templateRevisions){};
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/content")
    public Response getRevisionContent(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        this.permissionChecker.checkView(templateId);
        Release template = this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        return Response.ok((Object)this.getTemplateAsDsl(template), (String)"text/plain").build();
    }

    @POST
    @Path(value="/{templateId:.*Release[^/-]*}/versions")
    public Response createVersion(@PathParam(value="templateId") @IdParam String templateId, VersionView versionView) {
        Checks.checkArgument((boolean)this.releaseService.isTemplate(templateId), (String)"Snapshots can only be created for templates", (Object[])new Object[0]);
        this.permissionChecker.checkEdit(templateId);
        Try result = (Try)this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.NewTemplateVersion(versionView.name(), versionView.description(), Permissions.getAuthenticatedUserName()));
        return Response.ok((Object)result.fold((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CreateVersionResponse createVersionResponse;
            Throwable throwable = x0$1;
            if (throwable instanceof TemplateVersioningException) {
                TemplateVersioningException templateVersioningException = (TemplateVersioningException)((Object)((Object)throwable));
                String msg = templateVersioningException.msg();
                int statusCode = templateVersioningException.statusCode();
                createVersionResponse = new CreateVersionResponse(false, msg, statusCode);
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                createVersionResponse = new CreateVersionResponse(false, throwable2.getMessage(), 500);
            } else {
                throw new MatchError((Object)throwable);
            }
            return createVersionResponse;
        }, (Function1 & Serializable & scala.Serializable)id -> TemplateVersioningResource.$anonfun$createVersion$2(BoxesRunTime.unboxToInt((Object)id)))).build();
    }

    @PUT
    @Path(value="/{templateId:.*Release[^/-]*}/revisions/{revisionId}/restore")
    public Response restoreRevision(@PathParam(value="templateId") @IdParam String templateId, @PathParam(value="revisionId") int revisionId) {
        Release template = this.releaseService.findById(templateId);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, template);
        this.permissionChecker.check(XLReleasePermissions.EDIT_TRIGGERS, template);
        this.permissionChecker.check(XLReleasePermissions.CREATE_RELEASE_FROM_TEMPLATE, template);
        this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new TemplateVersionExtensionActorMessages.RestoreRevision(revisionId));
        return Response.ok().build();
    }

    @GET
    @Path(value="/{templateId:.*Release[^/-]*}/compare")
    public TemplateContentAndPrevious compare(@PathParam(value="templateId") @IdParam String templateId, @DefaultValue(value="0") @QueryParam(value="revisionId") int revisionId, @QueryParam(value="toRevisionId") int toRevisionId) {
        this.permissionChecker.checkView(templateId);
        Release revision = revisionId == 0 ? this.releaseService.findById(templateId) : this.templateStorageService.load(revisionId, this.getResolutionContext(templateId));
        Release toRevision = this.templateStorageService.load(toRevisionId, this.getResolutionContext(templateId));
        return new TemplateContentAndPrevious(this.getTemplateAsDsl(revision), this.getTemplateAsDsl(toRevision));
    }

    public ResolutionContext getResolutionContext(String templateId) {
        return Ids.isInFolder((String)templateId) ? new ResolutionContext((Option)new Some((Object)Ids.getParentId((String)templateId))) : new ResolutionContext((Option)None$.MODULE$);
    }

    private String getTemplateAsDsl(Release template) {
        return this.dslExporter.exportTemplate(template, this.dslExporter.exportTemplate$default$2());
    }

    public static final /* synthetic */ CreateVersionResponse $anonfun$createVersion$2(int id) {
        return new CreateVersionResponse(true, ((Object)BoxesRunTime.boxToInteger((int)id)).toString(), CreateVersionResponse$.MODULE$.$lessinit$greater$default$3());
    }

    @Autowired
    public TemplateVersioningResource(DslExporter dslExporter, TemplateRevisionRepository templateRevisionRepository, TemplateStorageService templateStorageService, ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ReleaseService releaseService, ConfigurationRepository configurationRepository) {
        this.dslExporter = dslExporter;
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateStorageService = templateStorageService;
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.releaseService = releaseService;
        this.configurationRepository = configurationRepository;
    }
}

