/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.templates;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.xlplatform.upgrade.RepositoryVersionService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseRestoredEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.CiHelper;
import com.xebialabs.xlrelease.repository.DependencyTargetResolver;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.upgrade.Components;
import com.xebialabs.xlrelease.versioning.scm.ScmConnector;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorFactory$;
import com.xebialabs.xlrelease.versioning.scm.ScmTemplateToBlobsConverter;
import com.xebialabs.xlrelease.versioning.scm.ValidatedCommitInfo;
import com.xebialabs.xlrelease.versioning.scm.ValidatedCommitInfo$;
import com.xebialabs.xlrelease.versioning.scm.domain.ScmConnectedTemplate;
import com.xebialabs.xlrelease.versioning.scm.domain.ScmConnectedTemplate$;
import com.xebialabs.xlrelease.versioning.scm.domain.ScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.templates.ReleaseVersioningSerialization;
import com.xebialabs.xlrelease.versioning.templates.TemplateStorageService;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionDataRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.TemplateRevisionRepository;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevision;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionData;
import com.xebialabs.xlrelease.versioning.templates.repository.persistence.data.TemplateRevisionType$;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@Service
@Primary
@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u00015\u0011\u0001\u0004\u00122UK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0015\t\u0019A!A\u0005uK6\u0004H.\u0019;fg*\u0011QAB\u0001\u000bm\u0016\u00148/[8oS:<'BA\u0004\t\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\n\u0015\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\fUK6\u0004H.\u0019;f'R|'/Y4f'\u0016\u0014h/[2f\u0011!I\u0002A!A!\u0002\u0013Q\u0012A\u0007;f[Bd\u0017\r^3SKZL7/[8o%\u0016\u0004xn]5u_JL\bCA\u000e\u001f\u001b\u0005a\"BA\u000f\u0003\u0003)\u0011X\r]8tSR|'/_\u0005\u0003?q\u0011!\u0004V3na2\fG/\u001a*fm&\u001c\u0018n\u001c8SKB|7/\u001b;pefD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0001\u001fi\u0016l\u0007\u000f\\1uKJ+g/[:j_:$\u0015\r^1SKB|7/\u001b;pef\u0004\"aG\u0012\n\u0005\u0011b\"A\b+f[Bd\u0017\r^3SKZL7/[8o\t\u0006$\u0018MU3q_NLGo\u001c:z\u0011!1\u0003A!A!\u0002\u00139\u0013A\b:fY\u0016\f7/\u001a,feNLwN\\5oON+'/[1mSj\fG/[8o!\t)\u0002&\u0003\u0002*\u0005\tq\"+\u001a7fCN,g+\u001a:tS>t\u0017N\\4TKJL\u0017\r\\5{CRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007CA\u00171\u001b\u0005q#BA\u0018\u0007\u0003\u001d\u0019XM\u001d<jG\u0016L!!\r\u0018\u0003\u001dI+G.Z1tKN+'O^5dK\"A1\u0007\u0001B\u0001B\u0003%A'A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"!N\u001c\u000e\u0003YR!!\b\u0004\n\u0005a2$!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\"A!\b\u0001B\u0001B\u0003%1(A\u0006uCN\\7+\u001a:wS\u000e,\u0007CA\u0017=\u0013\tidFA\u0006UCN\\7+\u001a:wS\u000e,\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\u0002\u0017Q,\u0017-\\*feZL7-\u001a\t\u0003[\u0005K!A\u0011\u0018\u0003\u0017Q+\u0017-\\*feZL7-\u001a\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\u0006A\"/\u001a9pg&$xN]=WKJ\u001c\u0018n\u001c8TKJ4\u0018nY3\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015aB;qOJ\fG-\u001a\u0006\u0003\u0015\"\t!\u0002\u001f7qY\u0006$hm\u001c:n\u0013\tauI\u0001\rSKB|7/\u001b;pef4VM]:j_:\u001cVM\u001d<jG\u0016D\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IaT\u0001\tKZ,g\u000e\u001e\"vgB\u0011\u0001kU\u0007\u0002#*\u0011!KB\u0001\u0007KZ,g\u000e^:\n\u0005Q\u000b&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\"Aa\u000b\u0001B\u0001B\u0003%q+\u0001\reKB,g\u000eZ3oGf$\u0016M]4fiJ+7o\u001c7wKJ\u0004\"!\u000e-\n\u0005e3$\u0001\u0007#fa\u0016tG-\u001a8dsR\u000b'oZ3u%\u0016\u001cx\u000e\u001c<fe\"A1\f\u0001B\u0001B\u0003%A,A\u000etG6$V-\u001c9mCR,Gk\u001c\"m_\n\u001c8i\u001c8wKJ$XM\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0012\t1a]2n\u0013\t\tgLA\u000eTG6$V-\u001c9mCR,Gk\u001c\"m_\n\u001c8i\u001c8wKJ$XM\u001d\u0005\u0006G\u0002!\t\u0001Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u00154w\r[5kW2lgn\u001c9\u0011\u0005U\u0001\u0001\"B\rc\u0001\u0004Q\u0002\"B\u0011c\u0001\u0004\u0011\u0003\"\u0002\u0014c\u0001\u00049\u0003\"B\u0016c\u0001\u0004a\u0003\"B\u001ac\u0001\u0004!\u0004\"\u0002\u001ec\u0001\u0004Y\u0004\"B c\u0001\u0004\u0001\u0005\"\u0002#c\u0001\u0004)\u0005\"\u0002(c\u0001\u0004y\u0005\"\u0002,c\u0001\u00049\u0006\"B.c\u0001\u0004a\u0006F\u00012s!\t\u0019h0D\u0001u\u0015\t)h/\u0001\u0006b]:|G/\u0019;j_:T!a\u001e=\u0002\u000f\u0019\f7\r^8ss*\u0011\u0011P_\u0001\u0006E\u0016\fgn\u001d\u0006\u0003wr\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002{\u0006\u0019qN]4\n\u0005}$(!C!vi><\u0018N]3e\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000b\tAa]1wKRA\u0011qAA\u0007\u0003;\t9\u0004E\u0002\u0010\u0003\u0013I1!a\u0003\u0011\u0005\u0011)f.\u001b;\t\u0011\u0005=\u0011\u0011\u0001a\u0001\u0003#\t\u0001\u0002^3na2\fG/\u001a\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0004\u0002\r\u0011|W.Y5o\u0013\u0011\tY\"!\u0006\u0003\u000fI+G.Z1tK\"A\u0011qDA\u0001\u0001\u0004\t\t#\u0001\u0003vg\u0016\u0014\b\u0003BA\u0012\u0003cqA!!\n\u0002.A\u0019\u0011q\u0005\t\u000e\u0005\u0005%\"bAA\u0016\u0019\u00051AH]8pizJ1!a\f\u0011\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0006\t\t\u0011\u0005e\u0012\u0011\u0001a\u0001\u0003C\t1\u0002Z3tGJL\u0007\u000f^5p]\"9\u0011Q\b\u0001\u0005B\u0005}\u0012\u0001E2sK\u0006$XMT3x-\u0016\u00148/[8o))\t\t%a\u0015\u0002X\u0005m\u0013Q\f\t\u0007\u0003\u0007\nI%!\u0014\u000e\u0005\u0005\u0015#bAA$!\u0005!Q\u000f^5m\u0013\u0011\tY%!\u0012\u0003\u0007Q\u0013\u0018\u0010E\u0002\u0010\u0003\u001fJ1!!\u0015\u0011\u0005\rIe\u000e\u001e\u0005\t\u0003+\nY\u00041\u0001\u0002\"\u0005QA/Z7qY\u0006$X-\u00133\t\u0011\u0005e\u00131\ba\u0001\u0003C\tqA^3sg&|g\u000e\u0003\u0005\u0002:\u0005m\u0002\u0019AA\u0011\u0011!\ty\"a\u000fA\u0002\u0005\u0005\u0002bBA1\u0001\u0011%\u00111M\u0001\u000fGJ,\u0017\r^3SKZL7/[8o)1\t)'!\u001e\u0002x\u0005}\u0014\u0011QAB!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\nA\u0001Z1uC*\u0019\u0011q\u000e\u000f\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0005\u0003g\nIG\u0001\tUK6\u0004H.\u0019;f%\u00164\u0018n]5p]\"A\u0011qBA0\u0001\u0004\t\t\u0002\u0003\u0005\u0002Z\u0005}\u0003\u0019AA=!\u0015y\u00111PA\u0011\u0013\r\ti\b\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005e\u0012q\fa\u0001\u0003CA\u0001\"a\b\u0002`\u0001\u0007\u0011\u0011\u0005\u0005\t\u0003\u000b\u000by\u00061\u0001\u0002\b\u0006a!/\u001a<jg&|g\u000eV=qKB!\u0011\u0011RAX\u001d\u0011\tY)a+\u000f\t\u00055\u0015\u0011\u0016\b\u0005\u0003\u001f\u000b9K\u0004\u0003\u0002\u0012\u0006\u0015f\u0002BAJ\u0003GsA!!&\u0002\":!\u0011qSAP\u001d\u0011\tI*!(\u000f\t\u0005\u001d\u00121T\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011BA\u000f\u0003\u0013\r\ty\u0007H\u0005\u0005\u0003W\ni'\u0003\u0003\u0002.\u0006%\u0014\u0001\u0006+f[Bd\u0017\r^3SKZL7/[8o)f\u0004X-\u0003\u0003\u00022\u0006M&\u0001\u0006+f[Bd\u0017\r^3SKZL7/[8o)f\u0004XM\u0003\u0003\u0002.\u0006%\u0004bBA\\\u0001\u0011\u0005\u0013\u0011X\u0001\be\u0016\u001cHo\u001c:f)\u0019\t\t\"a/\u0002>\"A\u0011QKA[\u0001\u0004\t\t\u0003\u0003\u0005\u0002@\u0006U\u0006\u0019AA'\u0003)\u0011XM^5tS>t\u0017\n\u001a\u0005\b\u0003\u0007\u0004A\u0011IAc\u0003\u0011aw.\u00193\u0015\r\u0005E\u0011qYAe\u0011!\ty,!1A\u0002\u00055\u0003\u0002CAf\u0003\u0003\u0004\r!!4\u0002\u000f\r|g\u000e^3yiB!\u0011qZAo\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017!D:fe&\fG.\u001b>bi&|gN\u0003\u0003\u0002X\u0006e\u0017\u0001\u00039mk6\u0014\u0017N\\4\u000b\u0007\u0005m\u0007\"\u0001\u0005eKBdw._5u\u0013\u0011\ty.!5\u0003#I+7o\u001c7vi&|gnQ8oi\u0016DH\u000fC\u0004\u0002d\u0002!I!!:\u0002/A\u0014xnY3tgJ+7\u000f^8sK\u0012$V-\u001c9mCR,GCBA\u0004\u0003O\fY\u000f\u0003\u0005\u0002j\u0006\u0005\b\u0019AA\t\u0003A\u0011Xm\u001d;pe\u0016$G+Z7qY\u0006$X\r\u0003\u0005\u0002n\u0006\u0005\b\u0019AA\t\u0003=\u0019WO\u001d:f]R$V-\u001c9mCR,\u0007bBAy\u0001\u0011%\u00111_\u0001\u0014aJ|7-Z:t\t\u0016\u0004XM\u001c3f]\u000eLWm\u001d\u000b\u0005\u0003#\t)\u0010\u0003\u0005\u0002j\u0006=\b\u0019AA\t\u0011\u001d\tI\u0010\u0001C\u0005\u0003w\f\u0011\u0003\\8bI2\u000bG/Z:u-\u0016\u00148/[8o)\u0011\ti0a@\u0011\u000b=\tY(!\u0005\t\u0011\u0005U\u0013q\u001fa\u0001\u0003CAqAa\u0001\u0001\t\u0013\u0011)!A\u000epm\u0016\u0014(/\u001b3f/&$\b\u000eT1uKN$8kY7D_:4\u0017n\u001a\u000b\u0007\u0003#\u00119Aa\u0003\t\u0011\t%!\u0011\u0001a\u0001\u0003#\t\u0001\u0003\u001d:fm&|Wo\u001d+f[Bd\u0017\r^3\t\u0011\u00055(\u0011\u0001a\u0001\u0003#AqAa\u0004\u0001\t\u0013\u0011\t\"\u0001\u0006yYJ4VM]:j_:,\"!!\t)\u0007\u0001\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0015RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0005\u0005?\u0011\t#A\u0002tc2T1Aa\t\u0007\u0003\t!'-\u0003\u0003\u0003(\te!aD%t)J\fgn]1di&|g.\u00197)\u0007\u0001\u0011Y\u0003\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\r)(\u0011\u0007\u0006\u0004\u0003\u0017T\u0018\u0002\u0002B\u001b\u0005_\u0011q\u0001\u0015:j[\u0006\u0014\u0018\u0010K\u0002\u0001\u0005s\u0001BAa\u000f\u0003B5\u0011!Q\b\u0006\u0004\u0005\u007fQ\u0018AC:uKJ,w\u000e^=qK&!!1\tB\u001f\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DbTemplateStorageService
implements TemplateStorageService {
    private final TemplateRevisionRepository templateRevisionRepository;
    private final TemplateRevisionDataRepository templateRevisionDataRepository;
    private final ReleaseVersioningSerialization releaseVersioningSerialization;
    private final ReleaseService releaseService;
    private final ReleaseRepository releaseRepository;
    private final RepositoryVersionService repositoryVersionService;
    private final XLReleaseEventBus eventBus;
    private final DependencyTargetResolver dependencyTargetResolver;
    private final ScmTemplateToBlobsConverter scmTemplateToBlobsConverter;

    @Override
    public void save(Release template, String user, String description) {
        this.createRevision(template, (Option<String>)None$.MODULE$, description, user, TemplateRevisionType$.MODULE$.REVISION());
    }

    @Override
    public Try<Object> createNewVersion(String templateId, String version, String description, String user) {
        Release template = this.releaseService.findById(templateId);
        ScmConnector scmConnector = ScmConnectorFactory$.MODULE$.createScmConnector(template);
        ValidatedCommitInfo info = (ValidatedCommitInfo)ValidatedCommitInfo$.MODULE$.create(version, description).get();
        return scmConnector.createNewVersion(this.scmTemplateToBlobsConverter.convertTemplate(template), info, user).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DbTemplateStorageService.$anonfun$createNewVersion$1(this, version, description, user, template, x$1)));
    }

    private TemplateRevision createRevision(Release template, Option<String> version, String description, String user, int revisionType) {
        TemplateRevision templateRevision = new TemplateRevision();
        templateRevision.ciUid_$eq(Predef$.MODULE$.Integer2int(template.getCiUid()));
        templateRevision.revisionType_$eq(revisionType);
        if (version.isDefined()) {
            templateRevision.version_$eq((String)version.get());
        }
        templateRevision.description_$eq(description);
        templateRevision.username_$eq(user);
        templateRevision.revisionTime_$eq(new Date());
        TemplateRevision savedTr = this.templateRevisionRepository.create(templateRevision);
        TemplateRevisionData trd = new TemplateRevisionData(savedTr.id(), this.xlrVersion(), this.releaseVersioningSerialization.toBytes(template));
        this.templateRevisionDataRepository.create(trd);
        return savedTr;
    }

    @Override
    public Release restore(String templateId, int revisionId) {
        block0: {
            TemplateRevision latestRevision = (TemplateRevision)this.templateRevisionRepository.latestRevision(templateId).get();
            if (revisionId == latestRevision.id()) break block0;
            Release currentTemplate = this.releaseService.findById(templateId);
            ResolutionContext context = Ids.isInFolder((String)templateId) ? new ResolutionContext((Option)new Some((Object)Ids.getParentId((String)templateId))) : new ResolutionContext((Option)None$.MODULE$);
            Release previousTemplate = this.load(revisionId, context);
            previousTemplate = this.overrideWithLatestScmConfig(previousTemplate, currentTemplate);
            this.processRestoredTemplate(previousTemplate, currentTemplate);
            Release updatedTemplate = this.releaseRepository.replace(currentTemplate, previousTemplate);
            this.eventBus.publish((XLReleaseEvent)new ReleaseRestoredEvent(currentTemplate, updatedTemplate, revisionId));
        }
        return this.releaseService.findById(templateId);
    }

    @Override
    public Release load(int revisionId, ResolutionContext context) {
        Release release;
        Option<TemplateRevisionData> option = this.templateRevisionDataRepository.findById(revisionId);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateRevisionData trd = (TemplateRevisionData)some.value();
            Option<Release> option2 = this.releaseVersioningSerialization.fromBytes(trd.content(), trd.dataModelVersion(), context);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading ", ", see logs for more details"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
                }
                throw new MatchError(option2);
            }
            Some some2 = (Some)option2;
            Release template = (Release)some2.value();
            release = this.processDependencies(template);
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Revision id ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)revisionId)})), new Object[0]);
            }
            throw new MatchError(option);
        }
        Release release2 = release;
        return release2;
    }

    private void processRestoredTemplate(Release restoredTemplate, Release currentTemplate) {
        restoredTemplate.setCiUid(currentTemplate.getCiUid());
        CiHelper.rewriteWithNewId((ConfigurationItem)restoredTemplate, (String)currentTemplate.getId());
        restoredTemplate.setRunningTriggeredReleasesCount(currentTemplate.getRunningTriggeredReleasesCount());
        this.processDependencies(restoredTemplate);
    }

    private Release processDependencies(Release restoredTemplate) {
        restoredTemplate.getAllGates().forEach(gateTask -> {
            List validDependencies = gateTask.getDependencies().stream().filter(d -> d.hasResolvedTarget() || Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.dependencyTargetResolver.resolveTarget(d)).isSuccess()).collect(Collectors.toList());
            gateTask.setDependencies(validDependencies);
        });
        return restoredTemplate;
    }

    private Option<Release> loadLatestVersion(String templateId) {
        ResolutionContext context = Ids.isInFolder((String)templateId) ? new ResolutionContext((Option)new Some((Object)Ids.getParentId((String)templateId))) : new ResolutionContext((Option)None$.MODULE$);
        return this.templateRevisionRepository.latestVersion(templateId).map((Function1 & Serializable & scala.Serializable)template -> this.load(template.id(), context));
    }

    private Release overrideWithLatestScmConfig(Release previousTemplate, Release currentTemplate) {
        Release release;
        ScmConnectedTemplate scmConnectedTemplate;
        Option<Tuple2<Release, ScmConnectorConfig>> option;
        Release release2 = currentTemplate;
        if (release2 instanceof ScmConnectedTemplate && !(option = ScmConnectedTemplate$.MODULE$.unapply(scmConnectedTemplate = (ScmConnectedTemplate)release2)).isEmpty()) {
            ScmConnectorConfig currentScmConfig = (ScmConnectorConfig)((Object)((Tuple2)option.get())._2());
            release = ScmConnectedTemplate$.MODULE$.apply(previousTemplate, currentScmConfig);
        } else {
            Release template;
            ScmConnectedTemplate scmConnectedTemplate2;
            Option<Tuple2<Release, ScmConnectorConfig>> option2;
            Release release3 = previousTemplate;
            Release release4 = release3 instanceof ScmConnectedTemplate && !(option2 = ScmConnectedTemplate$.MODULE$.unapply(scmConnectedTemplate2 = (ScmConnectedTemplate)release3)).isEmpty() ? (template = (Release)((Tuple2)option2.get())._1()) : previousTemplate;
            release = release4;
        }
        return release;
    }

    private String xlrVersion() {
        Version version = this.repositoryVersionService.readVersionOfComponent(Components.XL_RELEASE_COMPONENT);
        return version == null ? "0.0.0" : version.getVersion();
    }

    public static final /* synthetic */ int $anonfun$createNewVersion$1(DbTemplateStorageService $this, String version$1, String description$1, String user$1, Release template$1, String x$1) {
        return $this.createRevision(template$1, (Option<String>)new Some((Object)version$1), description$1, user$1, TemplateRevisionType$.MODULE$.VERSION()).id();
    }

    @Autowired
    public DbTemplateStorageService(TemplateRevisionRepository templateRevisionRepository, TemplateRevisionDataRepository templateRevisionDataRepository, ReleaseVersioningSerialization releaseVersioningSerialization, ReleaseService releaseService, ReleaseRepository releaseRepository, TaskService taskService, TeamService teamService, RepositoryVersionService repositoryVersionService, XLReleaseEventBus eventBus, DependencyTargetResolver dependencyTargetResolver, ScmTemplateToBlobsConverter scmTemplateToBlobsConverter) {
        this.templateRevisionRepository = templateRevisionRepository;
        this.templateRevisionDataRepository = templateRevisionDataRepository;
        this.releaseVersioningSerialization = releaseVersioningSerialization;
        this.releaseService = releaseService;
        this.releaseRepository = releaseRepository;
        this.repositoryVersionService = repositoryVersionService;
        this.eventBus = eventBus;
        this.dependencyTargetResolver = dependencyTargetResolver;
        this.scmTemplateToBlobsConverter = scmTemplateToBlobsConverter;
    }
}

