/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.versioning.scm;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActorMessages;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.versioning.scm.GHRepoInfo;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorFactory$;
import com.xebialabs.xlrelease.versioning.scm.ScmConnectorService;
import com.xebialabs.xlrelease.versioning.scm.actors.extensions.ScmTemplateExtensionActorMessages;
import com.xebialabs.xlrelease.versioning.scm.domain.NoScmConnectorConfig;
import com.xebialabs.xlrelease.versioning.scm.domain.ScmConnectedTemplate;
import com.xebialabs.xlrelease.versioning.scm.domain.ScmConnectorConfig;
import com.xebialabs.xlrelease.views.ConfigurationStatusResponse;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@Path(value="/scm")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011AcU2n\u0007>tg.Z2u_J\u0014Vm]8ve\u000e,'BA\u0002\u0005\u0003\r\u00198-\u001c\u0006\u0003\u000b\u0019\t!B^3sg&|g.\u001b8h\u0015\t9\u0001\"A\u0005yYJ,G.Z1tK*\u0011\u0011BC\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002'I,G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0011\u0005]QR\"\u0001\r\u000b\u0005e1\u0011AB1di>\u00148/\u0003\u0002\u001c1\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN+'O^5dK\"AQ\u0004\u0001B\u0001B\u0003%a$A\tqKJl\u0017n]:j_:\u001c\u0005.Z2lKJ\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0004\u0002\u0011M,7-\u001e:jifL!a\t\u0011\u0003#A+'/\\5tg&|gn\u00115fG.,'\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003M\u00198-\\\"p]:,7\r^8s'\u0016\u0014h/[2f!\t9\u0003&D\u0001\u0003\u0013\tI#AA\nTG6\u001cuN\u001c8fGR|'oU3sm&\u001cW\rC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0005[9z\u0003\u0007\u0005\u0002(\u0001!)QC\u000ba\u0001-!)QD\u000ba\u0001=!)QE\u000ba\u0001M!\u0012!F\r\t\u0003gyj\u0011\u0001\u000e\u0006\u0003kY\n!\"\u00198o_R\fG/[8o\u0015\t9\u0004(A\u0004gC\u000e$xN]=\u000b\u0005eR\u0014!\u00022fC:\u001c(BA\u001e=\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@i\tI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\rO\u0016$8kY7D_:4\u0017n\u001a\u000b\u0003\u0007>\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\t\r|'/\u001a\u0006\u0003\u0011&\u000b!A]:\u000b\u0005)[\u0015AA<t\u0015\u0005a\u0015!\u00026bm\u0006D\u0018B\u0001(F\u0005!\u0011Vm\u001d9p]N,\u0007\"\u0002)A\u0001\u0004\t\u0016A\u0003;f[Bd\u0017\r^3JIB\u0011!+\u0017\b\u0003'^\u0003\"\u0001\u0016\t\u000e\u0003US!A\u0016\u0007\u0002\rq\u0012xn\u001c;?\u0013\tA\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-\u0011Q\tyU\f\u0005\u0002_K6\tqL\u0003\u0002aC\u0006\u0011\u0011\u000e\u001a\u0006\u0003E\u000e\f\u0001\u0002\u001d7v[\nLgn\u001a\u0006\u0003I\"\t\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003M~\u0013q!\u00133QCJ\fW\u000e\u000b\u0003PQ2l\u0007CA5k\u001b\u00059\u0015BA6H\u0005%\u0001\u0016\r\u001e5QCJ\fW.A\u0003wC2,X-I\u0001QQ\u0011\u0001u\u000e\u001c:\u0011\u0005%\u0004\u0018BA9H\u0005\u0011\u0001\u0016\r\u001e5\"\u0003M\fAd\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSS\u0010\u000b\u0002AkB\u0011\u0011N^\u0005\u0003o\u001e\u00131aR#U\u0011\u0015I\b\u0001\"\u0001{\u0003\u001d\u0019wN\u001c8fGR$2aQ>\u007f\u0011\u0015\u0001\u0006\u00101\u0001RQ\tYX\f\u000b\u0003|Q2l\u0007BB@y\u0001\u0004\t\t!\u0001\ntG6\u001cuN\u001c8fGR|'oQ8oM&<\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d!!\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u0017\t)A\u0001\nTG6\u001cuN\u001c8fGR|'oQ8oM&<\u0007&\u0002=pY\u0006=\u0011EAA\t\u0003\u0011\u001awN\u001c8fGR|3\u0010^3na2\fG/Z%eu9R#+\u001a7fCN,7LX\u0018.;*j\bf\u0001=\u0002\u0016A\u0019\u0011.a\u0006\n\u0007\u0005eqI\u0001\u0003Q\u001fN#\u0006bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\u000bI&\u001c8m\u001c8oK\u000e$HcA\"\u0002\"!1\u0001+a\u0007A\u0002EC3!!\t^Q\u0015\t\t\u0003\u001b7nQ\u0019\tYb\u001c7\u0002*\u0005\u0012\u00111F\u0001(I&\u001c8m\u001c8oK\u000e$xf\u001f;f[Bd\u0017\r^3JIjr#FU3mK\u0006\u001cXm\u001700[uSS\u0010\u000b\u0003\u0002\u001c\u0005=\u0002cA5\u00022%\u0019\u00111G$\u0003\r\u0011+E*\u0012+F\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\taa\u001d;biV\u001cHcA\"\u0002<!9q0!\u000eA\u0002\u0005\u0005\u0001FBA\u001b_2\fy$\t\u0002\u00028!\"\u0011QGA\u000bQ\r\u0001\u0011Q\t\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n\u001e\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002P\u0005%#AC\"p]R\u0014x\u000e\u001c7fe\"2\u0001!a\u0015m\u00033\u00022![A+\u0013\r\t9f\u0012\u0002\t\u0007>t7/^7fg2\u0012\u00111L\u0011\u0003\u0003;\n\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8)\r\u0001\t\t\u0007\\A4!\rI\u00171M\u0005\u0004\u0003K:%\u0001\u0003)s_\u0012,8-Z:-\u0005\u0005m\u0003&\u0002\u0001pY\u0006-\u0014EAA7\u0003\u0011y3oY7")
public class ScmConnectorResource {
    private final ReleaseActorService releaseActorService;
    private final PermissionChecker permissionChecker;
    private final ScmConnectorService scmConnectorService;

    @GET
    @Path(value="{templateId:.*Release[^/-]*}")
    public Response getScmConfig(@PathParam(value="templateId") @IdParam String templateId) {
        Response response;
        this.permissionChecker.checkView(templateId);
        Option<ScmConnectorConfig> option = this.scmConnectorService.getScmConnectorConfig(templateId);
        if (option instanceof Some) {
            Some some = (Some)option;
            ScmConnectorConfig storedConfig = (ScmConnectorConfig)((Object)some.value());
            response = Response.ok((Object)((Object)storedConfig)).build();
        } else if (None$.MODULE$.equals(option)) {
            response = Response.ok((Object)((Object)new NoScmConnectorConfig())).build();
        } else {
            throw new MatchError(option);
        }
        return response;
    }

    @POST
    @Path(value="connect/{templateId:.*Release[^/-]*}")
    public Response connect(@PathParam(value="templateId") @IdParam String templateId, ScmConnectorConfig scmConnectorConfig) {
        Response response;
        this.permissionChecker.checkEdit(templateId);
        ScmConnectorConfig scmConnectorConfig2 = scmConnectorConfig;
        if (scmConnectorConfig2 instanceof NoScmConnectorConfig) {
            this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new ScmTemplateExtensionActorMessages.Disconnect());
            response = Response.ok((Object)((Object)new NoScmConnectorConfig())).build();
        } else {
            ScmConnectedTemplate template = (ScmConnectedTemplate)((Object)this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new ScmTemplateExtensionActorMessages.Connect(scmConnectorConfig)));
            ScmConnectorConfig storedConfig = template.getScmConnectorConfig();
            response = Response.ok((Object)((Object)storedConfig)).build();
        }
        return response;
    }

    @DELETE
    @Path(value="disconnect/{templateId:.*Release[^/-]*}")
    public Response disconnect(@PathParam(value="templateId") @IdParam String templateId) {
        this.permissionChecker.checkEdit(templateId);
        boolean status = BoxesRunTime.unboxToBoolean((Object)this.releaseActorService.executeCommand(templateId, (ReleaseExecutionActorMessages.ExtensionCommand)new ScmTemplateExtensionActorMessages.Disconnect()));
        return Response.ok((Object)BoxesRunTime.boxToBoolean((boolean)status)).build();
    }

    @POST
    @Path(value="status")
    public Response status(ScmConnectorConfig scmConnectorConfig) {
        Either<String, GHRepoInfo> result = ScmConnectorFactory$.MODULE$.createScmConnector(scmConnectorConfig).connectionStatus();
        return Response.ok((Object)result.fold((Function1 & Serializable & scala.Serializable)errorMsg -> new ConfigurationStatusResponse(Predef$.MODULE$.boolean2Boolean(false), errorMsg), (Function1 & Serializable & scala.Serializable)repoInfo -> !repoInfo.permissions().push() ? new ConfigurationStatusResponse(Predef$.MODULE$.boolean2Boolean(false), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SCM connector does not have the 'push' permission for '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repoInfo.fullName()}))) : new ConfigurationStatusResponse(Predef$.MODULE$.boolean2Boolean(true), null))).build();
    }

    @Autowired
    public ScmConnectorResource(ReleaseActorService releaseActorService, PermissionChecker permissionChecker, ScmConnectorService scmConnectorService) {
        this.releaseActorService = releaseActorService;
        this.permissionChecker = permissionChecker;
        this.scmConnectorService = scmConnectorService;
    }
}

