/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.io;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamBuffer;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.stopable.StopableHandler;
import org.rzo.netty.ahessian.utils.MyReentrantLock;

public class PullInputStreamConsumer
extends ChannelInboundHandlerAdapter
implements StopableHandler {
    final InputStreamConsumer _consumer;
    static ExecutorService _executor = Executors.newCachedThreadPool();
    final Lock _lock = new MyReentrantLock();
    final Condition _hasData = this._lock.newCondition();
    volatile boolean _stop = false;
    volatile ChannelHandlerContext _ctx;
    volatile InputStream _inputStream;
    volatile boolean _waiting = false;
    static AtomicInteger _threadCounter = new AtomicInteger(0);
    private boolean _stopEnabled = true;
    volatile Thread _currentThread = null;

    public PullInputStreamConsumer(InputStreamConsumer consumer) {
        this._consumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForData() throws Exception {
        while (!(this._stop || this._ctx != null && this._ctx.channel().isActive() && this._inputStream != null && this._inputStream.available() != 0)) {
            this._lock.lock();
            try {
                this._waiting = true;
                this._hasData.await(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Constants.ahessianLogger.warn("", (Throwable)e);
            }
            finally {
                this._waiting = false;
                this._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InputStreamBuffer in;
        _executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String tName = Thread.currentThread().getName();
                Thread.currentThread().setName("ahessian-PullInputStreamConsumer-#" + _threadCounter.incrementAndGet());
                PullInputStreamConsumer.this._currentThread = Thread.currentThread();
                try {
                    PullInputStreamConsumer.this.waitForData();
                    while (!PullInputStreamConsumer.this._stop) {
                        try {
                            PullInputStreamConsumer.this._consumer.consume(PullInputStreamConsumer.this._ctx, PullInputStreamConsumer.this._inputStream);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        PullInputStreamConsumer.this.waitForData();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    Thread.currentThread().setName(tName);
                }
            }
        });
        if (this._ctx != ctx) {
            this._ctx = ctx;
        }
        if (this._inputStream != (in = InputStreamHandler.getInputStream(ctx))) {
            this._inputStream = in;
            ((InputStreamBuffer)this._inputStream).setReadTimeout(-1L);
        }
        this._consumer.setContext(ctx);
        if (this._waiting) {
            this._lock.lock();
            try {
                this._hasData.signal();
            }
            finally {
                this._lock.unlock();
            }
        }
        ctx.fireChannelActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this._lock.lock();
        try {
            this._consumer.setContext(null);
            this._ctx = ctx;
        }
        finally {
            this._lock.unlock();
        }
        ctx.fireChannelInactive();
    }

    @Override
    public boolean isStopEnabled() {
        return this._stopEnabled;
    }

    @Override
    public void setStopEnabled(boolean stopEnabled) {
        this._stopEnabled = stopEnabled;
    }

    @Override
    public void stop() {
        this._stop = true;
        this._currentThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this._lock.lock();
        try {
            if (this._waiting) {
                this._hasData.signal();
            }
        }
        finally {
            this._lock.unlock();
        }
    }
}

