/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.Attributes$;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.impl.io.TcpConnectionStage;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.util.ByteString;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0001\u0003\u0001!Q!aF%oG>l\u0017N\\4D_:tWm\u0019;j_:\u001cF/Y4f\u0015\t\u0019A!\u0001\u0002j_*\u0011QAB\u0001\u0005S6\u0004HN\u0003\u0002\b\u0011\u000511\u000f\u001e:fC6T\u0011!C\u0001\u0005C.\\\u0017m\u0005\u0002\u0001\u0017A\u0019AbD\t\u000e\u00035Q!A\u0004\u0004\u0002\u000bM$\u0018mZ3\n\u0005Ai!AC$sCBD7\u000b^1hKB!!cE\u000b\u0016\u001b\u00051\u0011B\u0001\u000b\u0007\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0002\u001735\tqC\u0003\u0002\u0019\u0011\u0005!Q\u000f^5m\u0013\tQrC\u0001\u0006CsR,7\u000b\u001e:j]\u001eD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u000bG>tg.Z2uS>t7\u0001\u0001\t\u0003?\tj\u0011\u0001\t\u0006\u0003C!\tQ!Y2u_JL!a\t\u0011\u0003\u0011\u0005\u001bGo\u001c:SK\u001aD\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013a\u00018fi*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005I\u0001.\u00197g\u00072|7/\u001a\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b\u0005>|G.Z1o\u0011\u00159\u0004\u0001\"\u00019\u0003\u0019a\u0014N\\5u}Q!\u0011h\u000f\u001f>!\tQ\u0004!D\u0001\u0003\u0011\u0015ab\u00071\u0001\u001f\u0011\u0015)c\u00071\u0001'\u0011\u0015yc\u00071\u00011\u0011\u001dy\u0004A1A\u0005\n\u0001\u000ba\u0002[1t\u0005\u0016,gn\u0011:fCR,G-F\u0001B!\t\u0011\u0005*D\u0001D\u0015\t!U)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\r\u001e\u000b!bY8oGV\u0014(/\u001a8u\u0015\tA\"&\u0003\u0002J\u0007\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Daa\u0013\u0001!\u0002\u0013\t\u0015a\u00045bg\n+WM\\\"sK\u0006$X\r\u001a\u0011\t\u000f5\u0003!\u0019!C\u0001\u001d\u00069!-\u001f;fg&sW#A(\u0011\u0007I\u0001V#\u0003\u0002R\r\t)\u0011J\u001c7fi\"11\u000b\u0001Q\u0001\n=\u000b\u0001BY=uKNLe\u000e\t\u0005\b+\u0002\u0011\r\u0011\"\u0001W\u0003!\u0011\u0017\u0010^3t\u001fV$X#A,\u0011\u0007IAV#\u0003\u0002Z\r\t1q*\u001e;mKRDaa\u0017\u0001!\u0002\u00139\u0016!\u00032zi\u0016\u001cx*\u001e;!\u0011\u0015i\u0006\u0001\"\u0011_\u0003EIg.\u001b;jC2\fE\u000f\u001e:jEV$Xm]\u000b\u0002?B\u0011!\u0003Y\u0005\u0003C\u001a\u0011!\"\u0011;ue&\u0014W\u000f^3t\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\fQa\u001d5ba\u0016,\u0012!\u0005\u0005\u0007M\u0002\u0001\u000b\u0011B\t\u0002\rMD\u0017\r]3!\u0011\u0015A\u0007\u0001\"\u0011j\u0003-\u0019'/Z1uK2{w-[2\u0015\u0005)l\u0007C\u0001\u0007l\u0013\taWBA\bHe\u0006\u0004\bn\u0015;bO\u0016dunZ5d\u0011\u0015qw\r1\u0001`\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t\u0011\u0015\u0001\b\u0001\"\u0011r\u0003!!xn\u0015;sS:<G#\u0001:\u0011\u0005MThB\u0001;y!\t)('D\u0001w\u0015\t9X$\u0001\u0004=e>|GOP\u0005\u0003sJ\na\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011P\r\u0015\u0003\u0001y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004!\t!\"\u00198o_R\fG/[8o\u0013\u0011\t9!!\u0001\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public class IncomingConnectionStage
extends GraphStage<FlowShape<ByteString, ByteString>> {
    private final ActorRef connection;
    private final InetSocketAddress remoteAddress;
    private final boolean halfClose;
    private final AtomicBoolean hasBeenCreated;
    private final Inlet<ByteString> bytesIn;
    private final Outlet<ByteString> bytesOut;
    private final FlowShape<ByteString, ByteString> shape;

    private AtomicBoolean hasBeenCreated() {
        return this.hasBeenCreated;
    }

    public Inlet<ByteString> bytesIn() {
        return this.bytesIn;
    }

    public Outlet<ByteString> bytesOut() {
        return this.bytesOut;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("IncomingConnection");
    }

    @Override
    public FlowShape<ByteString, ByteString> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        if (this.hasBeenCreated().get()) {
            throw new IllegalStateException("Cannot materialize an incoming connection Flow twice.");
        }
        this.hasBeenCreated().set(true);
        return new TcpConnectionStage.TcpStreamLogic((FlowShape<ByteString, ByteString>)this.shape(), new TcpConnectionStage.Inbound(this.connection, this.halfClose), this.remoteAddress);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TCP-from(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddress}));
    }

    public IncomingConnectionStage(ActorRef connection, InetSocketAddress remoteAddress, boolean halfClose) {
        this.connection = connection;
        this.remoteAddress = remoteAddress;
        this.halfClose = halfClose;
        this.hasBeenCreated = new AtomicBoolean(false);
        this.bytesIn = Inlet$.MODULE$.apply("IncomingTCP.in");
        this.bytesOut = Outlet$.MODULE$.apply("IncomingTCP.out");
        this.shape = new FlowShape<ByteString, ByteString>(this.bytesIn(), this.bytesOut());
    }
}

