/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.events.XLReleaseOperation;
import com.xebialabs.xlrelease.service.PostAction;
import com.xebialabs.xlrelease.user.User;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import scala.Tuple2;

public class Changes {
    private Set<ConfigurationItem> updatedItems = Sets.newLinkedHashSet();
    private Multimap<Task, Tuple2<User, String>> commentsByTask = ArrayListMultimap.create();
    private Multimap<Task, Attachment> attachmentsByTaskId = ArrayListMultimap.create();
    private Set<String> removedIds = Sets.newLinkedHashSet();
    private List<PostAction> postActions = Lists.newArrayList();
    private List<Task> tasksToBackup = Lists.newArrayList();
    private List<XLReleaseOperation> operations = new ArrayList<XLReleaseOperation>();

    public void addAll(Changes changes) {
        this.updatedItems.addAll(changes.getUpdatedItems());
        this.commentsByTask.putAll(changes.getCommentsByTask());
        this.removedIds.addAll(changes.getRemovedIds());
        this.postActions.addAll(changes.getPostActions());
        this.tasksToBackup.addAll(changes.getTasksToBackup());
        this.operations.addAll(changes.getOperations());
    }

    public void update(ConfigurationItem item) {
        this.updatedItems.add(item);
    }

    public void updateAll(Collection<? extends ConfigurationItem> items) {
        this.updatedItems.addAll(items);
    }

    public void addComment(Task task, String comment) {
        if (!Strings.isBlank((String)comment)) {
            this.commentsByTask.put((Object)task, (Object)new Tuple2(null, (Object)comment));
        }
    }

    public void addComment(Task task, User user, String comment) {
        if (!Strings.isBlank((String)comment)) {
            this.commentsByTask.put((Object)task, (Object)new Tuple2((Object)user, (Object)comment));
        }
    }

    public void addPostAction(PostAction postAction) {
        this.postActions.add(postAction);
    }

    public void remove(String id) {
        this.removedIds.add(id);
    }

    public boolean hasUpdatedItems() {
        return !this.updatedItems.isEmpty();
    }

    public Set<ConfigurationItem> getUpdatedItems() {
        return this.updatedItems;
    }

    public ConfigurationItem[] toUpdatedItemsArray() {
        return this.updatedItems.toArray(new ConfigurationItem[this.updatedItems.size()]);
    }

    public Multimap<Task, Tuple2<User, String>> getCommentsByTask() {
        return this.commentsByTask;
    }

    public Multimap<Task, Attachment> getAttachmentsByTask() {
        return this.attachmentsByTaskId;
    }

    public Set<String> getRemovedIds() {
        return this.removedIds;
    }

    public List<PostAction> getPostActions() {
        return this.postActions;
    }

    public List<XLReleaseOperation> getOperations() {
        return this.operations;
    }

    public void addOperation(XLReleaseOperation operation) {
        this.operations.add(operation);
    }

    public void addAttachment(Task task, byte[] content, String filename, String contentType) {
        if (content == null || content.length == 0) {
            return;
        }
        Attachment attachment = new Attachment(new StreamWrappingOverthereFile(filename, new ByteArrayInputStream(content)), contentType);
        this.attachmentsByTaskId.put((Object)task, (Object)attachment);
    }

    public List<Task> getTasksToBackup() {
        return this.tasksToBackup;
    }

    public void addTaskToBackup(Task task) {
        this.tasksToBackup.add(task);
    }

    @SafeVarargs
    public final void addOperationBefore(XLReleaseOperation operation, Class<? extends XLReleaseOperation> ... operationBeforeClazzez) {
        for (int i = 0; i < this.operations.size(); ++i) {
            XLReleaseOperation existingOperation = this.operations.get(i);
            if (!Arrays.stream(operationBeforeClazzez).anyMatch(clazz -> clazz.isInstance(existingOperation))) continue;
            this.operations.add(i, operation);
            return;
        }
        this.operations.add(operation);
    }
}

